<?php
ini_set('display_errors', 1);

date_default_timezone_set('America/Bogota');
include('../../config/database.php');
$metodo = $_SERVER['REQUEST_METHOD'];
$fecha_actual = date('Y-m-d H:i:s');

session_start();
// $id_user = $_SESSION['id_user'];
// $username = $_SESSION['username'];

function consul_bulto($cod_bulto)
{
    $url = "http://129.146.161.23/BackEnd_Orion/bultos.php?bultop=$cod_bulto";
    $data_pedidos = file_get_contents($url);
    return json_decode($data_pedidos, true);
}

function tk_consul_bulto($mysqli, $code_bulto)
{
    $sql = "SELECT 
                tk_pedidos.id AS pedido_id,
                tk_bultos.id AS bulto_id,
                -- tk_bulto_articulos.id AS bulto_articulos_id,
                tk_bultos.*,
                tk_pedidos.*
                -- tk_bulto_articulos.*
            FROM tk_pedidos
            INNER JOIN tk_bultos ON tk_pedidos.id = tk_bultos.pedido_id
            -- INNER JOIN tk_bulto_articulos ON tk_bulto_articulos.bulto_id = tk_bultos.id
            WHERE tk_bultos.bulto_codigo = '$code_bulto'";

    $result = $mysqli->query($sql);

    $response = 0;
    if ($result && $result->num_rows > 0) {
        $response = [];
        while ($row = $result->fetch_assoc()) {


            $totalBultos = "SELECT 
                        COUNT(*) AS total_bultos
                    FROM tk_bultos
                    WHERE pedido_codigo = '$row[pedido_codigo]'";

            $resultBultos = $mysqli->query($totalBultos);

            if ($resultBultos && $resultBultos->num_rows > 0) {
                $bultosData = $resultBultos->fetch_assoc();
                $totalBultos = $bultosData['total_bultos'];
            } else {
                $totalBultos = 0;
            }

            $response[] = [
                'pedido' => $row['pedido_codigo'],
                'remesa' => $row['pedido_remesa'],
                'cliente' => $row['pedido_codigo_cliente'],
                'direccion' => $row['pedido_direccion'],
                'agencia' => $row['pedido_agencia'],
                'bulto' => $row['bulto_codigo'],
                'nro_bulto' => $row['bulto_numero'],
                'total_bultos' => $totalBultos,
                'bodega' => $row['pedido_cedi'],
                'tipob' => $row['bulto_tipo'],
                'caja' => $row['bulto_tipo_caja'],
                'division' => $row['bulto_division'],
                'fec_pedido' => $row['created_at'],
                'obs' => $row['pedido_observacion'],
                'importe' => $row['pedido_importe'], // valor declarado
                'poblacion' => $row['pedido_poblacion'],
            ];
        }

        return $response;
    }

    return [];
}

function veri_copia_bulto($mysqli, $cod_bulto)
{
    $sql = "SELECT * FROM bultos_adicionales WHERE cod_bulto_copia = '$cod_bulto'";
    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    return $resultarray;
}

function bulto_migracion($mysqli)
{
    // limitar por parametro
    $url = "http://129.146.151.238/orion/sincronizacion_ip5_orion.php";
    $data = file_get_contents($url);

    if (guardar_data_migracion($mysqli, json_decode($data, true))) {
        return [
            'success' => true,
            'message' => 'Migración completada correctamente.'
        ];
    }

    return [
        'success' => false,
        'message' => 'error Migración.'
    ];
}

function tk_consul_bulto_test($mysqli, $code_bulto)
{
    $sql = "SELECT 
                tk_pedidos.id AS pedido_id,
                tk_bultos.id AS bulto_id,
                tk_bulto_articulos.id AS bulto_articulos_id,
                tk_bultos.*,
                tk_pedidos.*,
                tk_bulto_articulos.*
            FROM tk_pedidos
            INNER JOIN tk_bultos ON tk_pedidos.id = tk_bultos.pedido_id
            INNER JOIN tk_bulto_articulos ON tk_bulto_articulos.bulto_id = tk_bultos.id
            WHERE tk_bultos.bulto_codigo = '$code_bulto'";

    $result = $mysqli->query($sql);

    if ($result && $result->num_rows > 0) {
        $response = [
            'status' => 1,
            'datos' => []
        ];
        while ($row = $result->fetch_assoc()) {
            $response['datos'][] = [
                "seq" => $row['secuencia_linea'],
                "codart" => $row['codigo_articulo'],
                "desart" => $row['articulo_descripcion'],
                "ean" => $row['articulo_ean'],
                "lote" => $row['lote'],
                "cantp" => $row['cantidad_pedida'],
                "cants" => $row['cantidad_servida'],
                "bodega" => $row['pedido_cedi'],
                "tipo_vol" => $row['bulto_volumetria']
            ];
        }
        return [$response];
    }


    return [
        'status' => 0,
        'datos' => 0
    ];
}



function guardar_data_migracion($mysqli, $data_migracion)
{
    $mysqli->begin_transaction();
    try {
        $pedidoSql = "
            INSERT IGNORE INTO tk_pedidos (
                pedido_codigo,
                pedido_division,
                pedido_anio,
                pedido_anio_alb,
                pedido_codigo_alb,
                pedido_secuencia,
                pedido_remesa,
                pedido_tipo,
                pedido_codigo_cliente,
                pedido_destinatario,
                pedido_direccion,
                pedido_poblacion,
                pedido_telefono,
                pedido_cedi,
                pedido_importe,
                pedido_descuento,
                pedido_recargo,
                pedido_agencia,
                pedido_recepcion_fecha,
                pedido_recepcion_hora,
                pedido_estado,
                pedido_observacion,
                created_at
            ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())
            ";

        $stmt = $mysqli->prepare($pedidoSql);

        foreach ($data_migracion['data'] as $pedido) {

            $fechaPedido = date('Y-m-d', strtotime($pedido['PEDIDO_RECEPCION_FECHA']));
            $stmt->bind_param(
                "ssiiisssssssssssssssss",
                $pedido['PEDIDO_CODIGO'],
                $pedido['PEDIDO_DIVISION'],
                $pedido['PEDIDO_ANIO'],
                $pedido['PEDIDO_ANIO_ALB'],
                $pedido['PEDIDO_CODIGO_ALB'],
                $pedido['PEDIDO_SECUENCIA'],
                $pedido['PEDIDO_REMESA'],
                $pedido['PEDIDO_TIPO'],
                $pedido['PEDIDO_CODIGO_CLIENTE'],
                $pedido['PEDIDO_DESTINATARIO'],
                $pedido['PEDIDO_DIRECCION'],
                $pedido['PEDIDO_POBLACION'],
                $pedido['PEDIDO_TELEFONO'],
                $pedido['PEDIDO_CEDI'],
                $pedido['PEDIDO_IMPORTE'],
                $pedido['PEDIDO_DESCUENTO'],
                $pedido['PEDIDO_RECARGO'],
                $pedido['PEDIDO_AGENCIA'],
                $fechaPedido,
                $pedido['PEDIDO_RECEPCION_HORA'],
                $pedido['PEDIDO_ESTADO'],
                $pedido['PEDIDO_OBSERVACIONES']
            );
            $stmt->execute();
            $pedidoId = $stmt->insert_id;
            if ($pedidoId != 0) {
                $bultoSql = "
                    INSERT IGNORE INTO tk_bultos (
                        pedido_id,
                        pedido_codigo,
                        bulto_codigo,
                        bulto_division,
                        bulto_secuencia_pedido,
                        bulto_numero,
                        bulto_tipo,
                        bulto_volumetria,
                        bulto_tipo_caja,
                        bulto_volumen_ip6,
                        bulto_estado,
                        created_at
                    ) VALUES (?,?,?,?,?,?,?,?,?,?,?,NOW())
                    ";

                $stmtBulto = $mysqli->prepare($bultoSql);

                foreach ($pedido['bultos'] as $bulto) {

                    $stmtBulto->bind_param(
                        "isssiisssss",
                        $pedidoId,
                        $pedido['PEDIDO_CODIGO'],
                        $bulto['BULTO_CODIGO'],
                        $bulto['BULTO_DIVISION'],
                        $bulto['BULTO_SECUENCIA_PEDIDO'],
                        $bulto['BULTO_NUMERO'],
                        $bulto['BULTO_TIPO'],
                        $bulto['BULTO_VOLUMETRIA'],
                        $bulto['BULTO_TIPO_CAJA'],
                        $bulto['BULTO_VOLUMEN_IP6'],
                        $bulto['BULTO_ESTADO']
                    );

                    $stmtBulto->execute();
                    $bultoId = $stmtBulto->insert_id;
                    $articuloSql = "
                        INSERT IGNORE INTO tk_bulto_articulos (
                            bulto_id,
                            bulto_codigo,
                            secuencia_linea,
                            codigo_articulo,
                            codigo_movimiento,
                            lote,
                            cantidad_pedida,
                            cantidad_servida,
                            numero_serie,
                            estado,
                            preparacion_fecha_j,
                            preparacion_hora,
                            mod_fecha,
                            mod_hora,
                            cantidad_verificada,
                            articulo_codigo,
                            articulo_division,
                            articulo_codigo_division,
                            articulo_ean,
                            articulo_descripcion,
                            created_at
                        ) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())";

                    $stmtArt = $mysqli->prepare($articuloSql);

                    foreach ($bulto['lineas'] as $linea) {
                        $fechaBultoLinea = date('Y-m-d', strtotime($linea['BULTOLINEA_MOD_FECHA']));
                        $stmtArt->bind_param(
                            "isisssiississsssssss",
                            $bultoId,
                            $bulto['BULTO_CODIGO'],
                            $linea['BULTOLINEA_SECUENCIA_LINEA'],
                            $linea['BULTOLINEA_CODIGO_ARTICULO'],
                            $linea['BULTOLINEA_CODIGO_MOVIMIENTO'],
                            $linea['BULTOLINEA_LOTE'],
                            $linea['BULTOLINEA_CANTIDAD_PEDIDA'],
                            $linea['BULTOLINEA_CANTIDAD_SERVIDA'],
                            $linea['BULTOLINEA_NUMERO_SERIE'],
                            $linea['BULTOLINEA_ESTADO'],
                            $linea['BULTOLINEA_PREPARACION_FECHA_J'],
                            $linea['BULTOLINEA_PREPARACION_HORA'],
                            $fechaBultoLinea,
                            $linea['BULTOLINEA_MOD_HORA'],
                            $linea['BULTOLINEA_CANTIDAD_VERIFICADA'],
                            $linea['ARTICULO_CODIGO'],
                            $linea['ARTICULO_DIVISION'],
                            $linea['ARTICULO_CODIGO_DIVISION'],
                            $linea['ARTICULO_EAN'],
                            $linea['ARTICULO_DESCRIPCION']
                        );

                        $stmtArt->execute();
                    }
                }
            }
            $mysqli->commit();
        }
        if (isset($stmt)) $stmt->close();
        if (isset($stmtBulto)) $stmtBulto->close();
        if (isset($stmtArt)) $stmtArt->close();
        return true;
    } catch (Exception $e) {
        $mysqli->rollback();
        print_r($e);
        return false;
    }
}

if ($metodo == 'GET') {
    if (isset($_GET['migration'])) {
        echo json_encode(bulto_migracion($mysqli));
    }

    if (isset($_GET['bulto_migration'])) {
        echo json_encode(tk_consul_bulto($mysqli, $_GET['bulto_migration']));
    }

    if (isset($_GET['verifica_bulto_test'])) {
        echo json_encode(tk_consul_bulto_test($mysqli, $_GET['verifica_bulto_test']));
    }
}
