<?php
ini_set('display_errors', 1);
require '../../lib/pdf/vendor/autoload.php';

use Spipu\Html2Pdf\Html2Pdf;

$bulto = $_GET['bulto'];
$bulto_cons = $_GET['bulto_cons'];
$num_bulto = $_GET['num_bulto'];

$url = "http://129.146.161.23/BackEnd_Orion/bultos.php?bulto=$bulto";
$data_pedidos = file_get_contents($url);
$pedidos = json_decode($data_pedidos, true);

try {
    $generator = new Picqer\Barcode\BarcodeGeneratorPNG(); // Pixel based PNG
    file_put_contents('barcode.png', $generator->getBarcode($bulto_cons, $generator::TYPE_CODE_128, 2, 40));
    $html2pdf = new Html2Pdf('P', array(100, 100), 'es', true, 'UTF-8', array(0, 0, 0, 0));
    $html2pdf->pdf->SetTitle('Etiqueta de Bulto');

    ob_start();
?>
    <page backtop="5mm" backbottom="5mm" backleft="2mm" backright="2mm">

        <table border="0.5" cellspacing="0" style="width: 100%; text-align: center;">
            <tr colspan="2" style="border-top-right-radius: 10px;">
                <td style="width: 100%; font-size: 15px; padding: 5px 0 5px 0;"><b>Copia de Etiqueta de Bulto</b></td>
            </tr>
        </table>

        <table border="0.5" cellspacing="0" style="width: 100%; text-align: center; font-weight: bold;">
            <tr>
                <td style="width: 40%; font-size: 11px; padding: 5px;">PEDIDO</td>
                <td style="width: 60%; font-size: 11px; padding: 5px;"><?php echo $pedidos[0]['pedido']; ?></td>
            </tr>
            <tr>
                <td style="width: 40%; font-size: 11px; padding: 5px;">REMESA</td>
                <td style="width: 60%; font-size: 11px; padding: 5px;"><?php echo $pedidos[0]['remesa']; ?></td>
            </tr>
            <tr>
                <td style="width: 40%; font-size: 11px; padding: 5px;">CLIENTE</td>
                <td style="width: 60%; font-size: 11px; padding: 5px;"><?php echo $pedidos[0]['cliente']; ?></td>
            </tr>
            <tr>
                <td colspan="2" style="width: 40%; font-size: 11px; padding: 5px;">DIRECCION</td>
            </tr>
            <tr>
                <td colspan="2" style="width: 40%; font-size: 8px; padding: 5px;">
                    <?php echo $pedidos[0]['direccion']; ?>
                </td>
            </tr>
            <tr>
                <td style="width: 40%; font-size: 11px; padding: 5px;">AGENCIA</td>
                <td style="width: 60%; font-size: 11px; padding: 5px;"><?php echo $pedidos[0]['agencia']; ?></td>
            </tr>
            <tr>
                <td style="width: 40%; font-size: 11px; padding: 5px;">BULTO ORIGINAL</td>
                <td style="width: 60%; font-size: 11px; padding: 5px;"><?php echo $pedidos[0]['bulto']; ?></td>
            </tr>
            <tr>
                <td style="width: 40%; font-size: 11px; padding: 5px;">BULTO COPIA</td>
                <td style="width: 60%; font-size: 11px; padding: 5px;"><?php echo $bulto_cons; ?></td>
            </tr>
            <tr>
                <td style="width: 40%; font-size: 11px; padding: 5px;">NUMERO DE COPIA</td>
                <td style="width: 60%; font-size: 11px; padding: 5px;"><?php echo $num_bulto; ?></td>
            </tr>
            <tr>
                <td colspan="2" style="width: 60%; font-size: 11px; padding: 10px;">
                    <img src="barcode.png" alt="">
                </td>
            </tr>

        </table>
    </page>
<?php

    $content = ob_get_clean();

    $html2pdf->writeHTML($content);
    $html2pdf->output();


} catch (HTML2PDF_exception $e) {
    echo $e;
    exit;
}

?>