<?php
// ⚠️ No pongas espacios antes de <?php
ini_set('display_errors', 0);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/php_errors.log');
set_time_limit(60);

// Limpia cualquier salida previa
while (ob_get_level() > 0) { ob_end_clean(); }
ob_start();

include "../../config/database.php";
date_default_timezone_set('America/Bogota');

/* ================== Params ================== */
$ruta          = $_GET['ruta']        ?? '';
$organizacion  = $_GET['agencia']     ?? '';
$id_ruta_cab   = $_GET['id_ruta']     ?? '';

/* ================== Colores ================== */
$BLUE = '#0C2E63';

/* ================== URL raíz del sitio (para /assets) ================== */
$scheme    = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host      = $_SERVER['HTTP_HOST'] ?? 'localhost';
$ROOT_URL  = rtrim($scheme.'://'.$host, '/'); // ej: https://midominio.com
$ver       = date('YmdHis'); // cache-buster simple

/* ================== Rutas públicas a imágenes (SIN base64) ================== */
$LOGO1_URL     = $ROOT_URL . '/assets/images/pharex/camion.png?v='.$ver;   // Picture 1 (A2)
$RIGHT_IMG_URL = $ROOT_URL . '/assets/images/pharex/pharex.png?v='.$ver;  // Picture 2 (L2:Q4)

/* ================== Helpers ================== */
function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

/* ================== Data ================== */
function consul_pedidos(mysqli $mysqli, $ruta, $id_ruta_cab) {
  $sql = "
    SELECT DISTINCT
      bpc.cod_pedido,
      bpc.cliente,
      bpc.agencia,
      bpc.direccion,
      bpc.bodega,
      bpc.fecha_lectura,
      bpc.fecha_cierre,
      bpc.fecha_integracion,
      bpc.cajas_sistema,
      bpc.cajas_fisica,
      bpc.observacion_cierre,
      bpc.confirmacion_pedido,
      bpc.ver_masivo,
      bpc.division,
      bpc.poblacion,
      bpc.importe,
      bpc.fecha_pedido,
      bpc.observaciones,
      bpc.valor_declarado,
      bpc.reser3,
      brapl.pedido,
      brapl.remesa,
      brapl.fecha_insert,
      bcc.s          AS secas,
      bcc.f          AS convencional,
      bcc.e          AS ecoflex_total,
      bcc.ecoflex6,
      bcc.ecoflex15,
      bcc.ecoflex30
    FROM bultos_rutas_agencias_pedidos_lin brapl
    INNER JOIN bultos_pedido_cab bpc
      ON bpc.remesa = brapl.remesa
    INNER JOIN bultos_calcu_cajas bcc
      ON bpc.remesa = bcc.remesa
    WHERE brapl.ruta = '".$mysqli->real_escape_string($ruta)."'
      AND brapl.id_ruta_cab = '".$mysqli->real_escape_string($id_ruta_cab)."'
  ";
  $res = $mysqli->query($sql);
  if (!$res) return [];
  $rows = [];
  foreach ($res as $r) $rows[] = $r;
  return $rows;
}

$rows = consul_pedidos($mysqli, $ruta, $id_ruta_cab);

/* Totales */
$total_pedidos   = 0; // contará filas mostradas (fila 7 no cuenta)
$total_cajas     = 0; // usa cajas_fisica
$total_neveras   = 0; // Convencional (f)
$total_ecoflex   = 0; // e
$total_ecoflex6  = 0;
$total_ecoflex15 = 0;
$total_ecoflex30 = 0;
$total_secas     = 0;

/* Cabecera de ruta (solo por si usas sello en totales, etc.) */
$datos_ruta_res = $mysqli->query("
  SELECT * FROM bultos_rutas_agencias_pedidos_cab
  WHERE ruta='".$mysqli->real_escape_string($ruta)."'
    AND agencia='".$mysqli->real_escape_string($organizacion)."'
    AND estado='1'
");
$datos_ruta     = $datos_ruta_res ? $datos_ruta_res->fetch_assoc() : null;
$fecha_servicio = $datos_ruta['fecha_servicio'] ?? '';
$vehiculo       = $datos_ruta['vehiculo']        ?? '';
$sello          = $datos_ruta['num_sello']       ?? '';

?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<base href="<?= h($ROOT_URL) ?>/">
<title>Relación de Despacho</title>
<style>
  body { font-family: Arial, Helvetica, sans-serif; }
  table { border-collapse: collapse; width: 100%; }
  td, th { border: 1px solid #1e3a66; padding: 7px 9px; white-space: nowrap; font-size: 13px; }
  .no-bd { border: none !important; }
  .center { text-align: center; }
  .bold { font-weight: 700; }
  .tiny { font-size: 11px; }
  .title { font-size: 32px; font-weight: 700; letter-spacing: .5px; }
</style>
</head>
<body>

<!-- ====== Fila vacía para que el bloque arranque en fila 2 (A2) ====== -->
<table border="0" style="width:100%;">
  <tr><td class="no-bd">&nbsp;</td></tr>
</table>

<!-- ===== Encabezado: A2:A4 + B2:B4 + C2:K4 + L2:Q4 ===== -->
<table border="1" style="width:100%;">
  <tr>
    <!-- A2:A4 => Picture 1 -->
    <td rowspan="3" style="text-align:center; width:180px;">
      <img src="<?= h($LOGO1_URL) ?>" alt="" style="display:block;margin:8px auto 6px;max-width:160px;max-height:44px;object-fit:contain;">
      <div class="tiny bold">Proceso Operaciones</div>
      <div class="tiny bold">Transporte</div>
      <div class="tiny" style="margin-top:6px;">Código: PR-LO-T04-F4</div>
    </td>

    <!-- B2:B4 -->
    <td class="center" style="width:120px;" rowspan="3">
      <div class="tiny bold">Versión</div>
      <div>0</div>
      <hr style="border:none;border-top:1px solid #1e3a66;margin:6px 0;">
      <div class="tiny">Página</div>
      <div>1 de 1</div>
    </td>

    <!-- C2:K4 (colspan 9, rowspan 3) -->
    <td colspan="9" rowspan="3" style="text-align:center; vertical-align:middle;">
      <div class="title">RELACION DE PEDIDOS</div>
    </td>

    <!-- L2:Q4 => Picture 2 -->
    <td colspan="6" rowspan="3" class="center" style="vertical-align:middle; height:64px;">
      <img src="<?= h($RIGHT_IMG_URL) ?>"
           alt=""
           style="display:block; margin:0 auto; max-height:64px; width:auto; object-fit:contain;" />
    </td>
  </tr>
  <tr></tr>
  <tr></tr>
</table>

<!-- ===== Fila intermedia VACÍA SIN LÍNEAS (espacio limpio) ===== -->
<table border="0" style="width:100%;">
  <tr style="height:28px;">
    <td class="no-bd">&nbsp;</td>
    <td class="no-bd">&nbsp;</td>
    <td class="no-bd">&nbsp;</td>
  </tr>
</table>

<!-- ===== Tabla principal ===== -->
<table border="1" style="width:100%;">
  <colgroup>
    <col width="120"><col width="100"><col width="100"><col width="140"><col width="160"><col width="220">
    <col width="260"><col width="180"><col width="90"><col width="70"><col width="70"><col width="70"><col width="70"><col width="110"><col width="110"><col width="100"><col width="260">
  </colgroup>

  <tr>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">FECHA SERVICIO</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">RUTA</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">PLACA</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">PEDIDO</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">LABORATORIO</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">DESTINATARIO</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">DIRECCIÓN</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">CIUDAD</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">CAJAS SECAS</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">ECO 6</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">ECO 15</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">ECO 30</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">ECO 59</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">CONVENCIONAL</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">TOTAL CAJAS</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">CEDI</th>
    <th bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;">COMENTARIOS</th>
  </tr>

<?php
$i = 0;
foreach ($rows as $r) {
  $i++;

  // ===== Fila 7 vacía (no cuenta para totales) =====
  if ($i === 7) {
    echo "<tr>";
    for ($c = 0; $c < 17; $c++) echo "<td class='center'>&nbsp;</td>";
    echo "</tr>";
    continue;
  }

  $observaciones = '';
  $ruta_nom = '';
  if (!empty($r['observacion_cierre'])) {
    $parts = explode('?', (string)$r['observacion_cierre']);
    if (count($parts) > 1) { $observaciones = $parts[0]; $ruta_nom = $parts[1]; }
    else { $observaciones = $r['observacion_cierre']; }
  }

  // Laboratorio por división
  $lab = '';
  if (!empty($r['division'])) {
    $q  = $mysqli->query("SELECT DESDIV FROM divisiones_ip6 WHERE CODDIV='".$mysqli->real_escape_string($r['division'])."'");
    $rw = $q ? $q->fetch_assoc() : null;
    $lab = $rw['DESDIV'] ?? '';
  }

  $secas = (int)($r['secas'] ?? 0);
  $eco6  = (int)($r['ecoflex6'] ?? 0);
  $eco15 = (int)($r['ecoflex15'] ?? 0);
  $eco30 = (int)($r['ecoflex30'] ?? 0);
  $eco59 = 0;
  $conv  = (int)($r['convencional'] ?? 0);
  $c_fis = (int)($r['cajas_fisica'] ?? 0);

  // Totales (solo filas mostradas)
  $total_pedidos++;
  $total_cajas     += $c_fis;
  $total_neveras   += $conv;
  $total_ecoflex   += (int)($r['ecoflex_total'] ?? ($eco6 + $eco15 + $eco30));
  $total_ecoflex6  += $eco6;
  $total_ecoflex15 += $eco15;
  $total_ecoflex30 += $eco30;
  $total_secas     += $secas;

  echo "<tr>";
  echo "<td class='center'>".h($fecha_servicio)."</td>";
  echo "<td class='center'>".h($ruta_nom)."</td>";
  echo "<td class='center'>".h($vehiculo)."</td>";
  echo "<td class='center'>".h($r['cod_pedido'])."</td>";
  echo "<td class='center'>".h($lab)."</td>";
  echo "<td>".h($r['cliente'])."</td>";
  echo "<td>".h($r['direccion'])."</td>";
  echo "<td>".h($r['poblacion'])."</td>";
  echo "<td class='center'>".$secas."</td>";
  echo "<td class='center'>".$eco6."</td>";
  echo "<td class='center'>".$eco15."</td>";
  echo "<td class='center'>".$eco30."</td>";
  echo "<td class='center'>".$eco59."</td>";
  echo "<td class='center'>".$conv."</td>";
  echo "<td class='center'>".$c_fis."</td>";
  echo "<td class='center'>".h($r['bodega'])."</td>";
  echo "<td>".h($observaciones)."</td>";
  echo "</tr>";
}
?>

  <!-- Separador -->
  <tr><td colspan="17" class="no-bd">&nbsp;</td></tr>

  <!-- Totales a la derecha -->
  <tr>
    <td colspan="12" class="no-bd"></td>
    <td colspan="5" class="no-bd" style="padding:0;">
      <table width="100%" border="1" style="border-collapse:collapse;">
        <tr>
          <td bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;text-align:center;" colspan="2">TOTAL PEDIDOS</td>
        </tr>
        <tr>
          <td bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;">TOTAL CAJAS</td>
          <td style="background-color:#F6F8FC;font-weight:700;text-align:center;"><?= (int)$total_cajas ?></td>
        </tr>
        <tr>
          <td bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;">TOTAL ECOFLEX</td>
          <td style="background-color:#F6F8FC;font-weight:700;text-align:center;"><?= (int)$total_ecoflex ?></td>
        </tr>
        <tr>
          <td bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;">TOTAL CONVENCIONAL</td>
          <td style="background-color:#F6F8FC;font-weight:700;text-align:center;"><?= (int)$total_neveras ?></td>
        </tr>
        <tr>
          <td bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;">TOTAL DEVOLUCIONES</td>
          <td style="background-color:#F6F8FC;font-weight:700;text-align:center;">0</td>
        </tr>
        <tr>
          <td bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;">TOTAL REPROGRAMACIONES</td>
          <td style="background-color:#F6F8FC;font-weight:700;text-align:center;">0</td>
        </tr>
        <tr>
          <td bgcolor="<?= $BLUE ?>" style="color:#fff;font-weight:700;">No. SELLO/PRECINTO</td>
          <td style="background-color:#F6F8FC;font-weight:700;text-align:center;"><?= h($sello) ?></td>
        </tr>
      </table>
    </td>
  </tr>
  <tr>
    <td colspan="12" class="no-bd"></td>
    <td colspan="5" class="no-bd center bold" style="padding:8px 0;"><?= (int)$total_pedidos ?></td>
  </tr>

  <!-- Firmas -->
  <tr><td colspan="17" class="no-bd">&nbsp;</td></tr>
  <tr>
    <td colspan="8" class="no-bd center bold">DESPACHO REALIZADO POR:</td>
    <td colspan="9" class="no-bd center bold">DOCUMENTOS RECIBIDOS POR:</td>
  </tr>
  <tr>
    <td colspan="8" class="no-bd"><div style="height:40px;"></div></td>
    <td colspan="9" class="no-bd"><div style="height:40px;"></div></td>
  </tr>
</table>

</body>
</html>
<?php
// ===== Enviar como XLS =====
$html = ob_get_clean();
$filename = "Relacion_de_Despacho_".date('Ymd_His').".xls";
header("X-Content-Type-Options: nosniff");
header("Content-Type: application/vnd.ms-excel; charset=UTF-8");
header('Content-Disposition: attachment; filename="'.$filename.'"');
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0', false);
header('Pragma: public');
header('Expires: 0');
echo $html;
exit;
