<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
$filename = "Relacion de Despacho.xls";
header("Content-Type: application/vnd.ms-excel; charset=utf-8");
header("Content-Disposition: attachment; filename=$filename");
session_start();
$bodega = $_SESSION['bodega'];
date_default_timezone_set('America/Bogota');
include('../../config/database.php');

$fecha_ini = $_GET['fd'] . ' 00:00:00';
$fecha_fin = $_GET['fh'] . ' 23:59:59';
$agencia = $_GET['agencia'];
$estado = $_GET['estado'];

// Determinar columna de fecha según estado
$columna_fecha = match($estado) {
    'lectura' => 'fecha_lectura',
    'cerrado' => 'fecha_cierre',
    'integrado' => 'fecha_integracion',
    default => 'fecha_lectura',
};

// Construcción del WHERE
$where = "c.agencia = '$agencia' AND confirmacion_pedido = '$estado' AND $columna_fecha BETWEEN '$fecha_ini' AND '$fecha_fin'";
if ($bodega != 'todos') {
    $where .= " AND bodega = '$bodega'";
}

// Consulta optimizada con JOINs y subconsultas para cajas
$sql = "
SELECT 
    c.cod_pedido,
    c.cliente,
    c.direccion,
    c.poblacion,
    c.fecha_lectura,
    c.fecha_pedido,
    c.valor_declarado,
    c.bodega,
    c.observaciones,
    c.observacion_cierre,
    c.cajas_fisica,
    d.DESDIV,
    MAX(u.username) AS username,
    COALESCE(SUM(CASE l.caja WHEN 'S' THEN 1 ELSE 0 END), 0) AS cajas_s,
    COALESCE(SUM(CASE l.caja WHEN 'E' THEN 1 ELSE 0 END), 0) AS cajas_e,
    COALESCE(SUM(CASE l.caja WHEN 'F' THEN 1 ELSE 0 END), 0) AS cajas_f
FROM bultos_pedido_cab c
LEFT JOIN divisiones_ip6 d ON d.CODDIV = c.division
LEFT JOIN (
    SELECT cod_pedido, agencia, username
    FROM bultos_pedido_lin
    GROUP BY cod_pedido, agencia, username
) u ON u.cod_pedido = c.cod_pedido AND u.agencia = c.agencia
LEFT JOIN bultos_pedido_lin l ON l.cod_pedido = c.cod_pedido
WHERE $where
GROUP BY 
    c.cod_pedido,
    c.cliente,
    c.direccion,
    c.poblacion,
    c.fecha_lectura,
    c.fecha_pedido,
    c.valor_declarado,
    c.bodega,
    c.cajas_fisica,
    c.observaciones,
    c.observacion_cierre,
    d.DESDIV
ORDER BY c.cod_pedido

";

$result = $mysqli->query($sql);

?>

<table border="1" cellpadding="2" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th>Fecha Servicio</th>
            <th>Ruta</th>
            <th>Placa</th>
            <th>Pedido</th>
            <th>Laboratorio</th>
            <th>Destinatario</th>
            <th>Direccion</th>
            <th>Ciudad</th>
            <th>Cajas Secas</th>
            <th>Ecoflex</th>
            <th>Convencional</th>
            <th>Total Cajas</th>
            <th>Cedi</th>
            <th>Comentarios</th>
            <th>Fecha Recibido</th>
            <th>Valor declarado</th>
            <th>Fecha Pedido</th>
            <th>Usuario</th>
        </tr>
    </thead>
    <tbody>
        <?php while($key = $result->fetch_assoc()) {
            $r = explode("?", $key['observacion_cierre']);
            $ruta = $r[1] ?? '';
            ?>
            <tr>
                <td></td>
                <td><?php echo $ruta; ?></td>
                <td></td>
                <td><?php echo $key['cod_pedido']; ?></td>
                <td><?php echo $key['DESDIV']; ?></td>
                <td><?php echo $key['cliente']; ?></td>
                <td><?php echo $key['direccion']; ?></td>
                <td><?php echo $key['poblacion']; ?></td>
                <td><?php echo $key['cajas_s']; ?></td>
                <td><?php echo $key['cajas_e']; ?></td>
                <td><?php echo $key['cajas_f']; ?></td>
                <td><?php echo $key['cajas_fisica']; ?></td>
                <td><?php echo $key['bodega']; ?></td>
                <td><?php echo $key['observaciones']; ?></td>
                <td><?php echo $key['fecha_lectura']; ?></td>
                <td><?php echo $key['valor_declarado']; ?></td>
                <td><?php echo $key['fecha_pedido']; ?></td>
                <td><?php echo $key['username']; ?></td>
            </tr>
        <?php } ?>
    </tbody>
</table>
