<?php 
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
date_default_timezone_set('America/Bogota');
include('../config/database.php');

// Aumenta memoria (opcional)
ini_set('memory_limit', '512M');

// Obtener datos del API
$url = "http://129.146.161.23/BackEnd_Orion/stock_calidad.php";
$data_stocks = file_get_contents($url);
$stocks = json_decode($data_stocks, true);

// Limpiar tabla
mysqli_query($mysqli, "TRUNCATE TABLE stock_calidad") or die('Error en TRUNCATE: ' . mysqli_error($mysqli));

// Tamaño del bloque
$chunkSize = 500;

// Dividir el array en bloques de 500
$chunks = array_chunk($stocks, $chunkSize);

foreach ($chunks as $chunk) {
    $values = [];

    foreach ($chunk as $key) {
        $a = mysqli_real_escape_string($mysqli, (string) ($key['CODART'] ?? ''));
		$b = mysqli_real_escape_string($mysqli, (string) ($key['DESART'] ?? ''));
		$c = mysqli_real_escape_string($mysqli, (string) ($key['CODDIV'] ?? ''));
		$d = mysqli_real_escape_string($mysqli, (string) ($key['DESDIV'] ?? ''));
		$f = mysqli_real_escape_string($mysqli, (string) ($key['UNIDADESHOST'] ?? ''));
		$g = mysqli_real_escape_string($mysqli, (string) ($key['UEMBA'] ?? ''));
		$h = mysqli_real_escape_string($mysqli, (string) ($key['UEMBS'] ?? ''));
		$i = mysqli_real_escape_string($mysqli, (string) ($key['CODBARRA'] ?? ''));
		$j = mysqli_real_escape_string($mysqli, (string) ($key['CODCLASE'] ?? ''));
		$k = mysqli_real_escape_string($mysqli, (string) ($key['CODLOT'] ?? ''));
		$l = mysqli_real_escape_string($mysqli, (string) ($key['BLOQUEOS'] ?? ''));
		$m = mysqli_real_escape_string($mysqli, (string) ($key['CANTIDAD'] ?? ''));
		$n = mysqli_real_escape_string($mysqli, (string) ($key['CODRECEP'] ?? ''));
		$o = mysqli_real_escape_string($mysqli, (string) ($key['CODMAT'] ?? ''));
		$p = mysqli_real_escape_string($mysqli, (string) ($key['CODUBI'] ?? ''));
		$q = mysqli_real_escape_string($mysqli, (string) ($key['CODAREA'] ?? ''));
		$r = mysqli_real_escape_string($mysqli, (string) ($key['CADUCI'] ?? ''));


        $values[] = "('$a','$b','$c','$d','$f','$g','$h','$i','$j','$k','$l','$m','$n','$o','$p','$q','$r')";
    }
    if (!empty($values)) {
        $sql = "INSERT INTO stock_calidad (CODART, DESART, CODDIV, DESDIV, UNIDADMED, UNIEMBART, UNIEMBSTK, CODBARRA, TIPOART, CODLOT, BLOQUEOS, CANTIDAD, CODRECEP, CODMAT, CODUBI, CODAREA, CADUCI) VALUES " . implode(", ", $values);
        if (!mysqli_query($mysqli, $sql)) {
            echo "Error al insertar: " . mysqli_error($mysqli);
        } else {
            echo "Bloque insertado con " . count($values) . " registros<br>";
        }
    }
}
?>
