
function validar() {
    let bulto = $("#bulto").val(), template = '';
    $.ajax({
        url: 'back-end/bulto_verificar/bulto.php',
        type: 'GET',
        data: { bulto },
        success: function (response) {
            console.log(response)
            if (response == 1) {
                lineas()
            } else {
                template += `
                <div class="alert alert-danger" role="alert" id="alerta_add">
                    <strong>Error!</strong> en la lectura del bulto o estado diferente a 9000, por favor verifique el código.
                </div>`;
                $('#result').html(template);
                setTimeout(function () { $('#alerta_add').alert('close'); }, 3000);
                
                // $('#modal_alerta').modal("show");
                
            }
        }
    })
}

function modal_alerta_reporte(){
    let bulto = $("#bulto").val();
    $.ajax({
        url: 'back-end/bulto_verificar/bulto.php',
        type: 'GET',
        data: { bulto },
        success: function (response) {
            console.log(response)
            if (response == 1) {
                lineas();
            } else {
                let reporte_error = document.getElementById('reporte_error');
                reporte_error.innerHTML = 'Estado diferente a 9000, por favor verifique el codigo.';
                $('#modal_alerta').modal("show");
            }
        }
    });
}

function copia_pregunta() {
    let bulto = $("#bulto").val()
    Swal.fire({
        title: '¿Desea generar una copia del bulto?',
        showDenyButton: true,
        confirmButtonText: 'Si',
        denyButtonText: `No`,
    }).then(async (result) => {
        if (result.isConfirmed) {
            await Swal.fire('Copia Generada', '', 'success')
            copia_pdf_etiqueta(bulto);
        } else if (result.isDenied) {
            Swal.fire('Copia no Generada', '', 'info')
        }
    })
}

async function copia_pdf_etiqueta(bulto) {
    await $.ajax({
        url: `back-end/bulto_verificar/generar_copia.php`,
        method: 'GET',
        data: { bulto: bulto },
        dataType: 'json', // 👈 jQuery hace el JSON.parse
        success: async function (o) {
            console.log(o);

            if (o.estado == 200) {
                await window.open(`${ENDPOINT}back-end/bulto_verificar/etiqueta.php?bulto=${o.bulto}&bulto_cons=${o.bulto_cons}&num_bulto=${o.num_bulto}`);
            } else {
                Swal.fire('Error al generar copia, por favor contactar a soporte', '', 'info');
            }
        },
        error: function (xhr) {
            console.error("Respuesta cruda:", xhr.responseText);
            Swal.fire('Error al generar copia (no JSON)', '', 'error');
        }
    });
}


function lineas() {
    let codbulto = $("#bulto").val();
    $.ajax({
        url: 'back-end/bulto_verificar/bulto.php',
        type: 'GET',
        data: { codbulto },
        success: function (response) {
            document.getElementById("tabla_inf").style.display = "block";
            document.getElementById("filtro").style.display = "none";
            document.getElementById("ean").focus();
            $("#cb_title").html(codbulto);
            let datas = JSON.parse(response);
            console.log(datas);
            let template = '';
            datas.forEach(data => {
                template += `
                <tr style="background-color:${data.bg}; color:${data.color};">
                    <td>${data.seq}</td>
                    <td>${data.codigo}</td>
                    <td>${data.articulo}</td>
                    <td>${data.ean}</td>
                    <td>${data.lote}</td>
                    <td>${data.cants}</td>
                    <td>${data.cantv}</td>
                </tr>`

            });
            $('#lineas').html(template);
        }
    })
}

function lectura() {
    let bulto_lect = $("#bulto").val(), ean = $("#ean").val(), template = '';
    const postData = {
        bulto: bulto_lect,
        ean: ean
    };

    $.post('back-end/bulto_verificar/bulto.php', postData, function (response) {
        console.log(response);
        if (response === '0') {
            
            let reporte_error = document.getElementById('reporte_error');
            reporte_error.innerHTML = 'el ean no esta relacionado a ningun articulo del bulto o la linea ya esta completa.';
            $('#modal_alerta').modal("show");
            $("#ean").val('');
            document.getElementById("ean").focus();
            
            // template += `
            // <div class="alert alert-danger" role="alert" id="alerta_erro">
            //     <strong>Error!</strong> el ean no esta relacionado a ningun articulo del bulto o la linea ya esta completa.
            // </div>`;
            // $('#result1').html(template);
            // setTimeout(function () { $('#alerta_erro').alert('close'); }, 3000);
        }
        if (response === '1') {
            $("#ean").val('');
            lineas();
        }
        if (response.substr(0, 1) == 'L') {
            $("#lote_lee").html(response.substr(1));
            $("#confirma_lote").modal("show");
            $("#ean").val('');
            lineas();
            activa_f();
        }
    });

}
function activa_f() {
    document.addEventListener("keyup", function (event) {
        if (event.code === 'Enter') {
            cerrar_modal();
        }
    });
}

function cerrar_modal() {
    $("#confirma_lote").modal("hide");
    document.getElementById("ean").focus();
}

function confirmar() {
    let bulto_conf = $("#bulto").val(), template = '';
    $.ajax({
        url: 'back-end/bulto_verificar/bulto.php',
        type: 'GET',
        data: { bulto_conf },
        success: function (response) {
            if (response == 1) {
                template += `
                <div class="alert alert-success" role="alert" id="alerta_erro">
                    <strong>Exito!</strong> Bulto finalizado correctamente.
                </div>`;
                $('#result1').html(template);
                setTimeout(function () {
                    $('#alerta_erro').alert('close');
                    // location.href ='https://orion.systemsolutions.com.co/main.php?verificar_bulto';}, 4000);
                    window.location.href = 'https://logissystem.com/orion/main.php?verficar_bulto';
                }, 2000);
            } else {
                let reporte_error = document.getElementById('reporte_error');
                reporte_error.innerHTML = 'hay lineas con diferencias, por favor validar';
                $('#modal_alerta').modal("show");
                $("#ean").val('');

            }
        }
    })
}