const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})


function consul_pedidos() {
    let pedido_cambio = $('#pedido_cambio').val();
    let agencia_cambio = $('#agencia_cambio').val();

    $.get(`back-end/cambio_agencia/cambio_agencia.php?pedido=${pedido_cambio}&agencia=${agencia_cambio}`, function (resp) {
        let template = ``;
        let o = JSON.parse(resp);

        template += `<div class="alert alert-${o.alerta}" role="alert" id="alerta_add">${o.msg}</div>`;
        $('#result').html(template);

    });
}

function consul_recepcion() {
    let recepcion = $('#recepcion').val(), error='', template='';
    let linea = $('#linea').val();
    let lote = $('#lote').val();
    let cantidad = $('#cantidad').val();
    let tipo_proceso = $('#tipo_proceso').val();
    if(recepcion === ''){error += 'Numero de recepcion <br>';}
    if(linea === ''){error += 'Numero de linea <br>';}
    if(lote === ''){error += 'Codigo de lote <br>';}
    if(tipo_proceso === 2){
        if(cantidad === ''){error += 'Falta cantidad <br>';}    
    }
    if(error !== ''){
        template +=`
        <div class="alert alert-danger" role="alert" id="alerta_add">
        <strong>Error!</strong> Faltan los sigueinte datos<br>${error}
        </div>`;
        $('#result').html(template);
        $('#result').delay(5000).fadeOut('slow');
        
    }else{
        $.get(`back-end/cambio_agencia/cambio_agencia.php?recepcion=${recepcion}&linea=${linea}&lote=${lote}&cantidad=${cantidad}&tipo_proceso=${tipo_proceso}`, function (resp) {
            let template = ``;
            let o = JSON.parse(resp);
            template += `<div class="alert alert-${o.alerta}" role="alert" id="alerta_add">${o.msg}</div>`;
            $('#result').html(template);
            
    
        });    
    }

    
}