
const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function consul_bulto() {

    if (bulto != '') {

        let bulto = $('#bulto').val();

        $.get(`back-end/consul_bulto/consul_bulto.php?bulto=${bulto}`, function (response) {

            if (response != '[]') {
                $('#deta_bulto').show();

                let o = JSON.parse(response);

                let templete = `
                    <table class="table table-striped table-bordered" id="tabla_pedido" style="font-size: 12px;" cellspacing="0">
                        <thead>
                            <tr>
                                <th class="text-center">Codigo Articulo</th>
                                <th class="text-center">Descripcion Articulo</th>
                                <th class="text-center">EAN</th>
                                <th class="text-center">Lote</th>
                                <th class="text-center">Cantidad Servida</th>
                                <th class="text-center">Cantidad Verificada</th>
                            </tr>
                        </thead>
                    <tbody>`;

                let body = ``;
                let templete_end = `</tbody></table>`;

                o.forEach(element => {
                    body += `
                        <tr style="background-color:${element.bg}; color:${element.color};">
                            <td><strong>${element.codart}</strong></td>
                            <td><strong>${element.desart}</strong></td>
                            <td><strong>${element.ean}</strong></td>
                            <td><strong>${element.lote}</strong></td>
                            <td><strong>${element.cantservida}</strong></td>
                            <td><strong>${element.cantverificada}</strong></td>
                        </tr>`;
                });

                $('#tabla_pedido').html(templete + body + templete_end);
                $('#filtro').hide();
            } else {
                Toast.fire({
                    icon: 'error',
                    title: 'Por favor diligencie un bulto valido'
                });
            }

        });

        // Toast.fire({
        //     icon: 'success',
        //     title: 'Consulta Exitosa'
        // });
        $('#ean').focus();
    } else {
        Toast.fire({
            icon: 'error',
            title: 'Por favor diligencie un bulto valido'
        });
    }
}

// function leer_ean() {
//     let bulto = $('#bulto').val();
//     let ean = $('#ean').val();
//     let selector_proceso = $('#selector_proceso').val();

//     if (selector_proceso == 'entrada') {
//         $.post(`back-end/consul_bulto/consul_bulto.php`, { ean, bulto_ean: bulto }, function (response) {
//             console.log(response)
//             let o = parseInt(response);

//             if (o == 200) {
//                 let error = `<div class='alert alert-success'>
//                                 <div class='iq-alert-text'>
//                                     <strong>Registro verificado</strong>
//                                 </div>
//                             </div>`;

//                 $('#alertas').html(error);

//                 setTimeout(function () {
//                     $('#alertas').html('');
//                 }, 5000);
//                 $('#ean').val('');
//                 $('#ean').focus();

//                 consul_bulto();


//             } else if (o == 400) {
//                 let error = `<div class='alert alert-danger'>
//                                 <div class='iq-alert-text'>
//                                     <strong>Error, falla al procesar el articulo</strong>
//                                 </div>
//                             </div>`;

//                 $('#alertas').html(error);

//                 setTimeout(function () {
//                     $('#alertas').html('');
//                 }, 5000);
//             } else if (o == 300) {

//                 Swal.fire({
//                     title: "Alerta",
//                     text: "Cantidades ingresadas exceden las servidas",
//                     icon: "warning"
//                 });

//                 let error = `<div class='alert alert-success'>
//                                 <div class='iq-alert-text'>
//                                     <strong>Registro verificado</strong>
//                                 </div>
//                             </div>`;

//                 $('#alertas').html(error);

//                 setTimeout(function () {
//                     $('#alertas').html('');
//                 }, 5000);
//                 $('#ean').val('');
//                 $('#ean').focus();

//                 consul_bulto();
//             } else if (o == 100) {
//                 lineas_ean_afectadas(bulto, ean);
//             }
//         });
//     } else {
//         $.post(`back-end/consul_bulto/consul_bulto.php`, { "ean_salida": ean, bulto_ean: bulto }, function (response) {

//             let o = parseInt(response);

//             if (o == 200) {
//                 let error = `<div class='alert alert-success'>
//                                 <div class='iq-alert-text'>
//                                     <strong>Registro verificado</strong>
//                                 </div>
//                             </div>`;

//                 $('#alertas').html(error);

//                 setTimeout(function () {
//                     $('#alertas').html('');
//                 }, 5000);
//                 $('#ean').val('');
//                 $('#ean').focus();

//                 consul_bulto();


//             } else {
//                 let error = `<div class='alert alert-danger'>
//                                 <div class='iq-alert-text'>
//                                     <strong>Error, falla al procesar el articulo</strong>
//                                 </div>
//                             </div>`;

//                 $('#alertas').html(error);

//                 setTimeout(function () {
//                     $('#alertas').html('');
//                 }, 5000);
//             }
//         });
//     }

// }

function descargar_reporte() {
    let bulto = $('#bulto').val();

    if (bulto == '') {
        let error = `<div class='alert alert-danger'>
                        <div class='iq-alert-text'>
                            <strong>Error, falla al intentar descargar el informe</strong>
                        </div>
                    </div>`;

        $('#result').html(error);

        setTimeout(function () {
            $('#result').html('');
        }, 5000);
    } else {
        let error = `<div class='alert alert-success'>
                        <div class='iq-alert-text'>
                            <strong>Descarga Exitosa</strong>
                        </div>
                    </div>`;

        $('#result').html(error);

        setTimeout(function () {
            $('#result').html('');
        }, 5000);

        window.open(`back-end/consul_bulto/descargar_informe.php?bulto=${bulto}`, '_blank');
    }
}

function descargar_informe_pedido() {

    let id_pedido = $('#id_pedido').val();
    window.open(`back-end/consul_bulto/descargar_informe_pedidos.php?pedido=${id_pedido}`);
}

function descargar_reporte_novedades() {
    let bulto = $('#bulto').val();

    if (bulto == '') {
        let error = `<div class='alert alert-danger'>
                        <div class='iq-alert-text'>
                            <strong>Error, falla al intentar descargar el informe</strong>
                        </div>
                    </div>`;

        $('#result').html(error);

        setTimeout(function () {
            $('#result').html('');
        }, 5000);
    } else {
        let error = `<div class='alert alert-success'>
                        <div class='iq-alert-text'>
                            <strong>Descarga Exitosa</strong>
                        </div>
                    </div>`;

        $('#result').html(error);

        setTimeout(function () {
            $('#result').html('');
        }, 5000);

        window.open(`back-end/consul_bulto/descargar_informe_novedades.php?bulto=${bulto}`, '_blank');
    }
}

function leer_ean() {
    let bulto_lect = $("#bulto").val()
    let ean = $("#ean").val()
    let template = '';
    let selector_proceso = $("#selector_proceso").val();
    let cantidad_proceso = $("#cantidad_proceso").val();

    if (selector_proceso == "entrada") {

        const postData = {
            bulto_ean: bulto_lect,
            ean: ean,
            cantidad_proceso: cantidad_proceso
        };

        $.post('back-end/consul_bulto/consul_bulto.php', postData, function (response) {
            console.log(response);
            if (response === '0') {

                let reporte_error = document.getElementById('reporte_error');
                reporte_error.innerHTML = 'el ean no esta relacionado a ningun articulo del bulto o la linea ya esta completa.';
                $('#modal_alerta').modal("show");
                $("#ean").val('');
                document.getElementById("ean").focus();
            }
            if (response === '1') {
                $("#ean").val('');
                consul_bulto();
            }
            if (response.substr(0, 1) == 'L') {
                $("#lote_lee").html(response.substr(1));
                $("#confirma_lote").modal("show");
                $("#ean").val('');
                consul_bulto();
                activa_f();
            }
        });

    } else if (selector_proceso == "salida") {

        const postData = {
            bulto_ean: bulto_lect,
            ean_salida: ean,
            cantidad_proceso: cantidad_proceso
        };

        $.post('back-end/consul_bulto/consul_bulto.php', postData, function (response) {
            console.log(response);
            if (response === '0') {

                let reporte_error = document.getElementById('reporte_error');
                reporte_error.innerHTML = 'el ean no esta relacionado a ningun articulo del bulto o la linea ya esta completa.';
                $('#modal_alerta').modal("show");
                $("#ean").val('');
                document.getElementById("ean").focus();
            }
            if (response === '1') {
                $("#ean").val('');
                consul_bulto();
            }
            if (response.substr(0, 1) == 'L') {
                $("#lote_lee").html(response.substr(1));
                $("#confirma_lote").modal("show");
                $("#ean").val('');
                consul_bulto();
                activa_f();
            }
        });

    }

    $('#cantidad_proceso').val('1');
}

function activa_f() {
    document.addEventListener("keyup", function (event) {
        if (event.code === 'Enter') {
            cerrar_modal();
        }
    });
}

function cerrar_modal() {
    $("#confirma_lote").modal("hide");
    document.getElementById("ean").focus();
}
