const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})


function datos_ciudades() {
    $.ajax({
        url: 'back-end/ges_ciu/general_ges_ciu.php',
        type: 'GET',
        success: function (response) {

            let o = JSON.parse(response);

            console.log(o);

            let templete = `
            <table id="datatable" class="table data-table table-striped table-bordered">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Dato Real</th>
                        <th>Dato Cliente</th>
                        <th>Dia</th>
                    </tr>
                </thead>
                <tbody>`;
            let end = `</tbody></table>`;
            let body = ``;

            o.forEach(item => {

                body += `
                    <tr>
                        <td>${item.id_prov}</td>
                        <td>${item.dato_real}</td>
                        <td>${item.dato_cliente}</td>
                        <td>${item.dia}</td>
                    </tr>`;
            });

            $('#datos_ciudades').html(templete + body + end);
        }
    })
}

function clean(){
    $('#dato_real').val('');
    $('#dato_cliente').val('');
    $('#dia').val('');
}

function crear_ciudad() {

    let dato_real = $('#dato_real').val();
    let dato_cliente = $('#dato_cliente').val();
    let dia = $('#dia').val();

    if (dato_real === '' || dato_cliente === '' || dia === '') {
        let template = `
                <div class="alert alert-danger" role="alert" id="alerta_add">
                    <strong>Error! Faltan datos: </strong><br>
                </div>`;
        $('#alertas').html(template);
    } else {
        $('#crear_cidudad').modal('hide');

        const POSTDATA = {
            dato_real: dato_real,
            dato_cliente: dato_cliente,
            dia: dia
        }

        $.ajax({
            url: 'back-end/ges_ciu/general_ges_ciu.php',
            type: 'POST',
            data: POSTDATA,
            success: function (response) {
                console.log(response)

                let result = parseInt(response);

                if (result == 200) {
                    Toast.fire({
                        icon: 'success',
                        title: 'Ciudad Creada'
                    })
                } else {
                    Toast.fire({
                        icon: 'error',
                        title: 'Error en la creacion de la ciudad'
                    })
                }

            }
        })
    }



    // }
}