function call_novedades_inventarios() {
    $.get(`back-end/gestor_novedades_inventarios/gestor_novedades_inventarios.php?gestor_novedades_inventarios`, function (response) {

        console.log(response)

        let o = JSON.parse(response);

        console.log(o)

        $('#tabla_novedades_inventarios').DataTable({
            data: o,
            columns: [
                { data: 'id_novedad' },
                { data: 'cod_inventario' },
                { data: 'codubi' },
                { data: 'codmat' },
                { data: 'codart' },
                { data: 'desart' },
                { data: 'codlot' },
                { data: 'cantidad' },
                { data: 'user_registro' },
                { data: 'fecha_registro' },
                { data: 'estado' },
                { data: 'user_confirma' },
                { data: 'fecha_confirma' },
                { data: 'confirmar' },
            ]
        });
    });
}

function confirmar_novedad(id, id_inventario) {

    Swal.fire({
        title: "¿Desea confirmar la novedad?",
        showDenyButton: true,
        confirmButtonText: "Si",
        denyButtonText: "No"
    }).then((result) => {
        if (result.isConfirmed) {

            $.post(`back-end/gestor_novedades_inventarios/gestor_novedades_inventarios.php?confirmar_novedad`, { confirmar_novedad: 'all', id_cons: id, id_inventario }, function (response) {
                console.log(response)

                let o = JSON.parse(response);

                if (o == 200) {
                    Swal.fire("Novedad confirmada", "", "success");
                    window.location.replace('main.php?inventarios')
                } else {
                    Swal.fire("Error al confirmar novedad", "", "error");
                }
            });

        }
    });
}

function exporta_novedades() {
    window.open('back-end/gestor_novedades_inventarios/exportar_novedades.php');
}