
consul_pedidos_rutas();
consul_lista_vehiculos();

const Toast = Swal.mixin({
    toast: true,
    position: "top-end",
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.onmouseenter = Swal.stopTimer;
        toast.onmouseleave = Swal.resumeTimer;
    }
});

async function datos_vehiculos(vehiculo) {

    await $.get(`back-end/gestor_rutas/gestor_rutas.php?lista_vehiculos`, async function (response) {

        let o = JSON.parse(response);

        let data = o.filter((word) => word.vehiculo == vehiculo);

        $("#usuario_vehiculo").val(data[0].usuario);
        $("#nombre_vehiculo").val(data[0].nombre);
    });
}

async function consul_lista_vehiculos() {
    await $.get(`back-end/gestor_rutas/gestor_rutas.php?lista_vehiculos`, async function (response) {
        let o = JSON.parse(response);
        console.log(o);

        let templete = `<select id="vehiculo_ruta" class="form-control" onchange="datos_vehiculos(this.value)" required>`;
        let body = `<option value="">Seleccione</option>`;
        let templete_end = `</select>`;

        await o.forEach(element => {
            body += `<option value="${element.vehiculo}">${element.vehiculo} - ${element.nombre}</option>`;
        });

        $("#lista_vehiculo_ruta").html(templete + body + templete_end);
    });
}

function limpiar_lista_pedidos_rutas() {

    let id_pedidos_ruta = $('#id_pedidos_ruta').val();

    Swal.fire({
        title: "Desea limpiar la lista de pedidos de la ruta seleccionada?",
        showDenyButton: true,
        confirmButtonText: "Si",
        denyButtonText: `No`
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(`back-end/gestor_rutas/gestor_rutas.php`, { limpiar_lista_pedidos: 'all', id_pedidos_ruta }, function (response) {
                console.log(response)

                let o = parseInt(response);

                if (o == 200) {
                    consul_pedidos_rutas();
                    Toast.fire({
                        icon: "success",
                        title: "Se ha limpiado la lista de pedidos exitosamente"
                    });
                    $('#modal_pedidos_ruta').modal('hide');
                } else if (o == 300) {
                    Toast.fire({
                        icon: "error",
                        title: "La ruta ya se encuentra cerrada por lo que no se pueden eliminar los pedidos"
                    });
                } else if (o == 400) {
                    Toast.fire({
                        icon: "error",
                        title: "Error al limpiar la lista de pedidos"
                    });
                }
            });
        }
    });

}

function limpiar_pedido_ruta(id_cons) {

    Swal.fire({
        title: "Desea eliminar el pedido de la lista de la ruta?",
        showDenyButton: true,
        confirmButtonText: "Si",
        denyButtonText: "No"
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(`back-end/gestor_rutas/gestor_rutas.php`, { id_cons, limpiar_pedido_ruta }, function (response) {
                console.log(response);
                let o = parseInt(response);

                if (o == 200) {

                    $('#modal_pedidos_ruta').modal('hide');

                    Toast.fire({
                        icon: "success",
                        title: "Se cerro la ruta exitosamente"
                    });
                } else {
                    Toast.fire({
                        icon: "error",
                        title: "Error al cerrar la ruta"
                    });
                }
            });
        }
    });
}

function consul_pedido_rutas_agencias(ruta, agencia) {

    $('#id_pedidos_ruta').val(ruta);

    $.get(`back-end/gestor_rutas/gestor_rutas.php?consul_pedido_rutas_agencias=all&ruta=${ruta}&agencia=${agencia}`, function (response) {
        console.log(response)

        let templete = `<table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Pedido</th>
                                    <th>Remesa</th>
                                    <th>Ruta</th>
                                    <th>Fecha Insercion</th>
                                    <th>Eliminar</th>
                                </tr>
                            </thead>
                            <tbody>`;
        let body = ``;
        let templete_end = `</tbody></table>`;

        let o = JSON.parse(response);
        o.forEach(element => {
            console.log(element)
            body += `<tr>
                        <td>${element.pedido}</td>
                        <td>${element.remesa}</td>
                        <td>${element.ruta}</td>
                        <td>${element.fecha_insert}</td>
                        <td>${element.estado == '0' ? element.btn_limpiar : element.estado == '1' ? element.btn_limpiar : "<button class='btn btn-danger btn-md center-block' disabled>X</button>"}</td>
                    </tr>`;
        });

        $('#tabla_pedido_por_rutas').html(templete + body + templete_end);
    });
}

function consul_pedidos_rutas() {
    $.get(`back-end/gestor_rutas/gestor_rutas.php?consul_pedidos_rutas=all`, function (response) {
        console.log(response)
        let templete = `<table class="table table-striped table-bordered">
                            <thead>
                                <tr>
                                    <th>Id</th>
                                    <th>Ruta</th>
                                    <th>Vehiculo</th>
                                    <th>Agencia</th>
                                    <th>Numero de Sello</th>
                                    <th>Fecha Servicio</th>
                                    <th>Fecha Asignacion</th>
                                    <th>Estado</th>
                                    <th>Bodega</th>
                                    <th>Pedidos</th>
                                    <th></th>
                                </tr>
                            </thead>
                            <tbody>`;
        let body = ``;
        let templete_end = `</tbody></table>`;

        let o = JSON.parse(response);
        o.forEach(element => {

            let estado = `<span class="badge badge-${element.estado == '0' ? 'info': element.estado == '1' ? 'warning' : 'success'}">${element.estado == '0' ? 'Creada' : element.estado == '1' ? 'Cargada' : 'Expedida'}</span>`;

            body += `<tr>
                        <td>${element.id_cons}</td>
                        <td>${element.ruta}</td>
                        <td>${element.vehiculo}</td>
                        <td>${element.agencia}</td>
                        <td>${element.num_sello}</td>
                        <td>${element.fecha_servicio}</td>
                        <td>${element.fecha_asignacion}</td>
                        <td>${estado}</td>
                        <td>${element.bodega}</td>
                        <td>${`
                                <button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modal_pedidos_ruta" onclick="consul_pedido_rutas_agencias('${element.ruta}','${element.id_cons}')"><i class="fas fa-list"></i></button>
                                <button class="btn btn-primary btn-sm" onclick="excel_relacion_despachos('${element.ruta}','${element.agencia}','${element.id_cons}')"><i class="fas fa-file-excel"></i></button>
                            `}</td>
                        <td>${element.estado == 1 ? `<button class="btn btn-primary btn-sm" onclick="cambiar_ruta(${element.id_cons}, ${element.estado})"><i class="fas fa-lock"></i></button>` :
                    `<button class="btn btn-primary btn-sm" disabled><i class="fas fa-lock"></i></button>`}</td>
                    </tr>`;
        });

        $('#tabla_pedido_rutas').html(templete + body + templete_end);

    });
}

function excel_relacion_despachos(ruta, agencia, id_ruta) {
    window.open(`back-end/gestor_rutas/informe_despachos.php?ruta=${ruta}&agencia=${agencia}&id_ruta=${id_ruta}`);
}

function cambiar_ruta(id_ruta, estado) {

    Swal.fire({
        title: "¿Desea cerrar el estado de la ruta?",
        showDenyButton: true,
        confirmButtonText: "Si",
        denyButtonText: "No"
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(`back-end/gestor_rutas/gestor_rutas.php`, { cambiar_ruta: "all", id_ruta: id_ruta, estado: estado }, function (response) {
                console.log(response);
                let o = parseInt(response);

                if (o == 200) {
                    consul_pedidos_rutas();
                    Toast.fire({
                        icon: "success",
                        title: "Se cerro la ruta exitosamente"
                    });
                } else {
                    Toast.fire({
                        icon: "error",
                        title: "Error al cerrar la ruta"
                    });
                }
            });
        }
    });

}

function crear_ruta() {

    let ruta_pedido = $('#ruta_pedido').val();
    let vehiculo_ruta = $('#vehiculo_ruta').val();
    let agencia_ruta = $('#agencia_ruta').val();
    let num_sello_ruta = $('#num_sello_ruta').val();
    let fecha_servicio_ruta = $('#fecha_servicio_ruta').val();
    let fecha_asignacion_ruta = $('#fecha_asignacion_ruta').val();
    let bodega_ruta = $('#bodega_ruta').val();
    let usuario_vehiculo = $('#usuario_vehiculo').val();
    let nombre_vehiculo = $('#nombre_vehiculo').val();

    console.log(usuario_vehiculo, nombre_vehiculo)

    let error = ``;
    let template = ``;

    if (ruta_pedido === '') { error += 'Falta el numero de Ruta <br>'; }
    if (agencia_ruta === '') { error += 'Falta agencia de la Ruta <br>'; }
    if (num_sello_ruta === '') { error += 'Falta numero de sello <br>'; }
    if (fecha_servicio_ruta === '') { error += 'Falta fecha servicio <br>'; }

    if (error !== '') {
        template += `
            <div class="alert alert-danger" role="alert" id="alerta_add">
                <strong>Error!</strong><br> Faltan los sigueinte datos<br>${error}
            </div>`;
        $('#alertas').html(template);
        $('#alertas').show();
        $('#alertas').delay(5000).fadeOut('slow');

    } else {

        $.post(`back-end/gestor_rutas/gestor_rutas.php`,
            {
                crear_ruta: 'all',
                ruta_pedido,
                vehiculo_ruta,
                agencia_ruta,
                num_sello_ruta,
                fecha_servicio_ruta,
                fecha_asignacion_ruta,
                bodega_ruta,
                usuario_vehiculo,
                nombre_vehiculo
            }, function (response) {
                console.log(response)

                let o = parseInt(response);

                if (o == 200) {
                    $('#form_crear_ruta').trigger("reset");
                    $('#modal_crear_ruta').modal("hide");
                    consul_pedidos_rutas();

                    Toast.fire({
                        icon: 'success',
                        title: 'Creacion de ruta exitosa'
                    });

                } else {
                    Toast.fire({
                        icon: 'error',
                        title: 'Error al crear la ruta'
                    });
                }
            });
    }
}

function verificar_agencia(agencia) {

    if (agencia == 'PHAREX') {
        $('#container_vehiculo').show();
    } else {
        $('#container_vehiculo').hide();
    }
}