function consul_usuarios() {
    $.get(`back-end/gestor_usuarios/gestor_usuarios.php?consul_usuario`, function (response) {

        console.log(response)

        let o = JSON.parse(response);

        $('#tabla_gestor_usuarios').DataTable({
            data: o,
            columns: [
                { data: 'id_user' },
                { data: 'username' },
                { data: 'name_user' },
                { data: 'telephone' },
                { data: 'bodega' },
                { data: 'permisos_acceso' },
                { data: 'status' },
                { data: 'btn' },
            ]
        });
    });
}


function crear_usuario() {
    let usuario = $('#usuario_crear').val();
    let nombre_usuario = $('#nombre_usuario_crear').val();
    let telefono = $('#telefono_crear').val();
    let bodega = $('#bodega_crear').val();
    let nivel_permisos = $('#nivel_permisos_crear').val();
    let password = $('#password_crear').val();

    $.post(`back-end/gestor_usuarios/gestor_usuarios.php`, {
        usuario: usuario,
        password: password,
        nombre_usuario: nombre_usuario,
        telefono: telefono,
        bodega: bodega,
        nivel_permisos: nivel_permisos,
        crear_usuario: true
    }, async function (response) {

        console.log(response)

        let o = parseInt(response);

        if (o == 200) {
            await Swal.fire({
                title: "Usuario Creado",
                icon: "success"
            });
            location.reload();
        } else {
            Swal.fire({
                title: "Error al Crear Usuario",
                icon: "error"
            });
        }
    });
}

function editar_usuario() {
    let id = $('#id_editar').val();
    let usuario = $('#usuario_editar').val();
    let nombre_usuario = $('#nombre_usuario_editar').val();
    let telefono = $('#telefono_editar').val();
    let bodega = $('#bodega_editar').val();
    let nivel_permisos = $('#nivel_permisos_editar').val();
    let estado = $('#estado_editar').val();

    $.post(`back-end/gestor_usuarios/gestor_usuarios.php`, {
        id: id,
        usuario: usuario,
        nombre_usuario: nombre_usuario,
        telefono: telefono,
        bodega: bodega,
        estado: estado,
        nivel_permisos: nivel_permisos,
        editar_usuario: true
    }, async function (response) {

        console.log(response)

        let o = parseInt(response);

        if (o == 200) {
            await Swal.fire({
                title: "Usuario Editado",
                icon: "success"
            });
            location.reload();
        } else {
            Swal.fire({
                title: "Error al Editar Usuario",
                icon: "error"
            });
        }
    });
}

function set_usuario_editar(id) {

    $.get(`back-end/gestor_usuarios/gestor_usuarios.php?consul_usuario_id&id=${id}`, function (response) {

        let o = JSON.parse(response);

        o.forEach(element => {
            $('#id_editar').val(element.id_user);
            $('#id_clave').val(element.id_user);
            $('#usuario_editar').val(element.username);
            $('#nombre_usuario_editar').val(element.name_user);
            $('#telefono_editar').val(element.telephone);
            $('#bodega_editar').val(element.bodega);
            $('#nivel_permisos_editar').val(element.permisos_acceso);
            $('#estado_editar').val(element.status);
        });
    });
}

function nueva_clave() {

    let id_clave = $('#id_clave').val();
    let nueva_clave = $('#nueva_clave').val();

    $.post(`back-end/gestor_usuarios/gestor_usuarios.php`, {
        id_clave,
        nueva_clave,
        cambiar_clave: true
    }, async function (response) {

        console.log(response)

        let o = parseInt(response);

        if (o == 200) {
            await Swal.fire({
                title: "Clave Actualizada",
                icon: "success"
            });
            location.reload();
        } else {
            Swal.fire({
                title: "Error al actualizar la clave",
                icon: "error"
            });
        }
    });
}

