const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

async function consul_info() {
    
    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();

    await $.get(`back-end/informe_bulto/informe_bulto.php?fecha_inicial=${fecha_ini}&fecha_fin=${fecha_fin}`, function (response) {
        console.log(response);

        let template = `
        <table class="table table-striped table-bordered" style="font-size:12px;">
            <thead>
                <tr>
                    <th>Codigo de Bulto</th>
                    <th>Numero Referencia</th>
                    <th>Cantidad Verificada</th>
                    <th>Usuario</th>
                    <th>Fecha Terminacion</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>`;
        let body = ``;
        let template_fin = `</tbody></table>`;

        let o = JSON.parse(response);
        o.forEach(element => {
            body += `
                <tr>
                    <td>${element.codbulto}</td>
                    <td>${element.nro_ref}</td>
                    <td>${element.cant_verf}</td>
                    <td>${element.usuario}</td>
                    <td>${element.fec_termina}</td>
                    <td><button class="btn btn-primary btn-sm" data-toggle="modal" data-target="#modal_articulo" onclick="modal_articulo('${element.codbulto}')">Detalles</button></td>
                </tr>
            `;
        });

        $('#tabla_bulto_span').html(template+body+template_fin);
        $('#tabla_informe_bultos').show();
    });
    await $('#excel_informe').show();
    await $('#excel_erores').show();
    await Swal.close();
}

async function descargar_informe(){
    
    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();
    
    window.open(`back-end/informe_bulto/informe_bulto_open.php?informe=${'all'}&fecha_inicial1=${fecha_ini}&fecha_fin=${fecha_fin}`);
   
}

async function descargar_errores(){
    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();
    
    await $.get(`back-end/informe_bulto/informe_bulto.php?errores=${'all'}&fecha_inicial1=${fecha_ini}&fecha_fin=${fecha_fin}`, function(reponse){
        
        const datos = JSON.parse(reponse);
        console.log(datos);
        
        const arreglo = [
            [
                'Id Consecutivo',
                'Usuario',
                'Bulto',
                'Error',
                'Fecha'
            ]
        ];
        
        datos.forEach(data=>{
            arreglo.push(
                [
                    data.id_cons,
                    data.usuario,
                    data.bulto,
                    data.error,
                    data.fecha
                ]
            );
        });

        console.log(arreglo);
        
        const sheetData = arreglo;
    
        const workbook = XLSX.utils.book_new();
        
        const worksheet = XLSX.utils.aoa_to_sheet(sheetData);
    
        const range = XLSX.utils.decode_range(worksheet['!ref']);
        for (let R = range.s.r; R <= range.e.r; ++R) {
            for (let C = range.s.c; C <= range.e.c; ++C) {
                const cell = worksheet[XLSX.utils.encode_cell({ r: R, c: C })];
                if (!cell) continue;
                cell.s = { border: { top: { style: 'thin' }, bottom: { style: 'thin' } } };
            }
        }
    
        // Agregar la hoja de trabajo al libro
        XLSX.utils.book_append_sheet(workbook, worksheet, 'MiHojaDeCalculo');
    
        // Crear un archivo binario a partir del libro de trabajo
        const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });
    
        /* create an XLSX file and try to save to Presidents.xlsx */
        XLSX.writeFileSync(workbook, "Informe de Errores.xlsx", { compression: true });
    });
}

function modal_articulo(bulto){

    $.get(`back-end/informe_bulto/informe_bulto.php?bulto=${bulto}`, function (response) {
        console.log(response);

        let template = `
        <table class="table table-striped table-bordered text-center" style="font-size:14px;">
            <thead>
                <tr>
                    <th>Codigo Articulo</th>
                    <th>Descripcion Articulo</th>
                    <th>EAN</th>
                    <th>Lote</th>
                    <th>Cantidad Servida</th>
                    <th>Cantidad Verificada</th>
                </tr>
            </thead>
            <tbody>`;
        let body = ``;
        let template_fin = `</tbody></table>`;

        let o = JSON.parse(response);
        o.forEach(element => {
            body += `
                <tr>
                    <td>${element.codart}</td>
                    <td>${element.desart}</td>
                    <td>${element.ean}</td>
                    <td>${element.lote}</td>
                    <td>${element.cantservida}</td>
                    <td>${element.cantverificada}</td>
                </tr>
            `;
        });

        $('#tabla_detalles_bulto').html(template+body+template_fin);
    });
}