


const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function generar_informe() {
    let cod_inventario = $('#cod_inventario').val();

    window.open(`back-end/inventarios/informe.php?cod_inventario=${cod_inventario}`, '_blank');
}

function consul_inventario() {
    let cod_inventario = $('#cod_inventario').val();

    $.get(`back-end/inventarios/inventarios.php?cod_inventario=${cod_inventario}`, function (resp) {
        let template = ``;
        let o = JSON.parse(resp);
        console.log(o);
        template += `<div class="alert alert-${o.alerta}" role="alert" id="alerta_add"><b>${o.msg}</b></div>`;
        $('#result').html(template);

        setTimeout(() => {
            $('#result').html('');
        }, 3000);

        if (o.status === 1) {
            lineas_inv(cod_inventario);
        }
    });
    $('#container_informe').show();
}

function consul_inventario_r() {
    let cod_inventario = $('#cod_inventario').val();

    $.get(`back-end/inventarios/inventarios.php?lin_inventario_r=${cod_inventario}`, async function (resp) {
        let template = `
        <table id="tabla_lista" class="table table-striped table-bordered" style="font-size:10px;">
            <thead>
                <tr>
                    <th>Asignar</th>
                    <th>S</th>
                    <th>Codart</th>
                    <th>Desart</th>
                    <th>Codubi</th>
                    <th>Codmat</th>
                    <th>Lote</th>
                    <th>Cant</th>
                    <th>Recep</th>
                    <th>Estado</th>
                    <th>Bodega</th>
                </tr>
            </thead>
            <tbody>`;
        let body = ``;
        let template_end = `</tbody></table>`;
        let o = JSON.parse(resp);
        console.log(o);

        let i = 0;

        o.forEach(item => {
            body += `
            <tr>
                <td>${item.check}</td>
                <td>${item.seq}</td>
                <td>${item.codart}</td>
                <td>${item.desart}</td>
                <td>${item.codubi}</td>
                <td>${item.codmat}</td>
                <td>${item.codlot}</td>
                <td>${item.cantidad}</td>
                <td>${item.codrecep}</td>
                <td>${item.status}</td>
                <td>${item.bodega}</td>
            </tr>`;

            if (item.base_status == '1000') {
                i++;
            }
        });

        if (o.length == i) {
            $('#container_invent_final').show();
        }

        await $('#container_tabla_lista').html('');
        await $('#container_tabla_lista').html(template + body + template_end);
        // $('#tabla_lista').DataTable({
        //     language: {
        //         url: "./js/es.json"
        //     },
        //     order: [[1, 'asc']]
        // });
    });
    $('#container_informe').show();
}

function checkAll() {
    var checkboxes = document.querySelectorAll('.chk-box');
    checkboxes.forEach(function (checkbox) {
        checkbox.checked = true;
    });
}

function lineas_inv(id) {

    let cod_inv = id;
    $.get(`back-end/inventarios/inventarios.php?lin_inventario=${cod_inv}`, async function (resp) {
        let template = `
        <table id="tabla_lista" class="table table-striped table-bordered" style="font-size:10px;">
            <thead>
                <tr>
                    <th>Asignar</th>
                    <th>S</th>
                    <th>Codart</th>
                    <th>Desart</th>
                    <th>Codubi</th>
                    <th>Codmat</th>
                    <th>Lote</th>
                    <th>Cant</th>
                    <th>Recep</th>
                    <th>Estado</th>
                    <th>Bodega</th>
                </tr>
            </thead>
            <tbody>`;
        let body = ``;
        let template_end = `</tbody></table>`;
        let o = JSON.parse(resp);
        console.log(o);

        let i = 0;

        o.forEach(item => {
            body += `
            <tr>
                <td>${item.check}</td>
                <td>${item.seq}</td>
                <td>${item.codart}</td>
                <td>${item.desart}</td>
                <td>${item.codubi}</td>
                <td>${item.codmat}</td>
                <td>${item.codlot}</td>
                <td>${item.cantidad}</td>
                <td>${item.codrecep}</td>
                <td>${item.status}</td>
                <td>${item.bodega}</td>
            </tr>`;

            if (item.base_status == '1000') {
                i++;
            }
        });

        if (o.length == i) {
            $('#container_invent_final').show();
        }

        await $('#container_tabla_lista').html('');
        await $('#container_tabla_lista').html(template + body + template_end);
        // $('#tabla_lista').DataTable({
        //     language: {
        //         url: "./js/es.json"
        //     },
        //     order: [[1, 'asc']]
        // });
    });
}

function lista_usuario_asignar() {

    $('#usuario_asignar').html('');

    $.get(`back-end/inventarios/inventarios.php?lista_usuarios_asignar`, function (response) {
        let o = JSON.parse(response);
        console.log(o)

        let body = `<option value="">Seleccione</option>`;

        o.forEach(item => {
            body += `<option value="${item.username}">${item.name_user}</option>`;
        });

        $('#usuario_asignar').html(body);
    });
}

function procesar_usuario_asignar() {
    let usuario_asignar = $('#usuario_asignar').val();
    let proceso_asigna = $("#proceso_asigna").val();
    var inventario = new Array();
    $('input[type=checkbox]:checked').each(function () {
        inventario.push($(this).val());
    });

    $.post(`back-end/inventarios/inventarios.php`, { usuario_asignar, inventario }, function (response) {

        console.log(response);
        let o = parseInt(response);

        if (o == 200) {
            Toast.fire({
                icon: "success",
                title: "Se asigno el usuario de toma exitosamente"
            });
            $('#modal_asignar').modal('hide');
            if(proceso_asigna == 'A'){consul_inventario();}else{consul_inventario_r();}
            
        } else {
            Toast.fire({
                icon: "error",
                title: "Error al realizar la asignacion"
            });
        }
    });
}

//Operaciones
//Funcionalidad para el ingreso de la toma
function consulta_toma() {

    $('#tabla_2').hide();

    let cod_toma = 1;
    $.get(`back-end/inventarios/inventarios.php?cod_toma=${cod_toma}`, function (resp) {

        if (resp == '0') {
            $('#tabla_1').hide();
            let template = `
            <div class="alert alert-warning" role="alert">
                <b>NO SE ENCONTRARON DATOS</b>
            </div>`;
            $('#result').html(template);
        }

        let template = ``;
        let o = JSON.parse(resp);
        console.log(o);
        $("#codinvet").html(o.codinve);
        $("#codubit").html(o.codubi+ ' ('+o.nro_codmat+')');
        $("#codinve").val(o.codinve);
        $("#codubi").val(o.codubi);

        $('#ubicacion_novedad').val(o.codubi);
        $('#codigo_inventario_novedad').val(o.codinve);
    });
}

function finaliza_ubicacion(){
    let codubi_fina = $("#codubi").val();
    let codinv_fina = $("#codinve").val();
    $.get(`back-end/inventarios/inventarios.php?codubi_fina=${codubi_fina}&codinv_fina=${codinv_fina}`, function (resp) {
        console.log(resp)

        consulta_toma();
    });
}

function confirma_matricula() {

    let codmat = $("#codmat").val();
    let codubi = $("#codubi").val();
    let codinvf = $("#codinve").val();
    if (codmat !== '') {
        $.get(`back-end/inventarios/inventarios.php?codmat=${codmat}&codubi=${codubi}&codinvf=${codinvf}`, function (resp) {
            if (parseInt(resp) == 400) {
                // $('#tabla_1').hide();
                let template = `
                    <div class="alert alert-danger" role="alert">
                        <b>LA MATRICULA LEIDA NO ESTA RELACIONA A LA UBICACIÓN ACTUAL DE LA TOMA</b>
                    </div>`;
                $('#result').html(template);
            } else {
                $('#tabla_1').hide();
                $('#tabla_2').show();

                let template = ``;
                let o = JSON.parse(resp);
                console.log(o);
                $("#dato1").html(o.codart);
                $("#dato2").html(o.desart);
                $("#dato3").html(o.codlot);
                $("#estado").val(o.status);
                $("#id_cons").val(o.id_toma);

                $('#matricula_novedad').val(codmat);
            }
        });
    }
}

function enviar_toma() {
    let id_cons = $('#id_cons').val();
    let estado = $('#estado').val();
    let canti = $('#canti').val();
    let obs = $('#obs').val();
    let enviar_toma = 'all';

    if (canti == '' || Number.isInteger(canti)) {
        Toast.fire({
            icon: "error",
            title: "El valor ingresado es negativo o esta vacio, por favor verificar"
        });
    } else {
        Swal.fire({
            title: "¿Desea generar una novedad antes de cerrar la toma?",
            showDenyButton: true,
            showCancelButton: true,
            confirmButtonText: "Si",
            denyButtonText: "No"
        }).then((result) => {
            if (result.isConfirmed) {
                $('#nueva_novedad').modal('show');
            } else if (result.isDenied) {
                $.post(`back-end/inventarios/inventarios.php`, { enviar_toma, id_cons, estado, canti, obs }, function (response) {
                    console.log(response);

                    let o = parseInt(response);

                    if (o == 200) {
                        Toast.fire({
                            icon: "success",
                            title: "Se realizo la toma exitosamente"
                        });
                        verificar_matricula();
                    } else {
                        Toast.fire({
                            icon: "error",
                            title: "Error al realizar la asignacion"
                        });
                    }
                });
            }
        });
    }
}

function verificar_matricula() {

    let codmat = $("#codmat").val();
    let codubi = $("#codubi").val();
    let codinvf = $("#codinve").val();

    $.get(`back-end/inventarios/inventarios.php?verificar_matricula&codmat=${codmat}&codubi=${codubi}&codinvf1=${codinvf}`, function (response) {
        console.log(response)
        let o = parseInt(response);

        if (o == 200) {
            confirma_matricula();
            Swal.fire({
                title: "Articulo de misma ubicacion encontrado",
                icon: "success"
            });
            $('#canti').val('');
        } else {
            location.reload();
        }

    });
}

// Funcion para verificacion de EAN
function set_data_articulos() {

    let ean = $('#ean_novedad').val();

    $.get(`back-end/inventarios/inventarios.php`, { ean, ver_articulo_ean: 'all' }, function (response) {

        let o = JSON.parse(response);

        if (o[0].status == '1') {
            Swal.fire({
                title: "Articulo Encontrado",
                icon: "success"
            });

            $('#cod_articulo_novedad').val(o[0].msg[0].codart);
            $('#desc_articulo_novedad').val(o[0].msg[0].desart);

        } else {
            Swal.fire({
                title: "Articulo no Encontrado",
                icon: "error"
            });
        }

    });
}

// Funcion para cuando no hay ean y se debe colocar el codigo de articulo
function set_data_arti_sin_ean() {
    let codarti = $('#cod_articulo_novedad').val();

    $.get(`back-end/inventarios/inventarios.php`, { codarti }, function (response) {
        console.log(response)
        let o = JSON.parse(response);
        
        if (o[0].status == '1') {
            Swal.fire({
                title: "Articulo Encontrado",
                icon: "success"
            });

            $('#desc_articulo_novedad').val(o[0].msg[0].descarti);

        } else {
            Swal.fire({
                title: "Articulo no Encontrado",
                icon: "error"
            });
        }

    });
}

function cargar_novedad() {
    let ubicacion = $('#ubicacion_novedad').val();
    let codigo_inventario = $('#codigo_inventario_novedad').val();
    let matricula = $('#matricula_novedad').val();
    let ean = $('#ean_novedad').val();
    let cod_articulo = $('#cod_articulo_novedad').val();
    let desc_articulo = $('#desc_articulo_novedad').val();
    let lote = $('#lote_novedad').val();
    let cantidad = $('#cantidad_novedad').val();

    $.post(`back-end/inventarios/inventarios.php`, {
        cargar_novedad: 'all',
        ubicacion,
        codigo_inventario,
        matricula,
        ean,
        cod_articulo,
        desc_articulo,
        lote,
        cantidad,
    }, function (response) {

        let o = JSON.parse(response);

        if (o == 200) {
            Swal.fire({
                title: "Novedad cargada",
                icon: "success"
            });
        } else {
            Swal.fire({
                title: "Error al cargar la novedad",
                icon: "error"
            });
        }

        $('#ean_novedad').val('');
        $('#cod_articulo_novedad').val('');
        $('#desc_articulo_novedad').val('');
        $('#lote_novedad').val('');
        $('#cantidad_novedad').val('');
    });
}

function finalizacion_inventarios() {

    let cod_inventario = $('#cod_inventario').val();

    Swal.fire({
        title: "¿Desea integrar las lineas de inventarios?",
        showDenyButton: true,
        confirmButtonText: "Si",
        denyButtonText: "No"
    }).then((result) => {
        if (result.isConfirmed) {
            $.post(`back-end/inventarios/inventarios.php`, { cod_inventario, "finalizacion_inventarios": "finalizacion_inventarios" }, function (response) {
                console.log(response);

                let o = parseInt(response);

                if (o == 200) {
                    Swal.fire({
                        title: "Inventario Finalizado",
                        icon: "success"
                    });
                } else {
                    Swal.fire({
                        title: "Error al finalizar el inventario",
                        icon: "error"
                    });
                }
            });
        }
    });
}

$('#filtro_tabla').on('keyup', function() {
    var value = $(this).val().toLowerCase();
    $("#tabla_lista tbody tr").filter(function() {
        $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
});