const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function insertar_bulto() {

    let bultocode = $("#bultocode").val();

    if (bultocode == '') {
        Toast.fire({
            icon: 'error',
            title: 'Codigo de bulto no encontrada'
        })
    } else {

        // $.get(`back-end/leer_bultos/leer_bultos.php?bulto_repetido=${postdata.num_bulto}&cod_pedido_b=${peticion_bulto}`, function (response) {
        $.get(`back-end/leer_bultos/leer_bultos.php?bulto_repetido=${bultocode}`, function (response) {
            let bulto = parseInt(response);
            console.log(response);

            if (bulto == 200) {
                datos_bultos(bultocode);
                Toast.fire({
                    icon: 'success',
                    title: 'Bulto leido'
                });
            } else {
                Toast.fire({
                    icon: 'error',
                    title: 'El bulto se encuentra ya ingresado en el pedido actual'
                });
            }
        });
    }
}

async function datos_bultos(bultocode) {

    $('#insertar_bulto').modal('hide');

    //Bulto de prueba 183001226992490363
    await $.post(`back-end/leer_bultos/leer_bultos.php`, {bultocode}, async function (response) {
        let bulto = parseInt(response);
        console.log(response);

        if (bulto == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Bulto ingresado'
            });

            call_data();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'El bulto se encuentra ya ingresado en el pedido actual'
            });
        }
    });

    // await $.get(`http://129.146.161.23/BackEnd_Orion/bultos.php?bulto=${bultocode}`, async function (response) {

    //     let o = JSON.parse(response);
    //     o = o[0];

    //     // Colocar ruta para consultar los datos del bulto
    //     const postdata = {
    //         cod_pedido: o.pedido,
    //         cod_bulto: o.bulto,
    //         cod_remesa: o.remesa,
    //         num_bulto: o.nro_bulto,
    //         cod_cliente: o.cliente,
    //         agencia: o.agencia,
    //         total_bulto: o.total_bultos
    //     }

        
    // });
}

async function call_data() {
    await $.get(`back-end/leer_bultos/leer_bultos.php?bulto_abierto=a`, function (response) {

        let o = JSON.parse(response);
        console.log(o);

        //Tabla datos del pedido
        let templete = `
        <table id="tabla_pedido" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Pedido</th>
                    <th>Remesa</th>
                    <th>Cliente</th>
                    <th>Agencia</th>
                    <th>Cajas sistema</th>
                    <th>Cajas fisicas</th>
                    <th>Cierre</th>
                </tr>
            </thead>
            <tbody>`;
        let fin_templete = `</tbody></table>`;
        let body = '';

        o.forEach(item => {
            body += `
            <tr>
                <td>${item.cod_pedido}</td>
                <td>${item.remesa}</td>
                <td>${item.cliente}</td>
                <td>${item.agencia}</td>
                <td>${item.cajas_sistema}</td>
                <td>${item.cajas_fisica}</td>
                <td>${item.boton}</td>
            </tr>`;
        })
        $('#tabla_pedido_span').html(templete + body + fin_templete);
    });
}

function cerrar_pedido(id_pedido, estado_pedido) {

    $('#id_pedido').val(id_pedido);
    let templete = ``;

    switch (estado_pedido) {
        case 0:
            // console.log("Cajas completas")
            templete += `
                <strong>Observaciones inconveniente de cierre</strong>
                <textarea id="observaciones_pedido" minlength="10" class="form-control" required></textarea>`;

            $('#cerrar_pedido_content').html(templete);

            break;

        case 1:
            // console.log("Cajas no completas")
            templete += `<h1>Las cajas se registran completas</h1>`;

            $('#cerrar_pedido_content').html(templete);

            break;
    }
}

function cerrar_pedido_accion() {

    let id_pedido = $('#id_pedido').val();
    let observaciones_pedido = '';
    observaciones_pedido = $('#observaciones_pedido').val();

    fetch(`back-end/leer_bultos/leer_bultos.php?id_pedido=${id_pedido}`, {
        method: 'PUT',
        body: JSON.stringify({
            id_pedido: id_pedido,
            observacion: observaciones_pedido
        }),
        Headers: {
            Accept: 'application/json',
            'Content-Type': 'text/html'
        }
    })
        .then((response) => response.text())
        .then((responseData) => {
            console.log(responseData);
            let resp = parseInt(responseData);

            if (resp == 200) {
                $('#cerrar_pedido_modal').modal('hide');
                call_data()
                Toast.fire({
                    icon: 'success',
                    title: 'Actualizacion de estado de tarea'
                });
            } else {
                Toast.fire({
                    icon: 'error',
                    title: 'Error de actualizacion de estado'
                });
            }

        })
        .catch((error) => {
            console.error('error', error)
        });
}