const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

async function insertar_bulto() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    let bultocode = $("#bultocode").val();
    let id_pedido = $('#id_pedido').val();
    let pedido = $('#pedido').val();
    let agencia = $('#agencia').val();

    //Verificar si el bulto fue ingresado
    if (bultocode == '') {
        await Toast.fire({
            icon: 'error',
            title: 'Codigo de bulto no encontrada'
        })
        await Swal.close();
    } else {
        //En caso de que no exista un pedido en pantalla
        if (id_pedido == '') {
            await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?bulto_repetido=${bultocode}`, async function (response) {
                let bulto = parseInt(response);
                console.log(response);

                //Si el Bulto no esta repetido
                if (bulto == 200) {

                    Swal.close();
                    await datos_bultos(bultocode);
                    await Toast.fire({
                        icon: 'success',
                        title: 'Bulto leido'
                    });
                }
                //Si el bulto esta repetido
                else {
                    await datos_bultos_sin_bulto(bultocode);
                    await Toast.fire({
                        icon: 'error',
                        title: 'El bulto se encuentra ya ingresado en el pedido actual'
                    });
                    await Swal.close();

                    let id_bulto = document.getElementById("bultocode");
                    id_bulto.focus();
                    id_bulto.value = '';
                }
            });
        }
        //En caso de que exista un pedido en pantalla
        else {
            await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?ver_cod_pedido=${pedido}&ver_bulto_pedido=${bultocode}&agencia_actual=${agencia}`, async function (response) {
                let bulto = parseInt(response);
                console.log(response);

                //En caso de que el pedido que esta en pantalla es diferente al ingresado en el bulto
                if (bulto == 400) {
                    //Se pregunta si quiere cerrar el pedido que tiene actualmente o si quiere seguir en dicho pedido
                    Swal.fire({
                        title: 'El pedido es diferente al inicial, ¿Desea cerrar la solicitud anterior?',
                        showDenyButton: true,
                        confirmButtonText: 'Si',
                        denyButtonText: `No`,
                    }).then((result) => {
                        if (result.isConfirmed) {
                            Swal.fire('Se cerro el pedido anterior y se abrio el nuevo solicitado', '', 'success')
                        } else if (result.isDenied) {
                            Swal.fire('No se cargo el nuevo pedido', '', 'info')
                        }
                    })
                }
                //En caso de que el pedido que esta en pantalla es igual al ingresado en el bulto
                else {
                    await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?bulto_repetido=${bultocode}`, async function (response) {
                        let bulto = parseInt(response);
                        console.log(response);

                        //Si el Bulto no esta repetido
                        if (bulto == 200) {
                            await datos_bultos(bultocode);
                            await Toast.fire({
                                icon: 'success',
                                title: 'Bulto leido'
                            });
                            await Swal.close();
                        }
                        //Si el bulto esta repetido
                        else {
                            let id_bulto = document.getElementById("bultocode");
                            id_bulto.focus();
                            id_bulto.value = '';

                            await Toast.fire({
                                icon: 'error',
                                title: 'El bulto se encuentra ya ingresado en el pedido actual'
                            });
                            await Swal.close();
                        }
                    });
                }
            });
        }
    }
}

//La funcion se ejecuta al momento de confirmar las cajas frias, con ecoflex o neveras
async function insertar_bulto_caja_fria() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    let bultocode = $("#bultocode").val();
    let id_pedido = $('#id_pedido').val();
    let pedido = $('#pedido').val();
    let agencia = $('#agencia').val();
    let tipo_caja_fria = $('#tipo_caja_fria').val();
    let tipo_ecoflex = $('#tipo_ecoflex').val();

    console.log(tipo_caja_fria)
    console.log(tipo_ecoflex)

    if (tipo_caja_fria == '0' && tipo_ecoflex == '' || tipo_caja_fria == '1' && tipo_ecoflex != '' || tipo_caja_fria == '0' && tipo_ecoflex != '') {
        if (tipo_caja_fria == '1') {

            //Verificar si el bulto fue ingresado
            if (bultocode == '') {
                await Toast.fire({
                    icon: 'error',
                    title: 'Codigo de bulto no encontrada'
                })
                await Swal.close();
            } else {
                //En caso de que no exista un pedido en pantalla
                if (id_pedido == '') {
                    await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?bulto_repetido=${bultocode}`, async function (response) {
                        let bulto = parseInt(response);
                        console.log(response);

                        //Si el Bulto no esta repetido
                        if (bulto == 200) {

                            await datos_bultos(bultocode, tipo_ecoflex);
                            $('#modal_caja_fria').modal('hide');

                            await Toast.fire({
                                icon: 'success',
                                title: 'Bulto leido'
                            });

                            await Swal.close();
                        }
                        //Si el bulto esta repetido
                        else {
                            await datos_bultos_sin_bulto(bultocode, tipo_ecoflex);
                            await Toast.fire({
                                icon: 'error',
                                title: 'El bulto se encuentra ya ingresado en el pedido actual'
                            });

                            await Swal.close();

                            let id_bulto = document.getElementById("bultocode");
                            id_bulto.focus();
                            id_bulto.value = '';
                        }
                    });
                }
                //En caso de que exista un pedido en pantalla
                else {
                    await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?ver_cod_pedido=${pedido}&ver_bulto_pedido=${bultocode}&agencia_actual=${agencia}`, async function (response) {
                        let bulto = parseInt(response);
                        console.log(response);

                        //En caso de que el pedido que esta en pantalla es diferente al ingresado en el bulto
                        if (bulto == 400) {
                            //Se pregunta si quiere cerrar el pedido que tiene actualmente o si quiere seguir en dicho pedido
                            Swal.fire({
                                title: 'El pedido es diferente al inicial, ¿Desea cerrar la solicitud anterior?',
                                showDenyButton: true,
                                confirmButtonText: 'Si',
                                denyButtonText: `No`,
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    Swal.fire('Se cerro el pedido anterior y se abrio el nuevo solicitado', '', 'success')
                                } else if (result.isDenied) {
                                    Swal.fire('No se cargo el nuevo pedido', '', 'info')
                                }
                            })
                        }
                        //En caso de que el pedido que esta en pantalla es igual al ingresado en el bulto
                        else {
                            await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?bulto_repetido=${bultocode}`, async function (response) {
                                let bulto = parseInt(response);
                                console.log(response);

                                //Si el Bulto no esta repetido
                                if (bulto == 200) {
                                    await datos_bultos(bultocode, tipo_ecoflex);
                                    $('#modal_caja_fria').modal('hide');

                                    await Toast.fire({
                                        icon: 'success',
                                        title: 'Bulto leido'
                                    });

                                    await Swal.close();
                                }
                                //Si el bulto esta repetido
                                else {
                                    let id_bulto = document.getElementById("bultocode");
                                    id_bulto.focus();
                                    id_bulto.value = '';

                                    await Toast.fire({
                                        icon: 'error',
                                        title: 'El bulto se encuentra ya ingresado en el pedido actual'
                                    });
                                    await Swal.close();
                                }
                            });
                        }
                    });
                }
            }
        } else {
            //Verificar si el bulto fue ingresado
            if (bultocode == '') {
                await Toast.fire({
                    icon: 'error',
                    title: 'Codigo de bulto no encontrada'
                })
                await Swal.close();
            } else {
                //En caso de que no exista un pedido en pantalla
                if (id_pedido == '') {
                    await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?bulto_repetido=${bultocode}`, async function (response) {
                        let bulto = parseInt(response);
                        console.log(response);

                        //Si el Bulto no esta repetido
                        if (bulto == 200) {

                            await datos_bultos(bultocode);
                            $('#modal_caja_fria').modal('hide');

                            await Toast.fire({
                                icon: 'success',
                                title: 'Bulto leido'
                            });

                            await Swal.close();
                        }
                        //Si el bulto esta repetido
                        else {
                            await datos_bultos_sin_bulto(bultocode);
                            await Toast.fire({
                                icon: 'error',
                                title: 'El bulto se encuentra ya ingresado en el pedido actual'
                            });
                            await Swal.close();

                            let id_bulto = document.getElementById("bultocode");
                            id_bulto.focus();
                            id_bulto.value = '';
                        }
                    });
                }
                //En caso de que exista un pedido en pantalla
                else {
                    await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?ver_cod_pedido=${pedido}&ver_bulto_pedido=${bultocode}&agencia_actual=${agencia}`, async function (response) {
                        let bulto = parseInt(response);
                        console.log(response);

                        //En caso de que el pedido que esta en pantalla es diferente al ingresado en el bulto
                        if (bulto == 400) {
                            //Se pregunta si quiere cerrar el pedido que tiene actualmente o si quiere seguir en dicho pedido
                            Swal.fire({
                                title: 'El pedido es diferente al inicial, ¿Desea cerrar la solicitud anterior?',
                                showDenyButton: true,
                                confirmButtonText: 'Si',
                                denyButtonText: `No`,
                            }).then((result) => {
                                if (result.isConfirmed) {
                                    Swal.fire('Se cerro el pedido anterior y se abrio el nuevo solicitado', '', 'success')
                                } else if (result.isDenied) {
                                    Swal.fire('No se cargo el nuevo pedido', '', 'info')
                                }
                            })
                        }
                        //En caso de que el pedido que esta en pantalla es igual al ingresado en el bulto
                        else {
                            await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?bulto_repetido=${bultocode}`, async function (response) {
                                let bulto = parseInt(response);
                                console.log(response);

                                //Si el Bulto no esta repetido
                                if (bulto == 200) {
                                    await datos_bultos(bultocode);
                                    $('#modal_caja_fria').modal('hide');
                                    await Toast.fire({
                                        icon: 'success',
                                        title: 'Bulto leido'
                                    });

                                    await Swal.close();
                                }
                                //Si el bulto esta repetido
                                else {
                                    let id_bulto = document.getElementById("bultocode");
                                    id_bulto.focus();
                                    id_bulto.value = '';

                                    await Toast.fire({
                                        icon: 'error',
                                        title: 'El bulto se encuentra ya ingresado en el pedido actual'
                                    });
                                    await Swal.close();
                                }
                            });
                        }
                    });
                }
            }
        }
    } else {
        Swal.close();
        let error = `<div class='alert alert-danger'>
                        <div class='iq-alert-text'>
                            <strong>Error, por favor seleccione un tipo de dato</strong>
                        </div>
                    </div>`;

        $('#alert_modal_caja_fria').html(error);

        setTimeout(function () {
            $('#alert_modal_caja_fria').html('');
        }, 5000);

    }
}

async function verificar_caja_fria() {

    let bultocode = $("#bultocode").val();

    await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?verificar_caja_fria=all&bulto_caja_fria=${bultocode}`, async function (response) {

        if (response == 'F') {
            $('#modal_caja_fria').modal('show');
            $('#id_bulto').val(bultocode);
        } else {
            insertar_bulto();
        }

    });
}

function cambio_caja_fria(caja_fria) {
    if (caja_fria == '1') {
        $('#select_litros_ecoflex').css("display", "block");
    } else {
        $('#select_litros_ecoflex').css("display", "none");
    }
}

function crear_boton_cierre(cierre) {
    let templete = "";

    if (!cierre) {
        templete += "<button class='btn btn-danger' data-toggle='modal' data-target='#cerrar_pedido_modal' onclick='cerrar_pedido_accion(0)'>Cerrar</button>";
        $('#cerrar_pedido_span').html(templete);
    } else {
        templete += "<button class='btn btn-success' data-toggle='modal' data-target='#cerrar_pedido_modal' onclick='cerrar_pedido_accion(1)'>Cerrar</button>";
        $('#cerrar_pedido_span').html(templete);
    }
}

function calculo_manual() {

    let porcentaje = $('#porcentaje').val();
    let valor = $('#valor_factura').val();
    let calculo = valor * porcentaje;

    $('#valor_declarado_cierre_pedido').val(new Intl.NumberFormat('en-US').format(calculo));

}

function cerrar_pedido_accion(estado_pedido) {

    let id_pedido = $('#id_pedido').val();

    $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?id_pedido=${id_pedido}`, function (response) {

        let o = JSON.parse(response);

        if (o['proceso'] == 'N') {
            document.getElementById('valor_factura').readOnly = false;
            $('#porcentaje').val(o['valor_general']);
        } else {
            document.getElementById('valor_factura').readOnly = true;
        }

    });

    $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?lista_rutas=all`, function (response) {
        console.log(response);

        let o = JSON.parse(response);
        let templete = ``;

        switch (estado_pedido) {
            case 0:
                templete += `
                    <strong>Observaciones inconveniente de cierre</strong>
                    <select id="observaciones_pedido" class="form-control">
                        <option value="">Seleccione</option>
                        <option value="Volumetria">Volumetria</option>
                        <option value="Reempaque">Reempaque</option>
                        <option value="Solicitud de Cliente">Solicitud de Cliente</option>
                    </select><br>
                    <strong>Ruta Pedido</strong>
                    <select id="ruta_pedido" class="form-control">
                        <option value="Ruta1">Ruta Nro 1</option>
                        <option value="Ruta2">Ruta Nro 2</option>
                        <option value="Ruta3">Ruta Nro 3</option>
                        <option value="Ruta4">Ruta Nro 4</option>
                        <option value="Ruta5">Ruta Nro 5</option>
                        <option value="Ruta6">Ruta Nro 6</option>
                        <option value="Ruta7">Ruta Nro 7</option>
                        <option value="Ruta8">Ruta Nro 8</option>
                        <option value="Ruta9">Ruta Nro 9</option>
                        <option value="Ruta10">Ruta Nro 10</option>
                        <option value="Ruta11">Ruta Nro 11</option>
                        <option value="Ruta12">Ruta Nro 12</option>
                        <option value="Ruta13">Ruta Nro 13</option>
                        <option value="Ruta14">Ruta Nro 14</option>
                        <option value="Ruta15">Ruta Nro 15</option>
                        <option value="Ruta16">Ruta Nro 16</option>
                        <option value="Ruta17">Ruta Nro 17</option>
                        <option value="Ruta18">Ruta Nro 18</option>
                        <option value="Ruta19">Ruta Nro 19</option>
                        <option value="Ruta20">Ruta Nro 20</option>
                    </select>`;

                $('#cerrar_pedido_content').html(templete);

                break;
            // 8794832
            case 1:
                templete += `
                <h1>Las cajas se registran completas</h1>
                <br>
                <strong>Ruta Pedido</strong>
                <select id="ruta_pedido" class="form-control">
                    <option value="Ruta1">Ruta Nro 1</option>
                    <option value="Ruta2">Ruta Nro 2</option>
                    <option value="Ruta3">Ruta Nro 3</option>
                    <option value="Ruta4">Ruta Nro 4</option>
                    <option value="Ruta5">Ruta Nro 5</option>
                    <option value="Ruta6">Ruta Nro 6</option>
                    <option value="Ruta7">Ruta Nro 7</option>
                    <option value="Ruta8">Ruta Nro 8</option>
                    <option value="Ruta9">Ruta Nro 9</option>
                    <option value="Ruta10">Ruta Nro 10</option>
                    <option value="Ruta11">Ruta Nro 11</option>
                    <option value="Ruta12">Ruta Nro 12</option>
                    <option value="Ruta13">Ruta Nro 13</option>
                    <option value="Ruta14">Ruta Nro 14</option>
                    <option value="Ruta15">Ruta Nro 15</option>
                    <option value="Ruta16">Ruta Nro 16</option>
                    <option value="Ruta17">Ruta Nro 17</option>
                    <option value="Ruta18">Ruta Nro 18</option>
                    <option value="Ruta19">Ruta Nro 19</option>
                    <option value="Ruta20">Ruta Nro 20</option>
                </select>`;

                $('#cerrar_pedido_content').html(templete);

                break;
        }
    });
}

function update_cerrar_pedido() {

    let id_pedido = $('#id_pedido').val();
    let observaciones_pedido = $('#observaciones_pedido').val();
    if (observaciones_pedido == null) {
        observaciones_pedido = '';
    }

    let locacion_valor_declarado = $('#locacion_valor_declarado').val();

    let cambio_agencia = $('#cambio_agencia').val();

    let ruta_pedido = $('#ruta_pedido').val();
    let valor_declarado_cierre_pedido = $('#valor_declarado_cierre_pedido').val();

    fetch(`back-end/leer_bultos_solo/leer_bultos_solo.php`, {
        method: 'PUT',
        body: JSON.stringify({
            id_pedido: id_pedido,
            observacion: observaciones_pedido,
            ruta_pedido: ruta_pedido,
            cambio_agencia: cambio_agencia,
            locacion_valor_declarado: locacion_valor_declarado,
            valor_declarado_cierre_pedido: valor_declarado_cierre_pedido
        }),
        Headers: {
            Accept: 'application/json',
            'Content-Type': 'text/html'
        }
    })
        .then((response) => response.text())
        .then((responseData) => {
            console.log(responseData);
            let resp = parseInt(responseData);

            if (resp == 200) {
                location.reload();
                Toast.fire({
                    icon: 'success',
                    title: 'Actualizacion de estado de tarea'
                });
            } else if (resp == 300) {
                Toast.fire({
                    icon: 'error',
                    title: 'La ruta seleccionada ya tiene una agencia asignada y no corresponde a la seleccionada'
                });
            } else if (resp == 400) {
                Toast.fire({
                    icon: 'error',
                    title: 'Error de actualizacion de estado'
                });
            }

        })
        .catch((error) => {
            console.error('error', error)
        });
}

async function datos_bultos_sin_bulto(bultocode, tipo_ecoflex = '') {

    let id_bulto = document.getElementById("bultocode");
    id_bulto.focus();
    id_bulto.value = '';

    //Tabla de los bultos de un pedido
    let templete_bulto = `
        <table id="tabla_bulto" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Bulto</th>
                    <th>Pedido</th>
                    <th>Numero de Bulto</th>
                </tr>
            </thead>
            <tbody>`;
    let fin_templete_bulto = `</tbody></table>`;
    let body_bulto = '';

    await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?bultos_consul=${bultocode}&tipo_ecoflex=${tipo_ecoflex}`, function (response) {
        o = JSON.parse(response);
        console.log(o);

        o.forEach(item => {
            body_bulto += `
        <tr>
            <td>${item.cod_bulto}</td>
            <td>${item.cod_pedido}</td>
            <td>${item.num_bulto}</td>
        </tr>`;
        });
        $('#tabla_bulto_span').html(templete_bulto + body_bulto + fin_templete_bulto);
    });

    //Tabla datos del pedido
    let templete = `
        <table id="tabla_pedido" class="table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Pedido</th>
                    <th>Remesa</th>
                    <th>Agencia</th>
                    <th>Cliente</th>
                    <th>Direccion</th>
                    <th>Cajas sistema</th>
                    <th>Cajas fisicas</th>
                </tr>
            </thead>
            <tbody>`;
    let fin_templete = `</tbody></table>`;
    let body = '';

    await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?pedido_consul=${bultocode}&tipo_ecoflex=${tipo_ecoflex}`, function (response) {

        p = JSON.parse(response);
        console.log(p);

        $('#valor_declarado_cierre_pedido').val(p[0].importe);

        p.forEach(item => {

            let estado_pedido = (item.cajas_sistema == item.cajas_fisica ? 1 : 0);
            crear_boton_cierre(estado_pedido);

            $('#id_pedido').val(item.id_cons);
            $('#pedido').val(item.cod_pedido);
            $('#agencia').val(item.agencia);

            body += `
                <tr>
                    <td>${item.cod_pedido}</td>
                    <td>${item.remesa}</td>
                    <td>${item.agencia}</td>
                    <td>${item.cliente}</td>
                    <td>${item.direccion}</td>
                    <td>${item.cajas_sistema}</td>
                    <td>${item.cajas_fisica}</td>
                </tr>`;
        })
        $('#tabla_pedido_span').html(templete + body + fin_templete);
    });
}

async function datos_bultos(bultocode, tipo_ecoflex = '') {

    let id_bulto = document.getElementById("bultocode");
    id_bulto.focus();
    id_bulto.value = '';

    console.log("Verificacion version")

    await $.post(`back-end/leer_bultos_solo/leer_bultos_solo.php`, { bultocode, tipo_ecoflex }, async function (response) {
        let bulto = parseInt(response);
        console.log(response);

        if (bulto == 300) {
            // Toast.fire({
            //     icon: 'error',
            //     title: 'Error, el bulto no esta en estado 7000'
            // });
            Swal.fire({
                icon: 'error',
                title: 'Error, el bulto no esta en estado 11500'
            });
        }

        if (bulto == 200) {
            //Tabla de los bultos de un pedido
            let templete_bulto = `
                <table id="tabla_bulto" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Bulto</th>
                            <th>Pedido</th>
                            <th>Numero de Bulto</th>
                        </tr>
                    </thead>
                    <tbody>`;
            let fin_templete_bulto = `</tbody></table>`;
            let body_bulto = '';

            await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?bultos_consul=${bultocode}&tipo_ecoflex=${tipo_ecoflex}`, function (response) {
                o = JSON.parse(response);
                console.log(o);

                o.forEach(item => {
                    body_bulto += `
                        <tr>
                            <td>${item.cod_bulto}</td>
                            <td>${item.cod_pedido}</td>
                            <td>${item.num_bulto}</td>
                        </tr>`;
                });
                $('#tabla_bulto_span').html(templete_bulto + body_bulto + fin_templete_bulto);
            });

            //Tabla datos del pedido
            let templete = `
                <table id="tabla_pedido" class="table table-striped table-bordered">
                    <thead>
                        <tr>
                            <th>Pedido</th>
                            <th>Remesa</th>
                            <th>Agencia</th>
                            <th>Cliente</th>
                            <th>Direccion</th>
                            <th>Cajas sistema</th>
                            <th>Cajas fisicas</th>
                        </tr>
                    </thead>
                    <tbody>`;
            let fin_templete = `</tbody></table>`;
            let body = '';

            await $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?pedido_consul=${bultocode}&tipo_ecoflex=${tipo_ecoflex}`, function (response) {

                p = JSON.parse(response);
                console.log(p);

                $('#valor_declarado_cierre_pedido').val(p[0].importe);
                p.forEach(item => {

                    let estado_pedido = (item.cajas_sistema == item.cajas_fisica ? 1 : 0);
                    crear_boton_cierre(estado_pedido);

                    $('#id_pedido').val(item.id_cons);
                    $('#pedido').val(item.cod_pedido);
                    $('#agencia').val(item.agencia);

                    body += `
                    <tr>
                        <td>${item.cod_pedido}</td>
                        <td>${item.remesa}</td>
                        <td>${item.agencia}</td>
                        <td>${item.cliente}</td>
                        <td>${item.direccion}</td>
                        <td>${item.cajas_sistema}</td>
                        <td>${item.cajas_fisica}</td>
                    </tr>`;
                })
                $('#tabla_pedido_span').html(templete + body + fin_templete);
                $('#tabla_pedido').DataTable({
                    language: {
                        url: "./js/es.json"
                    },
                });
            });
        }
        
        if(bulto == 400){
            Toast.fire({
                icon: 'error',
                title: 'Error insertar bulto, por favor comunicar a soporte'
            });
        }
    });
}

function calculo_valor_declarado(tipo_ruta) {

    let id_pedido = $('#id_pedido').val();
    let valor_factura = $('#valor_factura').val();

    $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?id_pedido_vd=${id_pedido}&tipo_ruta=${tipo_ruta}&cal_vd=all&valor_factura=${valor_factura}`, function (response) {

        console.log(response)

        $("#valor_declarado_cierre_pedido").val(response);

    });
}
