const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

async function insertar_bulto() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    let bultocode = $("#bultocode").val();
    $("#bultocode_v").val(bultocode);

    if (bultocode == '') {
        Toast.fire({
            icon: 'error',
            title: 'Codigo de bulto no encontrada'
        });
        Swal.close();
    } else {
        console.log('bn1');
        // $.get(`back-end/leer_bultos/leer_bultos.php?bulto_repetido=${postdata.num_bulto}&cod_pedido_b=${peticion_bulto}`, function (response) {
        await $.get(`back-end/leer_bultos_varios/leer_bultos_varios.php?bulto=${bultocode}`, async function (response) {
            let bulto = parseInt(response);
            console.log(response);

            if (bulto == 200) {
                console.log('bn2');
                await datos_bultos(bultocode);
                // await Swal.close();
                // await Toast.fire({
                //     icon: 'success',
                //     title: 'Bulto leido'
                // });
            } else {
                await Swal.close();
                await Toast.fire({
                    icon: 'error',
                    title: 'El bulto se encuentra ya ingresado en el pedido actual'
                });
                await call_data(bultocode);
            }
        });
    }
}

async function datos_bultos(bultocode) {
    console.log('bn3');
    document.getElementById("bultocode").focus();
    $("#bultocode").val('');

    //Bulto de prueba 183001226992490363
    await $.post(`back-end/leer_bultos_varios/leer_bultos_varios.php`, { bultocode }, async function (response) {
        let bulto = parseInt(response);
        console.log(response);

        if (bulto == 200) {
            await call_data(bultocode);
            await Toast.fire({
                icon: 'success',
                title: 'Bulto ingresado'
            });

        } else if (bulto == 300) {
            console.log(bulto)
            await Toast.fire({
                icon: 'error',
                title: 'La cantidad total de bultos es menor o igual a 20, por favor ingreselos de forma individual'
            });

        } else {
            await Toast.fire({
                icon: 'error',
                title: 'El bulto se encuentra ya ingresado en el pedido actual'
            });
        }
    });
}

function call_data(bultocode) {
    console.log('bn');
    $.get(`back-end/leer_bultos_varios/leer_bultos_varios.php?bulto_abierto=${bultocode}`, function (response) {

        let o = JSON.parse(response);
        console.log(o);

        //Tabla datos del pedido
        let templete = `
        <table id="tabla_pedido" class="table table-striped table-bordered" style="font-size: 12px;">
            <thead>
                <tr>
                    <th>Pedido</th>
                    <th>Remesa</th>
                    <th>Cliente</th>
                    <th>Agencia</th>
                    <th>Cajas sistema</th>
                    <th>Cajas fisicas</th>
                    <th>Cierre</th>
                    <th>Total Bultos</th>
                </tr>
            </thead>
            <tbody>`;
        let fin_templete = `</tbody></table>`;
        let body = '';

        o.forEach(item => {
            body += `
            <tr>
                <td>${item.cod_pedido}</td>
                <td>${item.remesa}</td>
                <td>${item.cliente}</td>
                <td>${item.agencia}</td>
                <td>${item.cajas_sistema}</td>
                <td>${item.cajas_fisica}</td>
                <td>${item.boton}</td>
                <td>${item.boton_todos}</td>
            </tr>`;
        })
        $('#tabla_pedido_span').html(templete + body + fin_templete);
    });
}

function cerrar_pedido(id_pedido, estado_pedido) {

    $('#id_pedido').val(id_pedido);
    let templete = ``;

    $.get(`back-end/leer_bultos_solo/leer_bultos_solo.php?id_pedido=${id_pedido}`, function (response) {

        let o = JSON.parse(response);

        if (o['proceso'] == 'N') {
            document.getElementById('valor_factura').readOnly = false;
            $('#porcentaje').val(o['valor_general']);
        } else {
            document.getElementById('valor_factura').readOnly = true;
        }

    });

    switch (estado_pedido) {
        case 0:
            // console.log("Cajas completas")
            templete += `
                <strong>Observaciones inconveniente de cierre</strong>
                <select id="observaciones_pedido" class="form-control">
                    <option value="Volumetria">Volumetria</option>
                    <option value="Reempaque">Reempaque</option>
                    <option value="Solicitud de Cliente">Solicitud de Cliente</option>
                </select><br>
                <strong>Ruta Pedido</strong>
                <select id="ruta_pedido" class="form-control">
                    <option value="Ruta1">Ruta Nro 1</option>
                    <option value="Ruta2">Ruta Nro 2</option>
                    <option value="Ruta3">Ruta Nro 3</option>
                    <option value="Ruta4">Ruta Nro 4</option>
                    <option value="Ruta5">Ruta Nro 5</option>
                    <option value="Ruta6">Ruta Nro 6</option>
                    <option value="Ruta7">Ruta Nro 7</option>
                    <option value="Ruta8">Ruta Nro 8</option>
                    <option value="Ruta9">Ruta Nro 9</option>
                    <option value="Ruta10">Ruta Nro 10</option>
                    <option value="Ruta11">Ruta Nro 11</option>
                    <option value="Ruta12">Ruta Nro 12</option>
                    <option value="Ruta13">Ruta Nro 13</option>
                    <option value="Ruta14">Ruta Nro 14</option>
                    <option value="Ruta15">Ruta Nro 15</option>
                    <option value="Ruta16">Ruta Nro 16</option>
                    <option value="Ruta17">Ruta Nro 17</option>
                    <option value="Ruta18">Ruta Nro 18</option>
                    <option value="Ruta19">Ruta Nro 19</option>
                    <option value="Ruta20">Ruta Nro 20</option>
                </select>`;

            $('#cerrar_pedido_content').html(templete);

            break;

        case 1:
            // console.log("Cajas no completas")
            templete += `<h1>Las cajas se registran completas</h1><br>
                <strong>Ruta Pedido</strong>
                <select id="ruta_pedido" class="form-control">
                    <option value="Ruta1">Ruta Nro 1</option>
                    <option value="Ruta2">Ruta Nro 2</option>
                    <option value="Ruta3">Ruta Nro 3</option>
                    <option value="Ruta4">Ruta Nro 4</option>
                    <option value="Ruta5">Ruta Nro 5</option>
                    <option value="Ruta6">Ruta Nro 6</option>
                    <option value="Ruta7">Ruta Nro 7</option>
                    <option value="Ruta8">Ruta Nro 8</option>
                    <option value="Ruta9">Ruta Nro 9</option>
                    <option value="Ruta10">Ruta Nro 10</option>
                    <option value="Ruta11">Ruta Nro 11</option>
                    <option value="Ruta12">Ruta Nro 12</option>
                    <option value="Ruta13">Ruta Nro 13</option>
                    <option value="Ruta14">Ruta Nro 14</option>
                    <option value="Ruta15">Ruta Nro 15</option>
                    <option value="Ruta16">Ruta Nro 16</option>
                    <option value="Ruta17">Ruta Nro 17</option>
                    <option value="Ruta18">Ruta Nro 18</option>
                    <option value="Ruta19">Ruta Nro 19</option>
                    <option value="Ruta20">Ruta Nro 20</option>
                </select>`;

            $('#cerrar_pedido_content').html(templete);

            break;
    }
}

function cerrar_pedido_accion() {

    let id_pedido = $('#id_pedido').val();
    let observaciones_pedido = $('#observaciones_pedido').val();
    if (observaciones_pedido == null) {
        observaciones_pedido = '';
    }

    let ruta_pedido = $('#ruta_pedido').val();
    let locacion_valor_declarado = $('#locacion_valor_declarado').val();
    let valor_declarado_cierre_pedido = $('#valor_declarado_cierre_pedido').val();

    fetch(`back-end/leer_bultos_varios/leer_bultos_varios.php`, {
        method: 'PUT',
        body: JSON.stringify({
            id_pedido: id_pedido,
            observacion: observaciones_pedido,
            ruta_pedido: ruta_pedido,
            locacion_valor_declarado: locacion_valor_declarado,
            valor_declarado_cierre_pedido: valor_declarado_cierre_pedido,
            cerrar_pedido: '1'
        }),
        Headers: {
            Accept: 'application/json',
            'Content-Type': 'text/html'
        }
    })
        .then((response) => response.text())
        .then((responseData) => {
            console.log(responseData);
            let resp = parseInt(responseData);
            let bultocode = $("#bultocode_v").val();
            if (resp == 200) {
                $('#cerrar_pedido_modal').modal('hide');
                call_data(bultocode)
                Toast.fire({
                    icon: 'success',
                    title: 'Actualizacion de estado de tarea'
                });
            } else {
                Toast.fire({
                    icon: 'error',
                    title: 'Error de actualizacion de estado'
                });
            }

        })
        .catch((error) => {
            console.error('error', error)
        });
}

function id_total_bultos(id_pedido) {
    $('#id_pedido').val(id_pedido);
}

function cambiar_estado_pedido() {

    let id_pedido = $('#id_pedido').val();
    let num_fisicas = $('#num_fisicas').val();

    console.log(num_fisicas)

    if (num_fisicas == '' || num_fisicas == '0') {
        Toast.fire({
            icon: 'error',
            title: 'Ingrese un numero de cajas fisicas valido'
        });
    } else {

        Swal.fire({
            title: 'Cargando...',
            html: 'Espere un momento por favor.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        fetch(`back-end/leer_bultos_varios/leer_bultos_varios.php`, {
            method: 'PUT',
            body: JSON.stringify({
                id_pedido: id_pedido,
                num_fisicas: num_fisicas,
                cargue_masivo: '1'
            }),
            Headers: {
                Accept: 'application/json',
                'Content-Type': 'text/html'
            }
        })
            .then((response) => response.text())
            .then(async (responseData) => {
                console.log(responseData);

                let resp = parseInt(responseData);
                let bultocode = $("#bultocode_v").val();
                if (resp == 200) {
                    $('#cargar_bulto_total').modal('hide');

                    await call_data(bultocode);
                    Toast.fire({
                        icon: 'success',
                        title: 'Actualizacion de pedido'
                    });
                    await Swal.close();
                } else {
                    Toast.fire({
                        icon: 'error',
                        title: 'Error de actualizacion de estado'
                    });
                }

            })
            .catch((error) => {
                console.error('error', error)
            });
    }

}

function calculo_valor_declarado(tipo_ruta) {

    let id_pedido = $('#id_pedido').val();
    let valor_factura = $('#valor_factura').val();

    $.get(`back-end/leer_bultos_varios/leer_bultos_varios.php?id_pedido_vd=${id_pedido}&tipo_ruta=${tipo_ruta}&cal_vd=all&valor_factura=${valor_factura}`, function (response) {

        console.log(response)

        $("#valor_declarado_cierre_pedido").val(response);

    });
}

function calculo_manual() {

    let porcentaje = $('#porcentaje').val();
    let valor = $('#valor_factura').val();
    let calculo = valor * porcentaje;

    $('#valor_declarado_cierre_pedido').val(new Intl.NumberFormat('en-US').format(calculo));

}