const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function genera_despacho() {
    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();
    let agencia = $('#agencia').val();
    let estado = $('#estado').val();
    //console.log("bn") http://129.146.161.23/orion/
    window.open('back-end/informe_bulto/informe_despachos.php?fd=' + fecha_ini + '&fh=' + fecha_fin + '&agencia=' + agencia + '&estado=' + estado, '_blank');
}

function lista_integra() {
    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();
    let agencia = $('#agencia').val();
    //console.log("bn")
    window.open('back-end/informe_bulto/informe_integra_solistica.php?fd=' + fecha_ini + '&fh=' + fecha_fin + '&agencia=' + agencia, '_blank');
}

function consul_pedidos() {

    let agencia = $('#agencia').val();
    let estado = $('#estado').val();
    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();

    if (estado === 'cerrado') {
        $('#integrar_boton').show();
    } else {
        $('#integrar_boton').hide();
    }

    if (estado !== 'lectura') {
        $('#lista_despachos').show();
    }

    $.get(`back-end/listar_pedidos/listar_pedidos.php?agencia=${agencia}&estado=${estado}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}`, async function (response) {
        let templete = `
        <table id="tabla_lista" class="table table-striped table-bordered" style="font-size:10px;">
            <thead>
                <tr>
                    ${estado == 'cerrado' ? '<th>Check Despacho</th>' : '<th></th>'}
                    <th>Codigo Bulto</th>
                    <th>Remesa</th>
                    <th>Cliente</th>
                    <th>Agencia</th>
                    <th>Direccion</th>
                    <th>Cajas Sistema</th>
                    <th>Cajas fisica</th>
                    <th>Estado</th>
                    <th>Usuario</th>
                    <th></th>
                    <th></th>
                </tr>
            </thead>
            <tbody>`;
        let body = ``;
        let templete_end = `</tbody></table>`;

        let o = JSON.parse(response);
        console.log(o);
        let boton_integracion = '';
        o.forEach(item => {

            let boton = `<button class="btn btn-success btn-sm" data-toggle="modal" data-target="#bultos_pedido" onclick="ver_bultos('${item.cod_pedido}','${item.agencia}')">Bultos</button>`;

            let integracion_active = '';
            if (item.confirmacion_pedido == 'Cerrado') {
                integracion_active = '';
            } else {
                integracion_active = 'disabled';
            }
            if (agencia == 'PHLANDFAST') {
                boton_integracion = `<button class="btn btn-info btn-sm ${integracion_active}" data-toggle="modal" data-target="#confirmar_servicio" onclick="confirma_servicio(${item.id_cons})">Despachar</button>`;
            } else {
                boton_integracion = `<button class="btn btn-info btn-sm ${integracion_active}" onclick="integrar_individual(${item.id_cons})">Despachar</button>`;
            }

            let check_integracion = `<input type="checkbox" checked ${estado == 'cerrado' ? '' : 'disabled'} value="${item.id_cons}">`;

            body += `
            <tr>
                <td>${check_integracion}</td>
                <td>${item.cod_pedido}</td>
                <td>${item.remesa}</td>
                <td>${item.cliente}</td>
                <td>${item.agencia}</td>
                <td>${item.direccion}</td>
                <td>${item.cajas_sistema}</td>
                <td>${item.cajas_fisica}</td>
                <td>${item.confirmacion_pedido}</td>
                <td>${item.usuario}</td>
                <td>${boton}</td>
                <td>${boton_integracion}</td>
            </tr>`;
        });

        await $('#tabla_lista_pedidos').html(templete + body + templete_end);
        await $('#tabla_lista').DataTable({
            language: {
                url: "./js/es.json"
            }
        });
    });

    $('#container_tabla_pedidos').show();
}

function confirma_servicio(id) {
    let boton_integracion = `<button class="btn btn-info btn-sm" onclick="integrar_individual(${id})">Despachar</button>`;
    $("#btn_confi").html(boton_integracion);
    console.log('bn')
}

function lista_despachos() {

    let agencia = $('#agencia').val();
    let estado = $('#estado').val();
    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();

    window.open(`back-end/pdf_despachos/pdf.php?agencia=${agencia}&estado=${estado}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}`);

}

function ver_bultos(pedido, agencia) {

    $.get(`back-end/listar_pedidos/listar_pedidos.php?cod_pedido=${pedido}&agencia=${agencia}`, function (response) {
        let templete = `
        <table class="table data-table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Codigo Pedido</th>
                    <th>Agencia</th>
                    <th>Codigo Bulto</th>
                    <th>Num. Bulto</th>
                </tr>
            </thead>
            <tbody>`;
        let body = ``;
        let templete_end = `</tbody></table>`;

        let o = JSON.parse(response);
        console.log(o);

        o.forEach(item => {

            body += `
            <tr>
                <td>${item.cod_pedido}</td>
                <td>${item.agencia}</td>
                <td>${item.cod_bulto}</td>
                <td>${item.num_bulto}</td>
            </tr>`;
        });

        $('#table_bultos_pedidos').html(templete + body + templete_end);
    });

}

function integrar_seleccion() {
    let integracion = new Array();
    Swal.fire({
        title: "¿Desea despachar la linea seleccionada?",
        showDenyButton: true,
        confirmButtonText: "Si",
        denyButtonText: "No"
    }).then((result) => {
        if (result.isConfirmed) {

            $('input[type=checkbox]:checked').each(function () {
                integracion.push($(this).val());
            });

            if (integracion.length == 0) {
                Swal.fire('No hay pedidos para despachar.', '', 'error');
            } else {

                // fetch(`back-end/listar_pedidos/listar_pedidos.php`, {
                //     method: 'PUT',
                //     body: JSON.stringify({
                //         integracion: integracion
                //     }),
                //     Headers: {
                //         Accept: 'application/json',
                //         'Content-Type': 'text/html'
                //     }
                // })
                //     .then((response) => response.text())
                //     .then((responseData) => {
                //         console.log(responseData);

                //     })
                //     .catch((error) => {
                //         console.error('error', error)
                //     });

                $.ajax({
                    type: 'PUT',
                    url: 'back-end/listar_pedidos/listar_pedidos.php',
                    data: JSON.stringify({
                        integracion: integracion
                    }),
                    contentType: 'application/json',
                    success: function (datos) {
                        console.log('Peticion PUT exitosa', datos);
                        Swal.fire('Se despachan los pedidos con exito', '', 'success')
                        consul_pedidos();
                    },
                    error: function (xhr, status, error) {
                        console.log('Error en la peticion PUT', error);
                        Swal.fire('Error!', 'Error al despachar los pedidos', 'Error')
                    }
                });
            }
        }
    });
}

async function integrar_individual1(id) {
    let id_cons = id;
    Swal.fire({
        title: "¿Desea despachar la linea seleccionada?",
        showDenyButton: true,
        confirmButtonText: "Si",
        denyButtonText: "No"
    }).then(async (result) => {
        if (result.isConfirmed) {

            await Swal.fire({
                title: 'Cargando...',
                html: 'Espere un momento por favor.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            await fetch(`back-end/listar_pedidos/listar_pedidos.php`, {
                method: 'PUT',
                body: JSON.stringify({
                    id_cons: id_cons
                }),
                Headers: {
                    Accept: 'application/json',
                    'Content-Type': 'text/html'
                }
            })
                .then((response) => response.text())
                .then((responseData) => {
                    console.log(responseData);
                    consul_pedidos();
                })
                .catch((error) => {
                    console.error('error', error)
                });

            Swal.close();

            Swal.fire('Se despachan los pedidos con exito', '', 'success')
        }
    });
}

function activa_fec(){
    let servicio = $("#servicio_confi").val();
    if(servicio== '0'){
        document.getElementById('act_fecha_cita').style.display="block";
    }
}

function integrar_individual(id) {
    let servicio = $("#servicio_confi").val();
    let id_cons = id;
    Swal.fire({
        title: "Quiere despachar el pedido?",
        // text: "You won't be able to revert this!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Si, Despachar!"
    }).then((result) => {
        if (result.isConfirmed) {

            // fetch(`back-end/listar_pedidos/listar_pedidos.php`, {
            //     method: 'PUT',
            //     body: JSON.stringify({
            //         id_cons: id_cons
            //     }),
            //     Headers: {
            //         Accept: 'application/json',
            //         'Content-Type': 'text/html'
            //     }
            // })
            //     .then((response) => response.text())
            //     .then((responseData) => {
            //         console.log(responseData);

            //     })
            //     .catch((error) => {
            //         console.error('error', error)
            //     });

            $.ajax({
                type: 'PUT',
                url: `back-end/listar_pedidos/listar_pedidos.php`,
                data: JSON.stringify({
                    id_cons: id_cons,
                    servicio: servicio
                }),
                success: function (datos) {
                    console.log('Peticion PUT exitosa', datos);

                    Swal.fire({
                        title: "Despachado!",
                        text: "Pedido despachado correctamente",
                        icon: "success"
                    });
                    consul_pedidos();
                },
                error: function (xhr, status, error) {
                    console.log('Error en la peticion PUT', error);
                    Swal.fire({
                        title: "Error!",
                        text: "Error al despachar el pedido",
                        icon: "error"
                    });
                }
            });
        }
    });
}

$('#container_tabla_pedidos').hide();
    $('#integrar_boton').hide();
    $('#lista_despachos').hide();
    
    //Pasar la fecha
    var fecha = new Date(); //Fecha actual
    var mes = fecha.getMonth()+1; //obteniendo mes
    var dia = fecha.getDate(); //obteniendo dia
    var ano = fecha.getFullYear(); //obteniendo a単o
    if(dia<10)
        dia='0'+dia; //agrega cero si el menor de 10
    if(mes<10)
        mes='0'+mes //agrega cero si el menor de 10 f_exp_mat
        var anoa = ano-1;
    //document.getElementById('mes').value=mes;

    document.getElementById('fecha_ini').value=ano+"-"+mes+"-"+dia;
    document.getElementById('fecha_fin').value=ano+"-"+mes+"-"+dia;
    document.getElementById('f_cita').value=ano+"-"+mes+"-"+dia;