// CONSULTAR TABLA ORDEN DE TRANSPORTE

function tomarDatos() {
    $.get(`back-end/orden_transporte/orden_transporte.php`, { tomar_datos: true }, function(response){
        let datos = JSON.parse(response); 
        console.log(datos); 
        let tableContent = '';
        datos.forEach(function(row){
            tableContent += `
                <tr>
                    <td>${row.id}</td>
                    <td>${row.fecha}</td>
                    <td>${row.cliente}</td>
                    <td>${row.solicitante}</td>
                    <td>${row.destino}</td>
                    <td>${row.direccion}</td>
                    <td>${row.un_recoger}</td>
                    <td>${row.un_recibir}</td>
                    <td>${row.fecha_entrega}</td>
                    <td>
                        <a href="#" onclick="imprimirDatos('${row.id}')"  class="button btn btn-primary  btn-sm ml-2 button-icon rounded-small" >
                            <i class="las la-print la-2x"></i>
                        </a>
                    </td>
                    <td>
                        <a href="#"
                            onclick="datosModalEditar('${row.id}', '${row.fecha}', '${row.cliente}', '${row.solicitante}', '${row.destino}', '${row.direccion}', '${row.un_recoger}', '${row.un_recibir}', '${row.fecha_entrega}')"  
                            class="button btn btn-warning  btn-sm ml-2 button-icon rounded-small" 
                            data-toggle="modal"  
                            data-target="#modal_editar"                          
                        >
                           <i class="las la-pen la-2x"></i>
                        </a>                       
                    </td>                       
                 
                </tr>
            `;
        });

        // TODO: FUNCIONALIDAD BOTON ELIMINAR
        // <td>
        // <a href="#" 
        // class="button btn btn-danger btn-sm ml-2 button-icon rounded-small" data-toggle="modal"  data-target="#modal_eliminar"
        // onclick="datosModalEliminar('${row.id}')"                         
        // >
        //     <i class="las la-trash la-2x"></i>
        // </a> 
        // </td>      

        $('#filas-pedidos').html(tableContent);   
    
        $('#ordenesTable').DataTable({
            
            "searching": true,
            "ordering": false,
            "destroy": true,
            language: {
                url: '//cdn.datatables.net/plug-ins/2.1.8/i18n/es-MX.json',
            },
        });
        
   

        
        

    }).fail(function(error) {
        console.log('Error en la solicitud:', error);
    });
}

////////////////////////////

// EDITAR

function datosModalEditar(id, fecha, cliente, solicitante, destino, direccion, un_recoger, un_recibir, fecha_entrega) {
    $('#editId').val(id);
    $('#editFecha').val(fecha);
    $('#editCliente').val(cliente);
    $('#editSolicita').val(solicitante);
    $('#editDestino').val(destino);
    $('#editDireccion').val(direccion);
    $('#editUn_recoger').val(un_recoger);
    $('#editUn_recibir').val(un_recibir);
    $('#editFecha_entrega').val(fecha_entrega);

    // Mostrar el modal
    $('#modal_editar').modal('show');
}

function editarDatos() {
    let datosOrden = {
        id: $('#editId').val(),
        fecha: $('#editFecha').val(),
        cliente: $('#editCliente').val(),
        estado: "1",
        solicitante: $('#editSolicita').val(),
        destino: $('#editDestino').val(),
        direccion: $('#editDireccion').val(),
        un_recoger: $('#editUn_recoger').val(),
        un_recibir: $('#editUn_recibir').val(),
        fecha_entrega: $('#editFecha_entrega').val()
    };


    $.post('back-end/orden_transporte/orden_transporte.php', { actualizar_datos: datosOrden}, function(response) {
        console.log('Datos actualizados:', response);
        location.reload();
        $('#modal_editar').modal('hide');  
    }).fail(function(error) {
        console.log('Error al actualizar los datos:', error);
    });
}

//////////////

// ELIMINAR

function datosModalEliminar(id){
    $('#eliminarID').val(id);


    // Mostrar el modal
    $('#modal_eliminar').modal('show');
}

function eliminarDatos(){
    let datosOrden = {
        id: $('#eliminarID').val()
    }
   

    $.post(`back-end/orden_transporte/orden_transporte.php`, { eliminar_datos: datosOrden}, function(response){
        console.log("Respuesta del servidor:", response);
        location.reload();
        $('#modal_eliminar').modal('hide');
   
    })
}

//  AGREGAR DATOS //

function agregarDatos(){
    let consecutivo = document.getElementById('consec').value,
        fecha = document.getElementById('fecha').value,
        cliente = document.getElementById('cliente').value,
        solicita = document.getElementById('solicita').value,
        destino = document.getElementById('destino').value,
        direccion = document.getElementById('direccion').value,
        observaciones = document.getElementById('observaciones').value,
        unsARecoger = document.getElementById('unsARecoger').value, 
        unsRecibidas = document.getElementById('unsRecibidas').value,
        fechaEntrega = document.getElementById('FechaEntrega').value;
        estado = "0";

    let camposVacios = [];

    if (consecutivo === '') camposVacios.push('Doc Referencia');
    if (fecha === '') camposVacios.push('Fecha');
    if (cliente === '') camposVacios.push('Cliente');
    if (solicita === '') camposVacios.push('Solicita');
    if (destino === '') camposVacios.push('Destino');
    if (direccion === '') camposVacios.push('Dirección');
    if (unsARecoger === '') camposVacios.push('Unidades a recoger');
    if (observaciones === '') camposVacios.push('Observaciones');

    if (camposVacios.length > 0) {
        alert(`Por favor, complete los siguientes campos: ${camposVacios.join(', ')}`);
        return;
    }

    let datos = {
        consecutivo : consecutivo,
        fecha : fecha,
        cliente : cliente,
        estado : "0",
        solicita : solicita,
        destino : destino,
        direccion : direccion,
        observaciones : observaciones,
        unsARecoger : unsARecoger,
        unsRecibidas : unsRecibidas,
        fechaEntrega : fechaEntrega
    }; 
    

    $.post(`back-end/orden_transporte/orden_transporte.php`, { cargar_datos: datos}, function(response){
        console.log("Respuesta del servidor:", response);
        location.reload();
        $('#modal_agregar').modal('hide');

        $('#modal_agregar').on('hidden.bs.modal', function () {
            $('#consec').val('');
            $('#fecha').val('');
            $('#cliente').val('');
            $('#solicita').val('');
            $('#destino').val('');
            $('#direccion').val('');
            $('#observaciones').val('');
            $('#unsARecoger').val('');
            $('#unsRecibidas').val('');
            $('#FechaEntrega').val('');
        });
    
       
    })


}       

 // CONSULTAR DATOS //
    function datosModalConsultar(id){
        $('#consultId').val(id);

        $('#modal_consultar').modal('show');
    }


    function consultarDatos() {

        let id = document.getElementById('consultId').value; 
        console.log(id);
    
        $.get('back-end/orden_transporte/orden_transporte.php', { consultar_datos: id }, function(response) {
            console.log("Respuesta del servidor:", response);
    
            let datos;
            console.log(datos);
            try {
                datos = JSON.parse(response);
            } catch (e) {
                console.error('Error al parsear JSON:', e);
                return;
            }
    

            if (datos) {
                document.getElementById('consultFecha').value = datos.fecha;
                document.getElementById('consultCliente').value = datos.cliente;
                document.getElementById('consultSolicita').value = datos.solicita;
                document.getElementById('consultDestino').value = datos.destino;
                document.getElementById('consultDireccion').value = datos.direccion;
                document.getElementById('consultObservaciones').value = datos.observaciones;
                document.getElementById('consultUnrecoger').value = datos.uns_a_recoger; 
                document.getElementById('consultUnrecibir').value = datos.uns_a_recibir; 
                document.getElementById('consultFechaEntrega').value = datos.fecha_entrega; 
            } else {
                alert("No se encontraron datos.");
            }
        });

        $('#modal_consultar').on('hidden.bs.modal', function () {
            // Restablecer los valores de los campos del formulario a vacío
            $('#consultId').val('');
            $('#consultFecha').val('');
            $('#consultCliente').val('');
            $('#consultSolicita').val('');
            $('#consultDestino').val('');
            $('#consultDireccion').val('');
            $('#consultObservaciones').val('');
            $('#consultUnrecoger').val('');
            $('#consultUnrecibir').val('');
            $('#consultFechaEntrega').val('');
        });
    }


// IMPRIMIR DATOS //

    function imprimirDatos(key){
        let id = key;
        
        window.open(`back-end/orden_transporte/pdf_orden_transporte.php?id=${id}`);
    }

    