const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function consulta() {

    let guia = $('#qrcode').val();

    if (guia == '') {
        Swal.fire({
            icon: 'error',
            title: 'Error de Datos',
            text: 'Por favor ingrese una remesa',
        })
    } else {
        $.ajax({
            url: 'back-end/asignar.php',
            type: 'GET',
            data: { guia },
            success: function (response) {
                console.log(response);
                if (response == 'NO') {
                    $('#error').modal("show");
                    $('#qrcode').val('');

                    Toast.fire({
                        icon: 'error',
                        title: 'Guia o Remesa no encontrada'
                    })

                } else {
                    let o = JSON.parse(response);
                    $('#guia').val(o.guia);
                    $('#pedido').val(o.pedido);
                    $('#cliente').val(o.cliente);
                    $('#telefono').val(o.tel_cliente);
                    $('#codigo').val(o.cod_cliente);
                    $('#direccion').val(o.direccion);
                    $('#poblacion').val(o.poblacion);
                    $('#obs').val(o.detalles);
                    $('#caja_seca').val(o.caja_seca);
                    $('#caja_fria').val(o.caja_fria);
                    $('#confirmar').modal("show");
                    $('#qrcode').val('');
                }

            }
        })
    }
}

function registrar() {

    const postData = {
        codigo_pedido: $('#pedido').val(),
        remesa: $('#guia').val(),
        codigo_cliente: $('#codigo').val(),
        cliente: $('#cliente').val(),
        telefono: $('#telefono').val(),
        direccion: $('#direccion').val(),
        poblacion: $('#poblacion').val(),
        obs: $('#obs').val(),
        caja_seca: $('#caja_seca').val(),
        caja_fria: $('#caja_fria').val(),
    };

    console.log(postData);

    $.post('back-end/guias.php', postData, function (response) {
        $('#form_confirma').trigger('reset');
        $("#confirmar").modal("hide");
        datos_solistica();

        console.log(response);
    });
}

function datos_solistica() {
    let templete = `
        <table id="datatable" class="table data-table table-striped table-bordered">
            <thead>
                <tr>
                    <th>Pedido</th>
                    <th>Remesa</th>
                    <th>Cliente</th>
                    <th>Direccion</th>
                    <th>Bodega</th>
                    <th>Estado</th>
                </tr>
            </thead>
            <tbody>`;
    let fin_templete = `</tbody></table>`;

    $.get(`back-end/consul_emp_log.php?emp_log=Solistica`, function (response) {
        console.log(response);
        o = JSON.parse(response);
        let body;
        o.forEach(element => {
            body += `
            <tr>
                <td onclick="modal_ped_soli('${element.guia}')">${element.codigo_pedido}</td>
                <td onclick="modal_ped_soli('${element.guia}')">${element.guia}</td>
                <td onclick="modal_ped_soli('${element.guia}')">${element.desc_cliente}</td>
                <td onclick="modal_ped_soli('${element.guia}')">${element.direccion}</td>
                <td onclick="modal_ped_soli('${element.guia}')">${element.bodega}</td>
                <td onclick="modal_ped_soli('${element.guia}')">${element.estado}</td>
            </tr>
            `;
        });

        $('#tabla_solistica').html(templete + body + fin_templete);
    });
}

function modal_datos(remesa) {
    $.get(`back-end/solistica/modal_pedido.php?remesa=${remesa}`, function (response) {
        console.log(response);

        o = JSON.parse(response);
        console.log(o);

        let lista_base_datos = o.base_datos;
        let fecha_integracion = o.fecha_integracion;
        let resp_cloud = o.respuesta;
        let estado = o.estado;

        if (estado == '') {
            $('#integracion').show();
        }

        console.log(lista_base_datos);

        $('#cod_pedido_interno').val(remesa);

        let cod_pedido = document.getElementById('cod_pedido');
        cod_pedido.innerHTML = lista_base_datos.pedido;
        let cod_guia = document.getElementById('cod_guia');
        cod_guia.innerHTML = lista_base_datos.guia;
        let cod_cliente = document.getElementById('cod_cliente');
        cod_cliente.innerHTML = lista_base_datos.cod_cliente;
        let nom_cliente = document.getElementById('nom_cliente');
        nom_cliente.innerHTML = lista_base_datos.nom_cliente;
        let direccion = document.getElementById('direccion');
        direccion.innerHTML = lista_base_datos.direccion;
        let poblacion = document.getElementById('poblacion');
        poblacion.innerHTML = lista_base_datos.poblacion;
        let bodega = document.getElementById('bodega');
        bodega.innerHTML = lista_base_datos.bodega;

        let valor_declarado = document.getElementById('valor_declarado');
        valor_declarado.innerHTML = lista_base_datos.valor_declarado;

        let obs_vae = document.getElementById('obs_vae');
        obs_vae.innerHTML = lista_base_datos.obs;
        let fecha_entrega = document.getElementById('fecha_entrega');
        fecha_entrega.innerHTML = lista_base_datos.fecha_registro;

        let divicion = document.getElementById('divicion');
        divicion.innerHTML = lista_base_datos.divicion;
        let num_cajas = document.getElementById('num_cajas');
        num_cajas.innerHTML = lista_base_datos.cajas;
        let fecha_registro = document.getElementById('fecha_registro');
        fecha_registro.innerHTML = lista_base_datos.fecha_registro;
        let fecha_pedido = document.getElementById('fecha_pedido');
        fecha_pedido.innerHTML = lista_base_datos.fecha_registro;
        let fecha_apertura = document.getElementById('fecha_apertura');
        fecha_apertura.innerHTML = lista_base_datos.fecha_apertura;
        let fecha_terminacion = document.getElementById('fecha_terminacion');
        fecha_terminacion.innerHTML = lista_base_datos.fecha_terminacion;
        let fecha_salida = document.getElementById('fecha_salida');
        fecha_salida.innerHTML = lista_base_datos.fecha_registro;
        let fecha_asignacion = document.getElementById('fecha_asignacion');
        fecha_asignacion.innerHTML = fecha_integracion;
        let obser_entega = document.getElementById('obser_entega');
        obser_entega.innerHTML = lista_base_datos.obs;
        let resp_cloud_input = document.getElementById('resp_cloud');
        resp_cloud_input.innerHTML = resp_cloud;
    });
}

function modal_ped_soli(id_pedido) {
    console.log(id_pedido);
    modal_datos(id_pedido);
    $('#detalle_orden').modal("show");
}

function integracion_pedido() {

    let remesa = $('#cod_pedido_interno').val();

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    fetch(`back-end/solistica/integracion.php`, {
        method: 'PUT',
        body: JSON.stringify({
            remesa: remesa
        }),
        Headers: {
            Accept: 'application/json',
            'Content-Type': 'text/html'
        }
    })
        .then((response) => response.text())
        .then(async (responseData) => {
            console.log(responseData);

            if (resp == 200) {

                await datos_solistica();
                Toast.fire({
                    icon: 'success',
                    title: 'Actualizacion de pedido'
                });
                await Swal.close();
            } else {
                Toast.fire({
                    icon: 'error',
                    title: 'Error de actualizacion de estado'
                });
            }

        })
        .catch((error) => {
            console.error('error', error)
        });
}