
const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
});

function call_table() {

    // let count_right = 0;
    // let count_wrong = 0;
    // let lista_errores = [];
    let lista_ftp = [];

    var tabla = $('#TablaExcel').DataTable({
        language: {
            url: "./js/es.json"
        },
    });

    var datos = tabla.rows().data().toArray();

    let timerInterval
    Swal.fire({
        didOpen: () => {
            Swal.showLoading()
        },
        willClose: () => {
            clearInterval(timerInterval)
        }
    })

    for (var i = 0; i < datos.length; i++) {
        var columna = 32;

        var celda = tabla.cell(i, columna);
        var nodoCelda = celda.nodes().to$();
        var select = nodoCelda.find('select');

        var valorSeleccionado = select.val();

        let POSTDATA = {
            CONSECUTIVO: datos[i][0],
            NIT: datos[i][2],
            NOMBRE: datos[i][3],
            NRO_PEDIDO_CTE: datos[i][4],
            NRO_DOCUMENTO_PEDIDO: datos[i][5],
            FECHA_PEDIDO: datos[i][6],
            FECHA_ENTREGA: datos[i][7],
            CODIGO_CLIENTE: datos[i][8],
            NIT_DESTINATARIO: datos[i][9],
            NOMBRE_DESTINATARIO: datos[i][10],
            DIRECCION_DESTINATARIO: datos[i][11],
            TELEFONO_DEST: datos[i][12],
            CIUDAD_DEST: datos[i][13],
            CODIGO_CLIENTE_REEXP: datos[i][14],
            DIRECCION_REEXP: datos[i][15],
            CIUDAD_REEXP: datos[i][16],
            BODEGA_ZONA_ORIGEN: datos[i][17],
            VALOR_ASEGURADO: datos[i][18],
            NOMBRE_DESTINATARIO_REEXP: datos[i][19],
            CODIGO_ARTICULO: datos[i][20],
            DESCRIPCION_ARTICULO: datos[i][21],
            CANTIDAD: datos[i][22],
            PRESENTACION: datos[i][23],
            NRO_LOTE: datos[i][24],
            FECHA_VTO: datos[i][25],
            VR_UNITARIO: datos[i][26],
            OBSERVACION: datos[i][27],
            ACONDICIONAR: datos[i][28],
            DESCRIP_ACONDICIONAMIENTO: datos[i][29],
            DIAS_CADUCIDAD: datos[i][30],
            STATUS: datos[i][31],
            BLOQUEOS: valorSeleccionado,
            ORDEN_DE_COMPRA: datos[i][33]
        }

        lista_ftp.push(POSTDATA);

        $.post('back-end/verificador.php', POSTDATA, function (response) {
            // console.log(response);
            switch (response) {
                case 200:
                    count_right += parseInt(count_right);
                    // registrar(datos[i][4], datos[i][5]);
                    break;

                case 400:
                    count_wrong += parseInt(count_wrong);
                    lista_errores.push(count_wrong);
                    break;
            }
        });
    }

    console.log(datos);

    $.ajax({
        url: "back-end/verificador.php",
        method: "POST",
        data: {
            bodega: datos[0][17],
            datos: lista_ftp,
            nombre: datos.length
        },
        // dataType: "json",
        success: function (data) {
            console.log(data);
        },
        error: function (error) {
            console.error("Hubo un error:", error);
        }
    });

    Toast.fire({
        icon: 'success',
        title: 'Cargue de datos correcto'
    })
}

function registrar() {

    const postData = {
        nro_guia: $('#guia').val(),
        nro_pedido: $('#pedido').val(),
    };

    $.post('back-end/guias.php', postData, function (response) {
        console.log(response);
    });
}

