<?php
date_default_timezone_set('America/Bogota');
include('config/database.php');
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
// Obtener JSON desde la URL remota
$url = 'http://129.146.161.23/BackEnd_Orion/movimientos_muelle.php?lista';
$json = file_get_contents($url);

if ($json === false) {
    die("Error al obtener el JSON desde la URL.");
}

// Decodificar el JSON
$dataArray = json_decode($json, true);

if (!is_array($dataArray)) {
    die("Error: JSON no válido o formato inesperado.");
}

// Preparar el statement solo una vez
// $stmt = $mysqli->prepare("INSERT INTO pedidos_muelles (
//     CODPED, CAJAS, DESCLI, POBLACION, HORAOPERACION, FECOPERACION, CODOPEEJEMOV, MUELLE, CEDI
// ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
$stmt = $mysqli->prepare("INSERT IGNORE INTO pedidos_muelles (
    CODPED, CAJAS, DESCLI, POBLACION, HORAOPERACION, FECOPERACION, CODOPEEJEMOV, MUELLE, CEDI, MATRICULA
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");


if (!$stmt) {
    die("Error al preparar el statement: " . $mysqli->error);
}

$stmt->bind_param("sissssssss", $CODPED, $CAJAS, $DESCLI, $POBLACION, $HORAOPERACION, $FECOPERACION, $CODOPEEJEMOV, $CODUBIDEST, $CEDI, $MATRICULA);

// Recorrer cada elemento del array
foreach ($dataArray as $item) {
    $CODPED = $item["CODPED"];
    $CAJAS = (int) $item["CAJAS"];
    $DESCLI = $item["DESCLI"];
    $POBLACION = $item["POBLACION"];
    $HORAOPERACION = $item["HORAOPERACION"];

    // Convertir fecha de dd/mm/yyyy a yyyy-mm-dd
    list($dia, $mes, $anio) = explode("/", $item["FECOPERACION"]);
    $FECOPERACION = "$anio-$mes-$dia";

    $CODOPEEJEMOV = $item["CODOPEEJEMOV"];
    $CODUBIDEST = $item["CODUBIDEST"];
    $CEDI = $item["CEDI"];
    $MATRICULA = $item["MATRICULA"];

    if (!$stmt->execute()) {
        echo "Error con pedido $CODPED: " . $stmt->error . "<br>";
    } else {
        echo "Registro con pedido $CODPED insertado correctamente.<br>";
    }
}

$stmt->close();
$mysqli->close();
?>
