
<?php 
// Headers CORS para permitir peticiones desde tu frontend
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

$metodo = $_SERVER['REQUEST_METHOD'];

if ($metodo == 'OPTIONS') {
    exit(0);
}

if ($metodo == 'GET') {
    try {
        // Lista de ubicaciones (corregido: agregado el parámetro)
        if (isset($_GET['lista_P003'])) {
            $url1 = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?lista_P003";
            $data_ubicaciones = file_get_contents($url1);
            echo $data_ubicaciones;
        }
        // Detalles de ubicación específica (corregido: usar $ubi en lugar de $cajaId)
        elseif (isset($_GET['codubi'])) {
            $ubi = $_GET['codubi'];
            $url1 = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?detalle&codubi=$ubi";
            $data_ubicaciones = file_get_contents($url1);
            echo $data_ubicaciones;
        }
        // Filtro por cliente y/o artículo
        elseif (isset($_GET['cliente_p3'])) {
            $cli = $_GET['cliente_p3'];
            if(isset($_GET['articulo'])){
                $art = $_GET['articulo'];
                $url1 = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?cliente_p3=$cli&articulo=$art";
                $data_pedidos = file_get_contents($url1);
                echo $data_pedidos;
            } else {
                $url1 = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?cliente_p3=$cli";
                $data_pedidos = file_get_contents($url1);
                echo $data_pedidos;
            }
        }
        // Lista de clientes
        elseif (isset($_GET['lista_cli'])) {
            $url1 = "http://129.146.161.23/BackEnd_Orion/lista_divisiones.php?lista";
            $data_ubicaciones = file_get_contents($url1);
            echo $data_ubicaciones;
        }
        // Artículos por cliente
        elseif (isset($_GET['coddiv'])) {
            $div = $_GET['coddiv'];
            $url1 = "http://129.146.161.23/BackEnd_Orion/lista_divisiones.php?articulos&coddiv=$div";
            $data_ubicaciones = file_get_contents($url1);
            echo $data_ubicaciones;
        }
        // Si no se encuentra ningún parámetro válido
        else {
            http_response_code(400);
            echo json_encode(['error' => 'Parámetro requerido no encontrado']);
        }
        
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error del servidor: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}
?>