<?php

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type');
header('Content-Type: application/json');

$metodo = $_SERVER['REQUEST_METHOD'];

if ($metodo == 'OPTIONS') {
    exit(0);
}

if ($metodo == 'GET') {
    try {
        // Lista de clientes
        if (isset($_GET['lista_cli'])) {
            $url = "http://129.146.161.23/BackEnd_Orion/lista_divisiones.php?lista";
            echo file_get_contents($url);
        }
        // Artículos por cliente
        elseif (isset($_GET['coddiv'])) {
            $div = $_GET['coddiv'];
            $url = "http://129.146.161.23/BackEnd_Orion/lista_divisiones.php?articulos&coddiv=$div";
            echo file_get_contents($url);
        }
        // Lista de ubicaciones generales
        elseif (isset($_GET['lista_P002'])) {
            $url = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?lista_P002";
            echo file_get_contents($url);
        }
        elseif (isset($_GET['lista_P002a'])) {
            $url = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?lista_P002a";
            echo file_get_contents($url);
        }
        elseif (isset($_GET['lista_P002b'])) {
            $url = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?lista_P002b";
            echo file_get_contents($url);
        }
        // Filtro por cliente y artículo
        elseif (isset($_GET['cliente_p2'])) {
            $cli = $_GET['cliente_p2'];
            $url = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?cliente_p2=$cli";
            if (isset($_GET['articulo'])) {
                $art = $_GET['articulo'];
                $url .= "&articulo=$art";
            }
            echo file_get_contents($url);
        }
        elseif (isset($_GET['cliente_p2a'])) {
            $cli = $_GET['cliente_p2a'];
            $url = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?cliente_p2a=$cli";
            if (isset($_GET['articulo'])) {
                $art = $_GET['articulo'];
                $url .= "&articulo=$art";
            }
            echo file_get_contents($url);
        }
        elseif (isset($_GET['cliente_p2b'])) {
            $cli = $_GET['cliente_p2b'];
            $url = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?cliente_p2b=$cli";
            if (isset($_GET['articulo'])) {
                $art = $_GET['articulo'];
                $url .= "&articulo=$art";
            }
            echo file_get_contents($url);
        }
        // Detalles de ubicación específica
        elseif (isset($_GET['codubi'])) {
            $ubi = $_GET['codubi'];
            $url = "http://129.146.161.23/BackEnd_Orion/datos_almacen.php?detalle&codubi=$ubi";
            echo file_get_contents($url);
        }
        // Si no se encuentra ningún parámetro válido
        else {
            http_response_code(400);
            echo json_encode(['error' => 'Parámetro requerido no encontrado']);
        }
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['error' => 'Error del servidor: ' . $e->getMessage()]);
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}
?>