<?php
date_default_timezone_set('America/Bogota');
include('config/database.php');
$metodo = $_SERVER['REQUEST_METHOD'];

if ($metodo == 'GET') {
    if (isset($_GET['agencias'])) {
        // Query SQL
        $sql = "SELECT agencia, COUNT(*) AS Nro_pedidos 
                FROM bultos_pedido_cab 
                WHERE fecha_lectura >= CURDATE() - INTERVAL 1 DAY 
                GROUP BY agencia";

        $result = mysqli_query($mysqli, $sql);

        // Verificar si hubo error en la consulta
        if (!$result) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Error en la consulta: ' . mysqli_error($conn)
            ]);
            mysqli_close($mysqli);
            exit;
        }

        // Construir array de resultados
        $data = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }   

        // Cerrar conexión
        mysqli_close($mysqli);

        // Respuesta JSON
        echo json_encode([
            'status' => 'success',
            'data' => $data
        ]);
    }
    if (isset($_GET['poblacion'])) {
        // Query SQL
        $sql = "SELECT agencia, poblacion, COUNT(*) Nro_pedidos FROM `bultos_pedido_cab` WHERE fecha_lectura >= CURDATE() - INTERVAL 1 DAY  GROUP BY agencia, poblacion";

        $result = mysqli_query($mysqli, $sql);

        // Verificar si hubo error en la consulta
        if (!$result) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Error en la consulta: ' . mysqli_error($conn)
            ]);
            mysqli_close($mysqli);
            exit;
        }

        // Construir array de resultados
        $data = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }

        // Cerrar conexión
        mysqli_close($mysqli);

        // Respuesta JSON
        echo json_encode([
            'status' => 'success',
            'data' => $data
        ]);
    }

    if (isset($_GET['user_cajas'])) {
        // Query SQL
        $sql = "SELECT username, COUNT(cod_bulto) cajas FROM `bultos_pedido_lin` WHERE fecha_lectura >= CURDATE() - INTERVAL 1 DAY  GROUP by username";

        $result = mysqli_query($mysqli, $sql);

        // Verificar si hubo error en la consulta
        if (!$result) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Error en la consulta: ' . mysqli_error($conn)
            ]);
            mysqli_close($mysqli);
            exit;
        }

        // Construir array de resultados
        $data = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }

        // Cerrar conexión
        mysqli_close($mysqli);

        // Respuesta JSON
        echo json_encode([
            'status' => 'success',
            'data' => $data
        ]);
    }
    if (isset($_GET['user_pedidos'])) {
        // Query SQL
        $sql = "SELECT username, COUNT(cod_pedido) cajas FROM `bultos_pedido_lin` WHERE fecha_lectura >= CURDATE() - INTERVAL 1 DAY  GROUP by username";

        $result = mysqli_query($mysqli, $sql);

        // Verificar si hubo error en la consulta
        if (!$result) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Error en la consulta: ' . mysqli_error($conn)
            ]);
            mysqli_close($mysqli);
            exit;
        }

        // Construir array de resultados
        $data = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }

        // Cerrar conexión
        mysqli_close($mysqli);

        // Respuesta JSON
        echo json_encode([
            'status' => 'success',
            'data' => $data
        ]);
    }
    if (isset($_GET['list_rutas'])) {
        // Query SQL
        $sql = "SELECT SUBSTRING_INDEX(observacion_cierre, '?', -1) Ruta, 'SIN PLACA' placa, COUNT(*) cantidad, 0 entregada, 0 procentaje FROM bultos_pedido_cab WHERE fecha_cierre >= CURDATE() - INTERVAL 1 DAY AND agencia='PHAREX' GROUP BY SUBSTRING_INDEX(observacion_cierre, '?', -1)";

        $result = mysqli_query($mysqli, $sql);

        // Verificar si hubo error en la consulta
        if (!$result) {
            echo json_encode([
                'status' => 'error',
                'message' => 'Error en la consulta: ' . mysqli_error($conn)
            ]);
            mysqli_close($mysqli);
            exit;
        }

        // Construir array de resultados
        $data = [];

        while ($row = mysqli_fetch_assoc($result)) {
            $data[] = $row;
        }

        // Cerrar conexión
        mysqli_close($mysqli);

        // Respuesta JSON
        echo json_encode([
            'status' => 'success',
            'data' => $data
        ]);
    }
}
