<?php

$idClient  = $_GET['clientID'] ?? '';
$getPedido = $_GET['c'] ?? '';

header("Location: https://bilpharex.co//ConsultTrackingOrder/executeViewPedido?c=" . urlencode($getPedido) . "&clientID=" . urlencode($idClient));

$apiUrl = "http://129.146.151.238/bilv2/ConsultTrackingOrder/executePedidoAPI?c=" . urlencode($getPedido) . "&clientID=" . urlencode($idClient);

// Llamar al API
$json = @file_get_contents($apiUrl);

if ($json === false) {
    $data = null;
} else {
    $data = json_decode($json, true);
}
?>
<!DOCTYPE html>
<html lang="es-CO">
<head>
    <meta charset="UTF-8">
    <title>Tracking pedido <?= htmlspecialchars($getPedido) ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        :root {
            --primary: #2563eb;
            --primary-soft: rgba(37, 99, 235, 0.08);
            --success: #16a34a;
            --danger: #dc2626;
            --warning: #f97316;
            --muted: #6b7280;
            --border: #e5e7eb;
            --bg: #f3f4f6;
            --card-bg: #ffffff;
            --radius-lg: 14px;
            --radius-md: 10px;
            --shadow-soft: 0 18px 40px rgba(15, 23, 42, 0.12);
        }

        * {
            box-sizing: border-box;
        }

        body {
            margin: 0;
            padding: 16px;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #e0f2fe 0, #f9fafb 45%, #e5e7eb 100%);
            color: #111827;
        }

        .page {
            max-width: 980px;
            margin: 0 auto;
        }

        .card {
            background: var(--card-bg);
            border-radius: var(--radius-lg);
            box-shadow: var(--shadow-soft);
            padding: 20px 20px 24px;
            overflow: hidden;
        }

        .card-header {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            gap: 12px;
            align-items: center;
            border-bottom: 1px solid var(--border);
            padding-bottom: 12px;
            margin-bottom: 18px;
        }

        .card-header-left h1 {
            font-size: 20px;
            margin: 0 0 4px;
        }

        .card-header-left .sub {
            font-size: 13px;
            color: var(--muted);
        }

        .chip {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 12px;
            background: var(--primary-soft);
            color: var(--primary);
            font-weight: 500;
        }

        .chip-dot {
            width: 8px;
            height: 8px;
            border-radius: 999px;
            background: var(--primary);
        }

        .pill {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 3px 9px;
            border-radius: 999px;
            font-size: 12px;
            background: #e5e7eb;
            color: #374151;
        }

        .pill span {
            font-size: 14px;
        }

        .meta {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            margin-top: 6px;
        }

        /* Timeline */
        .track-card {
            margin-top: 8px;
            padding: 16px 14px 12px;
            background: #f9fafb;
            border-radius: var(--radius-md);
            border: 1px solid #e5e7eb;
        }

        .track-title {
            font-size: 14px;
            font-weight: 600;
            margin: 0 0 4px;
            color: #374151;
        }

        .track-subtitle {
            font-size: 12px;
            color: var(--muted);
            margin: 0 0 14px;
        }

        .track {
            display: flex;
            width: 100%;
            position: relative;
            gap: 0;
        }

        .track-step {
            flex: 1;
            text-align: center;
            position: relative;
            padding: 0 4px;
        }

        .track-step-line {
            position: absolute;
            top: 22px;
            left: 0;
            right: 0;
            height: 4px;
            background: #e5e7eb;
            z-index: 0;
        }

        .track-step-line-fill {
            position: absolute;
            top: 22px;
            left: 0;
            height: 4px;
            background: var(--primary);
            z-index: 1;
        }

        .track-step-icon-wrap {
            position: relative;
            z-index: 2;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 999px;
            background: #ffffff;
            border: 2px solid #e5e7eb;
            margin-bottom: 6px;
        }

        .track-step-icon-wrap.active {
            border-color: var(--primary);
            background: var(--primary);
        }

        .track-step-icon-wrap.active span {
            color: #ffffff;
        }

        .track-step-icon-wrap span {
            font-size: 20px;
        }

        .track-step-label {
            display: block;
            font-size: 12px;
            font-weight: 600;
            color: #374151;
        }

        .track-step-date {
            display: block;
            font-size: 11px;
            color: var(--muted);
            margin-top: 2px;
        }

        .track-step.inactive .track-step-label,
        .track-step.inactive .track-step-date {
            color: #9ca3af;
        }

        /* Responsive timeline */
        @media (max-width: 700px) {
            .track {
                flex-direction: column;
                gap: 14px;
            }

            .track-step {
                text-align: left;
                padding-left: 40px;
            }

            .track-step-line {
                left: 26px;
                width: 2px;
                top: 0;
                bottom: 0;
                height: auto;
            }

            .track-step-line-fill {
                left: 26px;
                width: 2px;
                top: 0;
                height: auto;
            }

            .track-step-icon-wrap {
                position: absolute;
                left: 6px;
                top: 0;
            }
        }

        /* Sections (Datos, Detalles, Novedades) */
        .sections {
            margin-top: 18px;
            display: grid;
            grid-template-columns: minmax(0, 1.2fr) minmax(0, 1fr);
            gap: 16px;
        }

        @media (max-width: 900px) {
            .sections {
                grid-template-columns: minmax(0, 1fr);
            }
        }

        details.section {
            border-radius: var(--radius-md);
            border: 1px solid var(--border);
            background: #f9fafb;
            overflow: hidden;
        }

        details.section summary {
            list-style: none;
            cursor: pointer;
            padding: 10px 12px;
            font-size: 14px;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 10px;
            background: #f3f4f6;
        }

        details.section summary::-webkit-details-marker {
            display: none;
        }

        .summary-label {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .summary-badge {
            background: var(--primary-soft);
            color: var(--primary);
            font-size: 11px;
            padding: 2px 8px;
            border-radius: 999px;
        }

        .summary-chevron {
            font-size: 16px;
            color: var(--muted);
            transition: transform 0.2s ease;
        }

        details[open] .summary-chevron {
            transform: rotate(90deg);
        }

        .section-body {
            padding: 10px 12px 12px;
            font-size: 13px;
            background: #ffffff;
        }

        .data-list {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
            gap: 8px 16px;
        }

        .data-item-label {
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.03em;
            color: var(--muted);
            margin-bottom: 2px;
        }

        .data-item-value {
            font-size: 13px;
            font-weight: 500;
            color: #111827;
        }

        table.table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        .table th,
        .table td {
            border: 1px solid #e5e7eb;
            padding: 6px 8px;
            text-align: left;
        }

        .table th {
            background: #f3f4f6;
            font-weight: 600;
            font-size: 12px;
            color: #374151;
        }

        .table tbody tr:nth-child(even) {
            background: #f9fafb;
        }

        .table tbody tr:hover {
            background: #eff6ff;
        }

        .empty-state {
            font-size: 13px;
            color: var(--muted);
        }

        .badge-soft {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            padding: 2px 6px;
            border-radius: 999px;
            background: #fee2e2;
            color: #b91c1c;
            font-size: 11px;
        }

        .error-card {
            max-width: 480px;
            margin: 60px auto;
            text-align: center;
        }

        .error-title {
            font-size: 20px;
            margin-bottom: 8px;
        }

        .error-subtitle {
            font-size: 13px;
            color: var(--muted);
        }

    </style>
</head>
<body>
<div class="page">
    <?php if (!$data || empty($data['success'])): ?>
        <div class="card error-card">
            <div class="badge-soft" style="margin-bottom: 10px;">
                ⚠️ Error
            </div>
            <h1 class="error-title">No se pudo cargar el pedido</h1>
            <p class="error-subtitle">
                Verifica el número de pedido o inténtalo de nuevo más tarde.<br>
                Pedido consultado: <strong><?= htmlspecialchars($getPedido) ?></strong>
            </p>
        </div>
    <?php else: ?>
        <?php
        $resultado = $data['resultado'][0] ?? [];
        $timeline  = $data['timeline'] ?? [];
        $detalles  = $data['detalles'] ?? [];
        $novedades = $data['novedades'] ?? [];

        $destinatario = $resultado['DESCLI'] ?? '';
        $ciudad       = $resultado['POBLACION'] ?? '';
        $estadoRaw    = $resultado['STATUS'] ?? '';
        ?>
        <div class="card">
            <!-- HEADER -->
            <div class="card-header">
                <div class="card-header-left">
                    <h1>Tracking de pedido <?= htmlspecialchars($data['codped']) ?></h1>
                    <div class="sub">
                        Seguimiento del estado logístico y detalles del envío.
                    </div>
                    <div class="meta">
                        <?php if ($destinatario): ?>
                            <span class="pill">
                                👤 Destinatario:
                                <span><?= htmlspecialchars($destinatario) ?></span>
                            </span>
                        <?php endif; ?>
                        <?php if ($ciudad): ?>
                            <span class="pill">
                                📍 Ciudad:
                                <span><?= htmlspecialchars($ciudad) ?></span>
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
                <div>
                    <div class="chip">
                        <span class="chip-dot"></span>
                        Estado actual:
                        <strong>#<?= htmlspecialchars($estadoRaw) ?></strong>
                    </div>
                </div>
            </div>

            <!-- TIMELINE -->
            <div class="track-card">
                <p class="track-title">Progreso del envío</p>
                <p class="track-subtitle">
                    Visualiza en qué punto del proceso se encuentra tu pedido.
                </p>

                <?php
                // Calcular hasta qué paso está activo para la barra de progreso (horizontal)
                $lastActiveIndex = -1;
                foreach ($timeline as $idx => $step) {
                    if (!empty($step['active'])) {
                        $lastActiveIndex = $idx;
                    }
                }
                ?>

                <div class="track">
                    <?php foreach ($timeline as $index => $step): ?>
                        <?php
                        $isActive = !empty($step['active']);
                        $icon     = $step['icon'] ?? '•';
                        $label    = $step['label'] ?? '';
                        $fecha    = $step['fecha'] ?? '';
                        $isFilled = $index <= $lastActiveIndex;
                        ?>
                        <div class="track-step <?= $isActive ? 'active' : 'inactive' ?>">
                            <!-- Línea de fondo -->
                            <div class="track-step-line"></div>
                            <!-- Línea rellena -->
                            <?php if ($isFilled): ?>
                                <div class="track-step-line-fill"></div>
                            <?php endif; ?>

                            <div class="track-step-icon-wrap <?= $isActive ? 'active' : '' ?>">
                                <span><?= htmlspecialchars($icon) ?></span>
                            </div>
                            <span class="track-step-label"><?= htmlspecialchars($label) ?></span>
                            <span class="track-step-date"><?= htmlspecialchars($fecha) ?></span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- SECCIONES -->
            <div class="sections">
                <!-- DATOS DEL PEDIDO -->
                <details class="section" open>
                    <summary>
                        <div class="summary-label">
                            📦 Datos del pedido
                        </div>
                        <div class="summary-chevron">›</div>
                    </summary>
                    <div class="section-body">
                        <div class="data-list">
                            <div>
                                <div class="data-item-label">Número de guía</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($resultado['CLAVEAGE'] ?? '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Agencia</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars(str_replace('OPENPHAREX', 'Solistica', $resultado['CODAGE'] ?? '-')) ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Dirección</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($resultado['DIRECCION'] ?? '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Bultos</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($resultado['NRO_CAJAS'] ?? '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Unidades</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($resultado['CANT_UND'] ?? '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Observaciones</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($resultado['INFOCLIEXTRA'] ?? '-') ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </details>

                <!-- NOVEDADES -->
                <details class="section">
                    <summary>
                        <div class="summary-label">
                            ⚠️ Novedades
                            <?php if (!empty($novedades)): ?>
                                <span class="summary-badge"><?= count($novedades) ?> registradas</span>
                            <?php endif; ?>
                        </div>
                        <div class="summary-chevron">›</div>
                    </summary>
                    <div class="section-body">
                        <?php if (empty($novedades)): ?>
                            <p class="empty-state">Este pedido no registra novedades.</p>
                        <?php else: ?>
                            <table class="table">
                                <thead>
                                <tr>
                                    <th>Causal</th>
                                    <th>Fecha / Hora</th>
                                </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($novedades as $row): ?>
                                    <tr>
                                        <td><?= htmlspecialchars($row['OBSERVACION1']) ?></td>
                                        <td><?= htmlspecialchars($row['FECHA'] . ' ' . $row['HORASIT']) ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                            </table>
                        <?php endif; ?>
                    </div>
                </details>
            </div>

            <!-- LÍNEAS DEL PEDIDO (debajo en full width) -->
            <div class="sections" style="margin-top: 14px;">
                <details class="section" open style="grid-column: 1 / -1;">
                    <summary>
                        <div class="summary-label">
                            📃 Líneas del pedido
                            <?php if (!empty($detalles)): ?>
                                <span class="summary-badge"><?= count($detalles) ?> ítems</span>
                            <?php endif; ?>
                        </div>
                        <div class="summary-chevron">›</div>
                    </summary>
                    <div class="section-body">
                        <?php if (empty($detalles)): ?>
                            <p class="empty-state">No hay líneas asociadas a este pedido.</p>
                        <?php else: ?>
                            <div style="overflow-x: auto;">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Código</th>
                                        <th>Artículo</th>
                                        <th>Lote</th>
                                        <th>Cant. Pedida</th>
                                        <th>Cant. Servida</th>
                                        <th>Cant. Sin Servir</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($detalles as $row): ?>
                                        <?php
                                        $pedida  = (float) ($row['CANTPEDIDA'] ?? 0);
                                        $servida = (float) ($row['CANTSERVIDA'] ?? 0);
                                        $sinServir = $pedida - $servida;
                                        ?>
                                        <tr>
                                            <td><?= htmlspecialchars($row['CODART']) ?></td>
                                            <td><?= htmlspecialchars($row['DESART']) ?></td>
                                            <td><?= htmlspecialchars($row['CODLOT']) ?></td>
                                            <td><?= htmlspecialchars($pedida) ?></td>
                                            <td><?= htmlspecialchars($servida) ?></td>
                                            <td><?= htmlspecialchars($sinServir) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </details>
            </div>
        </div>
    <?php endif; ?>
</div>
</body>
</html>
