<?php
// Parámetros del formulario
$tipoBusqueda = $_GET['tipo'] ?? 'pedido'; // 'pedido' o 'remesa'
$valorBusqueda = trim($_GET['valor'] ?? '');

// Variables para la vista
$respuestaData = null;
$errorMensaje = null;

// Solo llamamos a la API si el usuario envió algo en el formulario
if ($valorBusqueda !== '') {
    $baseUrl = "http://129.146.161.23:9011/back-end/trackingPedidos/TrackingPedidos.php";

    if ($tipoBusqueda === 'remesa') {
        $apiUrl = $baseUrl . '?remesa=' . urlencode($valorBusqueda);
    } else {
        // Por defecto, número de pedido
        $apiUrl = $baseUrl . '?number=' . urlencode($valorBusqueda);
        $tipoBusqueda = 'pedido';
    }

    $json = @file_get_contents($apiUrl);

    if ($json === false) {
        $errorMensaje = "No se pudo conectar con el servicio de tracking. Intenta nuevamente.";
    } else {
        $response = json_decode($json, true);

        if (!is_array($response)) {
            $errorMensaje = "Respuesta inválida del servicio.";
        } elseif (empty($response['status'])) {
            $errorMensaje = $response['message'] ?? "La solicitud no fue procesada correctamente.";
        } elseif (empty($response['data'])) {
            // status = true pero data = null
            $errorMensaje = "No se encontraron datos para la búsqueda realizada.";
        } else {
            $respuestaData = $response['data'];
        }
    }
}

// Preparamos variables si hay datos
$numeroPedido   = $respuestaData['numeroPedido']   ?? '';
$division       = $respuestaData['division']       ?? '';
$destino        = $respuestaData['destino']        ?? '';
$ciudad         = $respuestaData['ciudad']         ?? $destino;
$direccion      = $respuestaData['direccion']      ?? '';
$destinatario   = $respuestaData['destinatario']   ?? '';
$transportadora = $respuestaData['transportadora'] ?? '';
$remesa         = $respuestaData['remesa']         ?? '';
$cerrado        = !empty($respuestaData['cerrado']);
$fechaCierre    = $respuestaData['fechaCierre']    ?? null;
$estados        = $respuestaData['estadosTracking'] ?? [];

// Mapeamos estados por código para buscarlos rápido
$estadosPorCodigo = [];
if (is_array($estados)) {
    foreach ($estados as $e) {
        if (isset($e['estado'])) {
            $estadosPorCodigo[$e['estado']] = $e;
        }
    }
}

// Lista fija de estados desde 3500 hasta 20000
$stepsDefinidos = [
    ['code' => 3500,  'label' => 'RECIBIDO'],
    ['code' => 7000,  'label' => 'EN ALISTAMIENTO'],
    ['code' => 11500, 'label' => 'ALISTAMIENTO TERMINADO'],
    ['code' => 12000, 'label' => 'DESPACHADO'],
    ['code' => 20000, 'label' => 'ENTREGADO'],
];

// Calculamos hasta qué paso está activo (último estado que realmente existe)
$lastActiveIndex = -1;
foreach ($stepsDefinidos as $idx => $step) {
    if (isset($estadosPorCodigo[$step['code']])) {
        $lastActiveIndex = $idx;
    }
}

// Datos del estado actual (si existe alguno)
$estadoActualNombre      = 'Sin estado registrado';
$estadoActualDescripcion = '';
$estadoActualFecha       = '';

if ($lastActiveIndex >= 0) {
    $codeUltimo = $stepsDefinidos[$lastActiveIndex]['code'];
    $ultimoEstado = $estadosPorCodigo[$codeUltimo] ?? null;
    if ($ultimoEstado) {
        $estadoActualNombre      = $ultimoEstado['nombre']      ?? $estadoActualNombre;
        $estadoActualDescripcion = $ultimoEstado['descripcion'] ?? '';
        $estadoActualFecha       = $ultimoEstado['fecha']       ?? '';
    }
}
?>
<!DOCTYPE html>
<html lang="es-CO">
<head>
    <meta charset="UTF-8">
    <title>Tracking de pedidos</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    <style>
        :root {
            --primary: #2563eb;
            --primary-soft: rgba(37, 99, 235, 0.08);
            --success: #16a34a;
            --danger: #dc2626;
            --warning: #f97316;
            --muted: #6b7280;
            --border: #e5e7eb;
            --bg: #f3f4f6;
            --card-bg: #ffffff;
            --radius-lg: 14px;
            --radius-md: 10px;
            --shadow-soft: 0 18px 40px rgba(15, 23, 42, 0.12);
        }

        * {
            box-sizing: border-box;
        }

        body {
            margin: 0;
            padding: 16px;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background: radial-gradient(circle at top, #e0f2fe 0, #f9fafb 45%, #e5e7eb 100%);
            color: #111827;
        }

        .page {
            max-width: 980px;
            margin: 0 auto;
        }

        .card {
            background: var(--card-bg);
            border-radius: var(--radius-lg);
            box-shadow: var(--shadow-soft);
            padding: 20px 20px 24px;
            overflow: hidden;
        }

        .card-header {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            gap: 12px;
            align-items: center;
            border-bottom: 1px solid var(--border);
            padding-bottom: 12px;
            margin-bottom: 18px;
        }

        .card-header-left h1 {
            font-size: 20px;
            margin: 0 0 4px;
        }

        .card-header-left .sub {
            font-size: 13px;
            color: var(--muted);
        }

        .chip {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 4px 10px;
            border-radius: 999px;
            font-size: 12px;
            background: var(--primary-soft);
            color: var(--primary);
            font-weight: 500;
        }

        .chip-dot {
            width: 8px;
            height: 8px;
            border-radius: 999px;
            background: var(--primary);
        }

        .pill {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 3px 9px;
            border-radius: 999px;
            font-size: 12px;
            background: #e5e7eb;
            color: #374151;
        }

        .pill span {
            font-size: 14px;
        }

        .meta {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            margin-top: 6px;
        }

        /* FORMULARIO */
        .form-card {
            margin-bottom: 18px;
            padding: 14px 14px 16px;
            background: #f9fafb;
            border-radius: var(--radius-md);
            border: 1px solid var(--border);
        }

        .form-title {
            font-size: 14px;
            font-weight: 600;
            margin: 0 0 8px;
            color: #374151;
        }

        .form-row {
            display: flex;
            flex-wrap: wrap;
            gap: 8px 14px;
            align-items: center;
        }

        .form-group-inline {
            display: flex;
            align-items: center;
            gap: 8px;
            font-size: 13px;
        }

        .form-group-inline label {
            display: flex;
            align-items: center;
            gap: 4px;
            cursor: pointer;
        }

        .form-input {
            flex: 1;
            min-width: 180px;
        }

        .form-input input[type="text"] {
            width: 100%;
            padding: 8px 10px;
            border-radius: 999px;
            border: 1px solid var(--border);
            font-size: 13px;
            outline: none;
        }

        .form-input input[type="text"]:focus {
            border-color: var(--primary);
            box-shadow: 0 0 0 1px rgba(37, 99, 235, 0.18);
        }

        .btn-primary {
            border: none;
            border-radius: 999px;
            padding: 8px 16px;
            font-size: 13px;
            font-weight: 500;
            cursor: pointer;
            background: var(--primary);
            color: #ffffff;
            display: inline-flex;
            align-items: center;
            gap: 6px;
        }

        .btn-primary:hover {
            opacity: 0.95;
        }

        /* Timeline */
        .track-card {
            margin-top: 8px;
            padding: 16px 14px 12px;
            background: #f9fafb;
            border-radius: var(--radius-md);
            border: 1px solid #e5e7eb;
        }

        .track-title {
            font-size: 14px;
            font-weight: 600;
            margin: 0 0 4px;
            color: #374151;
        }

        .track-subtitle {
            font-size: 12px;
            color: var(--muted);
            margin: 0 0 14px;
        }

        .track {
            display: flex;
            width: 100%;
            position: relative;
            gap: 0;
        }

        .track-step {
            flex: 1;
            text-align: center;
            position: relative;
            padding: 0 4px;
        }

        .track-step-line {
            position: absolute;
            top: 22px;
            left: 0;
            right: 0;
            height: 4px;
            background: #e5e7eb;
            z-index: 0;
        }

        .track-step-line-fill {
            position: absolute;
            top: 22px;
            left: 0;
            right: 0;
            height: 4px;
            background: var(--primary);
            z-index: 1;
        }

        .track-step-icon-wrap {
            position: relative;
            z-index: 2;
            display: inline-flex;
            align-items: center;
            justify-content: center;
            width: 40px;
            height: 40px;
            border-radius: 999px;
            background: #ffffff;
            border: 2px solid #e5e7eb;
            margin-bottom: 6px;
            color: #6b7280;
            font-weight: 600;
        }

        /* Paso alcanzado pero no el último */
        .track-step.reached .track-step-icon-wrap {
            border-color: var(--primary);
            color: var(--primary);
            background: #ffffff;
        }

        /* Último paso alcanzado (círculo azul con check) */
        .track-step.completed .track-step-icon-wrap {
            border-color: var(--primary);
            background: var(--primary);
            color: #ffffff;
        }

        .track-step-label {
            display: block;
            font-size: 12px;
            font-weight: 600;
            color: #374151;
        }

        .track-step-date {
            display: block;
            font-size: 11px;
            color: var(--muted);
            margin-top: 2px;
        }

        .track-step.pending .track-step-label,
        .track-step.pending .track-step-date {
            color: #9ca3af;
        }

        /* Responsive timeline */
        @media (max-width: 700px) {
            .track {
                flex-direction: column;
                gap: 14px;
            }

            .track-step {
                text-align: left;
                padding-left: 40px;
            }

            .track-step-line {
                left: 26px;
                width: 2px;
                top: 0;
                bottom: 0;
                height: auto;
            }

            .track-step-line-fill {
                left: 26px;
                width: 2px;
                top: 0;
                bottom: 0;
                height: auto;
            }

            .track-step-icon-wrap {
                position: absolute;
                left: 6px;
                top: 0;
            }
        }

        /* Sections */
        .sections {
            margin-top: 18px;
            display: grid;
            grid-template-columns: minmax(0, 1.2fr) minmax(0, 1fr);
            gap: 16px;
        }

        @media (max-width: 900px) {
            .sections {
                grid-template-columns: minmax(0, 1fr);
            }
        }

        details.section {
            border-radius: var(--radius-md);
            border: 1px solid var(--border);
            background: #f9fafb;
            overflow: hidden;
        }

        details.section summary {
            list-style: none;
            cursor: pointer;
            padding: 10px 12px;
            font-size: 14px;
            font-weight: 600;
            display: flex;
            align-items: center;
            justify-content: space-between;
            gap: 10px;
            background: #f3f4f6;
        }

        details.section summary::-webkit-details-marker {
            display: none;
        }

        .summary-label {
            display: flex;
            align-items: center;
            gap: 8px;
        }

        .summary-badge {
            background: var(--primary-soft);
            color: var(--primary);
            font-size: 11px;
            padding: 2px 8px;
            border-radius: 999px;
        }

        .summary-chevron {
            font-size: 16px;
            color: var(--muted);
            transition: transform 0.2s ease;
        }

        details[open] .summary-chevron {
            transform: rotate(90deg);
        }

        .section-body {
            padding: 10px 12px 12px;
            font-size: 13px;
            background: #ffffff;
        }

        .data-list {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(160px, 1fr));
            gap: 8px 16px;
        }

        .data-item-label {
            font-size: 11px;
            text-transform: uppercase;
            letter-spacing: 0.03em;
            color: var(--muted);
            margin-bottom: 2px;
        }

        .data-item-value {
            font-size: 13px;
            font-weight: 500;
            color: #111827;
        }

        table.table {
            width: 100%;
            border-collapse: collapse;
            font-size: 12px;
        }

        .table th,
        .table td {
            border: 1px solid #e5e7eb;
            padding: 6px 8px;
            text-align: left;
        }

        .table th {
            background: #f3f4f6;
            font-weight: 600;
            font-size: 12px;
            color: #374151;
        }

        .table tbody tr:nth-child(even) {
            background: #f9fafb;
        }

        .table tbody tr:hover {
            background: #eff6ff;
        }

        .empty-state {
            font-size: 13px;
            color: var(--muted);
        }

        .badge-soft {
            display: inline-flex;
            align-items: center;
            gap: 4px;
            padding: 2px 6px;
            border-radius: 999px;
            background: #fee2e2;
            color: #b91c1c;
            font-size: 11px;
        }

        .error-text {
            margin-top: 10px;
            font-size: 13px;
            color: var(--danger);
        }

        .status-pill {
            display: inline-flex;
            align-items: center;
            gap: 6px;
            padding: 3px 10px;
            border-radius: 999px;
            font-size: 12px;
            background: #dcfce7;
            color: #166534;
        }

        .status-pill.closed {
            background: #fee2e2;
            color: #b91c1c;
        }
    </style>
</head>
<body>
<div class="page">
    <div class="card">
        <!-- HEADER PRINCIPAL -->
        <div class="card-header">
            <div class="card-header-left">
                <h1>Tracking de pedidos</h1>
                <div class="sub">
                    Consulta el estado de tu envío por número de pedido o por remesa / guía.
                </div>
            </div>
            <?php if ($respuestaData): ?>
                <div>
                    <div class="chip">
                        <span class="chip-dot"></span>
                        Estado actual:
                        <strong><?= htmlspecialchars($estadoActualNombre) ?></strong>
                    </div>
                </div>
            <?php endif; ?>
        </div>

        <!-- FORMULARIO DE BÚSQUEDA -->
        <form method="get" class="form-card">
            <p class="form-title">Buscar tracking</p>
            <div class="form-row">
                <div class="form-group-inline">
                    <span style="font-size:12px; color:var(--muted);">Buscar por:</span>
                    <label>
                        <input type="radio" name="tipo" value="pedido" <?= $tipoBusqueda === 'pedido' ? 'checked' : '' ?>>
                        Pedido
                    </label>
                    <label>
                        <input type="radio" name="tipo" value="remesa" <?= $tipoBusqueda === 'remesa' ? 'checked' : '' ?>>
                        Remesa / Guía
                    </label>
                </div>

                <div class="form-input">
                    <input
                        type="text"
                        name="valor"
                        placeholder="Ej. 0030506401 o 8851958"
                        value="<?= htmlspecialchars($valorBusqueda) ?>"
                    >
                </div>

                <button type="submit" class="btn-primary">
                    🔍 Consultar
                </button>
            </div>

            <?php if ($errorMensaje && $valorBusqueda !== ''): ?>
                <div class="error-text">
                    ⚠️ <?= htmlspecialchars($errorMensaje) ?>
                </div>
            <?php endif; ?>
        </form>

        <?php if ($respuestaData): ?>
            <!-- META DEL PEDIDO -->
            <div class="meta" style="margin-bottom: 10px;">
                <?php if ($numeroPedido): ?>
                    <span class="pill">
                        📦 Pedido:
                        <span><?= htmlspecialchars($numeroPedido) ?></span>
                    </span>
                <?php endif; ?>
                <?php if ($remesa): ?>
                    <span class="pill">
                        🧾 Remesa / Guía:
                        <span><?= htmlspecialchars($remesa) ?></span>
                    </span>
                <?php endif; ?>
                <?php if ($destinatario): ?>
                    <span class="pill">
                        👤 Destinatario:
                        <span><?= htmlspecialchars($destinatario) ?></span>
                    </span>
                <?php endif; ?>
                <?php if ($ciudad): ?>
                    <span class="pill">
                        📍 Ciudad:
                        <span><?= htmlspecialchars($ciudad) ?></span>
                    </span>
                <?php endif; ?>
            </div>

            <!-- TIMELINE (SIEMPRE MISMOS ESTADOS 3500 → 20000) -->
            <div class="track-card">
                <p class="track-title">Progreso del envío</p>
                <p class="track-subtitle">
                    Visualiza en qué punto del proceso se encuentra tu pedido.
                </p>

                <div class="track">
                    <?php foreach ($stepsDefinidos as $index => $step): ?>
                        <?php
                        $code   = $step['code'];
                        $label  = $step['label'];
                        $data   = $estadosPorCodigo[$code] ?? null;
                        $isActive = $data !== null;
                        $isReached = $index <= $lastActiveIndex && $lastActiveIndex >= 0;
                        $isCompleted = $isActive && $index === $lastActiveIndex;
                        $fecha  = $data['fecha'] ?? '';
                        $iconText = $isCompleted ? '✔' : ($index + 1);

                        $stateClass = 'pending';
                        if ($isReached) {
                            $stateClass = 'reached';
                        }
                        if ($isCompleted) {
                            $stateClass = 'completed';
                        }
                        ?>
                        <div class="track-step <?= $stateClass ?>">
                            <div class="track-step-line"></div>
                            <?php if ($index > 0 && $isReached): ?>
                                <div class="track-step-line-fill"></div>
                            <?php endif; ?>

                            <div class="track-step-icon-wrap">
                                <span><?= htmlspecialchars($iconText) ?></span>
                            </div>
                            <span class="track-step-label"><?= htmlspecialchars($label) ?></span>
                            <span class="track-step-date">
                                <?= $fecha ? htmlspecialchars($fecha) : ' ' ?>
                            </span>
                            <span class="track-step-date">
                                Código: <?= htmlspecialchars($code) ?>
                            </span>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>

            <!-- SECCIONES DETALLE -->
            <div class="sections">
                <!-- DATOS DEL PEDIDO -->
                <details class="section" open>
                    <summary>
                        <div class="summary-label">
                            📦 Datos del pedido
                        </div>
                        <div class="summary-chevron">›</div>
                    </summary>
                    <div class="section-body">
                        <div class="data-list">
                            <div>
                                <div class="data-item-label">Número de pedido</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($numeroPedido ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Remesa / Guía</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($remesa ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Transportadora</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($transportadora ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">División</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($division ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Destino</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($destino ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Ciudad</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($ciudad ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Dirección</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($direccion ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Estado actual</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($estadoActualNombre) ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Detalle estado actual</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($estadoActualDescripcion ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Fecha último estado</div>
                                <div class="data-item-value">
                                    <?= htmlspecialchars($estadoActualFecha ?: '-') ?>
                                </div>
                            </div>
                            <div>
                                <div class="data-item-label">Cierre</div>
                                <div class="data-item-value">
                                    <?php if ($cerrado): ?>
                                        <span class="status-pill closed">
                                            Cerrado <?= $fechaCierre ? '· ' . htmlspecialchars($fechaCierre) : '' ?>
                                        </span>
                                    <?php else: ?>
                                        <span class="status-pill">
                                            En curso
                                        </span>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </details>

                <!-- RESUMEN DESTINATARIO -->
                <details class="section" open>
                    <summary>
                        <div class="summary-label">
                            👤 Destinatario
                        </div>
                        <div class="summary-chevron">›</div>
                    </summary>
                    <div class="section-body">
                        <?php if (!$destinatario && !$direccion && !$ciudad): ?>
                            <p class="empty-state">No hay datos adicionales del destinatario.</p>
                        <?php else: ?>
                            <div class="data-list">
                                <div>
                                    <div class="data-item-label">Nombre</div>
                                    <div class="data-item-value">
                                        <?= htmlspecialchars($destinatario ?: '-') ?>
                                    </div>
                                </div>
                                <div>
                                    <div class="data-item-label">Dirección</div>
                                    <div class="data-item-value">
                                        <?= htmlspecialchars($direccion ?: '-') ?>
                                    </div>
                                </div>
                                <div>
                                    <div class="data-item-label">Ciudad</div>
                                    <div class="data-item-value">
                                        <?= htmlspecialchars($ciudad ?: '-') ?>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </details>
            </div>

            <!-- HISTORIAL DE ESTADOS (FULL WIDTH) -->
            <div class="sections" style="margin-top: 14px;">
                <details class="section" open style="grid-column: 1 / -1;">
                    <summary>
                        <div class="summary-label">
                            📃 Historial de estados
                        </div>
                        <div class="summary-chevron">›</div>
                    </summary>
                    <div class="section-body">
                        <?php if (empty($estados)): ?>
                            <p class="empty-state">No hay estados registrados para este pedido.</p>
                        <?php else: ?>
                            <div style="overflow-x: auto;">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th>Código</th>
                                        <th>Nombre</th>
                                        <th>Descripción</th>
                                        <th>Fecha</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php foreach ($estados as $estado): ?>
                                        <tr>
                                            <td><?= htmlspecialchars($estado['estado'] ?? '-') ?></td>
                                            <td><?= htmlspecialchars($estado['nombre'] ?? '-') ?></td>
                                            <td><?= htmlspecialchars($estado['descripcion'] ?? '-') ?></td>
                                            <td><?= htmlspecialchars($estado['fecha'] ?? '-') ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        <?php endif; ?>
                    </div>
                </details>
            </div>
        <?php endif; ?>
    </div>
</div>
</body>
</html>
