<?php
date_default_timezone_set('America/Bogota');
include('../config/database.php');
session_start();
$metodo=$_SERVER['REQUEST_METHOD'];
function getGeocodeData($address) { 
    $address = urlencode($address);     
    $googleMapUrl = "https://maps.googleapis.com/maps/api/geocode/json?address={$address}&key=AIzaSyDy0i22lqtG9KvJWgZsEHRewBOz1tl76Ig";
    $geocodeResponseData = file_get_contents($googleMapUrl);
    $responseData = json_decode($geocodeResponseData, true);
    if($responseData['status']=='OK') {
        $latitude = isset($responseData['results'][0]['geometry']['location']['lat']) ? $responseData['results'][0]['geometry']['location']['lat'] : "";
        $longitude = isset($responseData['results'][0]['geometry']['location']['lng']) ? $responseData['results'][0]['geometry']['location']['lng'] : "";
        $formattedAddress = isset($responseData['results'][0]['formatted_address']) ? $responseData['results'][0]['formatted_address'] : "";         
        if($latitude && $longitude && $formattedAddress) {         
            $geocodeData = array();                         
            array_push(
                $geocodeData, 
                $latitude, 
                $longitude, 
                $formattedAddress
            );             
            return $geocodeData;             
        } else {
            return false;
        }         
    } else {
        echo "ERROR: {$responseData['status']}";
        return false;
    }
}
function uploadImgBase64 ($base64, $name){
    // decodificamos el base64
    $datosBase64 = base64_decode(preg_replace('#^data:image/\w+;base64,#i', '', $base64));
    // definimos la ruta donde se guardara en el server
    $path= $_SERVER['DOCUMENT_ROOT'].'/view/guias/firmas/'.$name;
    // guardamos la imagen en el server
    if(!file_put_contents($path, $datosBase64)){
        // retorno si falla
        return false;
    }
    else{
        // retorno si todo fue bien
        return true;
    }
}
//Registrar nuevo articulo
if($metodo=='POST'){
    //Si me manda el id, quiere decir que se va a editar
    if(isset($_POST['id_guia'])){
        $id_guia=$_POST['id_guia'];
        $estado=$_POST['estado'];
        $lnt=$_POST['lnt'];
        $lng=$_POST['lng'];
        $subestado = $_POST['subestado'];
        $recibe = $_POST['recibe'];
        $persona_recibe = $_POST['persona_recibe'];
        $obs = $_POST['obs'];
        $fecha_proceso= date("Y-m-d H:i:s");
        
        $fe_asigna =  mysqli_query($mysqli,"SELECT * FROM guias WHERE id_guia=$id_guia");
        $fa = mysqli_fetch_array($fe_asigna); $fechaas= $fa['fecha_asignacion'];
        
        //Calcular horas de entrega
        $t1 = StrToTime ($fecha_proceso);
        $t2 = StrToTime ($fechaas);
        $diff = $t1 - $t2;
        $hours = round($diff / ( 60 * 60 ));
        if($hours==0){$h=1;}else{$h=$hours;}

        $query = mysqli_query($mysqli, "UPDATE guias SET fecha_entrega='$fecha_proceso',horas_entrega=$hours, recibe='$recibe', persona_recibe='$persona_recibe', obs_entrega='$obs', estado_guia='$estado', subestado_guia='$subestado', latitud_entrega='$lnt', longitud_entrega='$lng' WHERE id_guia=$id_guia");
        if(!$query){
            die('Error en el registro'. mysqli_error($mysqli));
        }
        $slq_select = mysqli_query($mysqli,"SELECT * FROM guias WHERE id_guia=$id_guia");
        $datos = mysqli_fetch_array($slq_select);
        $usuario = $datos['usuario_asignado'];
        $nro_guia = $datos['codigo_guia'];
        $isert_log = mysqli_query($mysqli,"INSERT INTO log_guias VALUES(NULL,'$nro_guia','Guia entregado por','$fecha_proceso','$usuario')");
        echo 'Entrega exitosa';
    
    }

    if(isset($_POST['usuario'])){
        $user = $_POST['usuario'];
        $query = mysqli_query($mysqli, "UPDATE guias SET estado_guia=300 WHERE usuario_asignado='$user' and estado_guia=200");
        if(!$query){
            die('Error en el registro'. mysqli_error($mysqli));
        }
        echo '
        <div class="alert alert-success" role="alert" id="alerta1">
            La asignacion se ha realizado satisfactoriamente!
            <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                <span aria-hidden="true">&times;</span>
            </button>
        </div>
        ';
        //echo $id_guia;
        //var_dump($data);
    }
    
    if(isset($_POST['firma'])){
        $id_guia=$_POST['id_guia_fi'];
        $firma = 'firma_idguia_'.$id_guia.'-'.date('d_m_Y').'.png';
        
        $dir = $_SERVER['DOCUMENT_ROOT'].'/sis-trackApp/view/guias/firmas/'.$firma;
        unlink($dir);
        
        uploadImgBase64($_POST['firma'], 'firma_idguia_'.$id_guia.'-'.date('d_m_Y').'.png' );
        
        $query = mysqli_query($mysqli, "UPDATE guias SET firma='$firma' WHERE id_guia=$id_guia");
        if(!$query){
            die('Error en el registro'. mysqli_error($mysqli));
        }
        echo "Registro actualizado.....";
    }
    
    if(isset($_POST['foto'])){
        $id_guia=$_POST['id_guia_fo'];
        $foto = 'foto_idguia_'.$id_guia.'-'.date('d_m_Y').'.png';
        $dir = $_SERVER['DOCUMENT_ROOT'].'/sis-trackApp/view/guias/firmas/'.$foto;
        unlink($dir);
        uploadImgBase64($_POST['foto'], 'foto_idguia_'.$id_guia.'-'.date('d_m_Y').'.png' );
        
        $query = mysqli_query($mysqli, "UPDATE guias SET foto='$foto' WHERE id_guia=$id_guia");
        if(!$query){
            die('Error en el registro'. mysqli_error($mysqli));
        }
        echo "Registro actualizado.....";
    }
}


//Consultar todos
if($metodo=='GET'){
    //Si se mando un id quiere decir que se hara una busqueda individual
    if(isset($_GET['id_guia'])){
        $id = $_GET['id_guia'];
        $query = mysqli_query($mysqli, "SELECT * FROM guias WHERE id_guia='$id'");
        if(!$query){
            die('Error en la consulta'. mysqli_error($mysqli));
        }

        $json = array(); 
        while($row = mysqli_fetch_array($query)){
            $json[] = array(
                'guia' => $row['codigo_guia'],
                'cliente' => $row['nombre_cliente'],
                'cod_cliente' => $row['codigo_cliente'],
                'tel_cliente' => $row['telefono_cliente'],
                'pedido' => $row['pedido_cliente'],
                'email' => $row['email_cliente'],
                'direccion' => $row['direccion_destino'],
                'persona_ref' => $row['persona_referencia'],
                'tel_ref' => $row['telefono_referencia'],
                'detalles' => $row['detalles_guia'],
                'fecha_registro' => $row['fecha_registro'],
                'estado_guia' => $row['estado_guia'],
                'latitud' => $row['latitud_destino'],
                'longitud' => $row['longitud_destino'],
                'id' => $row['id_guia']
            );
        }
        $jsonstring = json_encode($json[0]);
        echo $jsonstring; 
    
    }
    //Sino se hace la busqueda de todos
    if(isset($_GET['u'])){
        $u=$_GET['u'];
        //$where.='WHERE usuario_asignado='.$_GET['u'];
        $query = mysqli_query($mysqli, "SELECT * FROM guias WHERE usuario_asignado='$u' and estado_guia < 400");
        if(!$query){
            die('Error en la consulta'. mysqli_error($mysqli));
        }
        $json = array(); 
        while($row = mysqli_fetch_array($query)){
            if($row['estado_guia']==200){$r='S';}else{$r='N';}
            $json[] = array(
                'guia' => 'Guia: '.$row['codigo_guia'],
                'cliente' => $row['nombre_cliente'],
                'telefono' => $row['telefono_cliente'],
                'direccion' => $row['direccion_destino'],
                'fecha' => $row['fecha_registro'],
                'pedido' => ' Pedido:'.$row['pedido_cliente'],
                'ruta' => $r,
                'id' => $row['id_guia']
            );
        }
        $jsonstring = json_encode($json);
        echo $jsonstring;
    }

}