consultar();
//Consultar all
function consultar(){
    $(document).ready(function() {
        $('#dataTable1').DataTable( {
            ajax: "http://localhost/sis-track/back-end/articulos.php",
            columns: [
                { data: "id" },
                { data: "name" },
                { data: "presentacion" },
                { data: "forma" },
                { data: "precio" },
                { data: "tipo" },
                { data: "ruta" },
                { defaultContent:"<button type='button' class='editar btn btn-primary btn-xs mr-1'  data-toggle='modal' data-target='#editar_articulo'><i class='fas fa-pencil-alt'></i></button><button type='button' class='eliminar btn btn-danger btn-xs'><i class='fas fa-trash-alt' ></i></button>"}
            ],
            "language": {
                url: "http://localhost/sis-track/lib/js/es.json"
              }
        } );
    });
}

//Registrar
function registrar(){
    let nom = $('#nombre').val(), presentacion = $('#presentacion').val(), forma =$('#forma').val().toUpperCase(), precio = $('#precio').val(), cliente = $('#list_cliente').val(), error='';

    if(nom===''){ error+='Nombre<br>'; } if(presentacion===''){ error+='Presentacion<br>'; }
    let template='';
    if(error!=''){
        template +=`
        <div class="alert alert-danger" role="alert" id="alerta_add">
            <strong>Error!</strong> Faltan los sigueinte datos<br>${error}
        </div>`;
        $('#result').html(template);
    }else{
        const postData = {
            nombre: $('#nombre').val().toUpperCase(),
            presentacion: $('#presentacion').val(),
            forma: $('#forma').val().toUpperCase(),
            precio: $('#precio').val(),
            cliente: $('#list_cliente').val(),
            tipo: $('#tipo').val(),
            ruta: $('#ruta').val()
        };
        
        $.post('back-end/articulos.php', postData, function(response){
            consultar();
            $('#form_articulo').trigger('reset');
            $('#result').html(response);
            setTimeout(function(){ $('#alerta_add').alert('close'); }, 3000);
        });  
    }
     
}

//Actualizar
function editar(){
    const postData = {
        nombre: $('#nombre_e').val(),
        presentacion: $('#presentacion_e').val(),
        forma: $('#forma_e').val(),
        precio: $('#precio_e').val(),
        id: $('#id_articulo').val()
    };
    $.post('back-end/articulos.php', postData, function(response){
        consultar();
        $('#result_edit').html(response);
        setTimeout(function(){ $('#alerta1').alert('close'); }, 3000);
    });  
}

//Eliminar
$('#dataTable1').on('click', '.eliminar', function (e){
    var id = $(this).parents('tr').find('td:first-child').text();
    eliminar(id) 
});
function eliminar(id){
    if(confirm('Seguro que desea borrar el registro?')){
        let id_articulo = id;
        $.ajax({
            url: 'back-end/articulos.php?id_articulo='+id_articulo,
            type: 'DELETE',
            data: {id_articulo},
            success:function(response){
                $('#resultado').html(response);
                consultar();
                setTimeout(function(){ $('#alerta_delete').alert('close'); }, 3000);
                //console.log(response);
            }
        }); 
        
    } 
}

//Buscar
$('#dataTable1').on('click', '.editar', function (e){
    var id = $(this).parents('tr').find('td:first-child').text();
    buscar(id) 
});
function buscar(id){
    let id_articulo = id;
    //console.log(id_articulo);
    $.ajax({
        url: 'back-end/articulos.php',
        type: 'GET',
        data: {id_articulo},
        success:function(response){
            const data = JSON.parse(response);
            $('#nombre_e').val(data.name);
            $('#presentacion_e').val(data.presentacion);
            $('#forma_e').val(data.forma);
            $('#precio_e').val(data.precio);
            $('#tipo_e').val(data.tipo);
            $('#ruta_e').val(data.ruta);
            $('#id_articulo').val(data.id);
        }
    });  
}

//Listado Clientes
function list_clientes(){
    $.ajax({
        url: 'back-end/clientes.php',
        type: 'GET',
        success: function(response){
            let datas = JSON.parse(response);
            console.log(datas);
            let template = '<option value="">Seleccione Opcion......</option>';
            datas.forEach(data =>{
                template +=`
                <option value="${data.id}">${data.name}</option>
                `
            });
            $('#list_cliente').html(template);
        }
    })
}
