function consultar(){
    $(document).ready(function() {
        $('#dataterceros').DataTable( {
            ajax: "https://logitrack.systemsolutions.com.co/back-end/rndc/terceros.php?all=0",
            columns: [
                { data: "tipo" },
                { data: "numid" },
                { data: "nombre" },
                { data: "tel" },
                { data: "direccion" },
                { data: "municipio" },
                { data: "sede" },
                { data: "btn" }
            ],
            "language": {
                url: "https://logitrack.systemsolutions.com.co/lib/js/es.json"
              }
        } );
    });
}

function consulta_pedido(){
    let pedido = $("#pedido").val(), error='',msg_html='';
    if(pedido===''){ error+='Numero de Pedido<br>'; }
    if(error !== ''){
        msg_html +=`
        <div class="alert alert-danger" role="alert" id="alerta_pro">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#result').html(msg_html);
        setTimeout(function(){ $('#alerta_pro').alert('close'); }, 2000);
    }else{
        $.ajax({
            url: 'back-end/rndc/remesas.php',
            type: 'GET',
            data: {pedido},
            success: function(response){
                if(response === '0'){
                    msg_html +=`
                    <div class="alert alert-danger" role="alert" id="alerta_pro">
                        <strong>Error!</strong> No se encontro ningún pedido con el codigo digitado
                    </div>`;
                    $('#result').html(msg_html);
                    setTimeout(function(){ $('#alerta_pro').alert('close'); }, 2000);
                }else{
                    let o = JSON.parse(response);
                    console.log(o); 
                    $("#remesa").val(o.pedido);
                    $("#numid_dest").val(o.cod_cliente);
                    $("#nombre_dest").val(o.cliente);
                    $("#direccion_dest").val(o.direccion);
                    $("#codsede_dest").val(o.codsede);
                    $("#nomsede_dest").val(o.nomsede);
                    $("#municipio").val(o.municipio);
                }
                           
            }
        })
    }
        
}


//Actualizar form dependiendo el tipo de id
function actualiza_form(){
    let tipo = $("#tipoid").val();
    if(tipo === 'N'){
        document.getElementById("c1").style.display = "none";
        document.getElementById("c2").style.display = "none";
        $("#codsede").val('');
        $("#nomsede").val('');
    }else{
        document.getElementById("c1").style.display = "block";
        document.getElementById("c2").style.display = "block";
        $("#codsede").val('1');
        $("#nomsede").val('SEDE1');
    }
}

function cargar_variables(){
    actualiza_form();
}

function registrar(){
    let tipo = $("#tipoid").val();
    let numid = $("#numid").val();
    let nombre = $("#nombre").val();
    let apellidouno = $("#apellidouno").val();
    let apellidodos = $("#apellidodos").val();
    let tel = $("#tel").val();
    let cel = $("#cel").val();
    let regimen = $("#regimen").val();
    let direccion = $("#direccion").val();
    let municipio = $("#municipio").val();
    let codsede = $("#codsede").val();
    let nomsede = $("#nomsede").val();
    let catlicencia = $("#catlicencia").val();
    let numlicencia = $("#numlicencia").val();
    let viglicencia = $("#viglicencia").val();
    let error='', msg_html='';
    //Validaciones
    if(numid===''){ error+='Numero ID<br>'; }
    if(nombre===''){ error+='Nombre<br>'; }
    if(tipo==='C'){
        if(apellidouno===''){ error+='1er Apellido<br>'; }
        if(apellidodos===''){ error+='2do Apellido<br>'; } 
    }
    if(direccion===''){ error+='Direccion<br>'; }
    if(municipio===''){ error+='Municipio<br>'; }
    if(tipo==='N'){
        if(codsede===''){ error+='Cod Sede<br>'; }
        if(nomsede===''){ error+='NomSede<br>'; } 
    }
    if(error !== ''){
        msg_html +=`
        <div class="alert alert-danger" role="alert" id="alerta_pro">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#result').html(msg_html);
        setTimeout(function(){ $('#alerta_pro').alert('close'); }, 2000);
    }else{
        const postData = {
            tipo: tipo,
            numid: numid,
            nombre: nombre,
            apellidouno: apellidouno,
            apellidodos: apellidodos,
            tel: tel,
            cel: cel,
            regimen: regimen,
            direccion: direccion,
            municipio: municipio,
            codsede: codsede,
            nomsede: nomsede,
            catlicencia: catlicencia,
            numlicencia: numlicencia,
            viglicencia: viglicencia,
            registro: 0
        };
        
        $.post('back-end/rndc/terceros.php', postData, function(response){
            consultar();
            $('#form_tercero').trigger('reset');
            $('#result').html(response);
            setTimeout(function(){ $('#alerta_pro').alert('close'); $("#nuevo_tercero").modal("hide");}, 1000);
        });
    }
    
}







