
// Set new default font family and font color to mimic Bootstrap's default styling
Chart.defaults.global.defaultFontFamily = 'Nunito', '-apple-system,system-ui,BlinkMacSystemFont,"Segoe UI",Roboto,"Helvetica Neue",Arial,sans-serif';
// Area Chart Example
var ctx = document.getElementById("myAreaChart");
var myLineChart = new Chart(ctx, {
type: 'line',
data: {
 labels: ["08:30", "09:50", "10:20"],
 datasets: [{
   pointRadius: 5,
   pointBackgroundColor: "rgba(0, 128, 0, 1)",
   showLine: false,
   data: [0,3,0],
 },
 {
   pointRadius: 5,
   pointBackgroundColor: "rgba(250, 0, 0, 1)",
   showLine: false,
   data: [1,0,0]
 },
 {
   pointRadius: 5,
   pointBackgroundColor: "rgba(244, 179, 13, 1)",
   showLine: false,
   data: [0,0,2]
 }],
},
options: {  
 maintainAspectRatio: false,
 layout: {
   padding: {
     left: 10,
     right: 25,
     top: 30,
     bottom: -8
   }
 },
 scales: {
   xAxes: [{
     gridLines: {
       display: true,
       drawBorder: false,
     },
     ticks: {
       maxTicksLimit: 12
     }
   }],
   yAxes: [{
       display: false,
     ticks: {
       min: 1,
       maxTicksLimit: 3
     },
   }],
 },
 legend: {
   display: false,
 }
 
}
});