<?php
include('../config/database.php');
session_start();
$metodo = $_SERVER['REQUEST_METHOD'];
// $year = '2024';
//session_start(); 
$user = $_SESSION['id_user'];
$fecha = date('Y-m-d');
function obtenerDiasFestivos($pais, $ano){
    $url = "https://date.nager.at/api/v2/PublicHolidays/$ano/$pais";
    $datos = file_get_contents($url);
    $festivos = json_decode($datos, true);
    $diasFestivos = [];
    foreach ($festivos as $festivo) {
        $diasFestivos[] = $festivo['date'];
    }
    return $diasFestivos;
}

function calcularDiasHabiles($fechaInicio, $fechaFin, $festivos){
    $inicio = new DateTime($fechaInicio);
    $fin = new DateTime($fechaFin);
    $fin->modify('+1 day');
    $unDia = new DateInterval('P1D');
    $intervaloDiasHabiles = new DateInterval('P1D');
    $intervaloDiasHabiles->d = 1;
    $periodo = new DatePeriod($inicio, $intervaloDiasHabiles, $fin);
    $diasHabiles = [];
    foreach ($periodo as $dia) {
        if ($dia->format('N') < 6 && !in_array($dia->format('Y-m-d'), $festivos)) {
            $diasHabiles[] = $dia->format('Y-m-d');
        }
    }
    return $diasHabiles;
}
if ($metodo == 'GET') {
    //----------------Consulta visitas-------------------- (v.fecha_visita BETWEEN '$fi' and '$ff')
    if (isset($_GET['reporte_cab'])) {

        $ff = $_GET['ff'];
        $year = date('Y', strtotime($ff));
        $fi = $_GET['fi'];
        $ciclo = $_GET['ciclo'];
        $query = mysqli_query($mysqli, "SELECT p.tipo_cliente, tc.tipo_c FROM visitas v, paneles p, tipos_cli tc WHERE v.id_user = '$user' AND (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=tc.id_tipo_c GROUP BY tc.tipo_c, p.tipo_cliente") or die('Error en la consulta' . mysqli_error($mysqli));
        $json = array();
        while ($row = mysqli_fetch_array($query)) {
            $tc = $row['tipo_cliente'];
            //Consultar total
            $query_total = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) total FROM visitas v, paneles p WHERE v.id_user = '$user' AND (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=$tc AND v.estado_visita >= '200'") or die('Error en la consulta' . mysqli_error($mysqli));
            $rowt = mysqli_fetch_array($query_total);
            $total = $rowt['total'];
            //Consultar pendientes
            $query_pend = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) nro_pend FROM visitas v, paneles p WHERE v.id_user = '$user' AND (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=$tc AND v.estado_visita IN (100,200,210)") or die('Error en la consulta' . mysqli_error($mysqli));
            $rowp = mysqli_fetch_array($query_pend);
            $pend = $rowp['nro_pend'];
            //Consultar gestionadas incluye anuladas
            $query_gest = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) nro_gest FROM visitas v, paneles p WHERE v.id_user = '$user' AND (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=$tc AND v.estado_visita IN (300,400)") or die('Error en la consulta' . mysqli_error($mysqli));
            $rowg = mysqli_fetch_array($query_gest);
            $real = $rowg['nro_gest'];
            
            if($ciclo == ''){
                
                $sql = "SELECT * FROM ciclos WHERE '$ff' BETWEEN fecha_desde AND fecha_hasta";
                $result = $mysqli->query($sql);
                $resultarray = array();
        
                foreach ($result as $key) {
                    $resultarray[] = $key;
                }
    
                $ciclo = $resultarray[0]['id'];
            }
            
            //Sacar segun ciclo
            $query_ciclo = mysqli_query($mysqli, "SELECT sum(o.cantidad) cantidad, c.dias_habiles FROM ciclos c, objetivos o WHERE o.visitador = '$user' AND c.id=$ciclo and o.ciclo=c.id AND o.reser2='$tc'") or die('Error en la consulta' . mysqli_error($mysqli));
            $rowciclo = mysqli_fetch_array($query_ciclo);
            
            if($rowciclo['dias_habiles'] !=''){
                $dias = $rowciclo['dias_habiles'];
                $nro_visitas = $rowciclo['cantidad'];
                //Calcular días
                $obtenerDiasFestivos = obtenerDiasFestivos("CO", $year);
                $diasHabiles = calcularDiasHabiles($fi, $ff, $obtenerDiasFestivos);
                $diasHabiles = count($diasHabiles);
                // $objetivo = (($diasHabiles*$nro_visitas)/$dias);
                $objetivo = $nro_visitas;
                $cumplimiento = (($real*100)/$objetivo);
            }else{
                $objetivo=0;
                $cumplimiento=0;
            }
            
            $json[] = array(
                'tipo' => $row['tipo_c'],
                'total' => $total,
                'pendientes' => $pend,
                'gestionadas' => $real,
                'cumplimiento' => number_format(($real*100)/$total).'%',
                'objetivo' => number_format($objetivo,0),
                'cumple_obj' => number_format($cumplimiento,0).'%',
                'faltantes_obj' => ($objetivo-$real < 0?0:number_format($objetivo-$real, 0))
            );
        }
        $jsonstring = json_encode($json);
        echo $jsonstring;
    }

}