const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function descargar_plantilla() {
    window.open('views/closeup/descargar_plantilla.php');
}

function cargar_archivo() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    const fileInput = document.getElementById("fileUpload");
    const file = fileInput.files[0];

    if (file) {
        const reader = new FileReader();

        reader.onload = async function (e) {
            const data = new Uint8Array(e.target.result);
            const workbook = XLSX.read(data, { type: "array" });

            // Leer el contenido de la primera hoja
            const firstSheetName = workbook.SheetNames[0];
            const worksheet = workbook.Sheets[firstSheetName];
            const jsonData = XLSX.utils.sheet_to_json(worksheet);

            console.log(jsonData);
            await $.post('back-end/closeup/closeup.php', { jsonData }, function (response) {
                console.log(response)
            });
            Swal.close();
        };

        reader.readAsArrayBuffer(file);
    } else {
        alert("Selecciona un archivo de Excel primero.");
    }
}

async function consul_datos() {

    let medico = $('#medico_closeup').val();
    let periodo = $('#periodo_closeup').val();
    let mercado = $('#mercado_closeup').val();

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    await $.get(`back-end/closeup/closeup.php?medico=${medico}&periodo=${periodo}&mercado=${mercado}`, async function (response) {
        console.log(response)
        try {
            let o = JSON.parse(response);
            let templete = ``;

            switch (periodo) {
                case 'mth':

                    templete = `
                    <table class="table table-flush" id="datatable_datos">
                        <thead class="thead-light">
                            <tr>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Marca </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> MTH-23 </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> MTH-24 </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> %Cre </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> %Ms-24 </th>
                            </tr>
                        </thead>
                        <tbody>`;
                    break;

                case 'qtr':

                    templete = `
                    <table class="table table-flush" id="datatable_datos">
                        <thead class="thead-light">
                            <tr>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Marca </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> QTR-23 </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> QTR-24 </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> %Cre </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> %Ms-24 </th>
                            </tr>
                        </thead>
                        <tbody>`;
                    break;

                case 'ytd':

                    templete = `
                    <table class="table table-flush" id="datatable_datos">
                        <thead class="thead-light">
                            <tr>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Marca </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> YTD-23 </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> YTD-24 </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> %Cre </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> %Ms-24 </th>
                            </tr>
                        </thead>
                        <tbody>`;
                    break;

                case 'mat':

                    templete = `
                    <table class="table table-flush" id="datatable_datos">
                        <thead class="thead-light">
                            <tr>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Marca </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> MAT-23 </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> MAT-24 </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> %Cre </th>
                                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> %Ms-24 </th>
                            </tr>
                        </thead>
                        <tbody>`;
                    break;

            }

            let body = ``;
            let template_end = `</tbody></table>`;

            o.forEach(element => {

                switch (periodo) {
                    case 'mth':

                        body += `
                            <tr>
                                <td class="text-center font-weight-normal">${element.marca}</td>
                                <td class="text-center font-weight-normal">${element.MTH_ANT}</td>
                                <td class="text-center font-weight-normal">${element.MTH_ACT}</td>
                                <td class="text-center font-weight-normal">${element.crecimi}%</td>
                                <td class="text-center font-weight-normal">${element.contar}%
                                    <div class="progress w-100 mt-2">
                                        <div class="progress-bar bg-dark w-${element.contar}" role="progressbar" aria-valuenow="${element.contar}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </td>
                            </tr>`;
                        break;

                    case 'qtr':

                        body += `
                            <tr>
                                <td class="text-center font-weight-normal">${element.marca}</td>
                                <td class="text-center font-weight-normal">${element.QTR_ANT}</td>
                                <td class="text-center font-weight-normal">${element.QTR_ACT}</td>
                                <td class="text-center font-weight-normal">${element.crecimi}%</td>
                                <td class="text-center font-weight-normal">${element.contar}%
                                    <div class="progress w-100 mt-2">
                                        <div class="progress-bar bg-dark w-${element.contar}" role="progressbar" aria-valuenow="${element.contar}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </td>
                            </tr>`;
                        break;

                    case 'ytd':

                        body += `
                            <tr>
                                <td class="text-center font-weight-normal">${element.marca}</td>
                                <td class="text-center font-weight-normal">${element.YTD_ANT}</td>
                                <td class="text-center font-weight-normal">${element.YTD_ACT}</td>
                                <td class="text-center font-weight-normal">${element.crecimi}%</td>
                                <td class="text-center font-weight-normal">${element.contar}%
                                    <div class="progress w-100 mt-2">
                                        <div class="progress-bar bg-dark w-${element.contar}" role="progressbar" aria-valuenow="${element.contar}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </td>
                            </tr>`;
                        break;

                    case 'mat':

                        body += `
                            <tr>
                                <td class="text-center font-weight-normal">${element.marca}</td>
                                <td class="text-center font-weight-normal">${element.MAT_ANT}</td>
                                <td class="text-center font-weight-normal">${element.MAT_ACT}</td>
                                <td class="text-center font-weight-normal">${element.crecimi}%</td>
                                <td class="text-center font-weight-normal">${element.contar}%
                                    <div class="progress w-100 mt-2">
                                        <div class="progress-bar bg-dark w-${element.contar}" role="progressbar" aria-valuenow="${element.contar}" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </td>
                            </tr>`;
                        break;
                }
            });

            await $('#tabla_closeup').html(templete + body + template_end);
        } catch (error) {
            Toast.fire({
                icon: 'error',
                title: 'No hay resultados de los datos buscados'
            });
        }


    });

    // const dataTableSearch = new simpleDatatables.DataTable("#datatable_datos", {
    //     searchable: true
    // });

    await Swal.close();
}

function list_medicos() {

    let list_medicos = 'ALL';

    $.ajax({
        url: `back-end/closeup/closeup.php`,
        type: 'GET',
        data: { list_medicos },
        success: function (response) {

            let datas = JSON.parse(response);

            let arraySinDuplicados = [];

            datas.forEach(function (elemento) {
                if (!arraySinDuplicados.includes(elemento)) {
                    arraySinDuplicados.push(elemento);
                }
            });

            let select = document.getElementById('medico_closeup');

            const opcion3 = document.createElement('option');
                opcion3.text = "";
                opcion3.value = "";

            select.appendChild(opcion3);

            const opcion2 = document.createElement('option');
                opcion2.text = "Todos";
                opcion2.value = "Todos";

            select.appendChild(opcion2);

            arraySinDuplicados.forEach(data => {
                const opcion1 = document.createElement('option');
                opcion1.text = data;
                opcion1.value = data;

                select.appendChild(opcion1);
            });

        }
    });

    $('#medico_closeup').select2();
}

async function list_mercado() {

    let list_mercado = 'ALL';

    $.ajax({
        url: `back-end/closeup/closeup.php`,
        type: 'GET',
        data: { list_mercado },
        success: async function (response) {

            let datas = JSON.parse(response);

            let arraySinDuplicados = [];

            datas.forEach(function (elemento) {
                if (!arraySinDuplicados.includes(elemento)) {
                    arraySinDuplicados.push(elemento);
                }
            });

            let select = document.getElementById('mercado_closeup');

            const opcion3 = document.createElement('option');
                opcion3.text = " ";
                opcion3.value = " ";

            select.appendChild(opcion3);

            const opcion2 = document.createElement('option');
                opcion2.text = "Todos";
                opcion2.value = "Todos";

            select.appendChild(opcion2);

            arraySinDuplicados.forEach(data => {
                const opcion1 = document.createElement('option');
                opcion1.text = data;
                opcion1.value = data;

                select.appendChild(opcion1);
            });
        }
    });

    $('#mercado_closeup').select2();
}