const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function cambios_cliente() {
    let inlineRadio1 = document.getElementById("inlineRadio1");
    let inlineRadio2 = document.getElementById("inlineRadio2");

    if (inlineRadio1.checked == true) {
        $("#identificacion_container").show();
        $("#apellidos_container").show();
        $("#fecha_cumple_container").show();
        $("#container_especialidad1").show();
        $("#container_especialidad2").show();
    }

    if (inlineRadio2.checked == true) {
        $("#identificacion_container").hide();
        $("#apellidos_container").hide();
        $("#fecha_cumple_container").hide();
        $("#container_especialidad1").hide();
        $("#container_especialidad2").hide();
    }
}

async function descargar_lista() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    window.open(`views/datos/descargar_plantilla.php?visitador='a'`);
    await Swal.close();
}

function list_visitadores() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            // console.log(datas)

            let template = `<datalist id="visitadores_lista">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {
                body += `
                    <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#visitadores').html(template + body + template_end);
        }
    });
}

async function list_especialidades1() {

    let list_especialidades = 'ALL';

    await $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_especialidades },
        success: async function (response) {

            let datas = JSON.parse(response);

            let select_especialidad1 = document.getElementById('especialidad1');

            let opt1 = document.createElement('option');
            opt1.innerText = 'Seleccione';
            opt1.selected = true;
            await select_especialidad1.appendChild(opt1);

            datas.forEach(async data => {
                let opt = document.createElement('option');
                opt.value = data.id_especialidad;
                opt.innerText = data.especialidad;
                await select_especialidad1.appendChild(opt);
            });
        }
    });
}

async function list_especialidades2() {

    let list_especialidades = 'ALL';

    await $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_especialidades },
        success: async function (response) {

            let datas = JSON.parse(response);

            let select_especialidad2 = document.getElementById('especialidad2');

            let opt1 = document.createElement('option');
            opt1.innerText = 'Seleccione';
            opt1.selected = true;
            await select_especialidad2.appendChild(opt1);

            datas.forEach(async data => {
                let opt = document.createElement('option');
                opt.value = data.id_especialidad;
                opt.innerText = data.especialidad;
                await select_especialidad2.appendChild(opt);
            });
        }
    });
}

function list_tipo_cliente() {
    let list_tipo_cliente = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_tipo_cliente },
        success: function (response) {

            let datas = JSON.parse(response);

            // console.log(datas)

            let select_tipo_cliente = document.getElementById('tipo_cliente');

            let opt = document.createElement('option');
            opt.innerText = 'Seleccione';
            select_tipo_cliente.appendChild(opt);

            datas.forEach(data => {
                let opt = document.createElement('option');
                opt.value = data.id_tipo_c;
                opt.innerText = data.tipo_c;
                select_tipo_cliente.appendChild(opt);
            });
        }
    });
}

function list_tipo_cliente_editar() {

}

function list_visitadores_nuevo() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            // console.log(datas)

            let template = `<datalist id="visitadores_lista_nuevo">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {
                body += `
                    <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#visitadores_nuevo').html(template + body + template_end);
        }
    });
}

function list_visitadores_editar() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            // console.log(datas)

            let template = `<datalist id="editar_visitadores_lista">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {
                body += `
                    <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#editar_visitadores').html(template + body + template_end);
        }
    });
}

function nuevo_cliente_individual() {

    let identificacion = $('#identificacion').val();
    let nombres = $('#nombres').val();
    let apellidos = $('#apellidos').val();
    let telefono = $('#telefono').val();
    let email_cliente = $('#email_cliente').val();
    let direccion_cliente = $('#direccion_cliente').val();
    let ciudad_cliente = $('#ciudad_cliente').val();
    let tipo_cliente = $('#tipo_cliente').val();
    let especialidad1 = $('#especialidad1').val();
    let especialidad2 = $('#especialidad2').val();
    let fecha_cumple = $('#fecha_cumple').val();
    let visitador_nuevo = $('#visitador_nuevo').val();
    let estado = $('#estado').val();
    let categoria = $('#categoria').val();

    let crear = "crear";
    let error = '';
    let template = '';

    let inlineRadio1 = document.getElementById("inlineRadio1");
    let inlineRadio2 = document.getElementById("inlineRadio2");

    if (inlineRadio1.checked == true) {
        if (identificacion === '') { error += '<strong>Identificacion</strong></br>' }
        if (nombres === '') { error += '<strong>Nombres</strong></br>' }
        if (apellidos === '') { error += '<strong>Apellidos</strong></br>' }
        if (telefono === '') { error += '<strong>Telefono</strong></br>' }
        if (email_cliente === '') { error += '<strong>Email</strong></br>' }
        if (direccion_cliente === '') { error += '<strong>Direccion</strong></br>' }
        if (ciudad_cliente === '') { error += '<strong>ciudad</strong></br>' }
        if (tipo_cliente === '') { error += '<strong>Tipo</strong></br>' }
        if (especialidad1 === '') { error += '<strong>Especialidad 1</strong></br>' }
        if (especialidad2 === '') { error += '<strong>Especialidad 2</strong></br>' }
        if (fecha_cumple === '') { error += '<strong>Fecha Cumpleaos</strong></br>' }
        if (visitador_nuevo === '') { error += '<strong>Visitador</strong></br>' }
        if (estado === '') { error += '<strong>Estado</strong></br>' }
        if (categoria === '') { error += '<strong>Categoria</strong></br>' }
    }

    if (inlineRadio2.checked == true) {
        if (nombres === '') { error += '<strong>Nombres</strong></br>' }
        if (telefono === '') { error += '<strong>Telefono</strong></br>' }
        if (email_cliente === '') { error += '<strong>Email</strong></br>' }
        if (direccion_cliente === '') { error += '<strong>Direccion</strong></br>' }
        if (ciudad_cliente === '') { error += '<strong>ciudad</strong></br>' }
        if (tipo_cliente === '') { error += '<strong>Tipo</strong></br>' }
        if (especialidad1 === '') { error += '<strong>Especialidad 1</strong></br>' }
        if (especialidad2 === '') { error += '<strong>Especialidad 2</strong></br>' }
        if (visitador_nuevo === '') { error += '<strong>Visitador</strong></br>' }
        if (estado === '') { error += '<strong>Estado</strong></br>' }
        if (categoria === '') { error += '<strong>Categoria</strong></br>' }
    }

    if (error != '') {
        template += `
        <div class="alert alert-warning" role="alert" id="alerta_lin">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#errores').html(template);
    } else {
        $.post(
            `back-end/datos/datos.php`,
            {
                crear,
                identificacion,
                nombres,
                apellidos,
                telefono,
                email_cliente,
                direccion_cliente,
                ciudad_cliente,
                tipo_cliente,
                especialidad1,
                especialidad2,
                fecha_cumple,
                visitador_nuevo,
                estado,
                categoria
            },
            async function (response) {

                let o = parseInt(response);

                if (o == 200) {

                    $('#cliente_individual').modal("hide");

                    await Swal.fire({
                        icon: 'success',
                        title: 'Crear cliente',
                        text: 'Creacion de cliente exitosa.',
                    });

                    buscar_cliente();
                    $('#nuevo_cliente').trigger('reset');

                } else {
                    // console.log(response);
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Error al crear el cliente.',
                    })
                }
            });
    }
}

async function buscar_cliente() {

    let visitador = 'all';
    await $('#list_paneles').html();
    let filtro_estado = $('#filtro_estado').val();

    await $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { visitador, filtro_estado },
        success: async function (response) {
            let datas = JSON.parse(response);
            // console.log(datas);

            let body = '';
            datas.forEach(data => {
                body += `
                    <tr>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.apellidos_cliente + ' ' + data.nombres_cliente} </td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.telefono_cliente} </td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.ciudad_cliente} </td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.estado_cliente} </td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.btn_editar} </td>
                    </tr>`;
            });
            await $('#list_paneles').html(body);
        }
    });

    const dataTableSearch = new simpleDatatables.DataTable("#datatable_clientes", {
        searchable: true,
        columns: [
            { select: 0, sort: "asc" },
        ]
    });
}

datos_editar();

function datos_editar() {

    let list_tipo_cliente = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_tipo_cliente },
        success: function (response) {

            let datas = JSON.parse(response);

            // console.log(datas);

            let template = `<select class="form-control" id="editar_tipo_cliente">`;
            let body = `<option value="">Seleccione</option>`;
            let template_end = `</select>`;

            datas.forEach(data => {
                body += `<option value="${data.id_tipo_c}">${data.tipo_c}</option>`;
            });

            $('#contenedor_editar_tipo_cliente').html(template + body + template_end);
        }
    });

    let list_especialidades = 'all';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_especialidades },
        success: function (response) {

            let datas = JSON.parse(response);

            let select1 = document.getElementById("editar_especialidad1");
            let select2 = document.getElementById("editar_especialidad2");
            select1.innerHTML = '';
            select2.innerHTML = '';

            let option1 = document.createElement("option");
            option1.text = 'Seleccione';

            let option2 = document.createElement("option");
            option2.text = 'Seleccione';

            select1.appendChild(option1);
            select2.appendChild(option2);

            datas.forEach(data => {

                let option3 = document.createElement("option");
                option3.value = data.id_especialidad;
                option3.text = data.especialidad;

                let option4 = document.createElement("option");
                option4.value = data.id_especialidad;
                option4.text = data.especialidad;

                select1.appendChild(option3);
                select2.appendChild(option4);
            });
        }
    });

}

async function setID(id_cliente) {

    $('#editar_id_cliente').val(id_cliente);

    await list_visitadores_editar();
    // await list_tipo_cliente_editar();

    let list_especialidades = "all";

    await $.ajax({
        url: 'back-end/datos/datos.php',
        type: 'GET',
        data: { id_cliente },
        success: function (response) {
            // console.log(response);
            let datas = JSON.parse(response);
            datas.forEach(async (data) => {

                await $('#editar_codigo_cliente').val(data.id_cliente);
                await $('#editar_identificacion').val(data.identificacion);
                await $('#editar_nombres').val(data.nombres_cliente);
                await $('#editar_apellidos').val(data.apellidos_cliente);
                await $('#editar_telefono').val(data.telefono_cliente);
                await $('#editar_email_cliente').val(data.email_cliente);
                await $('#editar_direccion_cliente').val(data.direccion_cliente);
                await $('#editar_ciudad_cliente').val(data.ciudad_cliente);

                await $('#editar_tipo_cliente').val(data.tipo_cliente);

                await $('#editar_especialidad1').val(data.especialidad1);
                await $('#editar_especialidad2').val(data.especialidad2);

                await $('#editar_fecha_cumple').val(data.fecha_cumple);
                await $('#editar_visitador').val(data.id_user);
                await $('#editar_estado').val(data.estado_cliente);
                await $('#editar_categoria').val(data.categoria);
            });
        }
    });
}

function editar_cliente_individual() {

    let editar_id_cliente = $('#editar_id_cliente').val();

    let editar_identificacion = $('#editar_identificacion').val();
    let editar_nombres = $('#editar_nombres').val();
    let editar_apellidos = $('#editar_apellidos').val();
    let editar_telefono = $('#editar_telefono').val();
    let editar_email_cliente = $('#editar_email_cliente').val();
    let editar_direccion_cliente = $('#editar_direccion_cliente').val();
    let editar_ciudad_cliente = $('#editar_ciudad_cliente').val();
    let editar_tipo_cliente = $('#editar_tipo_cliente').val();

    let editar_especialidad1 = $('#editar_especialidad1').val();
    let editar_especialidad2 = $('#editar_especialidad2').val();

    let editar_fecha_cumple = $('#editar_fecha_cumple').val();
    let editar_visitador = $('#editar_visitador').val();
    let editar_estado = $('#editar_estado').val();
    let editar_categoria = $('#editar_categoria').val();

    fetch(`back-end/datos/datos.php`, {
        method: 'PUT',
        body: JSON.stringify({
            editar_id_cliente: editar_id_cliente,
            editar_identificacion: editar_identificacion,
            editar_nombres: editar_nombres,
            editar_apellidos: editar_apellidos,
            editar_telefono: editar_telefono,
            editar_email_cliente: editar_email_cliente,
            editar_direccion_cliente: editar_direccion_cliente,
            editar_ciudad_cliente: editar_ciudad_cliente,
            editar_tipo_cliente: editar_tipo_cliente,
            editar_especialidad1: editar_especialidad1,
            editar_especialidad2: editar_especialidad2,
            editar_fecha_cumple: editar_fecha_cumple,
            editar_visitador: editar_visitador,
            editar_estado: editar_estado,
            editar_categoria: editar_categoria
        }),
        Headers: {
            Accept: 'application/json',
            'Content-Type': 'text/html'
        }
    })
        .then((response) => response.text())
        .then(async (responseData) => {
            console.log(responseData)
            let resp = parseInt(responseData);

            if (resp == 200) {
                $('#edit_ciclo').modal("hide");
                Toast.fire({
                    icon: 'success',
                    title: 'Cliente Actualizado'
                });
                $('#editar_cliente_individual').modal('hide');
                await buscar_cliente();
            } else if (resp == 300) {
                Toast.fire({
                    icon: 'error',
                    title: 'El Cliente tiene una Visita Programada'
                });
            } else {
                Toast.fire({
                    icon: 'error',
                    title: 'Error al Actualizar el Cliente'
                });
            }

        })
        .catch((error) => {
            console.error('error', error)
        });
}