var ciclo_actual = '';

const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function visitas_planificadas() {

    let fecha_ini = $('#fecha_ini_v').val();
    let fecha_fin = $('#fecha_fin_v').val();
    let tipo_cliente = $('#tipo_cliente_filtro').val();

    $.get(`back-end/inicio/inicio.php?visitas_planificadas=${'all'}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}&tipo_cliente=${tipo_cliente}`, function (respose) {
        
        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o[0].visitas_planificadas}</h5>`
        $('#visitas_planificadas').html(body);
    });
}

function visitas_gestionadas() {

    let fecha_ini = $('#fecha_ini_v').val();
    let fecha_fin = $('#fecha_fin_v').val();
    let tipo_cliente = $('#tipo_cliente_filtro').val();

    $.get(`back-end/inicio/inicio.php?visitas_gestionadas=${'all'}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}&tipo_cliente=${tipo_cliente}`, function (respose) {

        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o[0].visitas_gestionadas}</h5>`;
        $('#visitas_gestionadas').html(body);

    });
}

function visitas_pendientes() {

    let fecha_ini = $('#fecha_ini_v').val();
    let fecha_fin = $('#fecha_fin_v').val();
    let tipo_cliente = $('#tipo_cliente_filtro').val();

    $.get(`back-end/inicio/inicio.php?visitas_pendientes=${'all'}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}&tipo_cliente=${tipo_cliente}`, function (respose) {
        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o[0].visitas_pendientes}</h5>`;
        $('#visitas_pendientes').html(body);
    });
}

function porcentaje_cumplimiento() {
    let fecha_ini = $('#fecha_ini_v').val();
    let fecha_fin = $('#fecha_fin_v').val();
    let tipo_cliente = $('#tipo_cliente_filtro').val();

    $.get(`back-end/inicio/inicio.php?porcentaje_cumplimiento=${'all'}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}&tipo_cliente=${tipo_cliente}`, function (respose) {

        let dato = parseInt((respose * 100));

        if (isNaN(dato)) {
            dato = 0;
        }

        let body = `<h5 class="font-weight-bolder mb-0">${dato + "%"}</h5>`;
        $('#porcentaje_cumplimiento').html(body);
    });
}

function objetivos_gestionadas(){

    let fecha_ini = $('#fecha_ini_v').val();
    let fecha_fin = $('#fecha_fin_v').val();
    let ciclo = $('#list_ciclo').val();
    let tipo_cliente = $('#tipo_cliente_filtro').val();

    $.get(`back-end/inicio/inicio.php?objetivos_gestionadas=${'all'}&ciclo=${ciclo}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}&tipo_cliente=${tipo_cliente}`, function (respose) {

        let dato = parseInt(respose);

        if (isNaN(dato)) {
            dato = 0;
        }

        let body = `<h5 class="font-weight-bolder mb-0">${dato + "%"}</h5>`;
        $('#objetivos_gestionadas').html(body);
    });

    $('#objetivos_gestionadas').html();
}

async function aplicar_filtro() {

    $('#fecha_ini_v').val($('#fecha_ini').val());
    $('#fecha_fin_v').val($('#fecha_fin').val());

    await visitas_planificadas();
    await visitas_gestionadas();
    await visitas_pendientes();
    await porcentaje_cumplimiento();
    await lista_pendientes();
    await consulta_lineas();
    await objetivos_gestionadas();
    await objetivos_ciclo_actual();

    Toast.fire({
        icon: 'success',
        title: 'Filtro Aplicado'
    });
}

function update_date() {
    $('#fecha_ini_filtro').val($('#fecha_ini_v').val());
    $('#fecha_fin_filtro').val($('#fecha_fin_v').val());
}

function lista_cumple() {
    $.get(`back-end/inicio/inicio.php?lista_cumple=${'all'}`, function (respose) {

        let o = JSON.parse(respose);
        let body = ``;

        o.forEach(data => {
            body += `
                <tr>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.cliente}</td>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.fecha_cumple}</td>
                </tr>`;
        });

        $('#lista_cumple').html(body);
    });
}

function lista_compromisos() {
    $.get(`back-end/inicio/inicio.php?lista_compromisos=${'all'}`, function (respose) {

        let o = JSON.parse(respose);
        let body = ``;

        o.forEach(data => {
            body += `
                <tr>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.nombres_cliente}</td>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.fecha_compromiso}</td>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.compromiso}</td>
                </tr>`;
        });

        $('#lista_compromisos').html(body);
    });
}

function lista_pendientes() {

    let fecha_ini = $('#fecha_ini_v').val();
    let fecha_fin = $('#fecha_fin_v').val();
    let tipo_cliente = $('#tipo_cliente_filtro').val();

    $.get(`back-end/inicio/inicio.php?lista_pendientes=${'all'}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}&tipo_cliente=${tipo_cliente}`, function (respose) {

        let o = JSON.parse(respose);
        let body = ``;

        o.forEach(data => {

            body += `
            <tr>
                <td class="w-30">
                    <div class="d-flex px-2 py-1 align-items-center">
                        <div class="ms-4">
                        <p class="text-xs font-weight-bold mb-0">Cliente</p>
                        <h6 class="text-sm mb-0">${data.nombres_cliente}</h6>
                        </div>
                    </div>
                </td>
                <td>
                    <div class="text-center">
                        <p class="text-xs font-weight-bold mb-0">Estado</p>
                        <h6 class="text-sm mb-0">${data.html_estado}</h6>
                    </div>
                </td>
                <td>
                    <div class="text-center">
                        <p class="text-xs font-weight-bold mb-0">Accion</p>
                        <h6 class="text-sm mb-0">${data.btn_accion}</h6>
                    </div>
                </td>
            </tr>`;
        });

        $('#lista_pendientes').html(body);
    });
}

function modificar(id_visita) {
    $('#modal_modificar').modal('show');

    $.get(`back-end/visitas/visitas.php?id_visita=${id_visita}`, function (response) {

        let o = JSON.parse(response);

        $('#id_visita').val(o[0].id_visita);
        $('#cliente').val(o[0].nombres_cliente);
        $('#producto_visita').val(o[0].producto_visita);
        $('#formula').val(o[0].formula);
        $('#producto').val(o[0].producto_formula);
        $('#incentivo').val(o[0].incentivo);
        $('#m_medica').val(o[0].m_medica);

        if (o[0].detalle_incentivo == '0' || o[0].detalle_incentivo == '') {
            let nro_incidencias = 0;
        }

        if (o[0].nro_muestra == '' || o[0].nro_muestra == '0') {
            let nro_muestra = 0;
        }

        $('#nro_incentivo').val(nro_incidencias);
        $('#nro_muestra').val(nro_muestra);

        $('#incentivo1').val(o[0].incentivo1);
        $('#cantidad_in1').val(o[0].cantidad_in1);
        $('#incentivo2').val(o[0].incentivo2);
        $('#cantidad_in2').val(o[0].cantidad_in2);
        $('#incentivo3').val(o[0].incentivo3);
        $('#cantidad_in3').val(o[0].cantidad_in3);
        $('#muestra1').val(o[0].muestra1);
        $('#cantidad_m1').val(o[0].cantidad_m1);
        $('#muestra2').val(o[0].muestra2);
        $('#cantidad_m2').val(o[0].cantidad_m2);
        $('#muestra3').val(o[0].muestra3);
        $('#cantidad_m3').val(o[0].cantidad_m3);

        $('#tipo_visita').val(o[0].tipo_visita);
        $('#observaciones').val(o[0].observaciones);
        $('#compromisos').val(o[0].compromiso);
        $('#fecha_compromiso').val(o[0].fecha_compromiso);
        $('#nueva_visita').val();
        $('#fecha').val();
    });

    $.get(`back-end/visitas/visitas.php?list_articulos=all`, function (response) {

        let o = JSON.parse(response);

        let template = `<datalist id="listaArticulos">`;
        let template1 = `<datalist id="listaArticulos1">`;
        let body = ``;
        let template_end = `</datalist>`;

        o.forEach(data => {
            body += `<option>${data.nombres_articulo}</option>`;
        });

        $('#datalist_producto').html(template + body + template_end);
        $('#datalist_producto1').html(template1 + body + template_end);

    });
}

function modificar_visita() {
    let id_visita = $('#id_visita').val();
    let nombre_cliente = $('#cliente').val();
    let producto_visita = $('#producto_visita').val();
    let formula = $('#formula').val();
    let producto_formula = $('#producto').val();
    let incentivo = $('#incentivo').val();
    let detalle_incentivo = $('#nro_incentivo').val();
    let m_medica = $('#m_medica').val();
    let nro_muestra = $('#nro_muestra').val();

    let incentivo1 = $('#incentivo1').val();
    let cantidad_in1 = $('#cantidad_in1').val();
    let incentivo2 = $('#incentivo2').val();
    let cantidad_in2 = $('#cantidad_in2').val();
    let incentivo3 = $('#incentivo3').val();
    let cantidad_in3 = $('#cantidad_in3').val();
    let muestra1 = $('#muestra1').val();
    let cantidad_m1 = $('#cantidad_m1').val();
    let muestra2 = $('#muestra2').val();
    let cantidad_m2 = $('#cantidad_m2').val();
    let muestra3 = $('#muestra3').val();
    let cantidad_m3 = $('#cantidad_m3').val();

    let tipo_visita = $('#tipo_visita').val();
    let observaciones = $('#observaciones').val();
    let compromiso = $('#compromisos').val();
    let fecha_compromiso = $('#fecha_compromiso').val();
    let nueva_visita = $('#nueva_visita').val();
    let fecha = $('#fecha').val();

    const POSTDATA = {
        id_visita: id_visita,
        nombres_cliente: nombres_cliente,
        producto_visita: producto_visita,
        formula: formula,
        producto_formula: producto_formula,
        incentivo: incentivo,
        detalle_incentivo: detalle_incentivo,
        m_medica: m_medica,
        nro_muestra: nro_muestra,
        incentivo1: incentivo1,
        cantidad_in1: cantidad_in1,
        incentivo2: incentivo2,
        cantidad_in2: cantidad_in2,
        incentivo3: incentivo3,
        cantidad_in3: cantidad_in3,
        muestra1: muestra1,
        cantidad_m1: cantidad_m1,
        muestra2: muestra2,
        cantidad_m2: cantidad_m2,
        muestra3: muestra3,
        cantidad_m3: cantidad_m3,
        tipo_visita: tipo_visita,
        observaciones: observaciones,
        compromiso: compromiso,
        fecha_compromiso: fecha_compromiso,
        nueva_visita: nueva_visita,
        fecha: fecha
    }

    $.post(`back-end/visitas/visitas.php`, POSTDATA, function (response) {
        let o = parseInt(response);
        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Visita Actualizada'
            });
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Actualizar Visita'
            });
        }
    });
}

function setId_hora_inicio(id_visita) {
    $('#Id_hora_inicio').val(id_visita);
}

function hora_inicio() {

    let id_visita = $('#Id_hora_inicio').val();

    $.post(`back-end/inicio/inicio.php`, { id_visita }, function (response) {
        let o = parseInt(response);

        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Visita Iniciada'
            });
            lista_pendientes();
            $('#hora_inicio').modal('hide');
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Iniciar Visita'
            });
        }
    });
}

function objetivos_ciclo_actual() {

    let fecha_ini = $('#fecha_ini_v').val();
    let fecha_fin = $('#fecha_fin_v').val();
    let ciclo = $('#list_ciclo').val();
    let tipo_cliente = $('#tipo_cliente_filtro').val();

    $.get(`back-end/inicio/inicio.php?objetivos_ciclo_actual=${'all'}&ciclo=${ciclo}&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}&tipo_cliente=${tipo_cliente}`, function (respose) {
        console.log(respose)
        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o.ciclo} - ${o.cant_obje}</h5>`;

        let ciclo_interno = o.ciclo.split(' ');
        ciclo_actual = ciclo_interno[1];
        consulta_lineas(ciclo_actual);

        document.getElementById('list_ciclo').select = ciclo_interno[1];

        $('#objetivos_ciclo_actual').html(body);
    });

}














function formula_active(data) {

    let producto = document.getElementById('producto');
    let btn_lista2 = document.getElementById('btn_lista2');
    if (data == 'SI') {
        producto.disabled = false;
        btn_lista2.disabled = false;
    } else {
        producto.disabled = true;
        btn_lista2.disabled = true;
    }
}

function incentivo_active(data) {

    let n_obsequio = document.getElementById('nro_incentivo');
    if (data == 'SI') {
        n_obsequio.disabled = false;
    } else {
        n_obsequio.disabled = true;
    }
}

function m_medica_active(data) {

    let nro_muestra = document.getElementById('nro_muestra');
    if (data == 'SI') {
        nro_muestra.disabled = false;
    } else {
        nro_muestra.disabled = true;
    }
}

async function modificar(id_visita) {

    let nueva_visita = $('#nueva_visita').val();
    if (nueva_visita == 'NO') { $('#fecha_visita_nueva_container').hide(); }

    let formula = $('#formula').val();
    if (formula == 'NO') {

        let producto = document.getElementById('producto');
        producto.disabled = true;

        let btn_lista2 = document.getElementById('btn_lista2');
        btn_lista2.disabled = true;
    }

    let incentivo = $('#incentivo').val();
    if (incentivo == 'NO') {
        let n_obsequio = document.getElementById('nro_incentivo');
        n_obsequio.disabled = true;
    }

    let m_medica = $('#m_medica').val();
    if (m_medica == 'NO') {
        let nro_muestra = document.getElementById('nro_muestra');
        nro_muestra.disabled = true;
    }

    $('#modal_modificar').modal('show');

    await $.get(`back-end/visitas/visitas.php?id_visita=${id_visita}`, async function (response) {

        let o = JSON.parse(response);

        $('#id_visita').val(o[0].id_visita);
        $('#cliente').val(o[0].nombres_cliente);
        $('#producto_visita').val(o[0].producto_visita);

        $('#producto').val(o[0].producto_formula);

        if (o[0].detalle_incentivo == '0' || o[0].detalle_incentivo == '') {
            let nro_incidencias = 0;
        }

        if (o[0].nro_muestra == '' || o[0].nro_muestra == '0') {
            let nro_muestra = 0;
        }

        $('#nro_incentivo').val(nro_incidencias);
        $('#nro_muestra').val(nro_muestra);

        $('#incentivo1').val(o[0].incentivo1);
        $('#cantidad_in1').val(o[0].cantidad_in1);
        $('#incentivo2').val(o[0].incentivo2);
        $('#cantidad_in2').val(o[0].cantidad_in2);
        $('#incentivo3').val(o[0].incentivo3);
        $('#cantidad_in3').val(o[0].cantidad_in3);
        $('#muestra1').val(o[0].muestra1);
        $('#cantidad_m1').val(o[0].cantidad_m1);
        $('#muestra2').val(o[0].muestra2);
        $('#cantidad_m2').val(o[0].cantidad_m2);
        $('#muestra3').val(o[0].muestra3);
        $('#cantidad_m3').val(o[0].cantidad_m3);

        $('#tipo_visita').val(o[0].tipo_visita);
        $('#observaciones').val(o[0].observaciones);
        $('#compromisos').val(o[0].compromiso);
        $('#fecha_compromiso').val(o[0].fecha_compromiso);
        $('#nueva_visita').val();
        $('#fecha').val();
    });

    await $.get(`back-end/visitas/visitas.php?list_articulos=all`, async function (response) {

        let o = JSON.parse(response);


        let template = `<datalist id="listaArticulos">`;
        let template1 = `<datalist id="listaArticulos1">`;
        let temp = '';
        let body = ``;
        let template_end = `</datalist>`;

        o.forEach(data => {
            let t = data.tipo;
            if (t == 'OBSEQUIO') { temp += `<option>${data.nombre_articulo}</option>`; }
            body += `<option>${data.nombre_articulo}</option>`;
        });

        $('#datalist_producto').html(template + body + template_end);
        $('#datalist_producto1').html(template1 + body + template_end);
        $('#list_incentivo').html(temp);
    });

    await $.get(`back-end/visitas/visitas.php?list_articulos_inventario=all`, async function (response) {

        let o = JSON.parse(response);


        let muestra1 = document.getElementById('muestra1');
        let muestra2 = document.getElementById('muestra2');
        let muestra3 = document.getElementById('muestra3');

        let option = document.createElement('option');
        option.text = 'Seleccione';

        muestra1.appendChild(option);
        muestra2.appendChild(option);
        muestra3.appendChild(option);

        o.forEach(data => {
            let option1 = document.createElement('option');
            option1.value = data.nombre_articulo;
            option1.text = data.nombre_articulo;

            muestra1.appendChild(option1);

            let option2 = document.createElement('option');
            option2.value = data.nombre_articulo;
            option2.text = data.nombre_articulo;

            muestra2.appendChild(option2);

            let option3 = document.createElement('option');
            option3.value = data.nombre_articulo;
            option3.text = data.nombre_articulo;

            muestra3.appendChild(option3);
        });
    });
}

async function consul_list_productos() {
    $.get(`back-end/visitas/visitas.php?list_articulos=all`, function (response) {

        let o = JSON.parse(response);


        let template = `<datalist id="listaArticulos">`;
        let template1 = `<datalist id="listaArticulos1">`;
        let temp = '';
        let temp1 = '';
        let body = ``;
        let body_table = ``;
        let template_end = `</datalist>`;

        o.forEach(data => {
            let t = data.tipo;
            if (t == 'OBSEQUIO') { temp += `<option>${data.nombre_articulo}</option>`; }
            if (t == 'MUESTRA') { temp1 += `<option>${data.nombre_articulo}</option>`; }
            body += `<option>${data.nombre_articulo}</option>`;
            body_table +=
                `<tr>
                    <td>
                        <input type="checkbox" value="${data.nombre_articulo}">
                    </td>
                    <td>${data.nombre_articulo}</td>
                </tr>`;
        });

        $('#datalist_producto').html(template + body + template_end);
        $('#datalist_producto1').html(template1 + body + template_end);
        $('#list_incentivo').html(temp);
        $('#list_productos').html(body_table);
        $('#list_productos1').html(body_table);
    });

    await $.get(`back-end/visitas/visitas.php?list_articulos_inventario=all`, async function (response) {

        let o = JSON.parse(response);


        let muestra1 = document.getElementById('muestra1');
        let muestra2 = document.getElementById('muestra2');
        let muestra3 = document.getElementById('muestra3');

        let option = document.createElement('option');
        option.text = 'Seleccione';

        muestra1.appendChild(option);
        muestra2.appendChild(option);
        muestra3.appendChild(option);

        o.forEach(data => {
            let option1 = document.createElement('option');
            option1.value = data.nombre_articulo;
            option1.text = data.nombre_articulo;

            muestra1.appendChild(option1);

            let option2 = document.createElement('option');
            option2.value = data.nombre_articulo;
            option2.text = data.nombre_articulo;

            muestra2.appendChild(option2);

            let option3 = document.createElement('option');
            option3.value = data.nombre_articulo;
            option3.text = data.nombre_articulo;

            muestra3.appendChild(option3);
        });

    });
}

function detalles(id_visita) {
    $('#modal_detalles').modal('show');

    $.get(`back-end/visitas/visitas.php?id_visita=${id_visita}`, function (response) {
        let o = JSON.parse(response);

        $('#cliente_detalle').val(o[0].nombres_cliente);
        $('#producto_visita_detalle').val(o[0].producto_visita);
        $('#formula_detalle').val(o[0].formula);
        $('#producto_detalle').val(o[0].producto_formula);
        $('#incentivo_detalle').val(o[0].incentivo);

        let contar_incent = 0;
        let contar_muestra = 0;

        if (o[0].cantidad_in1 == 0) {
            $('#container_nro_incentivo1_detalle').hide();
        } else {
            contar_incent++;
        }

        if (o[0].cantidad_in2 == 0) {
            $('#container_nro_incentivo2_detalle').hide();
        } else {
            contar_incent++;
        }

        if (o[0].cantidad_in3 == 0) {
            $('#container_nro_incentivo3_detalle').hide();
        } else {
            contar_incent++;
        }

        if (o[0].cantidad_m1 == 0) {
            $('#container_nro_muestra1_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m2 == 0) {
            $('#container_nro_muestra2_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m3 == 0) {
            $('#container_nro_muestra3_detalle').hide();
        } else {
            contar_muestra++;
        }

        $('#nro_incentivo_detalle').val(contar_incent);
        $('#nro_muestra_detalle').val(contar_muestra);

        $('#incentivo1_detalle').val(o[0].incentivo1);
        $('#cantidad_in1_detalle').val(o[0].cantidad_in1);
        $('#incentivo2_detalle').val(o[0].incentivo2);
        $('#cantidad_in2_detalle').val(o[0].cantidad_in2);
        $('#incentivo3_detalle').val(o[0].incentivo3);
        $('#cantidad_in3_detalle').val(o[0].cantidad_in3);

        $('#muestra1_detalle').val(o[0].muestra1);
        $('#cantidad_m1_detalle').val(o[0].cantidad_m1);
        $('#muestra2_detalle').val(o[0].muestra2);
        $('#cantidad_m2_detalle').val(o[0].cantidad_m2);
        $('#muestra3_detalle').val(o[0].muestra3);
        $('#cantidad_m3_detalle').val(o[0].cantidad_m3);

        $('#m_medica_detalle').val(o[0].m_medica);

        $('#tipo_visita_detalle').val(o[0].tipo_visita);
        $('#observaciones_detalle').val(o[0].observaciones);
        $('#compromisos_detalle').val(o[0].compromiso);
        $('#fecha_compromiso_detalle').val(o[0].fecha_compromiso);
        $('#nueva_visita_detalle').val(o[0].proxima_visita);
        $('#fecha_detalle').val(o[0].fecha_proxima_visita);

    });
}

function modificar_visita() {
    let id_visita = $('#id_visita').val();
    let nombres_cliente = $('#cliente').val();
    let producto_visita = $('#producto_visita').val();
    let formula = $('#formula').val();
    let producto_formula = $('#producto').val();
    let incentivo = $('#incentivo').val();
    let detalle_incentivo = $('#nro_incentivo').val();
    let m_medica = $('#m_medica').val();
    let nro_muestra = $('#nro_muestra').val();

    let incentivo1 = $('#incentivo1').val();
    let cantidad_in1 = $('#cantidad_in1').val();
    let incentivo2 = $('#incentivo2').val();
    let cantidad_in2 = $('#cantidad_in2').val();
    let incentivo3 = $('#incentivo3').val();
    let cantidad_in3 = $('#cantidad_in3').val();
    let muestra1 = $('#muestra1').val();
    let cantidad_m1 = $('#cantidad_m1').val();
    let muestra2 = $('#muestra2').val();
    let cantidad_m2 = $('#cantidad_m2').val();
    let muestra3 = $('#muestra3').val();
    let cantidad_m3 = $('#cantidad_m3').val();

    let tipo_visita = $('#tipo_visita').val();
    let observaciones = $('#observaciones').val();
    let compromiso = $('#compromisos').val();
    let fecha_compromiso = $('#fecha_compromiso').val();
    let nueva_visita = $('#nueva_visita').val();
    let fecha = $('#fecha').val();

    const POSTDATA = {
        id_visita: id_visita,
        nombres_cliente: nombres_cliente,
        producto_visita: producto_visita,
        formula: formula,
        producto_formula: producto_formula,
        incentivo: incentivo,
        detalle_incentivo: detalle_incentivo,
        m_medica: m_medica,
        nro_muestra: nro_muestra,
        incentivo1: incentivo1,
        cantidad_in1: cantidad_in1,
        incentivo2: incentivo2,
        cantidad_in2: cantidad_in2,
        incentivo3: incentivo3,
        cantidad_in3: cantidad_in3,
        muestra1: muestra1,
        cantidad_m1: cantidad_m1,
        muestra2: muestra2,
        cantidad_m2: cantidad_m2,
        muestra3: muestra3,
        cantidad_m3: cantidad_m3,
        tipo_visita: tipo_visita,
        observaciones: observaciones,
        compromiso: compromiso,
        fecha_compromiso: fecha_compromiso,
        nueva_visita: nueva_visita,
        fecha: fecha
    }

    $.post(`back-end/visitas/visitas.php`, POSTDATA, function (response) {
        let o = parseInt(response);
        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Visita Actualizada'
            });
            aplicar_filtro();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Actualizar Visita'
            });
        }
    });
}

function cambiar(id_visita) {
    $('#modal_cambiar').modal('show');
    $('#id_visita').val(id_visita);
}

function cambiar_visita() {
    let nueva_fecha = $('#nueva_fecha').val();
    let id_visita = $('#id_visita').val();

    $.post(`back-end/visitas/visitas.php`, { id_visita, nueva_fecha }, function (response) {
        let o = parseInt(response);
        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Fecha Actualizada'
            });
            call_data();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Actualizar la Fecha'
            });
        }
    });
}

function cerrar(id_visita) {
    $('#modal_cerrar').modal('show');
    $('#id_visita').val(id_visita);
}

function cerrar_visita() {

    let id_visita = $('#id_visita').val();
    let observaciones_cierre = $('#observaciones_cierre').val();

    $.post(`back-end/visitas/visitas.php`, { id_visita, observaciones_cierre }, function (response) {

        let o = parseInt(response);
        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Cierre exitoso'
            });
            call_data();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Realizar el Cierre'
            });
        }
    });
}

function load_incentivos_input(data) {

    $('#container_nro_incentivo1').hide();
    $('#container_nro_incentivo2').hide();
    $('#container_nro_incentivo3').hide();

    for (let index = 1; index <= data; index++) {
        $(`#container_nro_incentivo${index}`).show();
    }
}

function load_muestra_input(data) {

    $('#container_nro_muestra1').hide();
    $('#container_nro_muestra2').hide();
    $('#container_nro_muestra3').hide();

    for (let index = 1; index <= data; index++) {
        $(`#container_nro_muestra${index}`).show();
    }
}

function setId_hora_inicio(id_visita) {
    $('#Id_hora_inicio').val(id_visita);
}

function hora_inicio() {

    let id_visita = $('#Id_hora_inicio').val();

    $.post(`back-end/inicio/inicio.php`, { id_visita }, function (response) {
        ;
        let o = parseInt(response);

        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Visita Iniciada'
            });
            aplicar_filtro();
            $('#hora_inicio').modal('hide');
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Iniciar Visita'
            });
        }
    });
}

async function consul_ficha_medica(cod_medico) {
    $.get(`back-end/visitas/visitas.php?cod_medico=${cod_medico}`, async function (response) {
        let o = JSON.parse(response);



        let templete = `
            <table class="table table-flush" style="font-size: 10px;" id="datatable_datos">
                <thead class="thead-light">
                    <tr>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Marca </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Mercado </th>
                    </tr>
                </thead>
            <tbody>`;

        let body = ``;
        let template_end = `</tbody></table>`;

        o.forEach(element => {
            body += `
                <tr>
                    <td style="font-size: 10px;" class="text-center font-weight-normal">${element.marca}</td>
                    <td style="font-size: 10px;" class="text-center font-weight-normal">${element.Mercado}</td>
                </tr>`;
        });

        await $('#tabla_ficha_medica').html(templete + body + template_end);
    });
}

function colect_lista_productos() {
    let datos = ``;
    let lista = [];
    let tabla_productos_select = document.getElementById('tabla_productos_select');

    let filas = tabla_productos_select.getElementsByTagName('tr');

    for (let i = 0; i < filas.length; i++) {
        let celdas = filas[i].getElementsByTagName('td');

        for (let j = 0; j < celdas.length; j++) {
            let contenido = celdas[j].getElementsByTagName('input');


            if (contenido[0] != undefined) {
                if (contenido[0].checked == true) {
                    lista.push(contenido[0].value);
                    datos += contenido[0].value + ` ,`;
                }
            }
        }
    }

    $('#producto_visita').val(datos);
}

function colect_lista_productos1() {
    let datos = ``;
    let lista = [];
    let tabla_productos_select = document.getElementById('tabla_productos_select1');

    let filas = tabla_productos_select.getElementsByTagName('tr');

    for (let i = 0; i < filas.length; i++) {
        let celdas = filas[i].getElementsByTagName('td');

        for (let j = 0; j < celdas.length; j++) {
            let contenido = celdas[j].getElementsByTagName('input');


            if (contenido[0] != undefined) {
                if (contenido[0].checked == true) {
                    lista.push(contenido[0].value);
                    datos += contenido[0].value + ` ,`;
                }
            }
        }
    }

    $('#producto').val(datos);
}

function list_ciclo() {

    let list_ciclo = 'ALL';

    $.ajax({
        url: 'back-end/objetivos_visita/objetivos_visita.php',
        type: 'GET',
        data: { list_ciclo },
        success: function (response) {

            let datas = JSON.parse(response);
            let list_ciclo_select = document.getElementById('list_ciclo');

            let opt = document.createElement('option');
            opt.value = "";
            opt.innerHTML = "Seleccione";
            list_ciclo_select.appendChild(opt);

            datas.forEach(data => {
                let opt = document.createElement('option');
                opt.value = data.id;
                opt.innerHTML = data.ciclo;
                list_ciclo_select.appendChild(opt);
            });

        }
    });

    var inputElement = document.getElementById("fecha_ini");
    var inputElement1 = document.getElementById("fecha_fin");
    var fecha = new Date(); //Fecha actual
    var mes = fecha.getMonth() + 1; //obteniendo mes
    var dia = fecha.getDate(); //obteniendo dia
    var ano = fecha.getFullYear(); //obteniendo a単o
    if (dia < 10)
        dia = '0' + dia; //agrega cero si el menor de 10
    if (mes < 10)
        mes = '0' + mes //agrega cero si el menor de 10 f_exp_mat
    //

    inputElement.value = (ano + "-" + mes + "-" + dia);
    inputElement1.value = (ano + "-" + mes + "-" + dia);
}

function actualiza_fecha() {
    document.getElementById("f1").style.display = "block";
    document.getElementById("f2").style.display = "block";
    document.getElementById("tipo_cliente_filtro_container").style.display = "block";

    let id = $('#list_ciclo').val();
    $.get(`back-end/ciclos_visita/ciclos_visita.php?id_ciclo=${id}`, function (response) {

        let o = JSON.parse(response);

        $('#fecha_ini').val(o[0].fecha_desde);
        $('#fecha_fin').val(o[0].fecha_hasta);
        $('#fecha_ini_v').val(o[0].fecha_desde);
        $('#fecha_fin_v').val(o[0].fecha_hasta);
    });
}

function val_fecha_ini() {
    $f1 = $('#fecha_ini').val();
    $f2 = $('#fecha_ini_v').val();
    if ($f1 < $f2) {
        $('#fecha_ini').val($f2);
    }
}

function val_fecha_fin() {
    $f1 = $('#fecha_fin').val();
    $f2 = $('#fecha_fin_v').val();
    if ($f1 > $f2) {
        $('#fecha_fin').val($f2);
    }
}

function consulta_lineas(consulta_lineas = '') {

    let reporte_cab = 'ALL';
    let fi = $("#fecha_ini").val();
    let ff = $("#fecha_fin").val();
    let ciclo = $('#list_ciclo').val() == null ? consulta_lineas : $('#list_ciclo').val();

    $.ajax({
        url: 'back-end/reportes.php',
        type: 'GET',
        data: { reporte_cab, fi, ff, ciclo },
        success: function (response) {
            console.log(response);
            let datas = JSON.parse(response);
            let template = '';
            datas.forEach(data => {
                template += `
                <tr>
                    <td class="text-center text-sm font-weight-normal">${data.tipo}</td>
                    <td class="text-center text-sm font-weight-normal">${data.total}</td>
                    <td class="text-center text-sm font-weight-normal">${data.gestionadas}</td>
                    <td class="text-center text-sm font-weight-normal">${data.pendientes}</td>
                    <td class="text-center text-sm font-weight-normal">${data.cumplimiento}</td>
                    <td class="text-center text-sm font-weight-normal">${data.objetivo}</td>
                    <td class="text-center text-sm font-weight-normal">${data.cumple_obj}</td>
                    <td class="text-center text-sm font-weight-normal">${data.faltantes_obj}</td>
                </tr>`
            });
            $('#lineas_tipo').html(template);
        }
    });
}