const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function lista_ciclos() {
    $.get(`back-end/reporte1/reporte1.php?lista_ciclos=${'all'}`, function (response) {

        console.log(response);
        let o = JSON.parse(response);
        let templete = `<select class="form-control" id="ciclos_visitas">`;
        let body = `<option value="">Seleccione</option>`;
        let templete_end = `</select>`;

        o.forEach(data => {
            body += `
                <option value="${data.id}">${data.ciclo}</option>
            `;
        });

        $('#lista_ciclos').html(templete + body + templete_end);
    });
}

async function consul_medicos_no_visitados() {

    let ciclo_visitas = $('#ciclos_visitas').val();

    if (ciclo_visitas == '') {
        Toast.fire({
            icon: 'error',
            title: 'Por favor Seleccione un ciclo'
        });
    } else {
        Swal.fire({
            title: 'Cargando...',
            html: 'Espere un momento por favor.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });
        let templete = `<table class="table table-flush" id="datatable_visitas">
        <thead class="thead-light">
            <tr>
                <th
                    class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">
                    Codigo</th>
                <th
                    class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">
                    Cliente</th>
                <th
                    class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">
                    Telefono</th>
                <th
                    class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">
                    Especialidad</th>
                <th
                    class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">
                    Estado</th>
                <th
                    class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">
                </th>
            </tr>
        </thead>
        <tbody>`;
        let body = ``;
        let templete_end = `</tbody>
        </table>`;

        await $.get(`back-end/reporte1/reporte1.php?consul_no_visit=${'all'}&ciclo_visitas=${ciclo_visitas}`, async function (response) {
            console.log(response);
        
  

            let o = JSON.parse(response);
            // console.log(o);

            o.forEach(data => {

                body += `
                    <tr>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.codigo}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.cliente}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.telefono}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.especialidad}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.estado}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.btn}</td>
                    </tr>
                `;
            });

            await $('#visitas_container').html(templete + body + templete_end);
            Swal.close();
            Toast.fire({
                icon: 'success',
                title: 'Consulta Realizada'
            });

        });

        const dataTableSearch = new simpleDatatables .DataTable("#datatable_visitas", {
            searchable: true,
        });
    }

}

function crear_visita() {
    let id_panel = $('#id_panel').val();
    let fecha_visita = $('#fecha_visita').val();

    $.post(`back-end/reporte1/reporte1.php`, { id_panel, fecha_visita }, function (response) {

        console.log(response)
        let o = parseInt(response);

        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Visita Programada'
            });
            $('#modal_fecha_visita').modal('hide');
            consul_medicos_no_visitados();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Programar Visita'
            });
        }
    });
}

function setID(id_panel) {
    $('#id_panel').val(id_panel);
}