const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

async function call_data() {

    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();

    await $.get(`back-end/visitas/visitas.php?datos=all&fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}`, function (response) {

        let o = JSON.parse(response);
        console.log(o)
        let body = ``;

        o.forEach(data => {
            body += `
                <tr>
                    <td class="text-center font-weight-normal">${data.apellidos_cliente} ${data.nombres_cliente}</td>
                    <td class="text-center font-weight-normal">${data.direccion_cliente}</td>
                    <td class="text-center font-weight-normal">${data.telefono_cliente}</td>
                    <td class="text-center font-weight-normal">${data.estado_cliente}</td>
                    <td class="text-center font-weight-normal">
                        ${data.btn_ficha}
                        ${data.btn_hora_ini}
                        ${data.btn_modificar}
                        ${data.btn_cambiar}
                        ${data.btn_cerrar}
                        ${data.btn_detalles}
                    </td>
                <tr>`;
        });

        $('#datos_tabla_visitas').html(body);
    });

}

function filtro_fecha() {
    $('#filtro_fecha').modal('show');

    $('#fecha_ini_filtro').val($("#fecha_ini").val());
    $('#fecha_fin_filtro').val($("#fecha_fin").val());
}

async function aplicar_filtro() {

    await $('#fecha_ini').val($("#fecha_ini_filtro").val());
    await $('#fecha_fin').val($("#fecha_fin_filtro").val());

    call_data();
}

function fecha_nueva_visita(dato) {
    if (dato == 'SI') {
        $('#fecha_visita_nueva_container').show();
    } else {
        $('#fecha_visita_nueva_container').hide();
    }
}

function formula_active(data) {

    let producto = document.getElementById('producto');
    let btn_lista2 = document.getElementById('btn_lista2');
    if (data == 'SI') {
        producto.disabled = false;
        btn_lista2.disabled = false;
    } else {
        producto.disabled = true;
        btn_lista2.disabled = true;
    }
}

function incentivo_active(data) {

    let n_obsequio = document.getElementById('nro_incentivo');
    if (data == 'SI') {
        n_obsequio.disabled = false;
    } else {
        n_obsequio.disabled = true;
    }
}

function m_medica_active(data) {

    let nro_muestra = document.getElementById('nro_muestra');
    if (data == 'SI') {
        nro_muestra.disabled = false;
    } else {
        nro_muestra.disabled = true;
    }
}

async function modificar(id_visita) {

    let nueva_visita = $('#nueva_visita').val();
    if (nueva_visita == 'NO') { $('#fecha_visita_nueva_container').hide(); }

    let formula = $('#formula').val();
    if (formula == 'NO') {

        let producto = document.getElementById('producto');
        producto.disabled = true;

        let btn_lista2 = document.getElementById('btn_lista2');
        btn_lista2.disabled = true;
    }

    let incentivo = $('#incentivo').val();
    if (incentivo == 'NO') {
        let n_obsequio = document.getElementById('nro_incentivo');
        n_obsequio.disabled = true;
    }

    let m_medica = $('#m_medica').val();
    if (m_medica == 'NO') {
        let nro_muestra = document.getElementById('nro_muestra');
        nro_muestra.disabled = true;
    }

    $('#modal_modificar').modal('show');

    await $.get(`back-end/visitas/visitas.php?id_visita=${id_visita}`, async function (response) {

        let o = JSON.parse(response);

        $('#id_visita').val(o[0].id_visita);
        $('#cliente').val(o[0].apellidos_cliente+' '+o[0].nombres_cliente);
        $('#producto_visita').val(o[0].producto_visita);

        $('#producto').val(o[0].producto_formula);

        if (o[0].detalle_incentivo == '0' || o[0].detalle_incentivo == '') {
            let nro_incidencias = 0;
        }

        if (o[0].nro_muestra == '' || o[0].nro_muestra == '0') {
            let nro_muestra = 0;
        }

        $('#nro_incentivo').val(nro_incidencias);
        $('#nro_muestra').val(nro_muestra);

        $('#incentivo1').val(o[0].incentivo1);
        $('#cantidad_in1').val(o[0].cantidad_in1);
        $('#incentivo2').val(o[0].incentivo2);
        $('#cantidad_in2').val(o[0].cantidad_in2);
        $('#incentivo3').val(o[0].incentivo3);
        $('#cantidad_in3').val(o[0].cantidad_in3);

        $('#muestra1').val(o[0].muestra1);
        $('#cantidad_m1').val(o[0].cantidad_m1);
        $('#muestra2').val(o[0].muestra2);
        $('#cantidad_m2').val(o[0].cantidad_m2);
        $('#muestra3').val(o[0].muestra3);
        $('#cantidad_m3').val(o[0].cantidad_m3);

        $('#muestra4').val(o[0].muestra4);
        $('#cantidad_m4').val(o[0].cantidad_m4);
        $('#muestra5').val(o[0].muestra5);
        $('#cantidad_m5').val(o[0].cantidad_m5);
        $('#muestra6').val(o[0].muestra6);
        $('#cantidad_m6').val(o[0].cantidad_m6);

        $('#muestra7').val(o[0].muestra7);
        $('#cantidad_m7').val(o[0].cantidad_m7);
        $('#muestra8').val(o[0].muestra8);
        $('#cantidad_m8').val(o[0].cantidad_m8);
        $('#muestra9').val(o[0].muestra9);
        $('#cantidad_m9').val(o[0].cantidad_m9);

        $('#muestra10').val(o[0].muestra10);
        $('#cantidad_m10').val(o[0].cantidad_m10);

        $('#tipo_visita').val(o[0].tipo_visita);
        $('#observaciones').val(o[0].observaciones);
        $('#compromisos').val(o[0].compromiso);
        $('#fecha_compromiso').val(o[0].fecha_compromiso);
        $('#nueva_visita').val();
        $('#fecha').val();
    });

    await $.get(`back-end/visitas/visitas.php?list_articulos=all`, async function (response) {

        let o = JSON.parse(response);

        let template = `<datalist id="listaArticulos">`;
        let template1 = `<datalist id="listaArticulos1">`;
        let temp = '';
        let body = ``;
        let template_end = `</datalist>`;

        o.forEach(data => {
            let t = data.tipo;
            if (t == 'OBSEQUIO') { temp += `<option>${data.nombre_articulo}</option>`; }
            body += `<option>${data.nombre_articulo}</option>`;
        });

        $('#datalist_producto').html(template + body + template_end);
        $('#datalist_producto1').html(template1 + body + template_end);
        $('#list_incentivo').html(temp);
    });

    await $.get(`back-end/visitas/visitas.php?list_articulos_inventario=all`, async function (response) {

        let o = JSON.parse(response);
        console.log(o);

        let muestra1 = document.getElementById('muestra1');
        let muestra2 = document.getElementById('muestra2');
        let muestra3 = document.getElementById('muestra3');
        let muestra4 = document.getElementById('muestra4');
        let muestra5 = document.getElementById('muestra5');
        let muestra6 = document.getElementById('muestra6');
        let muestra7 = document.getElementById('muestra7');
        let muestra8 = document.getElementById('muestra8');
        let muestra9 = document.getElementById('muestra9');
        let muestra10 = document.getElementById('muestra10');

        muestra1.innerHTML = '';
        muestra2.innerHTML = '';
        muestra3.innerHTML = '';
        muestra4.innerHTML = '';
        muestra5.innerHTML = '';
        muestra6.innerHTML = '';
        muestra7.innerHTML = '';
        muestra8.innerHTML = '';
        muestra9.innerHTML = '';
        muestra10.innerHTML = '';

        let option1 = document.createElement('option');
        option1.text = 'Seleccione';

        let option2 = document.createElement('option');
        option2.text = 'Seleccione';

        let option3 = document.createElement('option');
        option3.text = 'Seleccione';

        let option4 = document.createElement('option');
        option4.text = 'Seleccione';

        let option5 = document.createElement('option');
        option5.text = 'Seleccione';

        let option6 = document.createElement('option');
        option6.text = 'Seleccione';

        let option7 = document.createElement('option');
        option7.text = 'Seleccione';

        let option8 = document.createElement('option');
        option8.text = 'Seleccione';

        let option9 = document.createElement('option');
        option9.text = 'Seleccione';

        let option10 = document.createElement('option');
        option10.text = 'Seleccione';

        muestra1.appendChild(option1);
        muestra2.appendChild(option2);
        muestra3.appendChild(option3);
        muestra4.appendChild(option4);
        muestra5.appendChild(option5);
        muestra6.appendChild(option6);
        muestra7.appendChild(option7);
        muestra8.appendChild(option8);
        muestra9.appendChild(option9);
        muestra10.appendChild(option10);

        o.forEach(data => {
            let option1 = document.createElement('option');
            option1.value = data.nombre_articulo;
            option1.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra1').val(data.cantidad);
            muestra1.appendChild(option1);

            let option2 = document.createElement('option');
            option2.value = data.nombre_articulo;
            option2.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra2').val(data.cantidad);
            muestra2.appendChild(option2);

            let option3 = document.createElement('option');
            option3.value = data.nombre_articulo;
            option3.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra3').val(data.cantidad);
            muestra3.appendChild(option3);

            let option4 = document.createElement('option');
            option4.value = data.nombre_articulo;
            option4.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra4').val(data.cantidad);
            muestra4.appendChild(option4);

            let option5 = document.createElement('option');
            option5.value = data.nombre_articulo;
            option5.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra5').val(data.cantidad);
            muestra5.appendChild(option5);

            let option6 = document.createElement('option');
            option6.value = data.nombre_articulo;
            option6.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra6').val(data.cantidad);
            muestra6.appendChild(option6);

            let option7 = document.createElement('option');
            option7.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra7').val(data.cantidad);
            muestra7.appendChild(option7);

            let option8 = document.createElement('option');
            option8.value = data.nombre_articulo;
            option8.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra8').val(data.cantidad);
            muestra8.appendChild(option8);

            let option9 = document.createElement('option');
            option9.value = data.nombre_articulo;
            option9.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra9').val(data.cantidad);
            muestra9.appendChild(option9);

            let option10 = document.createElement('option');
            option10.value = data.nombre_articulo;
            option10.text = data.cantidad + ' - ' + data.nombre_articulo;

            $('#limit_muestra10').val(data.cantidad);
            muestra10.appendChild(option10);
        });
    });
}

async function cargar_cant_articulo(nombre_articulo, input_limit) {
    await $.get(`back-end/visitas/visitas.php?consul_by_nombre=all&nombre_articulo=${nombre_articulo}`, async function (response) {

        let o = JSON.parse(response);
        await $(`#${input_limit}`).val(o[0].cantidad);
    });
}

function detalles(id_visita) {
    $('#modal_detalles').modal('show');

    $.get(`back-end/visitas/visitas.php?id_visita=${id_visita}`, function (response) {
        let o = JSON.parse(response);

        console.log(o)

        $('#cliente_detalle').val(o[0].apellidos_cliente+' '+o[0].nombres_cliente);
        $('#producto_visita_detalle').val(o[0].producto_visita);
        $('#formula_detalle').val(o[0].formula);
        $('#producto_detalle').val(o[0].producto_formula);
        $('#incentivo_detalle').val(o[0].incentivo);

        let contar_incent = 0;
        let contar_muestra = 0;

        if (o[0].cantidad_in1 == 0) {
            $('#container_nro_incentivo1_detalle').hide();
        } else {
            contar_incent++;
        }

        if (o[0].cantidad_in2 == 0) {
            $('#container_nro_incentivo2_detalle').hide();
        } else {
            contar_incent++;
        }

        if (o[0].cantidad_in3 == 0) {
            $('#container_nro_incentivo3_detalle').hide();
        } else {
            contar_incent++;
        }

        if (o[0].cantidad_m1 == 0) {
            $('#container_nro_muestra1_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m2 == 0) {
            $('#container_nro_muestra2_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m3 == 0) {
            $('#container_nro_muestra3_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m4 == 0) {
            $('#container_nro_muestra4_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m5 == 0) {
            $('#container_nro_muestra5_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m6 == 0) {
            $('#container_nro_muestra6_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m7 == 0) {
            $('#container_nro_muestra7_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m8 == 0) {
            $('#container_nro_muestra8_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m9 == 0) {
            $('#container_nro_muestra9_detalle').hide();
        } else {
            contar_muestra++;
        }

        if (o[0].cantidad_m10 == 0) {
            $('#container_nro_muestra10_detalle').hide();
        } else {
            contar_muestra++;
        }

        $('#nro_incentivo_detalle').val(contar_incent);
        $('#nro_muestra_detalle').val(contar_muestra);

        $('#incentivo1_detalle').val(o[0].incentivo1);
        $('#cantidad_in1_detalle').val(o[0].cantidad_in1);
        $('#incentivo2_detalle').val(o[0].incentivo2);
        $('#cantidad_in2_detalle').val(o[0].cantidad_in2);
        $('#incentivo3_detalle').val(o[0].incentivo3);
        $('#cantidad_in3_detalle').val(o[0].cantidad_in3);

        $('#muestra1_detalle').val(o[0].muestra1);
        $('#cantidad_m1_detalle').val(o[0].cantidad_m1);
        $('#muestra2_detalle').val(o[0].muestra2);
        $('#cantidad_m2_detalle').val(o[0].cantidad_m2);
        $('#muestra3_detalle').val(o[0].muestra3);
        $('#cantidad_m3_detalle').val(o[0].cantidad_m3);

        $('#muestra4_detalle').val(o[0].muestra4);
        $('#cantidad_m4_detalle').val(o[0].cantidad_m4);
        $('#muestra5_detalle').val(o[0].muestra5);
        $('#cantidad_m5_detalle').val(o[0].cantidad_m5);
        $('#muestra6_detalle').val(o[0].muestra6);
        $('#cantidad_m6_detalle').val(o[0].cantidad_m6);
        $('#muestra7_detalle').val(o[0].muestra7);
        $('#cantidad_m7_detalle').val(o[0].cantidad_m7);
        $('#muestra8_detalle').val(o[0].muestra8);
        $('#cantidad_m8_detalle').val(o[0].cantidad_m8);
        $('#muestra9_detalle').val(o[0].muestra9);
        $('#cantidad_m9_detalle').val(o[0].cantidad_m9);
        $('#muestra10_detalle').val(o[0].muestra10);
        $('#cantidad_m10_detalle').val(o[0].cantidad_m10);

        $('#m_medica_detalle').val(o[0].m_medica);

        $('#tipo_visita_detalle').val(o[0].tipo_visita);
        $('#observaciones_detalle').val(o[0].observaciones);
        $('#compromisos_detalle').val(o[0].compromiso);
        $('#fecha_compromiso_detalle').val(o[0].fecha_compromiso);
        $('#nueva_visita_detalle').val(o[0].proxima_visita);
        $('#fecha_detalle').val(o[0].fecha_proxima_visita);

    });
}

function modificar_visita() {

    let error = ``;
    let error2 = ``;

    let id_visita = $('#id_visita').val();
    let nombre_cliente = $('#cliente').val();
    let producto_visita = $('#producto_visita').val();
    let formula = $('#formula').val();
    let producto_formula = $('#producto').val();
    let incentivo = $('#incentivo').val();
    let detalle_incentivo = $('#nro_incentivo').val();
    let m_medica = $('#m_medica').val();
    let nro_muestra = $('#nro_muestra').val();

    let incentivo1 = $('#incentivo1').val();
    let cantidad_in1 = $('#cantidad_in1').val();
    let incentivo2 = $('#incentivo2').val();
    let cantidad_in2 = $('#cantidad_in2').val();
    let incentivo3 = $('#incentivo3').val();
    let cantidad_in3 = $('#cantidad_in3').val();

    let muestra1 = $('#muestra1').val();
    let cantidad_m1 = $('#cantidad_m1').val();
    let muestra2 = $('#muestra2').val();
    let cantidad_m2 = $('#cantidad_m2').val();
    let muestra3 = $('#muestra3').val();
    let cantidad_m3 = $('#cantidad_m3').val();
    let muestra4 = $('#muestra4').val();
    let cantidad_m4 = $('#cantidad_m4').val();
    let muestra5 = $('#muestra5').val();
    let cantidad_m5 = $('#cantidad_m5').val();
    let muestra6 = $('#muestra6').val();
    let cantidad_m6 = $('#cantidad_m6').val();
    let muestra7 = $('#muestra7').val();
    let cantidad_m7 = $('#cantidad_m7').val();
    let muestra8 = $('#muestra8').val();
    let cantidad_m8 = $('#cantidad_m8').val();
    let muestra9 = $('#muestra9').val();
    let cantidad_m9 = $('#cantidad_m9').val();
    let muestra10 = $('#muestra10').val();
    let cantidad_m10 = $('#cantidad_m10').val();

    let limit_muestra1 = $('#limit_muestra1').val();
    let limit_muestra2 = $('#limit_muestra2').val();
    let limit_muestra3 = $('#limit_muestra3').val();
    let limit_muestra4 = $('#limit_muestra4').val();
    let limit_muestra5 = $('#limit_muestra5').val();
    let limit_muestra6 = $('#limit_muestra6').val();
    let limit_muestra7 = $('#limit_muestra7').val();
    let limit_muestra8 = $('#limit_muestra8').val();
    let limit_muestra9 = $('#limit_muestra9').val();
    let limit_muestra10 = $('#limit_muestra10').val();

    let tipo_visita = $('#tipo_visita').val();
    let observaciones = $('#observaciones').val();
    let compromiso = $('#compromisos').val();
    let fecha_compromiso = $('#fecha_compromiso').val();
    let nueva_visita = $('#nueva_visita').val();
    let fecha = $('#fecha').val();

    if (parseInt(cantidad_m1) > 24) { error += 'error'; }
    if (parseInt(cantidad_m2) > 24) { error += 'error'; }
    if (parseInt(cantidad_m3) > 24) { error += 'error'; }
    if (parseInt(cantidad_m4) > 24) { error += 'error'; }
    if (parseInt(cantidad_m5) > 24) { error += 'error'; }
    if (parseInt(cantidad_m6) > 24) { error += 'error'; }
    if (parseInt(cantidad_m7) > 24) { error += 'error'; }
    if (parseInt(cantidad_m8) > 24) { error += 'error'; }
    if (parseInt(cantidad_m9) > 24) { error += 'error'; }
    if (parseInt(cantidad_m10) > 24) { error += 'error'; }

    if (parseInt(limit_muestra1) < parseInt(cantidad_m1)) { error2 += 'error'; }
    if (parseInt(limit_muestra2) < parseInt(cantidad_m2)) { error2 += 'error'; }
    if (parseInt(limit_muestra3) < parseInt(cantidad_m3)) { error2 += 'error'; }
    if (parseInt(limit_muestra4) < parseInt(cantidad_m4)) { error2 += 'error'; }
    if (parseInt(limit_muestra5) < parseInt(cantidad_m5)) { error2 += 'error'; }
    if (parseInt(limit_muestra6) < parseInt(cantidad_m6)) { error2 += 'error'; }
    if (parseInt(limit_muestra7) < parseInt(cantidad_m7)) { error2 += 'error'; }
    if (parseInt(limit_muestra8) < parseInt(cantidad_m8)) { error2 += 'error'; }
    if (parseInt(limit_muestra9) < parseInt(cantidad_m9)) { error2 += 'error'; }
    if (parseInt(limit_muestra10) < parseInt(cantidad_m10)) { error2 += 'error'; }
    //error == '' &&
    if (nro_muestra == 0) { error2 = ''; }
    if (error2 == '') {
        Swal.fire({
            title: "¿Desea cerrar la visita actual?",
            showDenyButton: true,
            confirmButtonText: "Si",
            denyButtonText: "No"
        }).then((result) => {
            if (result.isConfirmed) {
                const POSTDATA = {
                    id_visita: id_visita,
                    nombre_cliente: nombre_cliente,
                    producto_visita: producto_visita,
                    formula: formula,
                    producto_formula: producto_formula,
                    incentivo: incentivo,
                    detalle_incentivo: detalle_incentivo,
                    m_medica: m_medica,
                    nro_muestra: nro_muestra,
                    incentivo1: incentivo1,
                    cantidad_in1: cantidad_in1,
                    incentivo2: incentivo2,
                    cantidad_in2: cantidad_in2,
                    incentivo3: incentivo3,
                    cantidad_in3: cantidad_in3,
                    muestra1: muestra1,
                    cantidad_m1: cantidad_m1,
                    muestra2: muestra2,
                    cantidad_m2: cantidad_m2,
                    muestra3: muestra3,
                    cantidad_m3: cantidad_m3,
                    muestra4: muestra4,
                    cantidad_m4: cantidad_m4,
                    muestra5: muestra5,
                    cantidad_m5: cantidad_m5,
                    muestra6: muestra6,
                    cantidad_m6: cantidad_m6,
                    muestra7: muestra7,
                    cantidad_m7: cantidad_m7,
                    muestra8: muestra8,
                    cantidad_m8: cantidad_m8,
                    muestra9: muestra9,
                    cantidad_m9: cantidad_m9,
                    muestra10: muestra10,
                    cantidad_m10: cantidad_m10,
                    tipo_visita: tipo_visita,
                    observaciones: observaciones,
                    compromiso: compromiso,
                    fecha_compromiso: fecha_compromiso,
                    nueva_visita: nueva_visita,
                    fecha: fecha
                }

                $.post(`back-end/visitas/visitas.php`, POSTDATA, function (response) {
                    console.log(response)
                    let o = parseInt(response);
                    if (o == 200) {
                        Toast.fire({
                            icon: 'success',
                            title: 'Visita Actualizada'
                        });
                        $('#modal_modificar').modal('hide');
                        call_data();
                    } else {
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al Actualizar Visita'
                        });
                    }
                });
            }
        });
    } else if (error2 != '') {
        Toast.fire({
            icon: 'error',
            title: 'Uno de los articulos supera la cantidad del inventario'
        });
    }
}

function cambiar(id_visita) {
    $('#modal_cambiar').modal('show');
    $('#id_visita').val(id_visita);
}

function cambiar_visita() {
    let nueva_fecha = $('#nueva_fecha').val();
    let id_visita = $('#id_visita').val();

    $.post(`back-end/visitas/visitas.php`, { id_visita, nueva_fecha }, function (response) {
        let o = parseInt(response);
        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Fecha Actualizada'
            });
            call_data();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Actualizar la Fecha'
            });
        }
    });
}

function cerrar(id_visita) {
    $('#modal_cerrar').modal('show');
    $('#id_visita').val(id_visita);
}

function cerrar_visita() {

    let id_visita = $('#id_visita').val();
    let observaciones_cierre = $('#observaciones_cierre').val();

    $.post(`back-end/visitas/visitas.php`, { id_visita, observaciones_cierre }, function (response) {

        let o = parseInt(response);
        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Cierre exitoso'
            });
            call_data();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Realizar el Cierre'
            });
        }
    });
}

function load_incentivos_input(data) {

    $('#container_nro_incentivo1').hide();
    $('#container_nro_incentivo2').hide();
    $('#container_nro_incentivo3').hide();

    for (let index = 1; index <= data; index++) {
        $(`#container_nro_incentivo${index}`).show();
    }
}

function load_muestra_input(data) {

    $('#container_nro_muestra1').hide();
    $('#container_nro_muestra2').hide();
    $('#container_nro_muestra3').hide();
    $('#container_nro_muestra4').hide();
    $('#container_nro_muestra5').hide();
    $('#container_nro_muestra6').hide();
    $('#container_nro_muestra7').hide();
    $('#container_nro_muestra8').hide();
    $('#container_nro_muestra9').hide();
    $('#container_nro_muestra10').hide();

    for (let index = 1; index <= data; index++) {
        $(`#container_nro_muestra${index}`).show();
    }
}

function setId_hora_inicio(id_visita) {
    $('#Id_hora_inicio').val(id_visita);
}

function hora_inicio() {

    let id_visita = $('#Id_hora_inicio').val();

    $.post(`back-end/inicio/inicio.php`, { id_visita }, function (response) {
        console.log(response)
        let o = parseInt(response);

        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Visita Iniciada'
            });
            call_data();
            $('#hora_inicio').modal('hide');
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Iniciar Visita'
            });
        }
    });
}

async function consul_ficha_medica(cod_medico) {
    $.get(`back-end/visitas/visitas.php?cod_medico=${cod_medico}`, async function (response) {
        let o = JSON.parse(response);

        console.log(o.length);

        if (o.length != 0) {

            let templete = `
                <table class="table table-flush" style="font-size: 10px;" id="datatable_datos">
                    <thead class="thead-light">
                        <tr>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Marca </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Mercado </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> MAT-24 </th>
                        </tr>
                    </thead>
                <tbody>`;

            let body = ``;
            let template_end = `</tbody></table>`;

            o.forEach(element => {
                body += `
                    <tr>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${element.marca}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${element.Mercado}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${element.MAT_ACT}</td>
                    </tr>`;
            });

            await $('#tabla_ficha_medica').html(templete + body + template_end);
        } else {
            let templete = `<h3>No hay Datos</h3>`;
            await $('#tabla_ficha_medica').html(templete);
        }
    });
}

function colect_lista_productos() {
    let datos = ``;
    let lista = [];
    let tabla_productos_select = document.getElementById('tabla_productos_select');

    let filas = tabla_productos_select.getElementsByTagName('tr');

    for (let i = 0; i < filas.length; i++) {
        let celdas = filas[i].getElementsByTagName('td');

        for (let j = 0; j < celdas.length; j++) {
            let contenido = celdas[j].getElementsByTagName('input');


            if (contenido[0] != undefined) {
                if (contenido[0].checked == true) {
                    lista.push(contenido[0].value);
                    datos += contenido[0].value + ` ,`;
                }
            }
        }
    }

    $('#producto_visita').val(datos);
}

function colect_lista_productos1() {
    let datos = ``;
    let lista = [];
    let tabla_productos_select = document.getElementById('tabla_productos_select1');

    let filas = tabla_productos_select.getElementsByTagName('tr');

    for (let i = 0; i < filas.length; i++) {
        let celdas = filas[i].getElementsByTagName('td');

        for (let j = 0; j < celdas.length; j++) {
            let contenido = celdas[j].getElementsByTagName('input');


            if (contenido[0] != undefined) {
                if (contenido[0].checked == true) {
                    lista.push(contenido[0].value);
                    datos += contenido[0].value + ` ,`;
                }
            }
        }
    }

    $('#producto').val(datos);
}
async function consul_list_productos() {
    $.get(`back-end/visitas/visitas.php?list_articulos=all`, function (response) {

        let o = JSON.parse(response);


        let template = `<datalist id="listaArticulos">`;
        let template1 = `<datalist id="listaArticulos1">`;
        let temp = '';
        let temp1 = '';
        let body = ``;
        let body_table = ``;
        let template_end = `</datalist>`;

        o.forEach(data => {
            let t = data.tipo;
            if (t == 'OBSEQUIO') { temp += `<option>${data.nombre_articulo}</option>`; }
            if (t == 'MUESTRA') { temp1 += `<option>${data.nombre_articulo}</option>`; }
            body += `<option>${data.nombre_articulo}</option>`;
            body_table +=
                `<tr>
                    <td>
                        <input type="checkbox" value="${data.nombre_articulo}">
                    </td>
                    <td>${data.nombre_articulo}</td>
                </tr>`;
        });



        $('#datalist_producto').html(template + body + template_end);
        $('#datalist_producto1').html(template1 + body + template_end);
        $('#list_incentivo').html(temp);
        // $('#list_productos').html(body_table);
        // $('#list_productos1').html(body_table);
    });

    $.get(`back-end/visitas/visitas.php?list_marcas=all`, function (response) {

        let o = JSON.parse(response);
        let body_table = ``;

        o.forEach(data => {
            body_table +=
                `<tr>
                    <td>
                        <input type="checkbox" value="${data.nombre_marca}">
                    </td>
                    <td>${data.nombre_marca}</td>
                </tr>`;
        });

        $('#list_productos').html(body_table);
        $('#list_productos1').html(body_table);
    });

    await $.get(`back-end/visitas/visitas.php?list_articulos_inventario=all`, async function (response) {

        let o = JSON.parse(response);
        console.log(o);

        let muestra1 = document.getElementById('muestra1');
        let muestra2 = document.getElementById('muestra2');
        let muestra3 = document.getElementById('muestra3');

        let option = document.createElement('option');
        option.text = 'Seleccione';

        muestra1.appendChild(option);
        muestra2.appendChild(option);
        muestra3.appendChild(option);

        o.forEach(data => {
            let option1 = document.createElement('option');
            option1.value = data.nombre_articulo;
            option1.text = data.nombre_articulo;

            muestra1.appendChild(option1);

            let option2 = document.createElement('option');
            option2.value = data.nombre_articulo;
            option2.text = data.nombre_articulo;

            muestra2.appendChild(option2);

            let option3 = document.createElement('option');
            option3.value = data.nombre_articulo;
            option3.text = data.nombre_articulo;

            muestra3.appendChild(option3);
        });

    });
}

function arti_lista_data_check(data) {
    console.log(data.checked);
    let filas = tabla_productos_select.getElementsByTagName('tr');

    for (let i = 0; i < filas.length; i++) {
        let celdas = filas[i].getElementsByTagName('td');

        for (let j = 0; j < celdas.length; j++) {
            let contenido = celdas[j].getElementsByTagName('input');
            if(contenido[0] != undefined){
                console.log(contenido[0].checked);
                if(data.checked == true){
                    contenido[0].checked = true;
                }else{
                    contenido[0].checked = false;
                }
            }
        }
    }
}

function arti_lista_data_check1(data) {
    console.log(data.checked);
    let filas = tabla_productos_select1.getElementsByTagName('tr');

    for (let i = 0; i < filas.length; i++) {
        let celdas = filas[i].getElementsByTagName('td');

        for (let j = 0; j < celdas.length; j++) {
            let contenido = celdas[j].getElementsByTagName('input');
            if(contenido[0] != undefined){
                console.log(contenido[0].checked);
                if(data.checked == true){
                    contenido[0].checked = true;
                }else{
                    contenido[0].checked = false;
                }
            }
        }
    }
}
