const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function consul_ciclos() {
    let lineas = 'ALL';

    $.ajax({
        url: 'back-end/ciclos_visita/ciclos_visita.php',
        type: 'GET',
        data: { lineas },
        success: function (response) {
            let datas = JSON.parse(response);
            console.log(datas);
            let template = '';
            datas.forEach(data => {
                template += `
                    <tr>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.id}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.ciclo}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.dias_habiles}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.fecha_desde}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.fecha_hasta}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.status}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.btn_edi}</td>
                        
                    </tr>`

            });
            $('#list_ciclos').html(template);
        }
    });
}

function crearCiclo() {

    let ciclo = $('#ciclo_nuevo').val();
    let desde = $('#desde_nuevo').val();
    let hasta = $('#hasta_nuevo').val();

    let crear = "crear";
    let error = '';
    let template = '';

    if (ciclo === '') { error += '<strong>Ciclo</strong><br>'; }
    if (desde === '') { error += '<strong>Desde</strong><br>'; }
    if (hasta === '') { error += '<strong>Hasta</strong><br>'; }

    if (error != '') {
        template += `
        <div class="alert alert-warning" role="alert" id="alerta_lin">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#errores').html(template);

    } else {

        $.get(`back-end/ciclos_visita/ciclos_visita.php?ver_fechas=1&fecha_ini=${desde}&fecha_fin=${hasta}`, function (response) {

            let o = parseInt(response);
            console.log(o);

            if (o == 200) {

                $.post(`back-end/ciclos_visita/ciclos_visita.php`, { crear, ciclo, desde, hasta }, function (response) {

                    console.log(response);
                    let o = parseInt(response);

                    if (o == 200) {

                        consul_ciclos();
                        $('#nuevo_ciclo').modal("hide");

                        Swal.fire({
                            icon: 'success',
                            title: 'Crear Ciclo',
                            text: 'Creacion de ciclo exitosa.',
                        })

                    } else {
                        Swal.fire({
                            icon: 'error',
                            title: 'Oops...',
                            text: 'Error al crear el ciclo.',
                        })
                    }
                });

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: 'Las fechas seleccionadas se traslapan con un ciclo existente',
                });
            }
        });
    }

    $('#ciclo_nuevo').val('');
    $('#desde_nuevo').val('');
    $('#hasta_nuevo').val('');

}

function editarCiclo() {
    let id = $('#id_ciclo').val();
    let ciclo = $('#ciclo').val();
    let desde = $('#desde').val();
    let hasta = $('#hasta').val();

    $.get(`back-end/ciclos_visita/ciclos_visita.php?id_ver_fechas=${id}&fecha_ini=${desde}&fecha_fin=${hasta}`, function (response) {

        let o = parseInt(response);
        console.log(o);

        if (o == 200) {

            fetch(`back-end/ciclos_visita/ciclos_visita.php`, {
                method: 'PUT',
                body: JSON.stringify({
                    id: id,
                    ciclo: ciclo,
                    desde: desde,
                    hasta: hasta
                }),
                Headers: {
                    Accept: 'application/json',
                    'Content-Type': 'text/html'
                }
            })
                .then((response) => response.text())
                .then((responseData) => {
                    console.log(responseData);
                    let resp = parseInt(responseData);

                    if (resp == 200) {
                        consul_ciclos();
                        $('#edit_ciclo').modal("hide");
                        Toast.fire({
                            icon: 'success',
                            title: 'Ciclo Actualizado'
                        });
                    } else {
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al Actualizar el Ciclo'
                        });
                    }

                })
                .catch((error) => {
                    console.error('error', error)
                });

        } else {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Las fechas seleccionadas se traslapan con un ciclo existente',
            });
        }
    });
}

function setID(id) {
    $('#id_ciclo').val(id);

    $.get(`back-end/ciclos_visita/ciclos_visita.php?id_ciclo=${id}`, function (response) {

        let o = JSON.parse(response);

        console.log(o[0]);

        $('#ciclo').val(o[0].ciclo);
        $('#desde').val(o[0].fecha_desde);
        $('#hasta').val(o[0].fecha_hasta);
    });
}