const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
});

async function consul_inventario() {
    let inventario = 'ALL';

    await $.ajax({
        url: 'back-end/inventario/inventario.php',
        type: 'GET',
        data: { inventario },
        success: function (response) {

            let datas = JSON.parse(response);
            console.log(datas);
            let templete = `
                <table class="table table-flush" id="datatable_inventario">
                    <thead class="thead-light">
                    <tr>
                        <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Tipo Articulo</th>
                        <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Codigo Articulo</th>
                        <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Nombre Articulo</th>
                        <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Visitador</th>
                        <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Cantidad</th>
                        <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Accion</th>
                    </tr>
                    </thead>
                <tbody>`;

            let template_end = `</tbody></table>`;
            let body = '';

            datas.forEach(data => {
                body += `
                    <tr>
                        <td class="text-sm font-weight-normal">${data.tipo}</td>
                        <td class="text-sm font-weight-normal">${data.codigo_articulo}</td>
                        <td class="text-sm font-weight-normal">${data.nombre_articulo}</td>
                        <td class="text-sm font-weight-normal">${data.name_user}</td>
                        <td class="text-sm font-weight-normal">${data.cantidad}</td>
                        <td class="text-sm font-weight-normal">${data.btn_editar_inventario}</td>
                    </tr>`;
            });

            $('#list_inventario').html(templete + body + template_end);
        }
    });

    await new simpleDatatables.DataTable("#datatable_inventario", {
        searchable: true,
        fixedHeight: true
    });
}

async function registrar_inventario() {

    let archivo = document.getElementById("archivo").style.display;

    if (archivo == 'none') {

        let error = ``;

        let articulo_inventario = $('#articulo_inventario').val();
        let visitador = $('#visitador').val();
        let cantidad = $('#cantidad').val();

        if (articulo_inventario == '') { error += 'Articulo<br>'; }
        if (visitador == '') { error += 'Visitador<br>'; }
        if (cantidad == '' || cantidad < 0) { error += 'Cantidad<br>'; }

        let template = '';

        if (error != '') {
            template += `
            <div class="alert alert-warning" role="alert" id="alerta_tcli">
                <strong>Error!</strong> Faltan los siguientes datos<br>${error}
            </div>`;
            $('#span_error_modal').html(template);
            setTimeout(function () { $('#span_error_modal').html(''); }, 2000);
        } else {

            Swal.fire({
                title: 'Cargando...',
                html: 'Espere un momento por favor.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });        

            await $.post(`back-end/inventario/inventario.php`, { articulo_inventario, visitador, cantidad }, async function (response) {
                let o = parseInt(response);

                switch (o) {
                    case 200:
                        await Swal.close();
                        await consul_inventario();
                        await $('#nuevo_inventario').modal('hide');

                        Toast.fire({
                            icon: 'success',
                            title: 'Traslado Realizado'
                        });

                        break;

                    case 300:
                        await Swal.close();
                        Toast.fire({
                            icon: 'error',
                            title: 'El usuario seleccionado ya tiene ese articulo asignado'
                        });
                        break;

                    case 400:
                        await Swal.close();
                        Toast.fire({
                            icon: 'error',
                            title: 'Error al crear el articulo, por favor comunicar a soporte'
                        });
                        break;
                }
            });
        }
    } else if (archivo == 'block') {

        Swal.fire({
            title: 'Cargando...',
            html: 'Espere un momento por favor.',
            allowOutsideClick: false,
            didOpen: () => {
                Swal.showLoading();
            }
        });

        const fileInput = document.getElementById("fileUpload");
        const file = fileInput.files[0];

        if (file) {
            const reader = new FileReader();

            reader.onload = async function (e) {
                const data = new Uint8Array(e.target.result);
                const workbook = XLSX.read(data, { type: "array" });

                // Leer el contenido de la primera hoja
                const firstSheetName = workbook.SheetNames[0];
                const worksheet = workbook.Sheets[firstSheetName];
                const jsonData = XLSX.utils.sheet_to_json(worksheet);
                
                console.log(jsonData);


                // Mostrar los datos en la página
                await $.post(`back-end/inventario/inventario.php`, { jsonData }, async function (response) {
                    // console.log(response);
                    window.location.replace('main.php?inventario_no_proc');
                    await Swal.close();
                });
            };

            reader.readAsArrayBuffer(file);
        } else {
            alert("Selecciona un archivo de Excel primero.");
        }
    }
}

function set_edit_inventario(id_inventario) {

    $('#id_inventario').val(id_inventario);

    $.get(`back-end/inventario/inventario.php?id_inventario=${id_inventario}`, function (response) {
        let o = JSON.parse(response);

        $('#articulo').val(o[0].nombre_articulo);
        $('#usuario').val(o[0].name_user);
        $('#cantidad_actual').val(o[0].cantidad);
        $('#id_user').val(o[0].id_user);
        $('#id_articulo').val(o[0].id_articulo);

    });

    $('#editar_inventario').modal('show');
}

function list_visitadores() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: `back-end/inventario/inventario.php`,
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<datalist id="visitadores_lista">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {
                body += `
                <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#visitadores').html(template + body + template_end);
        }
    });
}

function list_articulos() {

    let list_articulos = 'ALL';

    $.ajax({
        url: `back-end/inventario/inventario.php`,
        type: 'GET',
        data: { list_articulos },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<datalist id="articulos_lista">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {
                body += `
                <option value="${data.id_articulo}">${data.codigo_articulo + " - " + data.nombre_articulo}</option>
                `;
            });

            $('#articulos').html(template + body + template_end);
        }
    });
}

function aplicar_accion() {

    let tipo_movimiento = $('#tipo_movimiento').val();
    let id_inventario = $('#id_inventario').val();

    let articulo = $('#articulo').val();
    let usuario = $('#usuario').val();
    let cantidad_actual = $('#cantidad_actual').val();
    let cantidad_ajustar = $('#cantidad_ajustar').val();
    let id_visitador = $('#id_visitador').val();
    let id_user = $('#id_user').val();
    let id_articulo = $('#id_articulo').val();

    if (cantidad_ajustar == '') {
        Toast.fire({
            icon: 'error',
            title: 'Por favor Diligenciar La Cantidad a Ajustar'
        });
    } else {
        switch (tipo_movimiento) {
            case 'T':

                $.post(`back-end/inventario/inventario.php`, { id_inventario, id_articulo, id_user, tipo_movimiento, articulo, usuario, cantidad_actual, cantidad_ajustar, id_visitador }, function (response) {

                    let o = parseInt(response);

                    switch (o) {
                        case 200:
                            Toast.fire({
                                icon: 'success',
                                title: 'Traslado Realizado'
                            });
                            consul_inventario();
                            break;

                        case 300:
                            Toast.fire({
                                icon: 'error',
                                title: 'Las Cantidades Ajustadas Son Mayores a las Actuales'
                            });
                            break;

                        case 400:
                            Toast.fire({
                                icon: 'error',
                                title: 'Error al Realizar Traslado'
                            });
                            break;
                    }
                });

                break;

            case 'S':

                $.post(`back-end/inventario/inventario.php`, { id_inventario, id_articulo, id_user, tipo_movimiento, articulo, usuario, cantidad_actual, cantidad_ajustar, id_visitador }, function (response) {

                    let o = parseInt(response);

                    switch (o) {
                        case 200:
                            Toast.fire({
                                icon: 'success',
                                title: 'Traslado Realizado'
                            });
                            consul_inventario();
                            break;

                        case 400:
                            Toast.fire({
                                icon: 'error',
                                title: 'Error al Realizar Traslado'
                            });
                            break;
                    }
                });
                break;

            case 'E':
                $.post(`back-end/inventario/inventario.php`, { id_inventario, id_articulo, id_user, tipo_movimiento, articulo, usuario, cantidad_actual, cantidad_ajustar, id_visitador }, function (response) {

                    let o = parseInt(response);

                    switch (o) {
                        case 200:
                            Toast.fire({
                                icon: 'success',
                                title: 'Traslado Realizado'
                            });
                            consul_inventario();
                            break;

                        case 400:
                            Toast.fire({
                                icon: 'error',
                                title: 'Error al Realizar Traslado'
                            });
                            break;
                    }
                });
                break;
        }
    }

    $('#tipo_movimiento').val('');
    $('#id_inventario').val('');

    $('#articulo').val('');
    $('#usuario').val('');
    $('#cantidad_actual').val('');
    $('#cantidad_ajustar').val('');
    $('#id_visitador').val('');
    $('#id_user').val('');
    $('#id_articulo').val('');

    $('#editar_inventario').modal('hide');
}

function tipo_movimiento(data) {
    $('#visitador_transfer').hide();

    if (data == 'T') {
        $('#visitador_transfer').show();
    }
}