async function consul_inventario_mov() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    let lista_articulos = $('#lista_articulos').val();
    let lista_usuarios = $('#lista_usuarios').val();

    await $.get(`back-end/inventario_mov/inventario_mov.php?inventario_mov=${'all'}&articulo=${lista_articulos}&usuario=${lista_usuarios}`, function (response) {
        
        let o = JSON.parse(response);
        console.log(o);

        let templete = `
        <table class="table table-flush" id="datatable_inventario_mov">
            <thead class="thead-light">
            <tr>
                <th style="font-size: 10px;" class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Id Inventario </th>
                <th style="font-size: 10px;" class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Tipo Movimiento </th>
                <th style="font-size: 10px;" class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Articulo </th>
                <th style="font-size: 10px;" class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Cantidad </th>
                <th style="font-size: 10px;" class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Usuario Receptor </th>
                <th style="font-size: 10px;" class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Usuario Movimiento </th>
                <th style="font-size: 10px;" class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Fecha Movimiento </th>
            </tr>
            </thead>
            <tbody id="list_visitas">`;
        let templete_end = `</tbody></table>`;
        let body = ``;

        o.forEach(element => {
            body += `
                <tr>
                    <td class="text-center font-weight-normal">${element.id_inventario}</td>
                    <td class="text-center font-weight-normal">${element.tipo_transferencia}</td>
                    <td class="text-center font-weight-normal">${element.nombre_articulo}</td>
                    <td class="text-center font-weight-normal">${element.cantidad}</td>
                    <td class="text-center font-weight-normal">${element.usuario_receptor}</td>
                    <td class="text-center font-weight-normal">${element.name_user}</td>
                    <td class="text-center font-weight-normal">${element.fecha_movimiento}</td>
                <tr>`;
        });

        $('#list_inventario_mov').html(templete + body + templete_end);
    });
    console.log()
    const dataTableSearch = new simpleDatatables.DataTable("#datatable_inventario_mov", {
        searchable: true,
        fixedHeight: true
    });
    await Swal.close();
}



async function lista_articulos() {

    $.get(`back-end/inventario_mov/inventario_mov.php?lista_articulos=all`, function (response) {
        let o = JSON.parse(response);

        let lista_articulos = document.getElementById('lista_articulos');

        let opt_select = document.createElement('option');
        opt_select.value = '';
        opt_select.text = 'Seleccione';

        let opt_todos = document.createElement('option');
        opt_todos.value = 'Todos';
        opt_todos.text = 'Todos';

        lista_articulos.appendChild(opt_select);
        lista_articulos.appendChild(opt_todos);

        o.forEach(element => {
            let opt = document.createElement('option');
            opt.value = element.id_articulo;
            opt.text = element.nombre_articulo;

            lista_articulos.appendChild(opt);

        });

        $('#lista_articulos').select2();
    });
}

async function lista_usuarios() {

    $.get(`back-end/inventario_mov/inventario_mov.php?lista_usuarios=all`, function (response) {
        let o = JSON.parse(response);

        let lista_usuarios = document.getElementById('lista_usuarios');

        let opt_select = document.createElement('option');
        opt_select.value = '';
        opt_select.text = 'Seleccione';

        let opt_todos = document.createElement('option');
        opt_todos.value = 'Todos';
        opt_todos.text = 'Todos';

        lista_usuarios.appendChild(opt_select);
        lista_usuarios.appendChild(opt_todos);

        o.forEach(element => {
            let opt = document.createElement('option');
            opt.value = element.id_user;
            opt.text = element.name_user;

            lista_usuarios.appendChild(opt);

        });

        $('#lista_usuarios').select2();
    });

}

async function descargar_inventario_movil() {

    let lista_usuarios = $('#lista_usuarios').val();
    let lista_articulos= $('#lista_articulos').val();
    window.open(`views/inventario_movi/descar_inventario_mov.php?lista_usuarios=${lista_usuarios}&lista_articulos=${lista_articulos}`);
}
