
const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

async function consul_visitas() {
    let lineas = 'ALL';
    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();

    await $.ajax({
        url: 'back-end/list_visita/list_visita.php',
        type: 'GET',
        data: { lineas, fecha_ini, fecha_fin },
        success: async function (response) {

            let datas = JSON.parse(response);

            let template = `<table class="table table-flush" style="font-size: 10px;" id="datatable_lineas">
            <thead class="thead-light">
              <tr>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Cliente </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Direccion </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Telefono </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Detalles </th>
              </tr>
            </thead>
            <tbody>`;
            let body = ``;
            let templete_end = `</tbody></table>`;

            await datas.forEach(data => {
                body += `
                    <tr>
                        <td style="font-size: 15px;" class="text-center font-weight-normal">${data.cliente}</td>
                        <td style="font-size: 15px;" class="text-center font-weight-normal">${data.direccion}</td>
                        <td style="font-size: 15px;" class="text-center font-weight-normal">${data.telefono}</td>
                        <td style="font-size: 15px;" class="text-center font-weight-normal">
                            ${data.btn_detalles}
                            ${data.btn_editar}
                        </td>
                    </tr>`

            });
            await $('#list_visitas').html(template + body + templete_end);

            Toast.fire({
                icon: 'success',
                title: 'Filtro Realizado'
            });
        }
    });
    await new simpleDatatables.DataTable("#datatable_lineas", {
        searchable: true
    });
}

async function descargar_tabla() {

    let visitador_filtro = $('#visitador_filtro').val();
    let selector_filtro = $('#selector_filtro').val();

    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();

    if (selector_filtro == 1) {
        await $.get(`back-end/list_visita/list_visita.php?fechas_filtro_descargar=${'all'}&fecha_inicial1=${fecha_ini}&fecha_fin=${fecha_fin}`, function (reponse) {


            const datos = JSON.parse(reponse);

            const arreglo = [
                [
                    'ID Visita',
                    'Codigo Cliente',
                    'Telefono Cliente',
                    'Nombre Cliente',
                    'Direccion Cliente',
                    'Producto Visita',
                    'Usuario',
                    'Tipo Cliente',
                    'Tipo Visita',
                    'Estado',
                    'Formula',
                    'Producto Formula',
                    'Obsequio',
                    'Desarrollo Obsequio',
                    'Observaciones',
                    'Observaciones Cierre',
                    'Fecha Visita',
                    'Tiempo de Actividad',
                    'Hora Inicio',
                    'Hora Fin'
                ]
            ];

            datos.forEach(data => {
                arreglo.push(
                    [
                        data.id_visita,
                        data.codigo_cliente,
                        data.telefono_cliente,
                        data.nombre_cliente,
                        data.direccion_cliente,
                        data.producto_visita,
                        data.username,
                        data.tipo_c,
                        data.tipo_visita,
                        data.estado_visita,
                        data.formula,
                        data.producto_formula,
                        data.incentivo,
                        data.detalle_incentivo,
                        data.observaciones,
                        data.observaciones_cierre,
                        data.fecha_visita,
                        data.timeDifer,
                        data.hora_inicio,
                        data.hora_fin
                    ]
                );
            });

            const sheetData = arreglo;

            const workbook = XLSX.utils.book_new();

            const worksheet = XLSX.utils.aoa_to_sheet(sheetData);

            const range = XLSX.utils.decode_range(worksheet['!ref']);
            for (let R = range.s.r; R <= range.e.r; ++R) {
                for (let C = range.s.c; C <= range.e.c; ++C) {
                    const cell = worksheet[XLSX.utils.encode_cell({ r: R, c: C })];
                    if (!cell) continue;
                    cell.s = { border: { top: { style: 'thin' }, bottom: { style: 'thin' } } };
                }
            }

            // Agregar la hoja de trabajo al libro
            XLSX.utils.book_append_sheet(workbook, worksheet, 'MiHojaDeCalculo');

            // Crear un archivo binario a partir del libro de trabajo
            const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });

            /* create an XLSX file and try to save to Presidents.xlsx */
            XLSX.writeFileSync(workbook, "Informe de Visitas.xlsx", { compression: true });
        });

    } else {

        await $.get(`back-end/list_visita/list_visita.php?visitador_filtro_descargar=${visitador_filtro}`, function (reponse) {

            const datos = JSON.parse(reponse);

            const arreglo = [
                [
                    'ID Visita',
                    'Codigo Cliente',
                    'Telefono Cliente',
                    'Nombre Cliente',
                    'Direccion Cliente',
                    'Producto Visita',
                    'Usuario',
                    'Tipo Cliente',
                    'Tipo Visita',
                    'Estado',
                    'Formula',
                    'Producto Formula',
                    'Obsequio',
                    'Desarrollo Obsequio',
                    'Observaciones',
                    'Fecha Visita',
                    'Tiempo de Actividad',
                    'Hora Inicio',
                    'Hora Fin'
                ]
            ];

            datos.forEach(data => {
                arreglo.push(
                    [
                        data.id_visita,
                        data.codigo_cliente,
                        data.telefono_cliente,
                        data.nombre_cliente,
                        data.direccion_cliente,
                        data.producto_visita,
                        data.username,
                        data.tipo_c,
                        data.tipo_visita,
                        data.estado_visita,
                        data.formula,
                        data.producto_formula,
                        data.incentivo,
                        data.detalle_incentivo,
                        data.observaciones,
                        data.fecha_visita,
                        data.timeDifer,
                        data.hora_inicio,
                        data.hora_fin
                    ]
                );
            });

            const sheetData = arreglo;

            const workbook = XLSX.utils.book_new();

            const worksheet = XLSX.utils.aoa_to_sheet(sheetData);

            const range = XLSX.utils.decode_range(worksheet['!ref']);
            for (let R = range.s.r; R <= range.e.r; ++R) {
                for (let C = range.s.c; C <= range.e.c; ++C) {
                    const cell = worksheet[XLSX.utils.encode_cell({ r: R, c: C })];
                    if (!cell) continue;
                    cell.s = { border: { top: { style: 'thin' }, bottom: { style: 'thin' } } };
                }
            }

            // Agregar la hoja de trabajo al libro
            XLSX.utils.book_append_sheet(workbook, worksheet, 'MiHojaDeCalculo');

            // Crear un archivo binario a partir del libro de trabajo
            const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });

            /* create an XLSX file and try to save to Presidents.xlsx */
            XLSX.writeFileSync(workbook, "Informe de Visitas.xlsx", { compression: true });
        });
    }

}

async function consul_por_visitador(visitador) {
    let visitador_filtro = 'ALL';

    await $.ajax({
        url: 'back-end/list_visita/list_visita.php',
        type: 'GET',
        data: { visitador_filtro, visitador },
        success: async function (response) {

            let datas = JSON.parse(response);

            let template = `<table class="table table-flush" id="datatable_lineas">
            <thead class="thead-light">
              <tr>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Cliente </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Direccion </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Telefono </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Detalles </th>
              </tr>
            </thead>
            <tbody>`;
            let body = ``;
            let templete_end = `</tbody></table>`;

            datas.forEach(data => {
                template += `
                    <tr>
                        <td class="text-center font-weight-normal">${data.cliente}</td>
                        <td class="text-center font-weight-normal">${data.direccion}</td>
                        <td class="text-center font-weight-normal">${data.telefono}</td>
                        <td class="text-center font-weight-normal">
                            ${data.btn_detalles}
                            ${data.btn_editar}
                        </td>
                    </tr>`

            });
            await $('#list_visitas').html(template + body + templete_end);

            Toast.fire({
                icon: 'success',
                title: 'Filtro Realizado'
            });
        }
    });
    await new simpleDatatables.DataTable("#datatable_lineas", {
        searchable: true
    });
}

function list_visitadores() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: `back-end/list_visita/list_visita.php`,
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);



            let template = `<datalist id="visitadores_lista">`;
            let body = ``;
            let template_end = `</datalist>`;

            body += `<option value="Todos">Todos</option>`;

            datas.forEach(data => {
                body += `
                <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#visitadores').html(template + body + template_end);
        }
    });
}

function update_date() {
    $('#fecha_ini_filtro').val($('#fecha_ini').val());
    $('#fecha_fin_filtro').val($('#fecha_fin').val());
}

function tipo_filtro(select) {
    if (select == 1) {
        $('#fechas_campo').show();
        $('#visitador_campo').hide();
    } else {
        $('#fechas_campo').hide();
        $('#visitador_campo').show();
    }
}

async function aplicar_filtro() {
    let visitador_filtro = $('#visitador_filtro').val();
    let selector_filtro = $('#selector_filtro').val();
    $('#descargar_tabla_btn').show();

    if (selector_filtro == 1) {
        await $('#fecha_ini').val($('#fecha_ini_filtro').val());
        await $('#fecha_fin').val($('#fecha_fin_filtro').val());
        consul_visitas();
    } else {
        consul_por_visitador(visitador_filtro);
    }
}

function modificar(id_visita) {

    $.get(`back-end/list_visita/list_visita.php?id_visita=${id_visita}`, function (response) {

        let o = JSON.parse(response);


        $('#id_visita').val(o[0].id_visita);
        $('#cliente').val(o[0].nombre_cliente);
        $('#producto_visita').val(o[0].producto_visita);
        $('#formula').val(o[0].formula);
        $('#producto').val(o[0].producto_formula);
        $('#incentivo').val(o[0].incentivo);
        $('#m_medica').val(o[0].m_medica);

        $('#nro_muestra').val(o[0].nro_muestra);
        $('#nro_incentivo').val(o[0].detalle_incentivo);

        $('#incentivo1').val(o[0].incentivo1);
        $('#cantidad_in1').val(o[0].cantidad_in1);
        $('#incentivo2').val(o[0].incentivo2);
        $('#cantidad_in2').val(o[0].cantidad_in2);
        $('#incentivo3').val(o[0].incentivo3);
        $('#cantidad_in3').val(o[0].cantidad_in3);
        $('#muestra1').val(o[0].muestra1);
        $('#cantidad_m1').val(o[0].cantidad_m1);
        $('#muestra2').val(o[0].muestra2);
        $('#cantidad_m2').val(o[0].cantidad_m2);
        $('#muestra3').val(o[0].muestra3);
        $('#cantidad_m3').val(o[0].cantidad_m3);

        $('#tipo_visita').val(o[0].tipo_visita);
        $('#observaciones').val(o[0].observaciones);
        $('#compromisos').val(o[0].compromiso);
        $('#fecha_compromiso').val(o[0].fecha_compromiso);
        $('#nueva_visita').val();
        $('#fecha').val();
    });

    $.get(`back-end/list_visita/list_visita.php?list_articulos=all`, function (response) {

        let o = JSON.parse(response);


        let template = `<datalist id="listaArticulos">`;
        let template1 = `<datalist id="listaArticulos1">`;
        let body = ``;
        let template_end = `</datalist>`;

        o.forEach(data => {
            body += `<option>${data.nombre_articulo}</option>`;
        });

        $('#datalist_producto').html(template + body + template_end);
        $('#datalist_producto1').html(template1 + body + template_end);
    });
}

function formula_active(data) {

    let producto = document.getElementById('edit_producto');
    let btn_lista2 = document.getElementById('edit_btn_lista2');
    if (data == 'SI') {
        producto.disabled = false;
        btn_lista2.disabled = false;
    } else {
        producto.disabled = true;
        btn_lista2.disabled = true;
    }
}

function incentivo_active(data) {

    let n_obsequio = document.getElementById('edit_nro_incentivo');
    if (data == 'SI') {
        n_obsequio.disabled = false;
    } else {
        n_obsequio.disabled = true;
    }
}

function m_medica_active(data) {

    let nro_muestra = document.getElementById('edit_nro_muestra');
    if (data == 'SI') {
        nro_muestra.disabled = false;
    } else {
        nro_muestra.disabled = true;
    }
}

function colect_lista_productos() {
    let datos = ``;
    let lista = [];
    let tabla_productos_select = document.getElementById('tabla_productos_select');

    let filas = tabla_productos_select.getElementsByTagName('tr');

    for (let i = 0; i < filas.length; i++) {
        let celdas = filas[i].getElementsByTagName('td');

        for (let j = 0; j < celdas.length; j++) {
            let contenido = celdas[j].getElementsByTagName('input');


            if (contenido[0] != undefined) {
                if (contenido[0].checked == true) {
                    lista.push(contenido[0].value);
                    datos += contenido[0].value + ` ,`;
                }
            }
        }
    }

    $('#edit_producto_visita').val(datos);
}

function colect_lista_productos1() {
    let datos = ``;
    let lista = [];
    let tabla_productos_select = document.getElementById('tabla_productos_select1');

    let filas = tabla_productos_select.getElementsByTagName('tr');

    for (let i = 0; i < filas.length; i++) {
        let celdas = filas[i].getElementsByTagName('td');

        for (let j = 0; j < celdas.length; j++) {
            let contenido = celdas[j].getElementsByTagName('input');


            if (contenido[0] != undefined) {
                if (contenido[0].checked == true) {
                    lista.push(contenido[0].value);
                    datos += contenido[0].value + ` ,`;
                }
            }
        }
    }

    $('#edit_sproducto').val(datos);
}

async function modificar_edit(id_visita) {

    let nueva_visita = $('#edit_nueva_visita').val();
    if (nueva_visita == 'NO') { $('#edit_fecha_visita_nueva_container').hide(); }

    let formula = $('#edit_formula').val();
    if (formula == 'NO') {

        let producto = document.getElementById('edit_producto');
        producto.disabled = true;

        let btn_lista2 = document.getElementById('edit_btn_lista2');
        btn_lista2.disabled = true;
    }

    let incentivo = $('#edit_incentivo').val();
    if (incentivo == 'NO') {
        let n_obsequio = document.getElementById('edit_nro_incentivo');
        n_obsequio.disabled = true;
    }

    let m_medica = $('#edit_m_medica').val();
    if (m_medica == 'NO') {
        let nro_muestra = document.getElementById('edit_nro_muestra');
        nro_muestra.disabled = true;
    }

    $('#modal_modificar').modal('show');

    await $.get(`app/back-end/visitas/visitas.php?id_visita=${id_visita}`, async function (response) {

        let o = JSON.parse(response);

        $('#edit_id_visita').val(o[0].id_visita);
        $('#edit_cliente').val(o[0].nombre_cliente);
        $('#edit_producto_visita').val(o[0].producto_visita);

        $('#edit_producto').val(o[0].producto_formula);

        if (o[0].detalle_incentivo == '0' || o[0].detalle_incentivo == '') {
            let nro_incidencias = 0;
        }

        if (o[0].nro_muestra == '' || o[0].nro_muestra == '0') {
            let nro_muestra = 0;
        }

        $('#edit_nro_muestra').val(nro_muestra);

        $('#edit_incentivo1').val(o[0].incentivo1);
        $('#edit_cantidad_in1').val(o[0].cantidad_in1);
        $('#edit_incentivo2').val(o[0].incentivo2);
        $('#edit_cantidad_in2').val(o[0].cantidad_in2);
        $('#edit_incentivo3').val(o[0].incentivo3);
        $('#edit_cantidad_in3').val(o[0].cantidad_in3);
        $('#edit_muestra1').val(o[0].muestra1);
        $('#edit_cantidad_m1').val(o[0].cantidad_m1);
        $('#edit_muestra2').val(o[0].muestra2);
        $('#edit_cantidad_m2').val(o[0].cantidad_m2);
        $('#edit_muestra3').val(o[0].muestra3);
        $('#edit_cantidad_m3').val(o[0].cantidad_m3);

        $('#edit_tipo_visita').val(o[0].tipo_visita);
        $('#edit_observaciones').val(o[0].observaciones);
        $('#edit_compromisos').val(o[0].compromiso);
        $('#edit_fecha_compromiso').val(o[0].fecha_compromiso);
        $('#edit_nueva_visita').val();
        $('#edit_fecha').val();
    });

    await $.get(`app/back-end/visitas/visitas.php?list_articulos=all`, async function (response) {

        let o = JSON.parse(response);

        let template = `<datalist id="listaArticulos">`;
        let template1 = `<datalist id="listaArticulos1">`;
        let temp = '';
        let body = ``;
        let template_end = `</datalist>`;

        o.forEach(data => {
            let t = data.tipo;
            if (t == 'OBSEQUIO') { temp += `<option>${data.nombre_articulo}</option>`; }
            body += `<option>${data.nombre_articulo}</option>`;
        });

        $('#edit_datalist_producto').html(template + body + template_end);
        $('#edit_datalist_producto1').html(template1 + body + template_end);
        $('#edit_list_incentivo').html(temp);
    });

    await $.get(`app/back-end/visitas/visitas.php?list_articulos_inventario=all`, async function (response) {

        let o = JSON.parse(response);
        console.log(o)

        let muestra1 = document.getElementById('edit_muestra1');
        let muestra2 = document.getElementById('edit_muestra2');
        let muestra3 = document.getElementById('edit_muestra3');

        let option = document.createElement('option');
        option.text = 'Seleccione';

        muestra1.appendChild(option);
        muestra2.appendChild(option);
        muestra3.appendChild(option);

        o.forEach(data => {
            let option1 = document.createElement('option');
            option1.value = data.nombre_articulo;
            option1.text = data.nombre_articulo;

            muestra1.appendChild(option1);

            let option2 = document.createElement('option');
            option2.value = data.nombre_articulo;
            option2.text = data.nombre_articulo;

            muestra2.appendChild(option2);

            let option3 = document.createElement('option');
            option3.value = data.nombre_articulo;
            option3.text = data.nombre_articulo;

            muestra3.appendChild(option3);
        });

        console.log(muestra1)
        console.log(muestra2)
        console.log(muestra3)
    });
}

async function consul_list_productos() {
    $.get(`app/back-end/visitas/visitas.php?list_articulos=all`, function (response) {

        let o = JSON.parse(response);

        let template = `<datalist id="listaArticulos">`;
        let template1 = `<datalist id="listaArticulos1">`;
        let temp = '';
        let temp1 = '';
        let body = ``;

        let template_end = `</datalist>`;

        o.forEach(data => {
            let t = data.tipo;
            if (t == 'OBSEQUIO') { temp += `<option>${data.nombre_articulo}</option>`; }
            if (t == 'MUESTRA') { temp1 += `<option>${data.nombre_articulo}</option>`; }
            body += `<option>${data.nombre_articulo}</option>`;

        });

        $('#datalist_producto').html(template + body + template_end);
        $('#datalist_producto1').html(template1 + body + template_end);
        $('#list_incentivo').html(temp);

    });

    await $.get(`app/back-end/visitas/visitas.php?list_marcas=all`, function (response) {

        let o = JSON.parse(response);

        let body_table = ``;

        o.forEach(element => {
            body_table +=
                `<tr>
                    <td>
                        <input type="checkbox" value="${element.nombre_marca}">
                    </td>
                    <td>${element.nombre_marca}</td>
                </tr>`;
        });

        $('#list_productos').html(body_table);
        $('#list_productos1').html(body_table);
    });

    await $.get(`app/back-end/visitas/visitas.php?list_articulos_inventario=all`, async function (response) {

        let o = JSON.parse(response);
        console.log(o);

        let muestra1 = document.getElementById('muestra1');
        let muestra2 = document.getElementById('muestra2');
        let muestra3 = document.getElementById('muestra3');

        let option = document.createElement('option');
        option.text = 'Seleccione';

        muestra1.appendChild(option);
        muestra2.appendChild(option);
        muestra3.appendChild(option);

        o.forEach(data => {
            let option1 = document.createElement('option');
            option1.value = data.nombre_articulo;
            option1.text = data.nombre_articulo;

            muestra1.appendChild(option1);

            let option2 = document.createElement('option');
            option2.value = data.nombre_articulo;
            option2.text = data.nombre_articulo;

            muestra2.appendChild(option2);

            let option3 = document.createElement('option');
            option3.value = data.nombre_articulo;
            option3.text = data.nombre_articulo;

            muestra3.appendChild(option3);
        });

    });
}

function modificar_visita() {
    let id_visita = $('#edit_id_visita').val();
    let nombre_cliente = $('#edit_cliente').val();
    let producto_visita = $('#edit_producto_visita').val();
    let formula = $('#edit_formula').val();
    let producto_formula = $('#edit_producto').val();
    let incentivo = $('#edit_incentivo').val();
    let detalle_incentivo = $('#edit_nro_incentivo').val();
    let m_medica = $('#edit_m_medica').val();
    let nro_muestra = $('#edit_nro_muestra').val();

    let incentivo1 = $('#edit_incentivo1').val();
    let cantidad_in1 = $('#edit_cantidad_in1').val();
    let incentivo2 = $('#edit_incentivo2').val();
    let cantidad_in2 = $('#edit_cantidad_in2').val();
    let incentivo3 = $('#edit_incentivo3').val();
    let cantidad_in3 = $('#edit_cantidad_in3').val();
    let muestra1 = $('#edit_muestra1').val();
    let cantidad_m1 = $('#edit_cantidad_m1').val();
    let muestra2 = $('#edit_muestra2').val();
    let cantidad_m2 = $('#edit_cantidad_m2').val();
    let muestra3 = $('#edit_muestra3').val();
    let cantidad_m3 = $('#edit_cantidad_m3').val();

    let tipo_visita = $('#edit_tipo_visita').val();
    let observaciones = $('#edit_observaciones').val();
    let compromiso = $('#edit_compromisos').val();
    let fecha_compromiso = $('#edit_fecha_compromiso').val();
    let nueva_visita = $('#edit_nueva_visita').val();
    let fecha = $('#edit_fecha').val();

    const POSTDATA = {
        id_visita: id_visita,
        nombre_cliente: nombre_cliente,
        producto_visita: producto_visita,
        formula: formula,
        producto_formula: producto_formula,
        incentivo: incentivo,
        detalle_incentivo: detalle_incentivo,
        m_medica: m_medica,
        nro_muestra: nro_muestra,
        incentivo1: incentivo1,
        cantidad_in1: cantidad_in1,
        incentivo2: incentivo2,
        cantidad_in2: cantidad_in2,
        incentivo3: incentivo3,
        cantidad_in3: cantidad_in3,
        muestra1: muestra1,
        cantidad_m1: cantidad_m1,
        muestra2: muestra2,
        cantidad_m2: cantidad_m2,
        muestra3: muestra3,
        cantidad_m3: cantidad_m3,
        tipo_visita: tipo_visita,
        observaciones: observaciones,
        compromiso: compromiso,
        fecha_compromiso: fecha_compromiso,
        nueva_visita: nueva_visita,
        fecha: fecha
    }

    $.post(`back-end/list_visita/list_visita.php`, POSTDATA, function (response) {
        let o = parseInt(response);
        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Visita Actualizada'
            });
            aplicar_filtro();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Actualizar Visita'
            });
        }
    });
}

function fecha_nueva_visita(dato) {
    if (dato == 'SI') {
        $('#edit_fecha_visita_nueva_container').show();
    } else {
        $('#edit_fecha_visita_nueva_container').hide();
    }
}

function load_incentivos_input(data) {

    $('#edit_container_nro_incentivo1').hide();
    $('#edit_container_nro_incentivo2').hide();
    $('#edit_container_nro_incentivo3').hide();

    for (let index = 1; index <= data; index++) {
        $(`#edit_container_nro_incentivo${index}`).show();
    }
}

function load_muestra_input(data) {

    $('#edit_container_nro_muestra1').hide();
    $('#edit_container_nro_muestra2').hide();
    $('#edit_container_nro_muestra3').hide();

    for (let index = 1; index <= data; index++) {
        $(`#edit_container_nro_muestra${index}`).show();
    }
}

async function descargar_inventario_visita() {

    let visitador_filtro = $('#visitador_filtro').val();
    let selector_filtro = $('#selector_filtro').val();

    console.log(selector_filtro)

    let fecha_ini = $('#fecha_ini').val();
    let fecha_fin = $('#fecha_fin').val();

    if (selector_filtro == 1) {
        window.open(`views/list_visita/descar_inventario_visita.php?fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}`);
    } else if(selector_filtro == 2){
        window.open(`views/list_visita/descar_inventario_visita.php?visitador_filtro=${visitador_filtro}`);
    } else if(selector_filtro == ''){
        window.open(`views/list_visita/descar_inventario_visita.php?fecha_ini=${fecha_ini}&fecha_fin=${fecha_fin}`);
    }
}