const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

async function consul_usuarios() {
    let list_usuarios = 'ALL';

    await $.ajax({
        url: 'back-end/usuarios/usuarios.php',
        type: 'GET',
        data: { list_usuarios },
        success: function (response) {
            let datas = JSON.parse(response);

            let template = `
            <table class="table table-flush" style="font-size: 10px;" id="datatable_usuarios">
                <thead class="thead-light">
                    <tr>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Id </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Usuario </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Nombre </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Ciudad </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Telefono </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Nivel Permisos </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Supervisor </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Estado </th>
                        <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Acciones</th>
                    </tr>
                </thead>
                <tbody>`;
            let template_end = `</tbody></table>`;
            let body = ``;

            datas.forEach(data => {
                body += `
                    <tr>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.id_user}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.username}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.name_user}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.ciudad}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.telefono}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.permisos_acceso}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.cliente}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.status}</td>
                        <td style="font-size: 10px;" class="text-center font-weight-normal">${data.btn_edit}${data.btn_clave}</td>
                    </tr>`
            });
            $('#list_usuarios').html(template+body+template_end);
        }
    });

    const dataTableSearch = new simpleDatatables.DataTable("#datatable_usuarios", {
        searchable: true,
        fixedHeight: true
    });
}

function crearUsuario() {

    let usuario = $('#usuario').val();
    let clave = $('#clave').val();
    let nombre = $('#nombre').val();
    let ciudad = $('#ciudad').val();
    let telefono = $('#telefono').val();
    let permisos = $('#permisos').val();
    let supervisor = $('#supervisor').val();
    let estado = $('#estado').val();
    let lineas = $('#linea_select').val();

    console.log(lineas);

    let crear = "crear";
    let error = '';
    let template = '';

    if (usuario === '') { error += '<strong>Usuario</strong><br>'; }
    if (nombre === '') { error += '<strong>Nombre</strong><br>'; }
    if (clave === '') { error += '<strong>Clave</strong><br>'; }
    if (ciudad === '') { error += '<strong>Ciudad</strong><br>'; }
    if (telefono === '') { error += '<strong>Telefono</strong><br>'; }
    if (permisos === '') { error += '<strong>Permisos</strong><br>'; }
    if (supervisor === '') { error += '<strong>Supervisor</strong><br>'; }
    if (estado === '') { error += '<strong>Estado</strong><br>'; }
    if (lineas.length == []) { error += '<strong>Lineas</strong><br>'; }

    if (error != '') {
        template += `
        <div class="alert alert-warning" role="alert" id="alerta_lin">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#errores').html(template);

    } else {
        $.post(`back-end/usuarios/usuarios.php`, { crear, usuario, clave, nombre, ciudad, telefono, permisos, supervisor, estado, lineas }, async function (response) {
            console.log(response)
            let o = parseInt(response);

            if (o == 200) {

                $('#nuevo_usuario').modal("hide");

                await Swal.fire({
                    icon: 'success',
                    title: 'Crear Usuario',
                    text: 'Creacion de usuario exitosa.',
                })
                window.location.reload()

                $('#usuario').val('');
                $('#clave').val('');
                $('#nombre').val('');
                $('#ciudad').val('');
                $('#telefono').val('');
                $('#permisos').val('');
                $('#supervisor').val('');
                $('#estado').val('');

            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Oops...',
                    text: 'Error al crear el usuario.',
                })
            }
        });
    }
}

async function setID(id_usuario) {
    
    var selectElement = document.getElementById('linea_select_edit');

    while (selectElement.options.length > 0) {
        selectElement.remove(0);
    }

    $('#id_usuario_editar').val(id_usuario);
    await lista_lineas_edit();

    await $.ajax({
        url: 'back-end/usuarios/usuarios.php',
        type: 'GET',
        data: { id_usuario },
        success: async function (response) {
            
            let datas = JSON.parse(response);
            datas.forEach(async data => {
                console.log(JSON.parse(data.tipo_user));
                await $('#usuario_editar').val(data.username);
                await $('#nombre_editar').val(data.name_user);
                await $('#ciudad_editar').val(data.ciudad);
                await $('#telefono_editar').val(data.telefono);
                await $('#permisos_editar').val(data.permisos_acceso);
                await $('#supervisor_editar').val(data.cliente);
                await $('#estado_editar').val(data.status);
                await $('#linea_select_edit').val(JSON.parse(data.tipo_user));
                await $('#linea_select_edit').trigger('change');
            });
        }
    });
}

function setIDclave(id_user) {
    $('#id_usuario_clave_editar').val(id_user);
}

function editarUsuario() {

    let id_usuario_editar = $('#id_usuario_editar').val();
    let usuario_editar = $('#usuario_editar').val();
    let nombre_editar = $('#nombre_editar').val();
    let ciudad_editar = $('#ciudad_editar').val();
    let telefono_editar = $('#telefono_editar').val();
    let permisos_editar = $('#permisos_editar').val();
    let supervisor_editar = $('#supervisor_editar').val();
    let estado_editar = $('#estado_editar').val();
    let lineas = $('#linea_select_edit').val();
    
    // console.log(lineas);

    let crear = "crear";
    let error = '';
    let template = '';

    if (usuario_editar === '') { error += '<strong>Usuario</strong><br>'; }
    if (nombre_editar === '') { error += '<strong>Nombre</strong><br>'; }
    if (ciudad_editar === '') { error += '<strong>Ciudad</strong><br>'; }
    if (telefono_editar === '') { error += '<strong>Telefono</strong><br>'; }
    if (permisos_editar === '') { error += '<strong>Permisos</strong><br>'; }
    if (supervisor_editar === '') { error += '<strong>Supervisor</strong><br>'; }
    if (lineas.length == []) { error += '<strong>Lineas</strong><br>'; }

    if (error != '') {
        template += `
        <div class="alert alert-warning" role="alert" id="alerta_lin">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#errores').html(template);

    } else {

        let editar_usuario = 'all';

        fetch('back-end/usuarios/usuarios.php', {
            method: 'PUT',
            body: JSON.stringify({
                editar_usuario: editar_usuario,
                id_usuario_editar: id_usuario_editar,
                usuario_editar: usuario_editar,
                nombre_editar: nombre_editar,
                ciudad_editar: ciudad_editar,
                telefono_editar: telefono_editar,
                permisos_editar: permisos_editar,
                supervisor_editar: supervisor_editar,
                estado_editar: estado_editar,
                lineas:lineas
            }),
            Headers: {
                Accept: 'application/json',
                'Content-Type': 'text/html'
            }
        })
            .then((response) => response.text())
            .then(async (responseData) => {
                console.log(responseData);
                let resp = parseInt(responseData);

                if (resp == 200) {
                    $('#edit_usuario').modal("hide");
                    await Toast.fire({
                        icon: 'success',
                        title: 'Usuario Actualizado'
                    });
                    // window.location.reload()

                } else {
                    Toast.fire({
                        icon: 'error',
                        title: 'Error al Actualizar el Usuario'
                    });
                }
            })
            .catch((error) => {
                console.error('error', error)
            });
    }
}

function editar_clave() {

    let id_usuario_clave_editar = $('#id_usuario_clave_editar').val();
    let password_1 = $('#password_1').val();
    let password_2 = $('#password_2').val();

    if (password_1 != password_2) {
        Toast.fire({
            icon: "error",
            title: "Las contraseña no coinciden"
        });
    } else {


        fetch('back-end/usuarios/usuarios.php', {
            method: 'PUT',
            body: JSON.stringify({
                id_usuario_clave_editar: id_usuario_clave_editar,
                password_1: password_1
            }),
            Headers: {
                Accept: 'application/json',
                'Content-Type': 'text/html'
            }
        })
            .then((response) => response.text())
            .then(async (responseData) => {
                console.log(responseData);
                let resp = parseInt(responseData);

                if (resp == 200) {

                    await Toast.fire({
                        icon: "success",
                        title: "Clave Actualizada"
                    });
                    window.location.reload()

                } else {

                    Toast.fire({
                        icon: 'error',
                        title: 'Error al Actualizar el Usuario'
                    });

                }
            })
            .catch((error) => {
                console.error('error', error)
            });
    }
}

async function lista_lineas() {

    await $.get(`back-end/usuarios/usuarios.php?lista_lineas=all`, async function (response) {
        let o = JSON.parse(response);

        let templete = `<select class="form-control" id="linea_select" multiple="multiple">`;
        let body = ``;
        let templete_end = `</select>`;

        o.forEach(data => {
            body += `<option value="${data.id_linea}">${data.linea}</option>`;
        })

        await $('#container_lista_linea').html(templete + body + templete_end);
    });
}


async function lista_lineas_edit() {

    await $.get(`back-end/usuarios/usuarios.php?lista_lineas=all`, async function (response) {
        let o = JSON.parse(response);

        let linea_select_edit = document.getElementById('linea_select_edit');
        o.forEach(data => {
            let option = document.createElement("option");
            option.value = data.id_linea;
            option.text = data.linea;
            linea_select_edit.appendChild(option);
        })
    });
}