<?php

include('../../config/database.php');

$jsonData = $_POST['jsonData'];
$jsonData = json_decode($jsonData, true);

// var_dump($jsonData);

function ver_ult_codigo($mysqli)
{
    $sql = "SELECT MAX(codigo_cliente) as cod_cli FROM paneles;";
    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    if ($resultarray[0]['cod_cli'] == '') {
        return 9999999;
    } else {
        return $resultarray[0]['cod_cli'];
    }
}

?>

<!DOCTYPE html>
<html lang="es">

<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <link rel="apple-touch-icon" sizes="76x76" href="../../assets/img/apple-icon.png">
    <link rel="icon" type="image/png" href="../../assets/img/logo-va.png">
    <title>
        VisitApp
    </title>
    <!--     Fonts and icons     -->
    <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,400,600,700" rel="stylesheet" />
    <!-- Nucleo Icons -->
    <link href="../../assets/css/nucleo-icons.css" rel="stylesheet" />
    <link href="../../assets/css/nucleo-svg.css" rel="stylesheet" />
    <!-- Font Awesome Icons -->
    <script src="https://kit.fontawesome.com/42d5adcbca.js" crossorigin="anonymous"></script>
    <script src="../../assets/js/plugins/datatables.js"></script>
    <link href="../../assets/css/nucleo-svg.css" rel="stylesheet" />
    <!-- CSS Files -->
    <link id="pagestyle" href="../../assets/css/soft-ui-dashboard.css?v=1.1.1" rel="stylesheet" />
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.4/jquery.min.js"></script>
    <script lang="javascript" src="https://cdn.sheetjs.com/xlsx-0.20.0/package/dist/xlsx.full.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
</head>

<body class="bg-gray-100">

    <div class="container-fluid">
        <div class="row mt-2">
            <div class="col-12">
                <div class="card">
                    <div class="card-header text-center">
                        <h1>Cargue Masivo</h1>

                        <a class="btn btn-primary btn-sm float-end m-2" onclick="enviar_datos_plantilla()">
                            <i class="fa fa-spinner text-sm me-2"></i>
                            Cargar Datos
                        </a>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-flush" style="font-size: 10px;" id="datatable_lineas">
                            <thead class="thead-light">
                                <tr>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Codigo Cliente</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Identificacion</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Nombres Cliente</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Apellidos Cliente</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Telefono Cliente</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Email Cliente</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Direccion Cliente</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Ciudad Cliente</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Tipo Cliente</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Categoria</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Especialidad 1</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Especialidad 2</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Fecha Cumpleaños</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Id Usuario</th>
                                    <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">
                                        Estado Cliente</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                $ver_ult_codigo = ver_ult_codigo($mysqli);
                                $i = 1;
                                foreach ($jsonData as $key) {
                                    $numeroDias = (isset($key['Fecha Cumpleaños']) ? $key['Fecha Cumpleaños'] : '0000-00-00');
                                    $fechaBase = strtotime('1900-01-01');

                                    // Verifica si $numeroDias es una cadena que puede ser convertida a un entero
                                    if (is_numeric($numeroDias)) {
                                        $numeroDias = intval($numeroDias);
                                        $fechaUnix = $fechaBase + ($numeroDias - 2) * 24 * 60 * 60; // Restamos 2 días para ajustar a la fecha correcta
                                        $fechaFormateada = date('Y-m-d', $fechaUnix);
                                    } else {
                                        // Manejar el caso donde $numeroDias no es un valor numérico
                                        $fechaFormateada = "Número de días no válido";
                                    }
                                ?>
                                    <tr>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo $ver_ult_codigo + $i ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Identificacion']) ? '' : $key['Identificacion']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Nombres Cliente']) ? '' : $key['Nombres Cliente']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Apellidos Cliente']) ? '' : $key['Apellidos Cliente']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Telefono Cliente']) ? '' : $key['Telefono Cliente']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Email Cliente']) ? '' : $key['Email Cliente']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Direccion Cliente']) ? '' : $key['Direccion Cliente']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Ciudad Cliente']) ? '' : $key['Ciudad Cliente']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Tipo Cliente']) ? '' : $key['Tipo Cliente']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Categoria']) ? '' : $key['Categoria']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Especialidad1']) ? '' : $key['Especialidad1']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Especialidad2']) ? '' : $key['Especialidad2']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo $fechaFormateada ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (!isset($key['Cod Visitador']) ? '' : $key['Cod Visitador']) ?>
                                        </td>
                                        <td style="font-size: 10px;" class="text-center font-weight-normal">
                                            <?php echo (isset($key['Estado Cliente'])?($key['Estado Cliente'] == 1 ? 'Activo' : 'Inactivo'):'') ?>
                                        </td>
                                    </tr>
                                <?php
                                    $i++;
                                }
                                //}
                                ?>
                            </tbody>
                        </table>
                    </div>

                </div>
            </div>
        </div>
    </div>


    <script>
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000,
            timerProgressBar: true,
            didOpen: (toast) => {
                toast.addEventListener('mouseenter', Swal.stopTimer)
                toast.addEventListener('mouseleave', Swal.resumeTimer)
            }
        });

        async function enviar_datos_plantilla() {

            Swal.fire({
                title: 'Cargando...',
                html: 'Espere un momento por favor.',
                allowOutsideClick: false,
                didOpen: () => {
                    Swal.showLoading();
                }
            });

            const tabla = document.getElementById('datatable_lineas');
            var filas = tabla.rows;

            // Crear un array para almacenar los datos
            var datos = [];

            // Iterar sobre las filas y obtener los datos de cada celda
            for (var i = 0; i < filas.length; i++) {
                var fila = filas[i];
                var celdas = fila.cells;

                // Crear un array para almacenar los datos de la fila actual
                var filaDatos = [];

                // Iterar sobre las celdas y obtener el texto de cada celda
                for (var j = 0; j < celdas.length; j++) {
                    filaDatos.push(celdas[j].innerText);
                }

                // Agregar los datos de la fila al array principal
                datos.push(filaDatos);
            }

            let ver_datos = 'all';
            await $.post(`../../back-end/datos/datos.php`, {
                datos,
                ver_datos
            }, async function(response) {
                console.log(response)
                let o = parseInt(response);

                if (o == 200) {
                    await Toast.fire({
                        icon: "success",
                        title: "Registros exitosos"
                    });
                } else {
                    await Toast.fire({
                        icon: "error",
                        title: "Error en algunos registros"
                    });
                }
            });

        }
    </script>

    <!--   Core JS Files   -->
    <script src="../../assets/js/core/popper.min.js"></script>
    <script src="../../assets/js/core/bootstrap.min.js"></script>
    <script src="../../assets/js/plugins/perfect-scrollbar.min.js"></script>
    <script src="../../assets/js/plugins/smooth-scrollbar.min.js"></script>
    <!-- Kanban scripts -->
    <script src="../../assets/js/plugins/dragula/dragula.min.js"></script>
    <script src="../../assets/js/plugins/jkanban/jkanban.js"></script>
    <script src="../../assets/js/plugins/chartjs.min.js"></script>
    <script src="../../assets/js/plugins/threejs.js"></script>
    <script src="../../assets/js/plugins/orbit-controls.js"></script>
    <!-- Github buttons -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <!-- Control Center for Soft Dashboard: parallax effects, scripts for the example pages etc -->
    <script src="../../assets/js/soft-ui-dashboard.min.js?v=1.1.1"></script>
</body>


</html>