<?php
include('../../config/database.php');
$metodo = $_SERVER['REQUEST_METHOD'];
//session_start();
$fecha = date('Y-m-d h:i:s');

function ver_ciclo($mysqli, $id, $fecha_ini, $fecha_fin)
{

    $sql = "SELECT * FROM ciclos WHERE id = '$id' AND fecha_desde = '$fecha_ini' AND fecha_hasta = '$fecha_fin'";
    $result = $mysqli->query($sql);
    $resultarray = array();

    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    if (!empty($resultarray)) {
        return 200;
    } else {
        return 400;
    }

}

function obtenerDiasFestivos($pais, $año)
{
    $url = "https://date.nager.at/api/v2/PublicHolidays/$año/$pais";

    $datos = file_get_contents($url);

    $festivos = json_decode($datos, true);

    $diasFestivos = [];
    foreach ($festivos as $festivo) {
        $diasFestivos[] = $festivo['date'];
    }

    return $diasFestivos;
}


function calcularDiasHabiles($fechaInicio, $fechaFin, $festivos)
{

    $inicio = new DateTime($fechaInicio);
    $fin = new DateTime($fechaFin);

    $fin->modify('+1 day');

    $unDia = new DateInterval('P1D');

    $intervaloDiasHabiles = new DateInterval('P1D');
    $intervaloDiasHabiles->d = 1;

    $periodo = new DatePeriod($inicio, $intervaloDiasHabiles, $fin);

    $diasHabiles = [];

    foreach ($periodo as $dia) {
        if ($dia->format('N') < 6 && !in_array($dia->format('Y-m-d'), $festivos)) {
            $diasHabiles[] = $dia->format('Y-m-d');
        }
    }

    return $diasHabiles;
}

if ($metodo == 'POST') {

    if (isset($_POST['crear'])) {
        $ciclo = $_POST['ciclo'];
        $desde = $_POST['desde'];
        $hasta = $_POST['hasta'];

        $year = date('Y');

        $obtenerDiasFestivos = obtenerDiasFestivos("CO", $year);

        $diasHabiles = calcularDiasHabiles($desde, $hasta, $obtenerDiasFestivos);
        $diasHabiles = count($diasHabiles);

        $sql = "INSERT INTO `ciclos`(`id`, `ciclo`, `dias_habiles`, `fecha_desde`, `fecha_hasta`, `ano_ciclo`, `fecha_registro`, `usar_registro`, `status`, `reser2`) VALUES 
                                  (null,'$ciclo', '$diasHabiles','$desde','$hasta','$year',CURRENT_TIMESTAMP,'','Y','')";
        $result = $mysqli->query($sql);

        if (!$result) {
            echo 400;
        } else {
            echo 200;
        }
    }
}

if ($metodo == 'GET') {

    if (isset($_GET['lineas'])) {
        $lineas = $_GET['lineas'];
        $year = date('Y');
        $sql = "SELECT * FROM ciclos WHERE reser2='$year'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        $i = 0;
        foreach ($result as $key) {

            $resultarray[$i]['id'] = $key['id'];
            $resultarray[$i]['ciclo'] = $key['ciclo'];
            $resultarray[$i]['dias_habiles'] = $key['dias_habiles'];
            $resultarray[$i]['fecha_desde'] = $key['fecha_desde'];
            $resultarray[$i]['fecha_hasta'] = $key['fecha_hasta'];

            if ($key['status'] == 'Y') {
                $resultarray[$i]['status'] = "<span class='badge badge-success'>Activo</span>";
            } else {
                $resultarray[$i]['status'] = "<span class='badge badge-danger'>Inactivo</span>";
            }

            $id = $key['id'];

            $resultarray[$i]['btn_edi'] = "<button class='btn btn-info btn-sm' data-bs-toggle='modal' data-bs-target='#edit_ciclo' onclick='setID($id)'><i class='fa fa-pencil-square-o' style='font-size:13px;'></i></button>";
            // $resultarray[$i]['btn_eliminar'] = "<i class='fa fa-pencil-square-o text-danger text-lg' onclick=`eliminarCiclo()`'></i>";

            $i++;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['id_ciclo'])) {

        $id_ciclo = $_GET['id_ciclo'];

        $sql = "SELECT * FROM ciclos WHERE id = '$id_ciclo'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['ver_fechas'])) {

        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];

        $sql = "SELECT * FROM ciclos WHERE 
                    ('$fecha_ini' BETWEEN ciclos.fecha_desde AND ciclos.fecha_hasta OR
                    '$fecha_fin' BETWEEN ciclos.fecha_desde AND ciclos.fecha_hasta OR
                    (ciclos.fecha_desde BETWEEN '$fecha_ini' AND '$fecha_fin' AND 
                    ciclos.fecha_hasta BETWEEN '$fecha_ini' AND '$fecha_fin'))";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        if (empty($resultarray)) {
            echo 200;
        } else {
            echo 400;
        }
    }

    if (isset($_GET['id_ver_fechas'])) {

        $id = $_GET['id_ver_fechas'];
        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];

        $ver_ciclo = ver_ciclo($mysqli, $id, $fecha_ini, $fecha_fin);

        if ($ver_ciclo != 200) {
            echo 200;
        } else {
            $sql = "SELECT * FROM ciclos WHERE 
                        ('$fecha_ini' BETWEEN ciclos.fecha_desde AND ciclos.fecha_hasta OR
                        '$fecha_fin' BETWEEN ciclos.fecha_desde AND ciclos.fecha_hasta OR
                        (ciclos.fecha_desde BETWEEN '$fecha_ini' AND '$fecha_fin' AND 
                        ciclos.fecha_hasta BETWEEN '$fecha_ini' AND '$fecha_fin'))";
            $result = $mysqli->query($sql);
            $resultarray = array();

            foreach ($result as $key) {
                $resultarray[] = $key;
            }

            if (empty($resultarray)) {
                echo 200;
            } else {
                echo 400;
            }
        }
    }
}

if ($metodo == 'PUT') {

    $data = file_get_contents("php://input");
    $decodedData = json_decode($data, true);

    $id = $decodedData['id'];
    $ciclo = $decodedData['ciclo'];
    $desde = $decodedData['desde'];
    $hasta = $decodedData['hasta'];

    $year = date('Y');

    $obtenerDiasFestivos = obtenerDiasFestivos("CO", $year);

    $diasHabiles = calcularDiasHabiles($desde, $hasta, $obtenerDiasFestivos);
    $diasHabiles = count($diasHabiles);

    $sql = "UPDATE `ciclos` SET `ciclo`='$ciclo', `dias_habiles` = '$diasHabiles',`fecha_desde`='$desde', `fecha_hasta`='$hasta' WHERE `id`='$id'";
    $result = $mysqli->query($sql);

    if (!$result) {
        echo 400;
    } else {
        echo 200;
    }
}
