<?php
include('../../config/database.php');
$metodo = $_SERVER['REQUEST_METHOD'];
session_start();

$user = $_SESSION['id_user'];
$tipo_user = $_SESSION['tipo_user'];
$fecha = date('Y-m-d h:i:s');

function calcularDiasHabiles($fechaInicio, $fechaFin, $festivos)
{
    $inicio = new DateTime($fechaInicio);
    $fin = new DateTime($fechaFin);
    $fin->modify('+1 day');
    $intervaloDiasHabiles = new DateInterval('P1D');
    $intervaloDiasHabiles->d = 1;
    $periodo = new DatePeriod($inicio, $intervaloDiasHabiles, $fin);
    $diasHabiles = [];
    foreach ($periodo as $dia) {
        if ($dia->format('N') < 6 && !in_array($dia->format('Y-m-d'), $festivos)) {
            $diasHabiles[] = $dia->format('Y-m-d');
        }
    }
    return $diasHabiles;
}

function obtenerDiasFestivos($pais, $year)
{
    $datos = file_get_contents("https://date.nager.at/api/v2/PublicHolidays/$year/$pais");
    $festivos = json_decode($datos, true);
    $diasFestivos = [];
    foreach ($festivos as $festivo) {
        $diasFestivos[] = $festivo['date'];
    }
    return $diasFestivos;
}

function ver_inventario_vacio($mysqli, $id_user, $id_articulo)
{
    $sql = "SELECT * FROM `inventarios` WHERE 
            `id_user` = '$id_user' AND 
            `id_articulo` = '$id_articulo' AND
            `cantidad` = '0'";
    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    if (empty($resultarray)) {
        return true;
    } else {
        return false;
    }
}

function estados_visita($mysqli, $id_estado)
{
    $sql = "SELECT * FROM `estados_visitas` WHERE codigo_estado = '$id_estado'";
    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }
    return $resultarray;
}

function consul_inventario($mysqli, $id_articulo, $id_user)
{
    $sql = "SELECT * FROM `inventarios` WHERE `id_articulo` = '$id_articulo' AND `id_user` = '$id_user'";
    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    return $resultarray;
}

function consul_articulo_by_name($mysqli, $id_nom_articulo)
{
    $sql = "SELECT * FROM `articulos` WHERE `nombre_articulo` = '$id_nom_articulo'";
    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    return $resultarray[0]['id_articulo'];
}

function consul_nom_usuario($mysqli, $cod_med)
{
    $sql = "SELECT * FROM `paneles` WHERE codigo_cliente = '$cod_med'";

    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    // var_dump($resultarray);
    return $resultarray[0]['apellidos_cliente'] . " " . $resultarray[0]['nombres_cliente'];
}

function consul_cod_cliente_by_id_visita($mysqli, $id_visita)
{
    $sql = "SELECT * FROM `visitas` WHERE codigo_cliente = '$id_visita'";

    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    // var_dump($resultarray);
    return $resultarray[0]['codigo_cliente'];
}

function consul_ciclo_by_fecha($mysqli)
{
    $fecha = date('Y-m-d');

    $sql = "SELECT * FROM ciclos WHERE '$fecha' BETWEEN fecha_desde AND fecha_hasta";
    $result = $mysqli->query($sql);
    $resultarray = array();

    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    return $resultarray[0]['id'];
}

if ($metodo == 'POST') {
    if (isset($_POST['id_visita'])) {
        $id_visita = $_POST['id_visita'];

        $sql = "UPDATE `visitas` SET `estado_visita` = '210', `hora_inicio` = CURRENT_TIME WHERE `id_visita` = '$id_visita'";
        $result = $mysqli->query($sql);

        if (!$result) {
            echo 400;
        } else {
            echo 200;
        }
    }

    if (isset($_POST['nombre_cliente'])) {
        $id_visita = $_POST['id_visita'];
        $nombre_cliente = $_POST['nombre_cliente'];
        $producto_visita = $_POST['producto_visita'];
        $formula = $_POST['formula'];
        $producto_formula = $_POST['producto_formula'];
        $incentivo = $_POST['incentivo'];

        $m_medica = $_POST['m_medica'];
        $nro_muestra = $_POST['nro_muestra'];

        // ----------------------------------------------------
        $muestra1 = $_POST['muestra1'];
        $cantidad_m1 = $_POST['cantidad_m1'];

        if ($muestra1 != '') {

            $muestra1_cod = consul_articulo_by_name($mysqli, $muestra1);
            $consul_inventario = consul_inventario($mysqli, $muestra1_cod, $user);

            $cantidad_actual = $consul_inventario[0]['cantidad'];
            $id_inventario = $consul_inventario[0]['id_inventario'];

            $total_arti = $cantidad_actual - $cantidad_m1;
            $cantidad_m1_n = -$cantidad_m1;

            $insert = "INSERT INTO `inventario_movimientos`(`id_cons`, `id_inventario`, `tipo_transferencia`, `cantidad`, `usuario_receptor`, `usuario_movimiento`, `fecha_movimiento`) VALUES 
                                                               (null,'$id_inventario','S','$cantidad_m1_n','','$user',CURRENT_TIMESTAMP)";
            $result = $mysqli->query($insert);

            $update1 = "UPDATE `inventarios` SET `cantidad`='$total_arti',`fecha_modifica`='CURRENT_TIMESTAMP' WHERE id_user = '$user' AND id_articulo = '$muestra1_cod'";
            $result1 = $mysqli->query($update1);
        }

        // ----------------------------------------------------

        $muestra2 = $_POST['muestra2'];
        $cantidad_m2 = $_POST['cantidad_m2'];

        if ($muestra2 != '') {

            $muestra2_cod = consul_articulo_by_name($mysqli, $muestra2);
            $consul_inventario = consul_inventario($mysqli, $muestra2_cod, $user);

            $cantidad_actual = $consul_inventario[0]['cantidad'];
            $id_inventario = $consul_inventario[0]['id_inventario'];

            $total_arti = $cantidad_actual - $cantidad_m2;
            $cantidad_m2_n = -$cantidad_m2;

            $insert = "INSERT INTO `inventario_movimientos`(`id_cons`, `id_inventario`, `tipo_transferencia`, `cantidad`, `usuario_receptor`, `usuario_movimiento`, `fecha_movimiento`) VALUES 
                                                                (null,'$id_inventario','S','$cantidad_m2_n','','$user',CURRENT_TIMESTAMP)";
            $result = $mysqli->query($insert);

            $update1 = "UPDATE `inventarios` SET `cantidad`='$total_arti',`fecha_modifica`='CURRENT_TIMESTAMP' WHERE id_user = '$user' AND id_articulo = '$muestra2_cod'";
            $result1 = $mysqli->query($update1);
        }

        // ----------------------------------------------------

        $muestra3 = $_POST['muestra3'];
        $cantidad_m3 = $_POST['cantidad_m3'];

        if ($muestra3 != '') {

            $muestra3_cod = consul_articulo_by_name($mysqli, $muestra3);
            $consul_inventario = consul_inventario($mysqli, $muestra3_cod, $user);

            $cantidad_actual = $consul_inventario[0]['cantidad'];
            $id_inventario = $consul_inventario[0]['id_inventario'];

            $total_arti = $cantidad_actual - $cantidad_m3;
            $cantidad_m3_n = -$cantidad_m3;

            $insert = "INSERT INTO `inventario_movimientos`(`id_cons`, `id_inventario`, `tipo_transferencia`, `cantidad`, `usuario_receptor`, `usuario_movimiento`, `fecha_movimiento`) VALUES 
                                                               (null,'$id_inventario','S','$cantidad_m3_n','','$user',CURRENT_TIMESTAMP)";
            $result = $mysqli->query($insert);

            $update1 = "UPDATE `inventarios` SET `cantidad`='$total_arti',`fecha_modifica`='CURRENT_TIMESTAMP' WHERE id_user = '$user' AND id_articulo = '$muestra3_cod'";
            $result1 = $mysqli->query($update1);
        }

        // ----------------------------------------------------

        $incentivo1 = $_POST['incentivo1'];
        $cantidad_in1 = $_POST['cantidad_in1'];
        $incentivo2 = $_POST['incentivo2'];
        $cantidad_in2 = $_POST['cantidad_in2'];
        $incentivo3 = $_POST['incentivo3'];
        $cantidad_in3 = $_POST['cantidad_in3'];
        $tipo_visita = $_POST['tipo_visita'];
        $observaciones = $_POST['observaciones'];
        $compromiso = $_POST['compromiso'];
        $fecha_compromiso = $_POST['fecha_compromiso'];
        $nueva_visita = $_POST['nueva_visita'];
        $fecha = $_POST['fecha'];

        if ($nueva_visita == 'SI') {
            $codigo_cliente = consul_cod_cliente_by_id_visita($mysqli, $id_visita);
            $sql_insert = "INSERT INTO visitas VALUES (NULL,'$codigo_cliente','','','','','','','','','','','','','','','','','','',
            '','','','','','','$user',200,0,0,'$fecha','','',CURRENT_TIMESTAMP, '', '')";
            $result = $mysqli->query($sql_insert);
        }

        $sql = "UPDATE `visitas` SET 
                    `producto_visita`='$producto_visita',
                    `formula`='$formula',
                    `producto_formula`='$producto_formula',
                    `incentivo`='$incentivo',
                    `m_medica`='$m_medica',
                    `nro_muestra`='$nro_muestra',
                    `muestra1`='$muestra1',
                    `cantidad_m1`='$cantidad_m1',
                    `muestra2`='$muestra2',
                    `cantidad_m2`='$cantidad_m2',
                    `muestra3`='$muestra3',
                    `cantidad_m3`='$cantidad_m3',
                    `incentivo1`='$incentivo1',
                    `cantidad_in1`='$cantidad_in1',
                    `incentivo2`='$incentivo2',
                    `cantidad_in2`='$cantidad_in2',
                    `incentivo3`='$incentivo3',
                    `cantidad_in3`='$cantidad_in3',
                    `tipo_visita`='$tipo_visita',
                    `observaciones`='$observaciones',
                    `compromiso`='$compromiso',
                    `fecha_compromiso`='$fecha_compromiso',
                    `proxima_visita`='$nueva_visita',
                    `fecha_proxima_visita`='$fecha',
                    `estado_visita`= '300'
                    WHERE `id_visita`='$id_visita'";
        $result = $mysqli->query($sql);

        if (!$result) {
            echo 400;
        } else {
            echo 200;
        }
    }

    if (isset($_POST['nueva_fecha'])) {

        $id_visita = $_POST['id_visita'];
        $nueva_fecha = $_POST['nueva_fecha'];

        $sql = "UPDATE `visitas` SET `fecha_visita` = '$nueva_fecha' WHERE `id_visita` = '$id_visita'";
        $result = $mysqli->query($sql);

        if (!$result) {
            echo 400;
        } else {
            echo 200;
        }
    }

    if (isset($_POST['observaciones_cierre'])) {

        $id_visita = $_POST['id_visita'];
        $observaciones_cierre = $_POST['observaciones_cierre'];

        $sql = "UPDATE `visitas` SET `observaciones_cierre` = '$observaciones_cierre', `estado_visita` = '400' WHERE `id_visita` = '$id_visita'";
        $result = $mysqli->query($sql);

        if (!$result) {
            echo 400;
        } else {
            echo 200;
        }
    }

    if (isset($_POST['registrar'])) {

        $fecha_visita = $_POST['fecha'];
        $list_cliente = json_decode($_POST['cliente']);
        $id_user = $_SESSION['id_user'];
        $fecha = date("Y-m-d H:i:s");

        foreach ($list_cliente as $valor) {
            $codigo_cliente = $valor;
            $sql = "INSERT INTO visitas VALUES (NULL,'$codigo_cliente','','','','','','','','','','','','','','','','','','',
            '','','','','','','$id_user',200,0,0,'$fecha_visita','','','$fecha', '', '')";
            $query = mysqli_query($mysqli, $sql);

            if (!$query) {
                die('Error en el registro' . mysqli_error($mysqli));
            }
            echo 'Registro Exitoso..';
        }
    }
}

if ($metodo == 'GET') {

    if (isset($_GET['objetivos_ciclo_actual'])) {

        // $ciclo = $_GET['ciclo'];
        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];
        $year = date('Y', strtotime($fecha_fin));
        $tipo_cliente = $_GET['tipo_cliente'];

        $sql = "SELECT * FROM ciclos WHERE '$fecha_fin' BETWEEN fecha_desde AND fecha_hasta";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        $ciclo = $resultarray[0]['id'];
        $datos_ciclo = $resultarray[0]['ciclo'];

        if($tipo_cliente == 'todos'){
            $query_ciclo = mysqli_query($mysqli, "SELECT sum(o.cantidad) cantidad, c.dias_habiles FROM ciclos c, objetivos o WHERE o.visitador = '$user' AND c.id=$ciclo and o.ciclo=c.id") or die('Error en la consulta' . mysqli_error($mysqli));    
        }else{
            $query_ciclo = mysqli_query($mysqli, "SELECT sum(o.cantidad) cantidad, c.dias_habiles FROM ciclos c, objetivos o WHERE o.visitador = '$user' AND o.tipo_cliente = '$tipo_cliente' AND c.id=$ciclo and o.ciclo=c.id") or die('Error en la consulta' . mysqli_error($mysqli));
        }
        $rowciclo = mysqli_fetch_array($query_ciclo);

        if ($rowciclo['dias_habiles'] != '') {
            $dias = $rowciclo['dias_habiles'];
            $nro_visitas = $rowciclo['cantidad'];
            //Calcular días
            $obtenerDiasFestivos = obtenerDiasFestivos("CO", $year);
            $diasHabiles = calcularDiasHabiles($fecha_ini, $fecha_fin, $obtenerDiasFestivos);
            $diasHabiles = count($diasHabiles);
            // echo "(($diasHabiles * $nro_visitas) / $dias)";
            // $objetivo = (($diasHabiles * $nro_visitas) / $dias);
            $objetivo = $nro_visitas;
        }else{
            $objetivo = 0;
        }

        $datos = array(
            'ciclo' => $datos_ciclo,
            'cant_obje' => round($objetivo)
        );

        echo json_encode($datos);
    }

    if (isset($_GET['objetivos_gestionadas'])) {

        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];
        $year = date('Y', strtotime($fecha_fin));
        $ciclo = $_GET['ciclo'];
        $tc = $_GET['tipo_cliente'];

        if ($tc == 'todos') {
            $query_gest = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) nro_gest FROM visitas v, paneles p WHERE v.id_user = '$user' AND (v.fecha_visita BETWEEN '$fecha_ini' and '$fecha_fin') and v.codigo_cliente=p.id_cliente AND v.estado_visita =300") or die('Error en la consulta' . mysqli_error($mysqli));
        } else {
            $query_gest = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) nro_gest FROM visitas v, paneles p WHERE v.id_user = '$user' AND (v.fecha_visita BETWEEN '$fecha_ini' and '$fecha_fin') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=$tc AND v.estado_visita =300") or die('Error en la consulta' . mysqli_error($mysqli));
        }
        $rowg = mysqli_fetch_array($query_gest);
        $real = $rowg['nro_gest'];

        if ($tc == 'todos') {
            $query_ciclo = mysqli_query($mysqli, "SELECT sum(o.cantidad) cantidad, c.dias_habiles FROM ciclos c, objetivos o WHERE o.visitador = '$user' AND c.id=$ciclo and o.ciclo=c.id") or die('Error en la consulta' . mysqli_error($mysqli));
        } else {
            $query_ciclo = mysqli_query($mysqli, "SELECT sum(o.cantidad) cantidad, c.dias_habiles FROM ciclos c, objetivos o WHERE o.visitador = '$user' AND c.id=$ciclo and o.ciclo=c.id AND o.reser2='$tc'") or die('Error en la consulta' . mysqli_error($mysqli));
        }

        $rowciclo = mysqli_fetch_array($query_ciclo);

        if ($rowciclo['dias_habiles'] != '') {
            $dias = $rowciclo['dias_habiles'];
            $nro_visitas = $rowciclo['cantidad'];
            //Calcular días
            $obtenerDiasFestivos = obtenerDiasFestivos("CO", $year);
            $diasHabiles = calcularDiasHabiles($fecha_ini, $fecha_fin, $obtenerDiasFestivos);
            $diasHabiles = count($diasHabiles);
            // $objetivo = (($diasHabiles * $nro_visitas) / $dias);
            $objetivo = $nro_visitas;
            echo $cumplimiento = (($real * 100) / $objetivo);
        } else {
            $objetivo = 0;
            echo $cumplimiento = 0;
        }
    }

    if (isset($_GET['visitas_planificadas'])) {

        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];
        $tipo_cliente = $_GET['tipo_cliente'];

        if ($tipo_cliente == 'todos') {
            $sql = "SELECT COUNT(visitas.id_visita) as visitas_planificadas FROM visitas WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                visitas.id_user = '$user' AND visitas.estado_visita >= '200'";
        } else {
            $sql = "SELECT COUNT(id_visita) as visitas_planificadas FROM visitas INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                paneles.tipo_cliente = '$tipo_cliente' AND
                visitas.id_user = '$user' AND visitas.estado_visita >= '200'";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['visitas_gestionadas'])) {
        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];
        $tipo_cliente = $_GET['tipo_cliente'];

        if ($tipo_cliente == 'todos') {
            $sql = "SELECT COUNT(visitas.id_visita) as visitas_gestionadas FROM visitas WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                visitas.id_user = '$user' AND (visitas.estado_visita = '300' )";
        } else {
            $sql = "SELECT COUNT(visitas.id_visita) as visitas_gestionadas FROM visitas INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente WHERE 
                paneles.tipo_cliente = '$tipo_cliente' AND
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                visitas.id_user = '$user' AND (visitas.estado_visita = '300')";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['visitas_pendientes'])) {
        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];
        $tipo_cliente = $_GET['tipo_cliente'];

        if ($tipo_cliente == 'todos') {
            $sql = "SELECT COUNT(visitas.id_visita) as visitas_pendientes FROM visitas WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                visitas.id_user = '$user' AND (visitas.estado_visita = '200' OR visitas.estado_visita = '210')";
        } else {
            $sql = "SELECT COUNT(visitas.id_visita) as visitas_pendientes FROM visitas INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente WHERE 
                paneles.tipo_cliente = '$tipo_cliente' AND
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                visitas.id_user = '$user' AND (visitas.estado_visita = '200' OR visitas.estado_visita = '210')";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['porcentaje_cumplimiento'])) {
        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];
        $tipo_cliente = $_GET['tipo_cliente'];

        if ($tipo_cliente == 'todos') {
            $sql = "SELECT COUNT(visitas.id_visita) as visitas_gestionadas FROM visitas WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                visitas.id_user = '$user' AND (visitas.estado_visita = '300' OR visitas.estado_visita = '400')";
        } else {
            $sql = "SELECT COUNT(visitas.id_visita) as visitas_gestionadas FROM visitas INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente WHERE 
                paneles.tipo_cliente = '$tipo_cliente' AND
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                visitas.id_user = '$user' AND (visitas.estado_visita = '300' OR visitas.estado_visita = '400')";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        if ($tipo_cliente == 'todos') {
            $sql = "SELECT COUNT(visitas.id_visita) as visitas_planificadas FROM visitas WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                visitas.id_user = '$user' AND visitas.estado_visita >= '200' ";
        } else {
            $sql = "SELECT COUNT(id_visita) as visitas_planificadas FROM visitas INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
                paneles.tipo_cliente = '$tipo_cliente' AND
                visitas.id_user = '$user' AND visitas.estado_visita >= '200'";
        }

        $resultp = $mysqli->query($sql);
        $resultarrayp = array();

        foreach ($resultp as $key) {
            $resultarrayp[] = $key;
        }

        $gestionadas = $resultarray[0]['visitas_gestionadas'];
        $planificadas = $resultarrayp[0]['visitas_planificadas'];

        echo $total_cumpli = $gestionadas / $planificadas;
    }

    if (isset($_GET['lista_cumple'])) {

        $fecha_hoy = date('m-d');
        $fecha_yester = date('m-d', strtotime('+1 day'));

        $sql = "SELECT nombres_cliente, apellidos_cliente, DATE_FORMAT(fecha_cumple, '%m-%d') AS fecha_cumple FROM `paneles` WHERE (DATE_FORMAT(fecha_cumple, '%m-%d') = '$fecha_hoy' OR DATE_FORMAT(fecha_cumple, '%m-%d') = '$fecha_yester') AND id_user = '$user'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        $i = 0;
        foreach ($result as $key) {
            $resultarray[$i]['cliente'] = $key['apellidos_cliente'] . " " . $key['nombres_cliente'];
            $resultarray[$i]['fecha_cumple'] = date('Y') . '-' . $key['fecha_cumple'];
            $i++;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['lista_compromisos'])) {

        $fecha_hoy = date('Y-m-d');
        $fecha_yester = date('Y-m-d', strtotime('+1 day'));

        $sql = "SELECT 
        visitas.`id_visita`,
        visitas.`codigo_cliente`,
        paneles.`nombres_cliente`,
        paneles.`apellidos_cliente`,
        visitas.`producto_visita`,
        visitas.`formula`,
        visitas.`producto_formula`,
        visitas.`incentivo`,
        visitas.`detalle_incentivo`,
        visitas.`m_medica`,
        visitas.`nro_muestra`,
        visitas.`muestra1`,
        visitas.`cantidad_m1`,
        visitas.`muestra2`,
        visitas.`cantidad_m2`,
        visitas.`muestra3`,
        visitas.`cantidad_m3`,
        visitas.`incentivo1`,
        visitas.`cantidad_in1`,
        visitas.`incentivo2`,
        visitas.`cantidad_in2`,
        visitas.`incentivo3`,
        visitas.`cantidad_in3`,
        visitas.`tipo_visita`,
        visitas.`observaciones`,
        visitas.`observaciones_cierre`,
        visitas.`compromiso`,
        visitas.`fecha_compromiso`,
        visitas.`id_user`,
        visitas.`estado_visita`,
        visitas.`latitud_visita`,
        visitas.`longitud_visita`,
        visitas.`fecha_visita`,
        visitas.`proxima_visita`,
        visitas.`fecha_proxima_visita`,
        visitas.`fecha_proceso`,
        visitas.`hora_inicio`,
        visitas.`hora_fin` 
        FROM visitas
        INNER JOIN paneles ON visitas.codigo_cliente = paneles.id_cliente
        WHERE visitas.fecha_compromiso BETWEEN '$fecha_hoy' AND '$fecha_yester' AND
        visitas.id_user = '$user'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['lista_pendientes'])) {

        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];
        $tipo_cliente = $_GET['tipo_cliente'];

        if ($tipo_cliente == 'todos') {
            $sql = "SELECT
            visitas.`id_visita`,
            visitas.`codigo_cliente`,
            paneles.`nombres_cliente`,
            paneles.`apellidos_cliente`,
            visitas.`producto_visita`,
            visitas.`id_user`,
            visitas.`estado_visita`,
            estados_visitas.`nom_estado`,
            estados_visitas.`html_estado`,
            visitas.`fecha_visita`
            FROM visitas
            INNER JOIN paneles ON visitas.codigo_cliente = paneles.id_cliente AND paneles.id_user='$user' 
            INNER JOIN estados_visitas ON estados_visitas.codigo_estado = visitas.estado_visita
            WHERE visitas.`fecha_visita` BETWEEN '$fecha_ini' AND '$fecha_fin' AND visitas.id_user = '$user'
            AND (visitas.`estado_visita` = '200' OR visitas.`estado_visita` = '210')";
        } else {
            $sql = "SELECT
            visitas.`id_visita`,
            visitas.`codigo_cliente`,
            paneles.`nombres_cliente`,
            paneles.`apellidos_cliente`,
            visitas.`producto_visita`,
            visitas.`id_user`,
            visitas.`estado_visita`,
            estados_visitas.`nom_estado`,
            estados_visitas.`html_estado`,
            visitas.`fecha_visita`
            FROM visitas
            INNER JOIN paneles ON visitas.codigo_cliente = paneles.id_cliente AND paneles.id_user='$user' 
            INNER JOIN estados_visitas ON estados_visitas.codigo_estado = visitas.estado_visita
            WHERE visitas.`fecha_visita` BETWEEN '$fecha_ini' AND '$fecha_fin' AND visitas.id_user = '$user'
            AND paneles.tipo_cliente = '$tipo_cliente'
            AND (visitas.`estado_visita` = '200' OR visitas.`estado_visita` = '210')";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        $i = 0;
        foreach ($result as $key) {

            $id_estado_visita = $key['estado_visita'];
            $id_visita = $key['id_visita'];

            $resultarray[$i]['id_visita'] = $key['id_visita'];
            $resultarray[$i]['codigo_cliente'] = $key['codigo_cliente'];
            $resultarray[$i]['nombres_cliente'] = $key['apellidos_cliente'] . " " . $key['nombres_cliente'];
            $resultarray[$i]['producto_visita'] = $key['producto_visita'];
            $resultarray[$i]['id_user'] = $key['id_user'];
            $resultarray[$i]['estado_visita'] = $key['estado_visita'];
            $resultarray[$i]['nom_estado'] = $key['nom_estado'];
            $resultarray[$i]['html_estado'] = $key['html_estado'];
            $resultarray[$i]['fecha_visita'] = $key['fecha_visita'];

            switch ($id_estado_visita) {
                case '200':
                    $resultarray[$i]['btn_accion'] = "
                        <a href='#' onclick='setId_hora_inicio($id_visita)' data-bs-toggle='modal' data-bs-target='#hora_inicio'>
                            <i class='fas fa-edit me-2'></i>
                        </a>";
                    break;

                case '210':
                    $resultarray[$i]['btn_accion'] = "
                        <a href='#' onclick='modificar($id_visita)' data-bs-toggle='modal' data-bs-target='#modal_modificar'>
                            <i class='fas fa-edit me-2'></i>
                        </a>";
                    break;
            }
            $i++;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['datos'])) {

        $fecha_ini = $_GET['fecha_ini'];
        $fecha_fin = $_GET['fecha_fin'];

        $sql = "SELECT
        visitas.id_visita,
        visitas.codigo_cliente,
        visitas.estado_visita,
        paneles.codigo_cliente AS cod_cli_pan,
        paneles.nombres_cliente,
        paneles.apellidos_cliente,
        paneles.telefono_cliente,
        paneles.direccion_cliente,
        paneles.estado_cliente
        FROM `visitas`
        INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente
        WHERE visitas.id_user = '$user' AND fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND
        visitas.estado_visita <= 300 AND 
        visitas.estado_visita >= 200";
        $result = $mysqli->query($sql);
        $resultarray = array();

        $i = 0;
        foreach ($result as $key) {

            $resultarray[$i]['id_visita'] = $key['id_visita'];
            $resultarray[$i]['codigo_cliente'] = $key['cod_cli_pan'];
            $resultarray[$i]['nombres_cliente'] = $key['apellidos_cliente'] . " " . $key['nombres_cliente'];
            $resultarray[$i]['direccion_cliente'] = $key['direccion_cliente'];
            $resultarray[$i]['telefono_cliente'] = $key['telefono_cliente'];

            $id_visita = $key['id_visita'];
            $cod_cliente = $key['codigo_cliente'];
            $cod_cli_pan = $key['cod_cli_pan'];
            $id_estado_visita = $key['estado_visita'];
            $estados_visita = estados_visita($mysqli, $id_estado_visita);

            $resultarray[$i]['estado_cliente'] = $estados_visita[0]['html_estado'];

            $resultarray[$i]['btn_cambiar'] = "<a class='btn btn-info btn-sm'><i class='fa fa-calendar-plus-o text-sm' onclick='cambiar($id_visita)'></i></a>";
            $resultarray[$i]['btn_cerrar'] = "<a class='btn btn-danger btn-sm'><i class='fa fa-times text-sm' onclick='cerrar($id_visita)'></i></a>";

            $resultarray[$i]['btn_modificar'] = "";

            if ($id_estado_visita == 200) {
                $resultarray[$i]['btn_cambiar'] = "<a class='btn btn-info btn-sm'><i class='fa fa-calendar-plus-o text-sm' onclick='cambiar($id_visita)'></i></a>";
                $resultarray[$i]['btn_cerrar'] = "<a class='btn btn-danger btn-sm'><i class='fa fa-times text-sm' onclick='cerrar($id_visita)'></i></a>";
                $resultarray[$i]['btn_modificar'] = "";
                $resultarray[$i]['btn_ficha'] = "<a class='btn btn-warning btn-sm'><i class='fa fa-tasks text-sm' onclick='consul_ficha_medica($cod_cli_pan)' data-bs-toggle='modal' data-bs-target='#ficha_medica'></i></a>";
                $resultarray[$i]['btn_hora_ini'] = "<a class='btn btn-success btn-sm'><i class='fa fa-clock-o text-sm' onclick='setId_hora_inicio($id_visita)' data-bs-toggle='modal' data-bs-target='#hora_inicio'></i></a>";
                $resultarray[$i]['btn_detalles'] = "";
            } else if ($id_estado_visita == 210) {
                $resultarray[$i]['btn_cambiar'] = "";
                $resultarray[$i]['btn_cerrar'] = "<a class='btn btn-danger btn-sm'><i class='fa fa-times text-sm' onclick='cerrar($id_visita)'></i></a>";
                $resultarray[$i]['btn_modificar'] = "<a class='btn btn-primary btn-sm'><i class='fa fa-pencil text-sm' onclick='modificar($id_visita)'></i></a>";
                $resultarray[$i]['btn_ficha'] = "<a class='btn btn-warning btn-sm'><i class='fa fa-tasks text-sm' onclick='consul_ficha_medica($cod_cli_pan)' data-bs-toggle='modal' data-bs-target='#ficha_medica'></i></a>";
                $resultarray[$i]['btn_hora_ini'] = "";
                $resultarray[$i]['btn_detalles'] = "";
            } else if ($id_estado_visita == 300) {
                $resultarray[$i]['btn_ficha'] = "";
                $resultarray[$i]['btn_cambiar'] = "";
                $resultarray[$i]['btn_cerrar'] = "";
                $resultarray[$i]['btn_hora_ini'] = "";
                $resultarray[$i]['btn_modificar'] = "";
                $resultarray[$i]['btn_detalles'] = "<a class='btn btn-secondary btn-sm'><i class='fa fa-pencil text-sm' onclick='detalles($id_visita)'></i></a>";
            }

            $i++;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['id_visita'])) {

        $id_visita = $_GET['id_visita'];

        $sql = "SELECT
        visitas.id_visita,
        visitas.codigo_cliente,
        visitas.producto_visita,
        visitas.formula,
        visitas.producto_formula,
        visitas.incentivo,
        visitas.detalle_incentivo,
        visitas.m_medica,
        visitas.nro_muestra,
        visitas.muestra1,
        visitas.cantidad_m1,
        visitas.muestra2,
        visitas.cantidad_m2,
        visitas.muestra3,
        visitas.cantidad_m3,
        visitas.incentivo1,
        visitas.cantidad_in1,
        visitas.incentivo2,
        visitas.cantidad_in2,
        visitas.incentivo3,
        visitas.cantidad_in3,
        visitas.tipo_visita,
        visitas.observaciones,
        visitas.compromiso,
        visitas.fecha_compromiso,
        visitas.id_user,
        visitas.estado_visita,
        visitas.latitud_visita,
        visitas.longitud_visita,
        visitas.fecha_visita,
        visitas.proxima_visita,
        visitas.fecha_proxima_visita,
        visitas.fecha_proceso,
        paneles.nombres_cliente,
        paneles.apellidos_cliente,
        paneles.telefono_cliente,
        paneles.direccion_cliente,
        paneles.estado_cliente
        FROM `visitas`
        INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente
        WHERE id_visita = '$id_visita'";
        $result = $mysqli->query($sql);
        $resultarray = array();
        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['list_articulos'])) {

        $tipo_user = json_decode($tipo_user, true);
        $resultarray = array();

        $i = 0;
        foreach ($tipo_user as $key) {

            $sql = "SELECT
                articulos.id_articulo,
                articulos.codigo_articulo,
                articulos.nombre_articulo,
                lineas.linea,
                tipos_art.tipo,
                articulos.precio_articulo,
                articulos.estado_articulo,
                articulos.user_registro,
                articulos.fecha_registro
                FROM `articulos`
                INNER JOIN tipos_art ON tipos_art.id_tipo = articulos.tipo_articulo
                INNER JOIN lineas ON lineas.id_linea = articulos.linea_articulo
                WHERE lineas.id_linea = '$key'
                ORDER BY articulos.nombre_articulo ASC";
            $result = $mysqli->query($sql);

            foreach ($result as $key2) {
                $resultarray[$i]['id_articulo'] = $key2['id_articulo'];
                $resultarray[$i]['codigo_articulo'] = $key2['codigo_articulo'];
                $resultarray[$i]['nombre_articulo'] = $key2['nombre_articulo'];
                $resultarray[$i]['linea'] = $key2['linea'];
                $resultarray[$i]['tipo'] = $key2['tipo'];
                $resultarray[$i]['precio_articulo'] = $key2['precio_articulo'];
                $resultarray[$i]['estado_articulo'] = $key2['estado_articulo'];
                $resultarray[$i]['user_registro'] = $key2['user_registro'];
                $resultarray[$i]['fecha_registro'] = $key2['fecha_registro'];
                $i++;
            }
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['list_articulos_inventario'])) {

        $sql = "SELECT 
        articulos.id_articulo,
        articulos.nombre_articulo
        FROM `inventarios` 
        INNER JOIN articulos ON articulos.id_articulo = inventarios.id_articulo
        WHERE `id_user` = '$user' GROUP BY `id_articulo`";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key2) {
            $resultarray[] = $key2;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['lista'])) {

        $fv = $_GET['fecha_v'];
        $query = mysqli_query($mysqli, "SELECT p.codigo_cliente, p.nombres_cliente, p.apellidos_cliente, tc.tipo_c FROM visitas v, paneles p, tipos_cli tc WHERE p.id_cliente=v.codigo_cliente AND p.tipo_cliente=tc.id_tipo_c AND fecha_visita='$fv' and v.id_user = '$user'") or die('Error en la consulta' . mysqli_error($mysqli));

        $json = array();
        while ($row = mysqli_fetch_array($query)) {
            $json[] = array(
                'codigo' => $row['codigo_cliente'],
                'nombres' => $row['apellidos_cliente'] . " " . $row['nombres_cliente'],
                'tipo' => $row['tipo_c']
            );
        }
        $jsonstring = json_encode($json);
        echo $jsonstring;
    }

    if (isset($_GET['cod_medico'])) {
        $cod_medico = $_GET['cod_medico'];

        $nombre_cliente = consul_nom_usuario($mysqli, $cod_medico);
        // $nombre_cliente = 'AARON RIVERO MARIA ALEJANDRA';

        $sql = "SELECT * FROM ficha_medica WHERE nombre = '$nombre_cliente'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }
}
