<?php

function loadEnv($path)
{
    if (!file_exists($path)) {
        throw new Exception(".env file not found at: " . $path);
    }

    $lines = file($path, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);

    foreach ($lines as $line) {
        //* ignorando comentarios
        if (str_starts_with(trim($line), '#')) continue;

        //* separando clave y valor
        list($key, $value) = explode('=', $line, 2);

        //* guardando variables en el entorno
        putenv("$key=$value");
        $_ENV[$key] = $value;
        $_SERVER[$key] = $value;
    }
}

loadEnv($_SERVER['DOCUMENT_ROOT'] . '/.env');
