
function list_tipo_cliente() {
    let list_tipo_cliente = 'ALL';
    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_tipo_cliente },
        success: function (response) {
            let datas = JSON.parse(response);
            console.log(datas);
            let template = '<option value="">Seleccione Opcion......</option>';
            datas.forEach(data => {
                template += `
                <option value="${data.id_tipo_c}">${data.tipo_c}</option>
                `
            });
            $('#tipo_cliente').html(template);
        }
    });
}

async function lista_clientes() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    let lista_cliente_tipo = $("#tipo_cliente").val();
    let fecha = $('#fecha_visita').val();

    await $.ajax({
        url: `back-end/visitas/visitas.php`,
        type: 'GET',
        data: { lista_cliente_tipo, fecha },
        success: async function (response) {
            let datas = JSON.parse(response);
            console.log(datas);

            let template1 = '';
            let template = '<option value="">Seleccione Opcion......</option>';

            let templete_ini = `
            <table class="table table-flush" id="datatable_visitas1">
                <thead class="thead-light">
                    <tr>
                        <th class="text-uppercase text-center text-secondary text-xs font-weight-bolder opacity-7">Sel</th>
                        <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Nombre</th>
                        <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Visita</th>
                    </tr>
                </thead>
                <tbody>`;
            let templete_fin = `</tbody></table>`;

            datas.forEach(data => {
                template += `
                <option value="${data.id_cliente}">${data.apellidos_cliente} ${data.nombres_cliente}</option>
                `;
                        
                template1 += `
                <tr>
                    <td class="text-center font-weight-normal">
                        <div class='form-check'>
                            <input class='form-check-input' type='checkbox' value='${data.id_cliente}' id=''>
                        </div>
                    </td>
                    <td class="font-weight-normal">${data.apellidos_cliente} ${data.nombres_cliente}</td>
                    <td class="font-weight-normal">${data.ver_visita_ciclo}</td>
                <tr>`;

            });
            $('#cliente').html(template);
            await $("#list_cliente_crea").html(templete_ini+template1+templete_fin);
        }
    });

    await new simpleDatatables.DataTable("#datatable_visitas1", {
        searchable: true,
        paging: false
    });

    await Swal.close();
}

function nueva_visita() {
    let fecha = $('#fecha_visita').val();
    var clientes_sel = new Array();
    $('input[type=checkbox]:checked').each(function () {
        clientes_sel.push($(this).val());
    });

    const postData = {
        registrar: 0,
        fecha: fecha,
        cliente: JSON.stringify(clientes_sel)
    };

    $.post('back-end/visitas/visitas.php', postData, function (response) {
        console.log(response);
        consulta_visitas();
        $('#form_visita').trigger('reset');
        $("#nueva_visita").modal("hide");
    });
}

async function consulta_visitas() {
    let fecha_visita = $('#fecha_visita').val();

    $.get('back-end/visitas/visitas.php', { lista: "all", fecha_v: fecha_visita }, function (response) {
        let o = JSON.parse(response);
        console.log(o)
        let body = ``;

        o.forEach(data => {
            body += `
                <tr>
                    <td class="text-center font-weight-normal">${data.codigo}</td>
                    <td class="text-center font-weight-normal">${data.nombre}</td>
                    <td class="text-center font-weight-normal">${data.tipo}</td>
                <tr>`;
        });

        $('#list_visitas').html(body);
    });

    
}