<?php
include('../../config/database.php');
$metodo = $_SERVER['REQUEST_METHOD'];
session_start();

$user = $_SESSION['id_user'];
$tipo_user = $_SESSION['tipo_user'];
$fecha = date('Y-m-d h:i:s');

function calcularDiasHabiles($fechaInicio, $fechaFin, $festivos){
    $inicio = new DateTime($fechaInicio);
    $fin = new DateTime($fechaFin);
    $fin->modify('+1 day');
    $unDia = new DateInterval('P1D');
    $intervaloDiasHabiles = new DateInterval('P1D');
    $intervaloDiasHabiles->d = 1;
    $periodo = new DatePeriod($inicio, $intervaloDiasHabiles, $fin);
    $diasHabiles = [];
    foreach ($periodo as $dia) {
        if ($dia->format('N') < 6 && !in_array($dia->format('Y-m-d'), $festivos)) {
            $diasHabiles[] = $dia->format('Y-m-d');
        }
    }
    return $diasHabiles;
}

function obtenerDiasFestivos($pais, $year)
{
    $datos = file_get_contents("https://date.nager.at/api/v2/PublicHolidays/$year/$pais");
    $festivos = json_decode($datos, true);
    $diasFestivos = [];
    foreach ($festivos as $festivo) {
        $diasFestivos[] = $festivo['date'];
    }
    return $diasFestivos;
}

function ver_ciclo($mysqli, $id_ciclo)
{
    $sql = "SELECT * FROM ciclos WHERE id = '$id_ciclo'";
    $result = $mysqli->query($sql);
    $resultarray = array();

    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    return $resultarray;
}

function consul_gestionadas_by_id_user($mysqli, $id_user, $fecha_ini, $fecha_fin)
{

    $sql_lista_tipo_cli = "SELECT * FROM tipos_cli WHERE estado = '1'";
    $result = $mysqli->query($sql_lista_tipo_cli);
    $resultarray = array();
    $i = 0;
    foreach ($result as $key) {

        $tipo_cliente = $key['id_tipo_c'];
        $nombre_tipo_cliente = $key['tipo_c'];

        $sql1 = "SELECT
            COUNT(visitas.id_visita) as visitas_gestionadas
            FROM visitas
            INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente
            WHERE 
            visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin'
            AND visitas.id_user = '$id_user' 
            AND visitas.estado_visita = '300'
            AND paneles.tipo_cliente = '$tipo_cliente'";

        $result1 = $mysqli->query($sql1);
        $resultarray1 = array();

        foreach ($result1 as $key1) {
            $resultarray1[] = $key1;
        }

        $resultarray[$i]['codigo_tipo_cliente'] = $tipo_cliente;
        $resultarray[$i]['nombre_tipo_cliente'] = $nombre_tipo_cliente;
        $resultarray[$i]['cantidad_gestionada'] = $resultarray1[0]['visitas_gestionadas'];
        $i++;
    }
    return $resultarray;
}

function consul_objetivos_by_id_user($mysqli, $id_user, $ciclo)
{
    $sql = "SELECT
    tipos_cli.tipo_c as tipo_cliente,
    objetivos.cantidad
    FROM objetivos
    INNER JOIN ciclos ON objetivos.ciclo = ciclos.id
    INNER JOIN tipos_cli ON tipos_cli.id_tipo_c = objetivos.reser2
    WHERE objetivos.visitador = '$id_user' AND ciclos.id = '$ciclo'
    ORDER BY tipo_cliente ASC";
    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    return $resultarray;
}

function consul_lista_clientes_by_id($mysqli, $lista_clientes)
{
    $sql = "SELECT * FROM tipos_cli WHERE id_tipo_c = '$lista_clientes'";
    $result = $mysqli->query($sql);
    $resultarray = array();
    foreach ($result as $key) {
        $resultarray[] = $key;
    }

    if (empty($resultarray)) {
        return 'Todos';
    } else {
        return $resultarray[0]['tipo_c'];
    }
}

if ($metodo == 'POST') {
    if (isset($_POST['id_visita'])) {
        $id_visita = $_POST['id_visita'];

        $sql = "UPDATE `visitas` SET `estado_visita` = '210', `hora_inicio` = CURRENT_TIME WHERE `id_visita` = '$id_visita'";
        $result = $mysqli->query($sql);

        if (!$result) {
            echo 400;
        } else {
            echo 200;
        }
    }
}

if ($metodo == 'GET') {

    if (isset($_GET['reporte_cab'])) {
        $ff = $_GET['ff'];
        $fi = $_GET['fi'];
        $ciclo = $_GET['ciclo'];
        $query = mysqli_query($mysqli, "SELECT p.tipo_cliente, tc.tipo_c FROM visitas v, paneles p, tipos_cli tc WHERE (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.codigo_cliente AND p.tipo_cliente=tc.id_tipo_c GROUP BY tc.tipo_c, p.tipo_cliente") or die('Error en la consulta' . mysqli_error($mysqli));
        $json = array();
        while ($row = mysqli_fetch_array($query)) {
            $tc = $row['tipo_cliente'];
            //Consultar total
            $query_total = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) total FROM visitas v, paneles p WHERE (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=$tc AND v.estado_visita != 400") or die('Error en la consulta' . mysqli_error($mysqli));
            $rowt = mysqli_fetch_array($query_total);
            $total = $rowt['total'];
            //Consultar pendientes
            $query_pend = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) nro_pend FROM visitas v, paneles p WHERE (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=$tc AND v.estado_visita IN (100,200,210)") or die('Error en la consulta' . mysqli_error($mysqli));
            $rowp = mysqli_fetch_array($query_pend);
            $pend = $rowp['nro_pend'];

            //Consultar gestionadas incluye anuladas
            $query_gest = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) nro_gest FROM visitas v, paneles p WHERE (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=$tc AND v.estado_visita = 300 ") or die('Error en la consulta' . mysqli_error($mysqli));
            $rowg = mysqli_fetch_array($query_gest);
            $real = $rowg['nro_gest'];

            //Sacar segun ciclo
            $query_ciclo = mysqli_query($mysqli, "SELECT sum(o.cantidad) cantidad, c.dias_habiles FROM ciclos c, objetivos o WHERE c.id=$ciclo and o.ciclo=c.id AND o.reser2='$tc'") or die('Error en la consulta' . mysqli_error($mysqli));
            
            //Consultar anuladas  
            $query_anuladas = mysqli_query($mysqli, "SELECT COUNT(v.id_visita) nro_anula FROM visitas v, paneles p WHERE (v.fecha_visita BETWEEN '$fi' and '$ff') and v.codigo_cliente=p.id_cliente AND p.tipo_cliente=$tc AND v.estado_visita =400") or die('Error en la consulta' . mysqli_error($mysqli));
            $rowanul = mysqli_fetch_array($query_anuladas);
            $anuladas = $rowanul['nro_anula'];

            $rowciclo = mysqli_fetch_array($query_ciclo);
            if ($rowciclo['dias_habiles'] != '') {
                $dias = $rowciclo['dias_habiles'];
                $nro_visitas = $rowciclo['cantidad'];
                //Calcular días
                $year = date('Y');
                $obtenerDiasFestivos = obtenerDiasFestivos("CO", $year);
                $diasHabiles = calcularDiasHabiles($fi, $ff, $obtenerDiasFestivos);
                $diasHabiles = count($diasHabiles);
                $objetivo = (($diasHabiles * $nro_visitas) / $dias);
                $cumplimiento = (($real * 100) / $objetivo);
            } else {
                $objetivo = 0;
                $cumplimiento = 0;
            }

            $json[] = array(
                'tipo' => $row['tipo_c'],
                'total' => $total,
                'pendientes' => $pend,
                'gestionadas' => $real,
                'anuladas' => $anuladas,
                'cumplimiento' => number_format(($real * 100) / $total) . '%',
                'objetivo' => number_format($objetivo, 0),
                'cumple_obj' => number_format($cumplimiento, 0) . '%'
            );
        }
        $jsonstring = json_encode($json);
        echo $jsonstring;
    }

    if (isset($_GET['visitas_planificadas'])) {

        $ciclo = $_GET['ciclo'];
        $lista_clientes = $_GET['lista_clientes'];

        $ver_ciclo = ver_ciclo($mysqli, $ciclo);

        $fecha_ini = $ver_ciclo[0]['fecha_desde'];
        $fecha_fin = $ver_ciclo[0]['fecha_hasta'];

        if ($lista_clientes == 'Todos') {
            $sql = "SELECT COUNT(id_visita) as visitas_planificadas FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND estado_visita >= '200'";
        } elseif ($lista_clientes != '') {
            $sql = "SELECT
                COUNT(visitas.id_visita) as visitas_planificadas 
                FROM visitas
                INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente
                WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND 
                visitas.estado_visita >= '200' AND
                paneles.tipo_cliente = '$lista_clientes'";
        } else {
            $sql = "SELECT COUNT(id_visita) as visitas_planificadas FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND estado_visita >= '200'";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['visitas_gestionadas'])) {

        $ciclo = $_GET['ciclo'];
        $lista_clientes = $_GET['lista_clientes'];

        $ver_ciclo = ver_ciclo($mysqli, $ciclo);

        $fecha_ini = $ver_ciclo[0]['fecha_desde'];
        $fecha_fin = $ver_ciclo[0]['fecha_hasta'];

        if ($lista_clientes == 'Todos') {
            $sql = "SELECT COUNT(id_visita) as visitas_gestionadas FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND estado_visita = '300'";
        } elseif ($lista_clientes != '') {
            $sql = "SELECT
                COUNT(visitas.id_visita) as visitas_gestionadas
                FROM visitas
                INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente
                WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND 
                visitas.estado_visita = '300' AND
                paneles.tipo_cliente = '$lista_clientes'";
        } else {
            $sql = "SELECT COUNT(id_visita) as visitas_gestionadas FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND estado_visita = '300'";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['visitas_pendientes'])) {

        $ciclo = $_GET['ciclo'];
        $lista_clientes = $_GET['lista_clientes'];

        $ver_ciclo = ver_ciclo($mysqli, $ciclo);

        $fecha_ini = $ver_ciclo[0]['fecha_desde'];
        $fecha_fin = $ver_ciclo[0]['fecha_hasta'];

        if ($lista_clientes == 'Todos') {
            $sql = "SELECT COUNT(id_visita) as visitas_pendientes FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND (estado_visita = '200' OR estado_visita = '210')";
        } elseif ($lista_clientes != '') {
            $sql = "SELECT
                COUNT(visitas.id_visita) as visitas_pendientes
                FROM visitas
                INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente
                WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND 
                (visitas.estado_visita = '200' OR visitas.estado_visita = '210') AND
                paneles.tipo_cliente = '$lista_clientes'";
        } else {
            $sql = "SELECT COUNT(id_visita) as visitas_pendientes FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND (estado_visita = '200' OR estado_visita = '210')";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['visitas_anuladas'])) {
        $ciclo = $_GET['ciclo'];

        $ver_ciclo = ver_ciclo($mysqli, $ciclo);
        $lista_clientes = $_GET['lista_clientes'];

        $fecha_ini = $ver_ciclo[0]['fecha_desde'];
        $fecha_fin = $ver_ciclo[0]['fecha_hasta'];

        if ($lista_clientes == 'Todos') {
            $sql = "SELECT COUNT(id_visita) as visitas_anuladas FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND estado_visita = '400'";
        } elseif ($lista_clientes != '') {
            $sql = "SELECT
                COUNT(visitas.id_visita) as visitas_anuladas
                FROM visitas
                INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente
                WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND 
                visitas.estado_visita = '400' AND
                paneles.tipo_cliente = '$lista_clientes'";
        } else {
            $sql = "SELECT COUNT(id_visita) as visitas_anuladas FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND estado_visita = '400'";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['sumatoria_objetivos'])) {

        $ciclo = $_GET['ciclo'];
        $lista_clientes = $_GET['lista_clientes'];

        if ($lista_clientes == 'Todos') {
            $sql = "SELECT SUM(cantidad) as sumatoria_objetivos FROM objetivos WHERE ciclo = '$ciclo'";
        } elseif ($lista_clientes != '') {
            $tipo_cliente = consul_lista_clientes_by_id($mysqli, $lista_clientes);
            $sql = "SELECT
                SUM(cantidad) as sumatoria_objetivos
                FROM objetivos 
                WHERE 
                ciclo = '$ciclo' AND
                tipo_cliente = '$tipo_cliente'";
        } else {
            $sql = "SELECT SUM(cantidad) as sumatoria_objetivos FROM objetivos WHERE ciclo = '$ciclo'";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['porcentaje_cumplimiento'])) {

        $ciclo = $_GET['ciclo'];
        $lista_clientes = $_GET['lista_clientes'];

        $ver_ciclo = ver_ciclo($mysqli, $ciclo);

        $fecha_ini = $ver_ciclo[0]['fecha_desde'];
        $fecha_fin = $ver_ciclo[0]['fecha_hasta'];

        if ($lista_clientes == 'Todos') {
            $sql = "SELECT COUNT(id_visita) as visitas_gestionadas FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND estado_visita = '300'";
        } elseif ($lista_clientes != '') {
            $sql = "SELECT
                COUNT(visitas.id_visita) as visitas_gestionadas
                FROM visitas
                INNER JOIN paneles ON paneles.id_cliente = visitas.codigo_cliente
                WHERE 
                visitas.fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND 
                visitas.estado_visita = '300' AND
                paneles.tipo_cliente = '$lista_clientes'";
        } else {
            $sql = "SELECT COUNT(id_visita) as visitas_gestionadas FROM visitas WHERE 
                fecha_visita BETWEEN '$fecha_ini' AND '$fecha_fin' AND estado_visita = '300'";
        }

        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        if ($lista_clientes == 'Todos') {
            $sql1 = "SELECT SUM(cantidad) as sumatoria_objetivos FROM objetivos WHERE ciclo = '$ciclo'";
        } elseif ($lista_clientes != '') {
            $tipo_cliente = consul_lista_clientes_by_id($mysqli, $lista_clientes);
            $sql1 = "SELECT
                SUM(cantidad) as sumatoria_objetivos
                FROM objetivos 
                WHERE 
                ciclo = '$ciclo' AND
                tipo_cliente = '$tipo_cliente'";
        } else {
            $sql1 = "SELECT SUM(cantidad) as sumatoria_objetivos FROM objetivos WHERE ciclo = '$ciclo'";
        }

        $result1 = $mysqli->query($sql1);
        $resultarray1 = array();

        foreach ($result1 as $key1) {
            $resultarray1[] = $key1;
        }

        $gestionadas = $resultarray[0]['visitas_gestionadas'];
        $sumatoria_objetivos = $resultarray1[0]['sumatoria_objetivos'];

        echo $total_cumpli = $gestionadas / $sumatoria_objetivos;
    }

    if (isset($_GET['lista_cumple'])) {

        $fecha_hoy = date('Y-m-d');
        $fecha_yester = date('Y-m-d', strtotime('+1 day'));

        $sql = "SELECT * FROM paneles WHERE fecha_cumple BETWEEN '$fecha_hoy' AND '$fecha_yester'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['lista_ciclos'])) {

        $sql = "SELECT * FROM ciclos WHERE status = 'Y'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['lista_compromisos'])) {

        $fecha_hoy = date('Y-m-d');
        $fecha_yester = date('Y-m-d', strtotime('+1 day'));

        $sql = "SELECT 
        visitas.`id_visita`,
        visitas.`codigo_cliente`,
        paneles.`nombre_cliente`,
        visitas.`producto_visita`,
        visitas.`formula`,
        visitas.`producto_formula`,
        visitas.`incentivo`,
        visitas.`detalle_incentivo`,
        visitas.`m_medica`,
        visitas.`nro_muestra`,
        visitas.`muestra1`,
        visitas.`cantidad_m1`,
        visitas.`muestra2`,
        visitas.`cantidad_m2`,
        visitas.`muestra3`,
        visitas.`cantidad_m3`,
        visitas.`incentivo1`,
        visitas.`cantidad_in1`,
        visitas.`incentivo2`,
        visitas.`cantidad_in2`,
        visitas.`incentivo3`,
        visitas.`cantidad_in3`,
        visitas.`tipo_visita`,
        visitas.`observaciones`,
        visitas.`observaciones_cierre`,
        visitas.`compromiso`,
        visitas.`fecha_compromiso`,
        visitas.`id_user`,
        visitas.`estado_visita`,
        visitas.`latitud_visita`,
        visitas.`longitud_visita`,
        visitas.`fecha_visita`,
        visitas.`proxima_visita`,
        visitas.`fecha_proxima_visita`,
        visitas.`fecha_proceso`,
        visitas.`hora_inicio`,
        visitas.`hora_fin` 
        FROM visitas
        INNER JOIN paneles ON visitas.codigo_cliente = paneles.id_cliente
        WHERE fecha_compromiso BETWEEN '$fecha_hoy' AND '$fecha_yester'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['lista_pendientes'])) {

        $ciclo = $_GET['ciclo'];

        $ver_ciclo = ver_ciclo($mysqli, $ciclo);

        $fecha_ini = $ver_ciclo[0]['fecha_desde'];
        $fecha_fin = $ver_ciclo[0]['fecha_hasta'];

        $sql = "SELECT
        visitas.`id_visita`,
        visitas.`codigo_cliente`,
        paneles.`nombre_cliente`,
        visitas.`producto_visita`,
        visitas.`id_user`,
        visitas.`estado_visita`,
        estados_visitas.`nom_estado`,
        estados_visitas.`html_estado`,
        visitas.`fecha_visita`
        FROM visitas
        INNER JOIN paneles ON visitas.codigo_cliente = paneles.id_cliente
        INNER JOIN estados_visitas ON estados_visitas.codigo_estado = visitas.estado_visita
        WHERE visitas.`fecha_visita` BETWEEN '$fecha_ini' AND '$fecha_fin'
        AND (visitas.`estado_visita` = '200' OR visitas.`estado_visita` = '210')";
        $result = $mysqli->query($sql);
        $resultarray = array();

        $i = 0;
        foreach ($result as $key) {

            $id_estado_visita = $key['estado_visita'];
            $id_visita = $key['id_visita'];

            $resultarray[$i]['id_visita'] = $key['id_visita'];
            $resultarray[$i]['codigo_cliente'] = $key['codigo_cliente'];
            $resultarray[$i]['nombre_cliente'] = $key['nombre_cliente'];
            $resultarray[$i]['producto_visita'] = $key['producto_visita'];
            $resultarray[$i]['id_user'] = $key['id_user'];
            $resultarray[$i]['estado_visita'] = $key['estado_visita'];
            $resultarray[$i]['nom_estado'] = $key['nom_estado'];
            $resultarray[$i]['html_estado'] = $key['html_estado'];
            $resultarray[$i]['fecha_visita'] = $key['fecha_visita'];

            switch ($id_estado_visita) {
                case '200':
                    $resultarray[$i]['btn_accion'] = "
                        <a href='#' onclick='setId_hora_inicio($id_visita)' data-bs-toggle='modal' data-bs-target='#hora_inicio'>
                            <i class='fas fa-edit me-2'></i>
                        </a>";
                    break;

                case '210':
                    $resultarray[$i]['btn_accion'] = "
                        <a href='#' onclick='modificar($id_visita)' data-bs-toggle='modal' data-bs-target='#modal_modificar'>
                            <i class='fas fa-edit me-2'></i>
                        </a>";
                    break;
            }
            $i++;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['esta_visit'])) {

        $ciclo = $_GET['ciclo'];

        $sql3 = "SELECT * FROM usuarios WHERE status = 'activo' AND permisos_acceso = 'Operario'";
        $result3 = $mysqli->query($sql3);
        $resultarray3 = array();

        $i = 0;
        foreach ($result3 as $key3) {

            $id_user = $key3['id_user'];

            $consul_objetivos_by_id_user = consul_objetivos_by_id_user($mysqli, $id_user, $ciclo);

            $name_user = $key3['name_user'];

            $cantidad_farmacia = 0;
            $cantidad_medico = 0;

            if (!empty($consul_objetivos_by_id_user)) {
                if ($consul_objetivos_by_id_user[0]['tipo_cliente'] == 'FARMACIA') {
                    $cantidad_farmacia = $consul_objetivos_by_id_user[0]['cantidad'];
                }
                if (count($consul_objetivos_by_id_user) > 1) {
                    if ($consul_objetivos_by_id_user[1]['tipo_cliente'] == 'MEDICO') {
                        $cantidad_medico = $consul_objetivos_by_id_user[1]['cantidad'];
                    }
                }
            }

            $ver_ciclo = ver_ciclo($mysqli, $ciclo);

            $fecha_ini = $ver_ciclo[0]['fecha_desde'];
            $fecha_fin = $ver_ciclo[0]['fecha_hasta'];

            $gestionada_farmacia = 0;
            $gestionada_medico = 0;

            $consul_gestionadas_by_id_user = consul_gestionadas_by_id_user($mysqli, $id_user, $fecha_ini, $fecha_fin);

            // var_dump($consul_gestionadas_by_id_user);

            foreach ($consul_gestionadas_by_id_user as $tipo_cliente) {
                if ($tipo_cliente['nombre_tipo_cliente'] == 'FARMACIA') {
                    $gestionada_farmacia = $tipo_cliente['cantidad_gestionada'];
                }
                if ($tipo_cliente['nombre_tipo_cliente'] == 'MEDICO') {
                    $gestionada_medico = $tipo_cliente['cantidad_gestionada'];
                }
            }

            $resultarray3[$i]['gestionada_farmacia'] = $gestionada_farmacia;
            $resultarray3[$i]['gestionada_medico'] = $gestionada_medico;
            $resultarray3[$i]['name_user'] = $name_user;
            $resultarray3[$i]['cantidad_farmacia'] = $cantidad_farmacia;
            $resultarray3[$i]['cantidad_medico'] = $cantidad_medico;
            $i++;
        }
        echo json_encode($resultarray3);
    }

    if (isset($_GET['lista_tipo_cliente'])) {
        $sql = "SELECT * FROM tipos_cli WHERE estado = '1'";
        $result = $mysqli->query($sql);
        $resultarray = array();

        foreach ($result as $key) {
            $resultarray[] = $key;
        }

        echo json_encode($resultarray);
    }

    if (isset($_GET['carteles_filtro'])) {

        $ciclo = $_GET['ciclo'];
        $lista_clientes = $_GET['lista_clientes'];

        $dato_tipo = consul_lista_clientes_by_id($mysqli, $lista_clientes);
        $dato_ciclo = ver_ciclo($mysqli, $ciclo);

        $resultarray = array(
            'tipo_cliente' => $dato_tipo,
            'ciclo' => $dato_ciclo[0]['ciclo']
        );

        echo json_encode($resultarray);
    }
}
