const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

consulta_articulos();
//Consultar Articulos
async function consulta_articulos() {
    let articulos = 'ALL';
    await $.ajax({
        url: 'back-end/articulos.php',
        type: 'GET',
        data: { articulos },
        success: function (response) {

            let datas = JSON.parse(response);
            console.log(datas);

            let template = `
            <table class="table table-flush" id="datatable_articulos">
                <thead class="thead-light">
                <tr>
                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">codigo</th>
                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">nombre</th>
                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">tipo</th>
                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">linea</th>
                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">estado</th>
                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Usuario</th>
                    <th class="text-uppercase text-secondary text-xs font-weight-bolder opacity-7">Fecha</th>
                    <th></th> 
                </tr>
                </thead>
            <tbody>`;
            let body = ``;
            let template_end = `</tbody></table>`;

            datas.forEach(data => {
                body += `
                <tr>
                    <td class="text-sm font-weight-normal">${data.codigo}</td>
                    <td class="text-sm font-weight-normal">${data.nombre}</td>
                    <td class="text-sm font-weight-normal">${data.tipo}</td>
                    <td class="text-sm font-weight-normal">${data.linea}</td>
                    <td class="text-sm font-weight-normal">${data.estado}</td>
                    <td class="text-sm font-weight-normal">${data.user}</td>
                    <td class="text-sm font-weight-normal">${data.fecha}</td>
                    <td class="text-sm font-weight-normal">${data.btn}</td>
                </tr>`
            });
            $('#tabla_articulos').html(template + body + template_end);
        }
    });

    const dataTableSearch = new simpleDatatables.DataTable("#datatable_articulos", {
        searchable: true,
        fixedHeight: true
    });
}

function registrar_articulo() {
    let codigo = $("#codigo").val();
    let nombre = $("#nombre").val().toUpperCase();
    let tipo = $("#tipo").val();
    let linea = $("#linea").val();
    let precio = $("#precio").val();
    let template = '', error = '';

    if (codigo === '') { error += 'Codigo<br>'; }
    if (nombre === '') { error += 'Nombre<br>'; }
    if (error != '') {
        template += `
        <div class="alert alert-danger" role="alert" id="alerta_art">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#result_articulo').html(template);
        setTimeout(function () { $('#alerta_art').alert('close'); }, 2000);
    } else {
        const postData = {
            codigo: codigo,
            nombre: nombre,
            tipo: tipo,
            linea: linea,
            precio: precio
        };
        $.post('back-end/articulos.php', postData, function (response) {
            consulta_articulos();
            $('#form_articulo').trigger('reset');
            $('#result_articulo').html(response);
            setTimeout(function () { $('#alerta_art').alert('close'); $("#nuevo_articulo").modal("hide"); }, 1000);
        });
    }
}

function busca_articulo(id) {
    let id_articulo = id;
    $.ajax({
        url: 'back-end/articulos.php',
        type: 'GET',
        data: { id_articulo },
        success: function (response) {
            let o = JSON.parse(response);
            // console.log(o);
            $("#e_codigo").val(o.codigo);
            $("#e_nombre").val(o.nombre);
            $("#e_tipo").val(o.tipo);
            $("#e_linea").val(o.linea);
            $("#e_precio").val(o.precio);
            $("#e_estado").val(o.estado);
            $("#e_id_articulo").val(o.id);
        }
    })
}

function edita_articulo() {
    let codigo_e = $("#e_codigo").val();
    let nombre = $("#e_nombre").val().toUpperCase();
    let tipo = $("#e_tipo").val();
    let linea = $("#e_linea").val();
    let precio = $("#e_precio").val();
    let estado = $("#e_estado").val();
    let id_articulo = $("#e_id_articulo").val();
    let template = '', error = '';

    if (codigo_e === '') { error += 'Codigo<br>'; }
    if (nombre === '') { error += 'Nombre<br>'; }
    if (error != '') {
        template += `
        <div class="alert alert-danger" role="alert" id="alerta_eart">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#result_e_articulo').html(template);
        setTimeout(function () { $('#alerta_eart').alert('close'); }, 2000);
    } else {
        const postData = {
            codigo_e: codigo_e,
            nombre: nombre,
            tipo: tipo,
            linea: linea,
            precio: precio,
            estado: estado,
            id_articulo: id_articulo
        };
        $.post('back-end/articulos.php', postData, function (response) {
            consulta_articulos();
            $('#form_e_articulo').trigger('reset');
            $('#result_e_articulo').html(response);
            setTimeout(function () { $('#alerta_eart').alert('close'); $("#edita_articulo").modal("hide"); }, 1000);
        });
    }
}

function maestros() {
    let lineas = 0;
    $.ajax({
        url: 'back-end/articulos.php',
        type: 'GET',
        data: { lineas },
        success: function (response) {
            let datas = JSON.parse(response);
            let template = '<option value="">Seleccionar</option>';
            datas.forEach(data => {
                template += `<option value="${data.id}">${data.linea}</option>`
            });
            $('#linea').html(template);
            $('#e_linea').html(template);
        }
    });
    let tipos_art = 0;
    $.ajax({
        url: 'back-end/articulos.php',
        type: 'GET',
        data: { tipos_art },
        success: function (response) {
            let datas = JSON.parse(response);
            // console.log(datas);
            let template = '<option value="">Seleccionar</option>';
            datas.forEach(data => {
                template += `<option value="${data.id}">${data.tipo}</option>`
            });
            $('#tipo').html(template);
            $('#e_tipo').html(template);
        }
    });
}

// Exportar
async function exportar_articulos() {
    // 🔹 Mostrar mensaje inicial antes de hacer la solicitud
    Toast.fire({
        icon: 'info',
        title: 'Generando archivo, por favor espera...'
    });

    try {
        const response = await $.get(`back-end/articulos.php?articulos=all`);
        const marcas = JSON.parse(response);

        if (!marcas || marcas.length === 0) {
            Toast.fire({
                icon: 'error',
                title: 'No hay datos para exportar'
            });
            return;
        }

        // 🔹 Encabezados del archivo
        const headers = ["Código", "Nombre", "Tipo", "Linea", "Estado", "Usuario", "Fecha"];

        // 🔹 Limpiar etiquetas HTML del estado y crear los datos
        const data = marcas.map(m => {
            const estadoLimpio = m.estado
                ? m.estado.replace(/<[^>]*>?/gm, '').trim()
                : ''; // Evita error si es null o undefined

            return [
                m.codigo,
                m.nombre,
                estadoLimpio,
                m.linea,
                m.tipo,
                m.user,
                m.fecha
            ];
        });

        // 🔹 Crear hoja y libro Excel
        const ws = XLSX.utils.aoa_to_sheet([headers, ...data]);
        const wb = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(wb, ws, "Articulos");

        // 🔹 Guardar archivo Excel
        const nombreArchivo = "articulos_" + new Date().toISOString().slice(0, 10) + ".xlsx";
        XLSX.writeFile(wb, nombreArchivo);

        Toast.fire({    
            icon: 'success',
            title: 'Archivo exportado correctamente'
        });
    } catch (error) {
        console.error(error);
        Toast.fire({
            icon: 'error',
            title: 'Error al generar el archivo'
        });
    }
}
