const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function cambios_cliente() {
    let inlineRadio1 = document.getElementById("inlineRadio1");
    let inlineRadio2 = document.getElementById("inlineRadio2");

    if (inlineRadio1.checked == true) {
        $("#identificacion_container").show();
        $("#apellidos_container").show();
        $("#fecha_cumple_container").show();
    }

    if (inlineRadio2.checked == true) {
        $("#identificacion_container").hide();
        $("#apellidos_container").hide();
        $("#fecha_cumple_container").hide();
    }
}

function list_visitadores() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<datalist id="visitadores_lista">`;
            let body = ``;
            let template_end = `</datalist>`;

            body += `<option value="Todos">Todos</option>`;

            datas.forEach(data => {
                body += `
                <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#visitadores').html(template + body + template_end);
        }
    });
}

function list_especialidades1() {

    let list_especialidades = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_especialidades },
        success: function (response) {

            let datas = JSON.parse(response);

            let select_especialidad = document.getElementById('especialidad1');

            let opt = document.createElement('option');
            opt.innerText = 'Seleccione';
            select_especialidad.appendChild(opt);

            datas.forEach(data => {
                let opt = document.createElement('option');
                opt.value = data.id_especialidad;
                opt.innerText = data.especialidad;
                select_especialidad.appendChild(opt);
            });
        }
    });
}

function list_especialidades2() {

    let list_especialidades = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_especialidades },
        success: function (response) {

            let datas = JSON.parse(response);

            let select_especialidad = document.getElementById('especialidad2');

            let opt = document.createElement('option');
            opt.innerText = 'Seleccione';
            select_especialidad.appendChild(opt);

            datas.forEach(data => {
                let opt = document.createElement('option');
                opt.value = data.id_especialidad;
                opt.innerText = data.especialidad;
                select_especialidad.appendChild(opt);
            });
        }
    });
}

function call_tipo_cliente_select() {

    $.get(`back-end/datos/datos.php?list_tipo_cliente=all`, function (response) {

        console.log(response);
        let o = JSON.parse(response);
        console.log(o);

        let tipo_cliente_select = document.getElementById('tipo_cliente_select');

        let option2 = document.createElement("option");
        tipo_cliente_select.appendChild(option2);

        let option = document.createElement("option");
        option.value = "Todos";
        option.text = "Todos";
        tipo_cliente_select.appendChild(option);

        o.forEach(element => {
            option1 = document.createElement("option");
            option1.value = element.id_tipo_c;
            option1.text = element.tipo_c;
            tipo_cliente_select.appendChild(option1);
        });

    });
}

function list_especialidades_editar1() {

    let list_especialidades = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_especialidades },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<select class="form-control" id="editar_especialidad1">`;
            let body = `<option value="">Seleccione</option>`;
            let template_end = `</select>`;

            datas.forEach(data => {
                body += `<option value="${data.id_especialidad}">${data.especialidad}</option>`;
            });

            $('#contenedor_editar_especialidad1').html(template + body + template_end);
        }
    });
}

function list_especialidades_editar2() {

    let list_especialidades = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_especialidades },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<select class="form-control" id="editar_especialidad2">`;
            let body = `<option value="">Seleccione</option>`;
            let template_end = `</select>`;

            datas.forEach(data => {
                body += `<option value="${data.id_especialidad}">${data.especialidad}</option>`;
            });

            $('#contenedor_editar_especialidad2').html(template + body + template_end);
        }
    });
}

function list_tipo_cliente() {
    let list_tipo_cliente = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_tipo_cliente },
        success: function (response) {

            let datas = JSON.parse(response);

            let select_tipo_cliente = document.getElementById('tipo_cliente');

            let opt = document.createElement('option');
            opt.innerText = 'Seleccione';
            select_tipo_cliente.appendChild(opt);

            datas.forEach(data => {
                let opt = document.createElement('option');
                opt.value = data.id_tipo_c;
                opt.innerText = data.tipo_c;
                select_tipo_cliente.appendChild(opt);
            });
        }
    });
}

function list_tipo_cliente_editar() {
    let list_tipo_cliente = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_tipo_cliente },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<select class="form-control" id="editar_tipo_cliente">`;
            let body = `<option value="">Seleccione</option>`;
            let template_end = `</select>`;

            datas.forEach(data => {
                body += `<option value="${data.id_tipo_c}">${data.tipo_c}</option>`;
            });

            $('#contenedor_editar_tipo_cliente').html(template + body + template_end);
        }
    });
}

function list_visitadores_nuevo() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<datalist id="visitadores_lista_nuevo">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {
                body += `
                    <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#visitadores_nuevo').html(template + body + template_end);
        }
    });
}

function list_visitadores_editar() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: `back-end/datos/datos.php`,
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<datalist id="editar_visitadores_lista">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {
                body += `
                    <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#editar_visitadores').html(template + body + template_end);
        }
    });
}

function nuevo_cliente_individual() {

    let identificacion = $('#identificacion').val();
    let nombres = $('#nombres').val();
    let apellidos = $('#apellidos').val();
    let telefono = $('#telefono').val();
    let email_cliente = $('#email_cliente').val();
    let direccion_cliente = $('#direccion_cliente').val();
    let ciudad_cliente = $('#ciudad_cliente').val();
    let tipo_cliente = $('#tipo_cliente').val();
    let especialidad1 = $('#especialidad1').val();
    let especialidad2 = $('#especialidad2').val();
    let fecha_cumple = $('#fecha_cumple').val();
    let visitador_nuevo = $('#visitador_nuevo').val();
    let estado = $('#estado').val();
    let categoria = $('#categoria').val();

    let crear = "crear";
    let error = '';
    let template = '';

    let inlineRadio1 = document.getElementById("inlineRadio1");
    let inlineRadio2 = document.getElementById("inlineRadio2");

    if (inlineRadio1.checked == true) {
        if (identificacion === '') { error += '<strong>Identificacion</strong></br>' }
        if (nombres === '') { error += '<strong>Nombres</strong></br>' }
        if (apellidos === '') { error += '<strong>Apellidos</strong></br>' }
        if (telefono === '') { error += '<strong>Telefono</strong></br>' }
        if (email_cliente === '') { error += '<strong>Email</strong></br>' }
        if (direccion_cliente === '') { error += '<strong>Direccion</strong></br>' }
        if (ciudad_cliente === '') { error += '<strong>ciudad</strong></br>' }
        if (tipo_cliente === '') { error += '<strong>Tipo</strong></br>' }
        if (especialidad1 === '') { error += '<strong>Especialidad 1</strong></br>' }
        if (especialidad2 === '') { error += '<strong>Especialidad 2</strong></br>' }
        if (fecha_cumple === '') { error += '<strong>Fecha Cumpleaños</strong></br>' }
        if (visitador_nuevo === '') { error += '<strong>Visitador</strong></br>' }
        if (estado === '') { error += '<strong>Estado</strong></br>' }
        if (categoria === '') { error += '<strong>Categoria</strong></br>' }
    }

    if (inlineRadio2.checked == true) {
        if (nombres === '') { error += '<strong>Nombres</strong></br>' }
        if (telefono === '') { error += '<strong>Telefono</strong></br>' }
        if (email_cliente === '') { error += '<strong>Email</strong></br>' }
        if (direccion_cliente === '') { error += '<strong>Direccion</strong></br>' }
        if (ciudad_cliente === '') { error += '<strong>ciudad</strong></br>' }
        if (tipo_cliente === '') { error += '<strong>Tipo</strong></br>' }
        if (especialidad1 === '') { error += '<strong>Especialidad 1</strong></br>' }
        if (especialidad2 === '') { error += '<strong>Especialidad 2</strong></br>' }
        if (visitador_nuevo === '') { error += '<strong>Visitador</strong></br>' }
        if (estado === '') { error += '<strong>Estado</strong></br>' }
        if (categoria === '') { error += '<strong>Categoria</strong></br>' }
    }

    if (error != '') {
        template += `
        <div class="alert alert-warning" role="alert" id="alerta_lin">
            <strong>Error!</strong> Faltan los siguientes datos<br>${error}
        </div>`;
        $('#errores').html(template);
    } else {
        $.post(
            `back-end/datos/datos.php`,
            {
                crear,
                identificacion,
                nombres,
                apellidos,
                telefono,
                email_cliente,
                direccion_cliente,
                ciudad_cliente,
                tipo_cliente,
                especialidad1,
                especialidad2,
                fecha_cumple,
                visitador_nuevo,
                estado,
                categoria
            },
            async function (response) {

                let o = parseInt(response);

                if (o == 200) {

                    $('#cliente_individual').modal("hide");

                    await Swal.fire({
                        icon: 'success',
                        title: 'Crear cliente',
                        text: 'Creacion de cliente exitosa.',
                    });

                    window.location.reload();

                } else {
                    console.log(response);
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: 'Error al crear el cliente.',
                    })
                }
            });
    }

    $('#codigo_cliente').val('');
    $('#identificacion').val('');
    $('#nombres').val('');
    $('#apellidos').val('');
    $('#telefono').val('');
    $('#email_cliente').val('');
    $('#direccion_cliente').val('');
    $('#ciudad_cliente').val('');
    $('#tipo_cliente').val('');
    $('#especialidad1').val('');
    $('#especialidad2').val('');
    $('#fecha_cumple').val('');
    $('#visitador_nuevo').val('');
    $('#estado').val('');
}

async function descargar_lista() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    let visitador = $('#visitador').val();
    let tipo_cliente_select = $('#tipo_cliente_select').val();

    window.open(`views/datos/descargar_plantilla.php?visitador=${visitador}&tipo_cliente_select=${tipo_cliente_select}`);
    await Swal.close();
}

async function buscar_cliente() {

    let visitador = $('#visitador').val();
    let tipo_cliente_select = $('#tipo_cliente_select').val();

    console.log(tipo_cliente_select);

    if (visitador == '') {
        Toast.fire({
            icon: 'error',
            title: 'Seleccione un visitador'
        });
    } else if (tipo_cliente_select == '') {
        Toast.fire({
            icon: 'error',
            title: 'Seleccione un tipo cliente'
        });
    } else {
        $('#descargar_lista_div').show();

        await $('#list_paneles').html();
        await $('#tabla_clientes_filtro').hide();

        await $.ajax({
            url: `back-end/datos/datos.php`,
            type: 'GET',
            data: { visitador, tipo_cliente_select },
            success: async function (response) {
                let datas = JSON.parse(response);

                let template = `
                    <table class="table table-flush" style="font-size: 10px;" id="datatable_clientes">
                        <thead class="thead-light">
                            <tr>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Apellidos </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Nombres </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Email </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Ciudad </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Tipo Cliente </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Especialidad 1 </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Especialidad 2 </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Estado </th>
                            <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7">Editar </th>
                            </tr>
                        </thead>
                    <tbody>`;
                let template_end = `</tbody></table>`;
                let body = '';
                datas.forEach(data => {
                    body += `
                <tr>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.apellidos_cliente} </td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.nombres_cliente} </td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.email_cliente} </td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.ciudad_cliente} </td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.tipo_cliente} </td>
                
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.especialidad1} </td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.especialidad2} </td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.estado_cliente} </td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.btn_editar} </td>
                </tr>`

                });
                await $('#list_paneles').html(template + body + template_end);
            }
        });

        await $('#tabla_clientes_filtro').show();
        const dataTableSearch = new simpleDatatables.DataTable("#datatable_clientes", {
            searchable: true,
            columns: [
                { select: 0, sort: "asc" },
            ]
        });
    }
}

async function setID(id_cliente) {
    $('#editar_id_cliente').val(id_cliente);

    await $.ajax({
        url: 'back-end/datos/datos.php',
        type: 'GET',
        data: { id_cliente },
        success: function (response) {
            let datas = JSON.parse(response);
            console.log(datas)
            datas.forEach(async (data) => {

                await $('#editar_codigo_cliente').val(data.id_cliente);
                await $('#editar_identificacion').val(data.identificacion);
                await $('#editar_nombres').val(data.nombres_cliente);
                await $('#editar_apellidos').val(data.apellidos_cliente);
                await $('#editar_telefono').val(data.telefono_cliente);
                await $('#editar_email_cliente').val(data.email_cliente);
                await $('#editar_direccion_cliente').val(data.direccion_cliente);
                await $('#editar_ciudad_cliente').val(data.ciudad_cliente);

                await $('#editar_tipo_cliente').val(data.tipo_cliente);
                await $('#editar_especialidad1').val(data.especialidad1);
                await $('#editar_especialidad2').val(data.especialidad2);

                await $('#editar_fecha_cumple').val(data.fecha_cumple);
                await $('#editar_visitador').val(data.id_user);
                await $('#editar_estado').val(data.estado_cliente);
                await $('#editar_categoria').val(data.categoria);
            });
        }
    });
}

function editar_cliente_individual() {

    let editar_id_cliente = $('#editar_id_cliente').val();
    let editar_identificacion = $('#editar_identificacion').val();
    let editar_nombres = $('#editar_nombres').val();
    let editar_apellidos = $('#editar_apellidos').val();
    let editar_telefono = $('#editar_telefono').val();
    let editar_email_cliente = $('#editar_email_cliente').val();
    let editar_direccion_cliente = $('#editar_direccion_cliente').val();
    let editar_ciudad_cliente = $('#editar_ciudad_cliente').val();
    let editar_tipo_cliente = $('#editar_tipo_cliente').val();
    let editar_especialidad1 = $('#editar_especialidad1').val();
    let editar_especialidad2 = $('#editar_especialidad2').val();
    let editar_fecha_cumple = $('#editar_fecha_cumple').val();
    let editar_visitador = $('#editar_visitador').val();
    let editar_estado = $('#editar_estado').val();
    let editar_categoria = $('#editar_categoria').val();

    fetch(`back-end/datos/datos.php`, {
        method: 'PUT',
        body: JSON.stringify({
            editar_id_cliente: editar_id_cliente,
            editar_identificacion: editar_identificacion,
            editar_nombres: editar_nombres,
            editar_apellidos: editar_apellidos,
            editar_telefono: editar_telefono,
            editar_email_cliente: editar_email_cliente,
            editar_direccion_cliente: editar_direccion_cliente,
            editar_ciudad_cliente: editar_ciudad_cliente,
            editar_tipo_cliente: editar_tipo_cliente,
            editar_especialidad1: editar_especialidad1,
            editar_especialidad2: editar_especialidad2,
            editar_fecha_cumple: editar_fecha_cumple,
            editar_visitador: editar_visitador,
            editar_estado: editar_estado,
            editar_categoria: editar_categoria
        }),
        Headers: {
            Accept: 'application/json',
            'Content-Type': 'text/html'
        }
    })
        .then((response) => response.text())
        .then(async (responseData) => {
            console.log(responseData);
            let resp = parseInt(responseData);

            if (resp == 200) {
                $('#edit_ciclo').modal("hide");
                Toast.fire({
                    icon: 'success',
                    title: 'Ciclo Actualizado'
                });
                await buscar_cliente();
            } else {
                Toast.fire({
                    icon: 'error',
                    title: 'Error al Actualizar el Ciclo'
                });
            }

        })
        .catch((error) => {
            console.error('error', error)
        });
}

async function descargar_plantilla() {
    const workbook = XLSX.utils.book_new();

    // Crear una hoja de trabajo
    const sheetData = [
        ['Identificacion', 'Nombres Cliente', 'Apellidos Cliente', 'Telefono Cliente', 'Email Cliente', 'Direccion Cliente', 'Ciudad Cliente', 'Tipo Cliente', 'Categoria', 'Especialidad1', 'Especialidad2', 'Fecha Cumpleaños', 'Cod Visitador', 'Estado Cliente'],
        ['', '', '', '', '', '', '', '', '', '', '', '1 Activo, 0 Inactivo']
    ];

    const worksheet = XLSX.utils.aoa_to_sheet(sheetData);

    // Agregar estilos o formatos adicionales si es necesario
    // Por ejemplo, para agregar un borde a la tabla:
    const range = XLSX.utils.decode_range(worksheet['!ref']);
    for (let R = range.s.r; R <= range.e.r; ++R) {
        for (let C = range.s.c; C <= range.e.c; ++C) {
            const cell = worksheet[XLSX.utils.encode_cell({ r: R, c: C })];
            if (!cell) continue;
            cell.s = { border: { top: { style: 'thin' }, bottom: { style: 'thin' } } };
        }
    }

    // Agregar la hoja de trabajo al libro
    XLSX.utils.book_append_sheet(workbook, worksheet, 'MiHojaDeCalculo');

    // Crear un archivo binario a partir del libro de trabajo
    const excelBuffer = XLSX.write(workbook, { bookType: 'xlsx', type: 'array' });

    /* create an XLSX file and try to save to Presidents.xlsx */
    XLSX.writeFileSync(workbook, "Plantilla Clientes.xlsx", { compression: true });
}

function cargar_plantilla() {

    window.io = {
        open: function (verb, url, data, target) {
            var form = document.createElement("form");
            form.action = url;
            form.method = verb;
            form.target = target || "_self";
            if (data) {
                for (var key in data) {
                    var input = document.createElement("textarea");
                    input.name = key;
                    input.value = typeof data[key] === "object"
                        ? JSON.stringify(data[key])
                        : data[key];
                    form.appendChild(input);
                }
            }
            form.style.display = 'none';
            document.body.appendChild(form);
            form.submit();
            document.body.removeChild(form);
        }
    };

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    const fileInput = document.getElementById("fileUpload");
    const file = fileInput.files[0];

    if (file) {
        const reader = new FileReader();

        reader.onload = async function (e) {
            const data = new Uint8Array(e.target.result);
            const workbook = XLSX.read(data, { type: "array" });

            // Leer el contenido de la primera hoja
            const firstSheetName = workbook.SheetNames[0];
            const worksheet = workbook.Sheets[firstSheetName];
            const jsonData = XLSX.utils.sheet_to_json(worksheet);

            console.log(jsonData);

            // Mostrar los datos en la p�gina
            io.open('POST', `views/datos/verMasivo.php`, {
                jsonData: jsonData
            }, 'newwin');
            Swal.close();
        };

        window.close()

        reader.readAsArrayBuffer(file);
    } else {
        alert("Selecciona un archivo de Excel primero.");
    }
}

function enviar_datos_plantilla() {

    var datos = $('#datatable_lineas').DataTable().data().toArray();
}